/*	aarp.c	1.0	87/06/22	*/
/*	(c) 1987, Kinetics, Inc.	*/

/*
 *	AppleTalk Address Resolution Protocol as per Draft
 *	Proposal from Apple Computer dated May 18, 1987.
 */

#include "param.h"
#include "types.h"
#include "mbuf.h"
#include "socket.h"
#include "time.h"
#include "kernel.h"
#include "../net/if.h"
#include "../netinet/in.h"
#include "../netinet/if_ether.h"

#include "../netddp/atalk.h"
#include "../netddp/katalk.h"
#include "../netddp/aarp.h"

u_char	aarp_probestate = 0;
int	aarpdebug = 0;
extern	struct arptab *arptnew();

/*
 *  aarpinput()
 *	- process ETHERTYPE_AARP packets
 *	- simple sanity checking done
 */
aarpinput(ac, m)
	register struct arpcom *ac;
	struct mbuf *m;
{
	register struct aarphdr *aap;
	register struct arptab *at = 0;
	register struct ifnet *ifp = &ac->ac_if;
	struct	in_addr isaddr, itaddr;
	struct	mbuf *mhold;
	struct	sockaddr_in sin;
	int	s;

	IF_ADJ(m);				/* strip off interface */
	if (m->m_len < sizeof(struct aarphdr))
		goto out;
	aap = mtod(m, struct aarphdr *);
	if ((ntohs(aap->hardtype) != AARP_ENETTYPE) ||
		ntohs(aap->prottype) != ETHERTYPE_APPLETALK)
		goto out;

	/* if it's from me, ignore */
	if (bcmp((caddr_t)aap->shardaddr, (caddr_t)ac->ac_enaddr,
		MAXHARDLEN) == 0)
		goto out;

	s = splimp();
	isaddr = aarp_spa(aap);
	itaddr = aarp_tpa(aap);

	switch (ntohs(aap->cmd)) {
	    case AARPREQ:
	    case AARPPROBE:
		/* no reply if probing */
		if (aarp_probestate)
			break;
		/* if not for me */
		if (((u_char *)&itaddr)[3] != ddp_getaddr(ifp)->at_Node)
			break;
		aarpreply(ac, aap);
		break;

	    case AARPRESP:
		ARPTAB_LOOK(at, isaddr.s_addr);
		if (at) {
			bcopy(at->at_enaddr, aap->shardaddr, MAXHARDLEN);
			at->at_flags |= ATF_COM;
			if (mhold = at->at_hold) {
				at->at_hold = 0;
				sin.sin_family = AF_APPLETALK;
				sin.sin_addr = isaddr;
				(*ifp->if_output)(ifp,
					mhold, (struct sockaddr *)&sin);
			}
		} else if (((u_char *)&itaddr)[3] == ddp_getaddr(ifp)->at_Node){
			/* ensure we have a table entry for the requester */
			at = arptnew(&isaddr);
			bcopy(at->at_enaddr, aap->shardaddr, MAXHARDLEN);
			at->at_flags |= ATF_COM;
		}
		break;
	}
	(void)splx(s);
out:
	m_freem(m);
}

/*
 *  aarpreply()
 *	- reply to aarp probes and requests for my address
 */
aarpreply(ac, raarp)
	register struct arpcom *ac;
	register struct aarphdr *raarp;
{
	struct	mbuf *m;
	register struct aarphdr *aarpp;
	struct sockaddr sa;
	struct ether_header *eh;
	struct ifnet *ifp = &ac->ac_if;

	if ((m = m_get(M_DONTWAIT, MT_DATA)) == NULL)
		return;
	m->m_len = sizeof(struct aarphdr);
	m->m_off = MMAXOFF - sizeof(struct aarphdr);

	aarpp = mtod(m, struct aarphdr *);

	aarpp->hardtype = htons(AARP_ENETTYPE);
	aarpp->prottype = htons(ETHERTYPE_APPLETALK);
	aarpp->hardlen = MAXHARDLEN;
	aarpp->protlen = MAXPROTLEN;
	aarpp->cmd = htons(AARPRESP);
	bcopy(ac->ac_enaddr, (caddr_t) aarpp->shardaddr, MAXHARDLEN);
	aarpp->slogaddr[0] = aarpp->slogaddr[1] =
		aarpp->slogaddr[2] = 0;
	aarpp->slogaddr[3] = ddp_getaddr(ifp)->at_Node;
	bcopy((caddr_t)raarp->shardaddr,
		(caddr_t)aarpp->dhardaddr, MAXHARDLEN);
	bcopy((caddr_t)raarp->slogaddr,
		(caddr_t)aarpp->dlogaddr, MAXPROTLEN);

	sa.sa_family = AF_UNSPEC;
	eh = (struct ether_header *)sa.sa_data;
	bcopy((caddr_t)aarpp->dhardaddr,
		(caddr_t)eh->ether_dhost, sizeof(eh->ether_dhost));
	bcopy(ac->ac_enaddr, eh->ether_shost, sizeof(eh->ether_shost));
	eh->ether_type = ETHERTYPE_AARP;
	(void)((*ifp->if_output)(ifp, m, &sa));
}

/*
 *  aarpresolve()
 *	- look in generic arp table, if not a complete
 *	  entry, send requests
 *	- requests are made using both aarp and regular arp
 */
aarpresolve(ac, m, destip, desten, usetrailers)
	register struct arpcom *ac;
	struct mbuf *m;
	register struct in_addr *destip;
	register struct ether_addr *desten;
	int *usetrailers;
{
	struct mbuf *mr;
	register struct arptab *at;
	register struct aarphdr *aarpp;
	struct sockaddr sa;
	struct ether_header *eh;
	struct ifnet *ifp = &ac->ac_if;
	int s = splimp();

	ARPTAB_LOOK(at, destip->s_addr);
	if ((at == 0) || ((at) && (at->at_flags & ATF_COM) != ATF_COM)) {
		/* not in table or not complete */
		(void)splx(s);
		if ((mr = m_get(M_DONTWAIT, MT_DATA)) == NULL)
			return(arpresolve(ac, m, destip, desten));
		mr->m_len = sizeof(struct aarphdr);
		mr->m_off = MMAXOFF - sizeof(struct aarphdr);
		aarpp = mtod(mr, struct aarphdr *);

		aarpp->hardtype = htons(AARP_ENETTYPE);
		aarpp->prottype = htons(ETHERTYPE_APPLETALK);
		aarpp->hardlen = MAXHARDLEN;
		aarpp->protlen = MAXPROTLEN;
		bcopy(ac->ac_enaddr, (caddr_t)aarpp->shardaddr, MAXHARDLEN);
		
		bzero((caddr_t)aarpp->dhardaddr, MAXHARDLEN);

		if (aarp_probestate) {
			bcopy((caddr_t)&destip->s_addr,
				(caddr_t)aarpp->slogaddr, MAXPROTLEN);
			aarpp->cmd = htons(AARPPROBE);
		} else {
			aarpp->slogaddr[0] = aarpp->slogaddr[1] =
				aarpp->slogaddr[2] = 0;
			aarpp->slogaddr[3] = ddp_getaddr(ifp)->at_Node;
			aarpp->cmd = htons(AARPREQ);
		}
		bcopy((caddr_t)&destip->s_addr,
			(caddr_t)aarpp->dlogaddr, MAXPROTLEN);

		sa.sa_family = AF_UNSPEC;
		eh = (struct ether_header *)sa.sa_data;
		bcopy((caddr_t)etherbroadcastaddr, (caddr_t)eh->ether_dhost,
	    		sizeof(eh->ether_dhost));
		bcopy(ac->ac_enaddr, eh->ether_shost, sizeof(eh->ether_shost));
		eh->ether_type = ETHERTYPE_AARP;
		(void)((*ifp->if_output)(ifp, mr, &sa));

		/* do regular arp too */
		return(arpresolve(ac, m, destip, desten, usetrailers));
	}

	/* been resolved */
	bcopy((caddr_t)at->at_enaddr, (caddr_t)desten, sizeof(at->at_enaddr));
	(void)splx(s);
	return 1;
}
