/* ISI: $Header: saio.h,v 1.1 87/10/02 09:55:46 root Exp $ */
/*	saio.h	6.2	9/23/83	*/

#include "../h/param.h"
#include "../h/time.h"
#include "../h/vnode.h"
#include "../h/dkbad.h"
#include "../ufs/inode.h"
#include "../ufs/fsdir.h"
#include "../ufs/fs.h"
#include "../machine/pte.h"
#include "../machine/board.h"

/*
 * Header file for standalone package
 */

/*
 * Drive description table. Returned from SAIODEVDATA call.
 */
struct st {
	int	nbsec;		/* # bytes per sector */
	int	nsect;		/* # sectors/track */
	int	ntpc;		/* # tracks/surfaces/heads */
	int	nspc;		/* # sectors/cylinder */
	int	ncyl;		/* # cylinders/drive */
	int	*off;		/* partition offset table (cylinders) */
};

/*
 * Io block: includes an inode, cells for the use of seek, etc, and a buffer.
 */
struct	iob {
	int		i_flgs;		/* see F_ below */
	struct		inode i_ino;	/* inode, if file */
	int		i_unit;		/* pseudo device unit */
	struct st	i_st;		/* drive info, available after open */
	daddr_t		i_fpart;	/* file system partition on device */
	daddr_t		i_boff;		/* block offset on device */
	off_t		i_offset;	/* seek offset in file */
	daddr_t		i_bn;		/* 1st block # of next read */
	long		i_ma;		/* physical memory addr of i/o buffer */
	int		i_cc;		/* character count of transfer */
	int		i_error;	/* error # return */
	int		i_errcnt;	/* error count for driver retries */
	int		i_errblk;	/* block # in error for err reporting */
	char		i_buf[MAXBSIZE];/* i/o buffer */
	union {
		struct fs	ui_fs;	/* file system super block info */
		char		dummy[SBSIZE];
	}		i_un;
};
#define i_fs i_un.ui_fs
#define NULL 0

#define F_READ		0x00000001	/* file opened for reading */
#define F_WRITE		0x00000002	/* file opened for writing */
#define F_ALLOC		0x00000004	/* buffer allocated */
#define F_FILE		0x00000008	/* file instead of device */
#define F_NBSF		0x00000010	/* no bad sector forwarding */
#define F_ECCLM		0x00000020	/* limit # of bits in ecc correction */
#define F_SSI		0x00000040	/* set skip sector inhibit */
#define F_SEVRE		0x00000080	/* Severe burnin (no retries, no ECC) */
#define F_BLKOFF	0x00000100	/* block (not file system) offset */
#define F_REMOTE	0x00000200	/* file is on remote system */
/* io types */
#define	F_RDDATA	0x00010000	/* read data */
#define	F_WRDATA	0x00020000	/* write data */
#define F_HDR		0x00040000	/* include header on next i/o */
#define F_CHECK		0x00080000	/* perform check of data read/write */
#define F_HCHECK	0x00100000	/* perform check of header and data */

#define	F_TYPEMASK	0x00ff0000

/*
 * Device switch.
 */
struct devsw {
	char	*dv_name;
	int	dv_kermajmin;
	char	*dv_bootf;
	int	dv_flags;
#define		DEV_MEDIA_MASK	0x00FF	/* type of media on device */
#define		DEV_DISK	0x0001
#define		DEV_TAPE	0x0002
#define		DEV_NET		0x0004
#define		DEV_DART	0x0008
#define		DEV_FLOPPY	0x0010
#define		DEV_AUTOBOOT	0x0100	/* device supports autoboot */
#define		DEV_CLUST	0x0200	/* device supported on cluster */
	int	(*dv_strategy)();
	int	(*dv_open)();
	int	(*dv_close)();
	int	(*dv_ioctl)();
};

struct devsw devsw[];

/*
 * Request codes. Must be the same a F_XXX above
 */
#define	READ	1
#define	WRITE	2

#define	NBUFS	3		/* > number of inderect blocks supported */

char	b[NBUFS][MAXBSIZE];
daddr_t	blknos[NBUFS];

#define	NFILES	2
struct	iob iob[NFILES];

extern	int errno;	/* just like unix */

/* error codes */
#define	EBADF	1	/* bad file descriptor */
#define	EOFFSET	2	/* relative seek not supported */
#define	EDEV	3	/* improper device specification on open */
#define	ENXIO	4	/* unknown device specified */
#define	EUNIT	5	/* improper unit specification */
#define	ESRCH	6	/* directory search for file failed */
#define	EIO	7	/* generic error */
#define	ECMD	10	/* undefined driver command */
#define	EBSE	11	/* bad sector error */
#define	EWCK	12	/* write check error */
#define	EECC	13	/* uncorrectable ecc error */
#define	EHER	14	/* hard error */

/* ioctl's -- for disks just now */
#define	SAIOHDR		(('d'<<8)|1)	/* next i/o includes header */
#define	SAIOCHECK	(('d'<<8)|2)	/* next i/o checks data */
#define	SAIOHCHECK	(('d'<<8)|3)	/* next i/o checks header & data */
#define	SAIONOBAD	(('d'<<8)|4)	/* inhibit bad sector forwarding */
#define	SAIODOBAD	(('d'<<8)|5)	/* enable bad sector forwarding */
#define	SAIOECCLIM	(('d'<<8)|6)	/* limit ecc correction to 5 bits */
#define	SAIOECCUNL	(('d'<<8)|7)	/* use standard ecc procedures */
#define	SAIODEVDATA	(('d'<<8)|8)	/* get device data */
#define	SAIOSSI		(('d'<<8)|9)	/* set skip sector inhibit */
#define	SAIONOSSI	(('d'<<8)|10)	/* inhibit skip sector handling */
#define	SAIOSSDEV	(('d'<<8)|11)	/* is device skip sector type? */
#define	SAIODEBUG	(('d'<<8)|12)	/* enable/disable debugging */
#define	SAIOSEVRE	(('d'<<8)|13)	/* severe burnin, no ECC, no retries */
#define	SAIONSEVRE	(('d'<<8)|14)	/* clear severe burnin */
