/*
 * Standalone RX02 floppy disk device driver
 */
#include "saio.h"
#include "sais68k.h"
#include "../is68kdev/rxreg.h"

#define	RXADDR	((struct rxdevice *)0x3FFE78)
struct rxdevice		*rxstd[] = { RXADDR };
static int 		rxnblk[] = { 500, 1001, 1001, 2002 };
static struct st	rxst = { DEV_BSIZE, 0, 0, 0, 0, 0};	/* GEO */

/*
 * fundamental constants of the RX02
 */
#define	RX_NSPB(u)	(RX_DENSITY(u)?2:4)	/* floppy sectors per block */
#define	RX_NWPS(u)	(RX_DENSITY(u)?128:64)	/* words per floppy sector */
#define	RX_NBPS(u)	(RX_DENSITY(u)?256:128)	/* bytes per floppy sector */
#define	NRX		2


#ifdef SPECIAL
#define FMTSECT	0000154	/* sector address for DSD format*/
#endif

#define TRWAIT	if (rxwait(rxaddr)) return(-1)

rxopen(io)
register struct iob *io;
{
	register struct rxdevice	*rxaddr = rxstd[0];

	if (!probe(&rxaddr->rxmp.rxba,&rxaddr->rxmp.rxba)) {
		printf("rx: controller not present\n");
		return (-1);
	}
        if (RX_UNIT(io->i_unit) >= NRX) {
                printf("rx: bad unit\n");
		return (-1);
	}
	if (!(io->i_flgs & F_BLKOFF) && io->i_boff != 0 ) {
                printf("rx: bad file system index\n");
		return (-1);
	}
	if (io->i_boff >= rxnblk[(io->i_unit>>1)&3]) {
		printf("rx: bad offset\n");
		return (-1);
	}
	rxaddr->rxcs = RX_RSTAT|RXCS_GO|(RX_UNIT(io->i_unit)<<4);
	while ((rxaddr->rxcs&RXCS_DONE) == 0)
		;
	if ((rxaddr->rxmp.rxes & RXES_RDY) == 0) {
                printf("rx: unit not ready\n");
		return (-1);
	}
	io->i_st = rxst;
	return (0);
}

#ifdef SPECIAL
rxsmden(io, func)
register struct iob *io;
{
/*	Don't let the FMT fool you - this is set media density */
	return(rxstrategy(io, FMT));
}

dsdformat(io, func)
register struct iob *io;
{
	return(rxstrategy(io, DSDFMT));
}
#endif

rxstrategy(io, func)
register struct iob *io;
{
	register struct rxdevice	*rxaddr = rxstd[0];
	int sector, track, head, wcnt;
	long addr;
	int errcnt=0, seccnt=0;

	if (io->i_bn >= rxnblk[(io->i_unit>>1)&3]) {
		printf("rx: bad block number\n");
                return(-1);
        }
	wcnt = io->i_cc >> 1;	/* word count left to xfer */
	switch (func) {
	    case READ:
	    more:
		rxfactr(io->i_unit, io->i_bn * RX_NSPB(io->i_unit) + seccnt,
			&sector, &track, &head);
	    retry:
		rxaddr->rxcs = (head<<9)|(RX_DENSITY(io->i_unit)<<7)|
			(RX_UNIT(io->i_unit)<<4)|RX_RCOM|RXCS_GO;
		TRWAIT;
		rxaddr->rxmp.rxsa = sector;
		TRWAIT;
		rxaddr->rxmp.rxta = track;
		while ((rxaddr->rxcs&RXCS_DONE) == 0)
			;
	    err:
		if (rxaddr->rxcs & RXCS_ERROR) {
			ushort csr, rxes;

			csr = rxaddr->rxcs;
			rxaddr->rxcs = RX_RSTAT|RXCS_GO|
				(RX_UNIT(io->i_unit)<<4);
			while ((rxaddr->rxcs&RXCS_DONE) == 0)
				;
			rxes = rxaddr->rxmp.rxes;
			printf("rx: error (cyl,trk,sec)=(%d,%d,%d) csr=0x%x er1=%b\n", 
				head, track, head, rxaddr->rxcs, rxes, 
				RXES_BITS);
			if (++errcnt < 5) {
				rxaddr->rxcs = RXCS_INIT;
				while ((rxaddr->rxcs&RXCS_DONE) == 0)
					;
				goto retry;
			}
			return(-1);
		}
		/* read done, empty buffer */
		addr = io->i_ma + seccnt*RX_NBPS(io->i_unit);
		if (!addr18(addr)) {
			printf("rx: 22 bit address\n");
			return (-1);
		}
		rxaddr->rxcs = ((hiword(addr)&3)<<12)|
			(RX_DENSITY(io->i_unit)<<7)|RX_EMPTY|RXCS_GO;
		TRWAIT;
		rxaddr->rxmp.rxwc = (wcnt >= RX_NWPS(io->i_unit)) ? 
			RX_NWPS(io->i_unit) : wcnt;
		TRWAIT;
		rxaddr->rxmp.rxba = loword(addr);
		while ((rxaddr->rxcs&RXCS_DONE) == 0)
			;
		if (rxaddr->rxcs & RXCS_ERROR)
			goto err;
		if ((wcnt -= RX_NWPS(io->i_unit)) <= 0)
			return(io->i_cc);
		seccnt++;
		goto more;

	    case WRITE:
		printf("rx: can not write floppies\n");
		return(-1);

#ifdef SPECIAL
	    case FMT:
		rxaddr->rxcs = (RX_DENSITY(io->i_unit)<<7)|
			(RX_UNIT(io->i_unit)<<4)|RX_FORMAT|RXCS_GO;
		TRWAIT;
		rxaddr->rxmp.rxdb = 'I';
		while ((rxaddr->rxcs&RXCS_DONE) == 0)
			;
		if (rxaddr->rxcs & RXCS_ERROR) {
			errcnt = 20;	/* inhibit retrys */
			goto err;
		}
		return(0);

	    case DSDFMT:
		rxaddr->rxcs = (RX_UNIT(io->i_unit)<<4)|RX_RSTAT|RXCS_GO;
		while ((rxaddr->rxcs&RXCS_DONE) == 0)
			;

		rxaddr->rxcs = RX_WCOM|RXCS_GO;
		TRWAIT;
		rxaddr->rxmp.rxsa = FMTSECT + (RX_DENSITY(io->i_unit)>>1);
		TRWAIT;
		rxaddr->rxmp.rxta = 0;
		while ((rxaddr->rxcs&RXCS_DONE) == 0)
			;
		return(0);
#endif

	    default:
		printf("rx: bad func 0x%x\n", func);
		return(-1);
	}
}

static
rxfactr(dev, sectr, psectr, ptrck, phead)
register int sectr;
int *psectr, *ptrck, *phead;
{
        register int p1, p2, p3;
	int nspc;

	nspc = (dev&4) ? 52 : 26;
        p1 = sectr/nspc;
        p2 = sectr%26;
	p3 = (sectr%nspc >= 26) ? 1 : 0;
        /* 2 to 1 interleave */
        p2 = (2*p2 + (p2 >= 13 ? 1 : 0) + p3) % 26;
        /* 6 sector per track slew */
        *psectr = 1 + (p2 + 6*p1) % 26;
        if (++p1 >= 77)
                p1 = 0;
        *ptrck = p1;
	*phead = p3;
}

rxioctl(io, cmd, arg)
	struct iob *io;
	int cmd;
	caddr_t arg;
{

	return (ECMD);
}

static
rxwait(rxaddr)
	register struct rxdevice *rxaddr;
{
	register int i;
	short cs;

	for ( i = 500000; i ; i--) {
		if (probe(&rxaddr->rxcs, &cs) && (cs & RXCS_TRANREQ) != 0)
			break;
		if (getlocal()) {
			printf("rx: aborted\n");
			return (-1);
		}
	}
	if (i == 0) {
		printf("rx: timeout\n");
		return(-1);
	}
	return (0);
}
