/*
 * UDA50-RA60/RA80/RA81, RQDX1-RD51/RX50 standalone disk driver
 */

#include "saio.h"
#include "sais68k.h"

/*
 * Parameters for the communications area
 */
#define	NRSPL2	0		/* log2 number of response packets */
#define	NCMDL2	0		/* log2 number of command packets */
#define	NRSP	(1<<NRSPL2)
#define	NCMD	(1<<NCMDL2)

#include "../is68kdev/rareg.h"
#include "../is68k/mscp.h"

static struct udadevice	*udastd[] = { (struct udadevice *)0x3FF468 };
static short 		uda_off[] = {0, 15884, 0, -1, -1, -1, 49324, 131404};
static struct st	udast = { DEV_BSIZE, 0, 0, 0, 0, uda_off }; /* GEO */

static struct uda 
{
	struct udaca	uda_ca;		/* communications area */
	struct mscp	uda_rsp[NRSP];	/* response packets */
	struct mscp	uda_cmd[NCMD];	/* command packets */
} 			uda;

struct mscp 		*udcmd();

static short		ra_openf;
static short		ra_stat;
static short		ra_ecode;
static short		ra_eflags;

/*
 * Open a UDA.  Initialize the device and set the unit online.
 */
raopen(io)
register struct iob *io;
{
	register struct mscp *mp;
	register struct udadevice *udaddr = udastd[0];
	register int i;
	register char *p;

	if (ra_openf)
		goto	ra_online;
	if (!probe(&udaddr->udaip,&i)) {
		printf("ra: controller not present\n");
		return (-1);
	}
	p = (caddr_t)&uda;
	for(i=0; i<sizeof(uda); i++)
		*p++ = 0;
	ra_openf++;
	udaddr->udaip = 0;	/* start initialization */
	while ((udaddr->udasa & UDA_STEP1) == 0) ;
	udaddr->udasa = UDA_ERR;
	while ((udaddr->udasa & UDA_STEP2) == 0) ;
	udaddr->udasa = (short)&uda.uda_ca.ca_ringbase;
	while ((udaddr->udasa & UDA_STEP3) == 0) ;
	udaddr->udasa = (short)((unsigned long)&uda.uda_ca.ca_ringbase >> 16 );
	while ((udaddr->udasa & UDA_STEP4) == 0) ;
	udaddr->udasa = UDA_GO;
	uda.uda_ca.ca_rspdsc[0].rl = (short)&uda.uda_rsp[0].m_cmdref;
	uda.uda_ca.ca_rspdsc[0].rh = 
		(short)((unsigned long)&uda.uda_rsp[0].m_cmdref >> 16);
	uda.uda_ca.ca_cmddsc[0].cl = (short)&uda.uda_cmd[0].m_cmdref;
	uda.uda_ca.ca_cmddsc[0].ch = 
		(short)((unsigned long)&uda.uda_cmd[0].m_cmdref >> 16);
	uda.uda_cmd[0].m_cntflgs = 0;

	if (udcmd(M_O_STCON) == 0) {
		printf("ra: open error, STCON\n");
		return (-1);
	}

ra_online:
	uda.uda_cmd[0].m_unit = io->i_unit&7;

	if (udcmd(M_O_ONLIN) == 0) {
		printf("ra: unit %d OFFLINE\n", io->i_unit&7, ra_stat);
		return (-1);
	}

	if (!(io->i_flgs & F_BLKOFF)) { 
		if (io->i_boff < 0 || io->i_boff > 7 || 
			uda_off[io->i_boff] == -1) {
			printf("ra: bad file system offset\n");
			return (-1);
		}
		io->i_boff = uda_off[io->i_boff];
	}
	io->i_st = udast;
	return (0);
}

static struct mscp *
udcmd(op)
int op;
{
	register struct mscp *mp;
	register int i;
	register struct udadevice *udaddr = udastd[0];

	uda.uda_cmd[0].m_opcode = op;
	uda.uda_rsp[0].m_header.uda_msglen = 
	    sizeof(struct mscp) - sizeof(struct mscp_header);
	uda.uda_cmd[0].m_header.uda_msglen = 
	    sizeof(struct mscp) - sizeof(struct mscp_header);
	uda.uda_ca.ca_rspdsc[0].rh |= UDA_OWN|UDA_INT;
	uda.uda_ca.ca_cmddsc[0].ch |= UDA_OWN|UDA_INT;
	i = udaddr->udaip;

	for (i = 800000; i; i--) {
		if (uda.uda_ca.ca_cmdint)
			uda.uda_ca.ca_cmdint = 0;
		if (uda.uda_ca.ca_rspint)
			break;
	}
	if (i == 0) {
		printf("ra: timeout\n");
		return (0);
	}

	uda.uda_ca.ca_rspint = 0;
	mp = &uda.uda_rsp[0];

	if ((mp->m_opcode & 0377) != (op|M_O_END) ||
	    (mp->m_status&M_S_MASK) != M_S_SUCC) {
		ra_stat = mp->m_status;
		ra_ecode = mp->m_opcode&0377;
		ra_eflags = mp->m_flags&0377;
		return(0);
	}

	return(mp);
}

rastrategy(io, func)
register struct iob *io;
{
	register struct mscp *mp;
	union {
		long	longw;
		struct {
			short	lo;
			short	hi;
		}	t_bs;
	} t_un;

	mp = &uda.uda_cmd[0];
	t_un.longw = io->i_bn;
	mp->m_lbn_l = t_un.t_bs.hi;
	mp->m_lbn_h = t_un.t_bs.lo;
	mp->m_unit = io->i_unit&7;
	mp->m_bc_l = loword(io->i_cc);
	mp->m_bc_h = hiword(io->i_cc);
	mp->m_xxx1 = 0;
	mp->m_buf_l = loword(io->i_ma);
	mp->m_buf_h = hiword(io->i_ma);

	if ((mp = udcmd(func == READ ? M_O_READ : M_O_WRITE)) == 0) {
		printf("ra: error\n");
		return(-1);
	}
	return(io->i_cc);
}

raioctl(io, cmd, arg)
	struct iob *io;
	int cmd;
	caddr_t arg;
{
	return (ECMD);
}
