#include "../h/param.h"

extern int (*putch)();
extern int (*getch)();
char	*prf_bufp;

/*
 * Scaled down version of C Library printf. Used to print diagnostic 
 * information directly on console tty.  Since it is not interrupt driven, 
 * all system activities are suspended.  Printf should not be used for 
 * chit-chat.
 *
 * One additional format: %b is supported to decode error registers.
 * Usage is:
 *	printf("reg=%b\n", regval, "<base><arg>*");
 * Where <base> is the output base expressed as a control character, e.g. \10 
 * gives octal; \20 gives hex. If the high bit of <base> is set then regval is 
 * negated. Each arg is a sequence of characters, the first of which gives the 
 * bit number to be inspected (origin 1), and the next characters (up to a 
 * control character, i.e. a character <= 32), give the name of the register. 
 * Thus
 *	printf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");		and
 *	printf("reg=%b\n", 0xFC, "\210\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=3<BITTWO,BITONE>
 */
#define	TOCONS	0x01
#define	TOBUF	0x02

/*VARARGS1*/
printf(fmt, x1)
	char *fmt;
	unsigned x1;
{
	prf(fmt, &x1, TOCONS);
}

sprintf(buf, fmt, x1)
	char *buf;
	char *fmt;
	unsigned x1;
{

	prf_bufp = buf;
	prf(fmt, &x1, TOBUF);
	*prf_bufp++ = '\0';
	return (prf_bufp - buf);
}

perror(fmt, x1)
	char *fmt;
	unsigned x1;
{
	_blink_errled();		/* blink error led */
	prf(fmt, &x1, TOCONS);		/* print error message */
#ifdef	notdef
	if (getlocal())			/* return nonzero if aborted */
		return 1;
	else
#endif	notdef
		return 0;
}

prf(fmt, adx, flags)
	register char *fmt;
	register u_int *adx;
{
	register int b, c, i, p, pad;
	char *s;
	int any;

loop:
	while ((c = *fmt++) != '%') {
		if (c == '\0')
			return;
		prf_putchar(c, flags);
	}
	p = 0;
	pad = 0;
again:
	if ((c = *fmt++) == '\0')
		return;
	if (p == 0 && (c == '-' || c == '+')) {
		pad++;
		goto again;
	}
	if (p == 0 && c >= '0' && c <= '9') {	/* number of places */
		do {
			p = (p * 10) + (c - '0');
			if ((c = *fmt++) == '\0')
				return;
		} while (c >= '0' && c <= '9');
	}

	/* THIS CODE IS VAX DEPENDENT IN HANDLING %l? AND %c */
	switch (c) {

	case 'l':
		goto again;
	case 'x': case 'X':
		b = 16;
		goto number;
	case 'd': case 'D':
	case 'u':		/* what a joke */
		b = 10;
		goto number;
	case 'o': case 'O':
		b = 8;
number:
		printn((u_long)*adx, b, p, flags);
		break;
	case 'a':		/* address */
		printn((u_long)*adx, 16, 8, flags);
		break;
	case 'c':
#ifdef	vax
		b = *adx;
		for (i = 24; i >= 0; i -= 8)
			if (c = (b >> i) & 0x7f)
				prf_putchar(c, flags);
#endif	vax
#ifdef	is68k
		c = *adx;
		prf_putchar(c, flags);
#endif	is68k
		break;
	case 'b':
		b = *adx++;
		s = (char *)*adx;
		c = *s++;
		i = c & 0x80;
		c &= 0x7F;
		printn((u_long)b, c, 0, flags);
		if (i)
			b = ~b;
		any = 0;
		if (b) {
			while (i = *s++) {
				if (b & (1 << (i-1))) {
					prf_putchar( any ? ',' : '<', flags);
					any = 1;
					for (; (c = *s) > 32; s++)
						prf_putchar(c, flags);
				} else
					for (; *s > 32; s++)
						;
			}
			if (any)
				prf_putchar('>', flags);
		}
		break;

	case 's':
		s = (char *)*adx;
	str:	if (p == 0) {
		    while ((c = *s++))
			prf_putchar(c, flags);
		} else if (pad) {
		    while ((c = *s++)) {
			prf_putchar(c, flags);
			p--;
		    }
		    c = ' ';
		    while (p-- > 0)
			prf_putchar(c, flags);
		} else {
		    while ((c = *s++) && p--)
			prf_putchar(c, flags);
		}
		break;

	case '%':
		prf_putchar('%', flags);
		break;

	case 'm':
		i = (int)*adx;
		b = i >> 20;
		printn(b, 10, 0, flags);
		if (p == 0) {
			prf_putchar('.', flags);
			b = 99-(((0x100 - ((i>>12)&0xFF))*99)/0x100);
			if (b < 10)
				prf_putchar('0', flags);
			printn(b, 10, 0, flags);
		}
		break;

	case 'e':		/* print out ethernet address */
		for (s = (char *)*adx, i = 0 ; i < 6 ; i++, s++) {
			printn((*s)&0xFF, 16, 0, flags);
			if (i < 5)
				prf_putchar(':', flags);
		}
		break;

	case 'i':		/* identify bus/cpu type */
#ifdef	QBUS
# ifdef	M68020
		s = "QBUS 68020 ";
# else	M68020
		s = "QBUS 68010 ";
# endif	M68020
#else	QBUS
# ifdef	M68020
#   ifdef	M68025
		s = "VMEBUS 68025 ";
#   else	M68025
		s = "VMEBUS 68020 ";
#   endif	M68025
# else	M68020
		s = "VMEBUS 68010 ";
# endif	M68020
#endif	QBUS
		for (; c = *s; s++)
			prf_putchar(c, flags);
		s = REV;
		for (; c = *s; s++)
			prf_putchar(c, flags);
		goto loop;
	}
	adx++;
	goto loop;
}

/*
 * Printn prints a number n in base b using p places.
 * We don't use recursion to avoid deep kernel stacks.
 */
printn(n, b, p, flags)
	u_long n;
{
	char prbuf[32];
	register char *cp = prbuf;
	register int np = 0;

	if (b == 10 && (int)n < 0) {
		prf_putchar('-', flags);
		n = (unsigned)(-(int)n);
	}
	do {
		*cp++ = "0123456789abcdef"[n%b];
		n /= b;
		np++;
	} while (n);
	if (p) {
		while (np++ < p)
			if (b == 10)
				prf_putchar(' ', flags);
			else
				prf_putchar('0', flags);
	}
	do
		prf_putchar(*--cp, flags);
	while (cp > prbuf);
}

prf_putchar(c, flags)
{
	if (flags & TOCONS)
		(*putch)(c);
	if (flags & TOBUF)
		*prf_bufp++ = c;
}

char *
stripwhite(buf)
	char *buf;
{
	register char c;
	register char *s1, *s2;

	for (s1 = s2 = buf ;  c = *s2 ; s2++)
		if (c != ' ' && c != '\t')
			*s1++ = c;
	*s1 = c;
	return (buf);
}

char *
striplwhite(buf)		/* remove leading white space */
	char *buf;
{
	register char *s1, *s2;

	for (s2 = buf ; *s2 == ' ' || *s2 == '\t'; s2++)
		;
	for (s1 = buf ;  *s2 ;)
		*s1++ = *s2++;
	*s1 = 0;
	return (buf);
}

char *
zerowhite(buf)
	char *buf;
{
	register char *s = buf;

	for (s = buf;  *s;  s += 1)
		if (*s == ' ' || *s == '\t')
			*s = '\0';
	return (buf);
}

gets(buf)
	char *buf;
{
	getsi(buf, 0);
}

getsi(buf, i)
	register char *buf;
{
	register char *lp = &buf[i];
	register int c;

	for (;;) {
		c = (*getch)() & 0x7F;
		switch(c) {
		case '\n':
		case '\r':
			c = '\n';
			*lp++ = '\0';
			return;

		case '':
			(*putch)('\b');
		case '\b':
			lp--;
			if (lp <= buf)
				lp = buf;
			else {
				(*putch)(' ');
				(*putch)('\b');
			}
			*lp = 0;
			break;

		case 'u'&037:
			lp = buf;
			(*putch)('\n');
			break;

		case 0x03:		/* ^C */
		case 0x04:		/* ^D */
			exit ();

		default:
			*lp++ = c;
		}
	}
}

getnum(string)
	unsigned char *string;
{
	register unsigned char *sp = string;
	register unsigned char c;
	register int base, num, digit;

	num = 0;
	while ((c = *sp) == ' ' || c == '\t')
		sp++;
	if (*sp == '0') {
		sp++;
		if (*sp == 'x' || *sp == 'X') {
			sp++;
			base = 16;
		} else
			base = 8;
	} else
		base = 10;

	while (c = *sp++) {
		switch (base) {
		  case 8:
			if ('0' <= c && c <= '7') {
				digit = c - '0';
				break;
			} else {
				printf("Invalid octal digit (%c)\n", c);
				return -1;
			}

		  case 16:
			digit = ctoh(c);
			if (digit == -1) {
				printf("Invalid hex digit (%c)\n", c);
				return -1;
			} else
				break;

		  case 10:
			if ('0' <= c && c <= '9') {
				digit = c - '0';
				break;
			} else {
				printf("Invalid decimal digit (%c)\n", c);
				return -1;
			}
		}
		num = num*base + digit;
	}
	return num;
}

gethex(string)
	char *string;
{
	register char *cp = string;
	register int c, n;

	n = 0;
	while (c = *cp++)
		if ((c = ctoh(c)) != -1)
			n = n * 16 + c;
		else 
			return getnum(string);
	return(n);
}

ctoh(c)
register char c;
{
	if (c >= '0' && c <= '9')
		return (c - '0');
	else if (c >= 'a' && c <= 'f')
		return (c - 'a' + 10);
	else if (c >= 'A' && c <= 'F')
		return (c - 'A' + 10);
	else
		return -1;
}

exit()
{
	printf("\nExit called\n");
	_rtt();
}
