#include	"../is68k/board.h"

int lerrs, terrs, toterrs;
int verbose;

char buf[80];

#define	u_int	unsigned int

struct test {
	char	*test_name;
	u_int	*test_start;
	u_int	*test_stop;
	int	test_mask;
	int	test_incr;
	int	test_nloc;
} test[] = {
#define PTP		0
	{"PTP",		(u_int *)PTP_BASE,	
			(u_int *)(PTP_BASE + PTP_INCR*(NPTPS-1)),
			PTP_MASK,	PTP_INCR,	NPTPS},
#define STBUF  		1
	{"TBUF_SYS",	(u_int *)TBUF_BASE_SYS,	
			(u_int *)(TBUF_BASE_SYS + TBUF_INCR*(NTBUFS-1)),
			TBUF_MASK,	TBUF_INCR,	NTBUFS},
#define UTBUF  		2
	{"TBUF_SYS",	(u_int *)TBUF_BASE_USR,	
			(u_int *)(TBUF_BASE_USR + TBUF_INCR*(NTBUFS-1)),
			TBUF_MASK,	TBUF_INCR,	NTBUFS},

#ifdef	M68025
#define VDMA  		3
	{"VDMA",	(u_int *)VDMA_BASE,	
			(u_int *)(VDMA_BASE + VDMA_INCR*(NVDMAS-1)),
			VDMA_MASK,	VDMA_INCR,	NVDMAS},
#define	CACHETA		4
	{"CACHETAG_A",	(u_int *)CTAG_A_BASE,	
			(u_int *)(CTAG_A_BASE + CTAG_INCR*(NCTAGS-1)),
			CTAG_MASK,	CTAG_INCR,	NCTAGS},
#define	CACHEDA		5
	{"CACHEDAT_A",	(u_int *)CDAT_A_BASE,	
			(u_int *)(CDAT_A_BASE+CDAT_INCR*(NCDATSL-1)),
			CDAT_MASK,	CDAT_INCR,	NCDATSL},
#define	CACHETB		6
	{"CACHETAG_B",	(u_int *)CTAG_B_BASE,	
			(u_int *)(CTAG_B_BASE + CTAG_INCR*(NCTAGS-1)),
			CTAG_MASK|CTAG_CTL_MASK,	CTAG_INCR,	NCTAGS},
#define	CACHEDB		7
	{"CACHEDAT_B",	(u_int *)CDAT_B_BASE,	
			(u_int *)(CDAT_B_BASE + CDAT_INCR*(NCDATSL-1)),
			CDAT_MASK,	CDAT_INCR,	NCDATSL},
#define	ALL		8
#else	M68025
#define	ALL		3
#endif	M68025
	{"ALL",		0,		0,
			0,		0,		0},
	{0,		0,		0,
			0,		0,		0},
};

main()
{
	long repeat, forever;
	int lapcnt, abort;
	int run, t, i;
	struct test *tp;

	printf("\n--- %i Standalone MMU Diagnostic Tests ---\n\n");
	lerrs = terrs = toterrs = 0;
regdef:	run = 0;
	printf("\nTest functionality of:\n");
	for (tp = test, i = 0; tp->test_name; tp++, i++)
		printf("  %c) %s\n", 'a'+i, tp->test_name);
	printf("Enter letter of functionality: ");
	stripwhite(gets(buf));
	if (buf[0] >= 'a' && buf[0] <= 'a'+i)
		run = 1 << (buf[0] - 'a');
	else if (buf[0] == 'x')
		exit();
	else 
		goto regdef;
	if (run == (1 << ALL))
		run -= 1;
menu:	printf("\nTests available:\n");
	printf("  a) Patterns\n  b) Walk\n  c) Ping-pong\n");
	printf("  d) Uniqueness\n  z) All tests\n\n");
	while (1) {
		printf("Enter letter of desired test ('H' for help, 'X' for region redefinition): ");
		stripwhite(gets(buf));
		t = buf[0];
		if (t == 'H')
			goto menu;
		else if (t == 'X')
			goto regdef;
		else if (t == 'x')
			exit();
		printf("Repeat count in decimal (0 means forever): ");
		stripwhite(gets(buf));
		repeat = atol(buf);
		forever = (repeat == 0 ? 1 : 0);
		verbose = 0;
		printf("Verbose? (no): ");
		stripwhite(gets(buf));
		if (buf[0] == 'y')
			verbose = 1;
		printf("\n");
		for (lapcnt = 1; (forever || repeat-- > 0); lapcnt++) {
		    if (abort = getlocal())
			break;
		    printf("Lap %d\n", lapcnt);
		    switch (t) {
			  case 'a':
				for (i = 0; i < ALL; i++)
				    if ((run & (1 << i)) && (abort = patt(i)))
					goto endfor;
				break;

			  case 'b':
				for (i = 0; i < ALL; i++)
				    if ((run & (1 << i)) && (abort = walk(i)))
					goto endfor;
				break;

			  case 'c':
				for (i = 0; i < ALL; i++)
				    if ((run & (1 << i)) && (abort = ping(i)))
					goto endfor;
				break;

			  case 'd':
				for (i = 0; i < ALL; i++)
				    if ((run & (1 << i)) && (abort = uniq(i)))
					goto endfor;
				break;

			  case 'z':
				for (i = 0; i < ALL; i++)
				    if ((run & (1 << i)) && 
					( (abort = patt(i)) ||
					  (abort = walk(i)) ||
					  (abort = ping(i)) ||
					  (abort = uniq(i))	))
					goto endfor;
				break;

			  default:
				printf("No such test\n");
				goto endfor;
		    }

		    printf("  %d errors this lap\n", lerrs);
		    lerrs = 0;
		}
endfor:		if (abort) {
			printf("\nTest aborted");
			abort = 0;
		} else
			printf("Test completed");
		printf(" with %d errors this test, %d total errors\n\n",
			terrs, toterrs);
		terrs = 0;
	}
}

# define NPATT 4
# define NPATT2 68
unsigned int tpatt[NPATT2] = {0, 0xffffffff, 0x55555555, 0xaaaaaaaa,
			0x1, 0x2, 0x4, 0x8,
			0x10, 0x20, 0x40, 0x80,
			0x100, 0x200, 0x400, 0x800,
			0x1000, 0x2000, 0x4000, 0x8000,
			0x10000, 0x20000, 0x40000, 0x80000,
			0x100000, 0x200000, 0x400000, 0x800000,
			0x1000000, 0x2000000, 0x4000000, 0x8000000,
			0x10000000, 0x20000000, 0x40000000, 0x80000000,
			~0x1, ~0x2, ~0x4, ~0x8,
			~0x10, ~0x20, ~0x40, ~0x80,
			~0x100, ~0x200, ~0x400, ~0x800,
			~0x1000, ~0x2000, ~0x4000, ~0x8000,
			~0x10000, ~0x20000, ~0x40000, ~0x80000,
			~0x100000, ~0x200000, ~0x400000, ~0x800000,
			~0x1000000, ~0x2000000, ~0x4000000, ~0x8000000,
			~0x10000000, ~0x20000000, ~0x40000000, ~0x80000000};

patt(i)
{
	register unsigned int	*start =	test[i].test_start;
	register unsigned int	*stop =		test[i].test_stop;
	register unsigned int	incr =		test[i].test_incr/sizeof(int);
	register unsigned int	mask =		test[i].test_mask;
	register unsigned int	*addr;
	register unsigned int	cpatt, rpatt;
	register int		x, n;

	printf("  Pattern test - %s\n",test[i].test_name);
	if (i != PTP)
		for (n = 0; n < NPATT2; n++) {
			cpatt = tpatt[n] & mask;
			if (verbose)
				printf("\r    Write  %x:       ", cpatt);
			for (addr = start; addr <= stop; addr+=incr)
				*addr = cpatt;
			if (verbose)
				printf("\r    Verify %x:       ", cpatt);
			for (addr = start; addr <= stop; addr+=incr) {
				rpatt = *addr & mask;
				if (rpatt != cpatt && error(i, addr, cpatt, rpatt, x))
					return 1;
			}
			if (getlocal())
				return 1;
		}
	else
		for (x = 0 ; x < NCTX ; x++) {
		    *CTX = x;
		    start = test[i].test_start;
		    stop = test[i].test_stop;
		    for (n = 0; n < NPATT2; n++) {
			cpatt = tpatt[n] & mask;
			if (verbose)
				printf("\r    Write  %x:       ", cpatt);
			for (addr = start; addr <= stop; addr+=incr)
				*addr = cpatt;
			if (verbose)
				printf("\r    Verify %x:       ", cpatt);
			for (addr = start; addr <= stop; addr+=incr) {
				rpatt = *addr & mask;
				if (rpatt != cpatt && error(i, addr, cpatt, rpatt, x))
					return 1;
			}
			if (getlocal())
				return 1;
		    }
		}
	if (verbose)
		printf("\r                                     \r");
	return 0;
}

walk(i)
{
	register unsigned int	*start =	test[i].test_start;
	register unsigned int	*stop =		test[i].test_stop;
	register unsigned int	incr =		test[i].test_incr/sizeof(int);
	register unsigned int	mask =		test[i].test_mask;
	register unsigned int	*addr;
	register unsigned int	cpatt;
	register int		x, n;

	printf("  Walking test - %s\n",test[i].test_name);
	if (i != PTP)
		for (n = 0; n < NPATT; n++) {
			cpatt = tpatt[n];
			if (verbose)
				printf("\r    Write  %x:       ", cpatt);
			for (addr = start; addr <= stop; addr += incr)
				*addr = cpatt;
			if (verbose)
				printf("\r    Walk   %x:       ", cpatt);
			if (walk1(i, start, stop, cpatt, mask, incr, x))
				return 1;
		}
	else
		for (x= 0 ; x < NCTX ; x++) {
		    *CTX = x;
		    start = test[i].test_start;
		    stop = test[i].test_stop;
		    for (n = 0; n < NPATT; n++) {
			cpatt = tpatt[n];
			if (verbose)
				printf("\r    Write  %x:       ", cpatt);
			for (addr = start; addr <= stop; addr += incr)
				*addr = cpatt;
			if (verbose)
				printf("\r    Walk   %x:       ", cpatt);
			if (walk1(i, start, stop, cpatt, mask, incr, x))
				return 1;
		    }
		}
	if (verbose)
		printf("\r                                     \r");
	return 0;
}

walk1(i, start, stop, cpatt, mask, incr, x)
register unsigned int *start, *stop, cpatt;
unsigned int mask;
{
	register unsigned int *addr, *addr2;
	register unsigned int pattc, rpatt;

	pattc = ~cpatt;
	pattc &= mask;
	cpatt &= mask;
	for (addr = start; addr <= stop; addr +=incr) {
		getlocal();	/* clear port */
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2 += incr) {
			rpatt = *addr2 & mask;
			if (rpatt != cpatt && addr2 != addr &&
			    error(i, addr2, cpatt, rpatt, x))
				return 1;
		}
		rpatt = *addr & mask;
		if (rpatt != pattc && error(i, addr, pattc, rpatt, x))
			return 1;
		*addr = cpatt;
		if (getlocal())
			return 1;
	}
	for (addr = start; addr <= stop; addr += incr) {
		rpatt = *addr & mask;
		if (rpatt != cpatt && error(i, addr, cpatt, rpatt, x))
			return 1;
	}
	return 0;
}

ping(i)
{
	register unsigned int	*start =	test[i].test_start;
	register unsigned int	*stop =		test[i].test_stop;
	register unsigned int	incr =		test[i].test_incr/sizeof(int);
	register unsigned int	mask =		test[i].test_mask;
	register unsigned int	*addr;
	register unsigned int	cpatt;
	register int		x, n;

	printf("  Ping-pong test - %s\n",test[i].test_name);
	if (i != PTP)
		for (n = 0; n < NPATT; n++) {
			if (verbose)
				printf("\r    ping-pong %x from %x to %x              ",
				(unsigned int)tpatt[n], (int)start, (int)stop);
			if (ping1(i, start, stop, tpatt[n], mask, incr, x))
				return 1;
		}
	else
		for (x = 0 ; x < NCTX ; x++) {
		    *CTX = x;
		    start = test[i].test_start;
		    stop = test[i].test_stop;
		    for (n = 0; n < NPATT; n++) {
			if (verbose)
				printf("\r    ping-pong %x from %x to %x              ",
				(int)tpatt[n], (int)start, (int)stop);
			if (ping1(i, start, stop, tpatt[n], mask, incr, x))
				return 1;
		    }
		}
	if (verbose)
		printf("\r                                                 \r");
	return 0;
}

ping1(i, start, stop, cpatt, mask, incr, x)
unsigned int *start, *stop, cpatt, mask;
{
	register unsigned int *addr1, *addr2, *addr3, *addr4;
	register unsigned int pattc;
	int n;

	pattc = ~cpatt & mask;
	cpatt &= mask;
	for (addr1 = start; addr1 <= stop; addr1 += incr)
		*addr1 = cpatt;
	for (addr1=start,addr2=stop; addr1<addr2; addr1 += incr,addr2 -= incr) {
		getlocal();	/* clear buffer */
		*addr1 = pattc;
		*addr2 = pattc;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc &&
			    error(i, addr3, pattc, *addr3 & mask, x))
				return 1;
			if ((*addr4 & mask) != pattc &&
			    error(i, addr4, pattc, *addr4 & mask, x))
				return 1;
		}
		for (addr3 = addr1+incr, addr4 = addr2-incr; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt &&
			    error(i, addr3, cpatt, *addr3 & mask, x))
				return 1;
			if ((*addr4 & mask) != cpatt &&
			    error(i, addr4, cpatt, *addr4 & mask, x))
				return 1;
		}

		if (getlocal())
			return 1;
	}
	for ( addr1 -= incr, addr2 += incr; addr1 >= start;
		addr1 -= incr, addr2 += incr) {
		getlocal();	/* clear buffer */

		*addr1 = cpatt;
		*addr2 = cpatt;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3 += incr,
			addr4 -= incr) {
			if ((*addr3 & mask) != pattc &&
			    error(i, addr3, pattc, *addr3 & mask, x))
				return 1;
			if ((*addr4 & mask) != pattc &&
			    error(i, addr4, pattc, *addr4 & mask, x))
				return 1;
		}
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3 += incr, addr4 -= incr) {
			if ((*addr3 & mask) != cpatt &&
			    error(i, addr3, cpatt, *addr3 & mask, x))
				return 1;
			if ((*addr4 & mask) != cpatt &&
			    error(i, addr4, cpatt, *addr4 & mask, x))
				return 1;
		}

		if (getlocal())
			return 1;
	}
	return 0;
}

uniq(i)
int i;
{
	register unsigned int	*start =	test[i].test_start;
	register unsigned int	*stop =		test[i].test_stop;
	register unsigned int	incr =		test[i].test_incr/sizeof(int);
	register unsigned int	mask =		test[i].test_mask;
	register unsigned int	*addr, *addr2;
	register unsigned int	cpatt, rpatt;
	unsigned int		x, n, k;

	printf("  Uniqueness test - %s\n",test[i].test_name);
	if (i != PTP)
		for (addr = start, k = 0; addr <= stop; addr += incr, k++) {
			if (verbose)
				printf("\r    seed %x    ",k);
			getlocal();	/* clear port */
			for (addr2=start, n=0; addr2 <= stop; addr2+=incr, n++)
				*addr2 = (n + k) & mask;
			for (addr2=start,n=0; addr2 <= stop; addr2+=incr, n++) {
				rpatt = *addr2 & mask;
				cpatt = (n + k) & mask;
				if (rpatt != cpatt && error(i, addr, cpatt, rpatt, x))
					return 1;
			}
			if (getlocal())
				return 1;
		}
	else
		for (addr = start, k = 0; addr <= stop; addr += incr, k++) {
		    if (verbose)
		    	printf("\r    seed %x    ",k);
		    getlocal();	/* clear port */
		    for (x = 0, n = 0 ; x < NCTX ; x++) {
			*CTX = x;
			for (addr2 = start; addr2 <= stop; addr2+=incr, n++)
				*addr2 = (n + k) & mask;
		    }
		    for (x = 0, n = 0 ; x < NCTX ; x++) {
			*CTX = x;
			for (addr2 = start; addr2 <= stop; addr2+=incr, n++) {
				rpatt = *addr2 & mask;
				cpatt = (n + k) & mask;
				if (rpatt != cpatt && error(i, addr, cpatt, rpatt, x))
					return 1;
			}
		    }
		    if (getlocal())
			return 1;
		}
	if (verbose)
		printf("\r                    \r");
	return 0;
}

error(i, addr, wrote, read, ctx)
register unsigned int *addr, wrote, read;
{
	register int j;

	j = perror("%s error at ", test[i].test_name);
	if (i == PTP)
		printf("context %d ", ctx);
	printf("%x: wrote %x, read %x\n", (int)addr, wrote, read);
	*addr = wrote;			/* Try to reset to correct value */
	lerrs++; terrs++; toterrs++;
	return j;
}
