#include "../is68k/board.h"

#ifdef	QBUS
#ifdef	M68020
#else	M68020
# define MAXADDR	0x7FDFFEL
# define MAXBANKS	0x7FF
#endif	M68020
#else	QBUS
#ifdef	M68020
# define MAXADDR	0xFFFFFEL
# define MAXBANKS	0xFFFF
#else	M68020
# define MAXADDR	0xFFDFFCL
# define MAXBANKS	0x3E
#endif	M68020
#endif	QBUS

char buf[80];
int lerrs;
int terrs;
int toterrs;
int tsize;
extern short end;
int verbose;

main()
{
	short *start, *stop;
	long nbanks, repeat, forever;
	char allc, test;
	int lapcnt, abort;
	int *q;

#ifdef	M68020
	onetoone(0);
#endif	M68020

	lerrs = 0;
	terrs = 0;
	toterrs = 0;
	printf("\n--- %i Standalone Memory Diagnostics ---\n\n");
regdef:	printf("Test region definition:\n");
	printf("  Test all memory (default 'yes') ? ");
	stripwhite(gets(buf));
	if ((allc = buf[0]) == 'n' || allc == 'N') {
    memdef:	printf("  Memory from 0 to %x reserved\n",&end);
		printf("  Enter hex start address: ");
		stripwhite(gets(buf));
		start = (short *)gethex(buf);
		if (start >= 0 && start <= (short *)&end) {
			printf("that would clobber you\n");
			goto regdef;
		}
		printf("  Enter hex stop address:  ");
		stripwhite(gets(buf));
		stop = (short *)gethex(buf);
		if (stop >= 0 && stop <= (short *)&end) {
			printf("that would clobber you\n");
			goto regdef;
		}
		if (stop <= start) {
			printf("last <= start\n");
			goto memdef;
		}
	} else {
		while ((nbanks = getmem()) < 1)
			printf("Invalid number of memory banks\n");
		start = (short *)&end;
		stop = (short *)((nbanks << 18) - 2);
		if (stop > (short *)MAXADDR)
			stop = (short *)MAXADDR;
	}
	verbose = 0;
	printf("  Verbose? (default no): ");
	stripwhite(gets(buf));
	if (buf[0] == 'y')
		verbose = 1;

	tsize = sizeof(short);
	printf("  Test as a byte? (default no): ");
	stripwhite(gets(buf));
	if (buf[0] == 'y')
		tsize |= sizeof(char);
	printf("  Test as a short? (default yes): ");
	stripwhite(gets(buf));
	if (buf[0] == 'n')
		tsize &= ~sizeof(short);
	printf("  Test as a long? (default no): ");
	stripwhite(gets(buf));
	if (buf[0] == 'y')
		tsize |= sizeof(long);
	printf("  Test with parity? (default yes): ");
	stripwhite(gets(buf));
	if ((allc = buf[0]) == 'n' || allc == 'N')
		_parityoff();
	else
		_parityon();
menu:	printf("\nTests available:\n");
	printf("  a) Patterns(short)\n  b) Walk(short)\n  c) Ping-pong(short)\n  d) Exec(-)\n");
	printf("  e) Uniqueness(long)\n  z) All tests\n\n");
	while (1) {
		printf("Enter letter of desired test ('H' for help, 'X' for region redefinition): ");
		stripwhite(gets(buf));
		test = buf[0];
		if (test == 'H')
			goto menu;
		else if (test == 'X') {
			printf("\n");
			goto regdef;
		} else if (test == 'x')
			exit();
		printf("Repeat count in decimal (0 means forever): ");
		stripwhite(gets(buf));
		repeat = atol(buf);
		forever = (repeat == 0 ? 1 : 0);
		printf("\n");
		for (lapcnt = 1; (forever || repeat-- > 0); lapcnt++) {
			if (abort = getlocal())
				break;
			printf("Lap %d\n", lapcnt);
			switch (test) {
			  case 'a':
				if (abort = patt(start, stop))
					goto endfor;
				break;

			  case 'b':
				if (abort = walk(start, stop))
					goto endfor;
				break;

			  case 'c':
				if (abort = ping(start, stop))
					goto endfor;
				break;

			  case 'd':
				if (abort = exec(start, stop))
					goto endfor;
				break;

			  case 'e':
				if (abort = uniq(start, stop))
					goto endfor;
				break;

			  case 'z':
				if (abort = patt(start, stop))
					goto endfor;
				if (abort = walk(start, stop))
					goto endfor;
				if (abort = ping(start, stop))
					goto endfor;
				if (abort = exec(start, stop))
					goto endfor;
				if (abort = uniq(start, stop))
					goto endfor;
				break;

			  default:
				printf("  No such test\n");
				goto endfor;
			}
			printf("  %d errors this lap\n", lerrs);
			lerrs = 0;
		}
endfor:
		if (abort) {
			printf("\n Test aborted");
			abort = 0;
		} else
			printf("Test completed");
		printf(" with %d errors on last test, %d total errors\n\n",
			terrs, toterrs);
		terrs = 0;
	}
}

getmem()
{
	int ibanks = 0;
	short *p;

	printf("  Enter number of banks (1 to %d; 0 for auto sizing): ",MAXBANKS);
	stripwhite(gets(buf));
	ibanks = atol(buf);
	if (ibanks < 0 || ibanks > MAXBANKS)
		return (0);
	else if(ibanks)
		return (ibanks);
	for (p = (short *)&end; p <= (short *)MAXADDR; p += 0x1000) {
		if (!probe(p,&ibanks)) {
bad: 			ibanks = ((int)(p-0x1000) >> 18)+1;
			printf("  Found %d memory banks\n", ibanks);
			return (ibanks);
		}
		*p = 0x5555;
		if (*p != 0x5555)
			goto bad;
	}
	printf("  Automatic sizing failed\n");
	return (0);
}

# define NPATT 4
# define BNPATT2 20
char bspatt[BNPATT2] = {0, 0xff, 0x55, 0xaa,
		0x1, 0x2, 0x4, 0x8,
		0x10, 0x20, 0x40, 0x80,
		~0x1, ~0x2, ~0x4, ~0x8,
		~0x10, ~0x20, ~0x40, ~0x80};
# define WNPATT2 36
short wspatt[WNPATT2] = {0, 0xffff, 0x5555, 0xaaaa,
		0x1, 0x2, 0x4, 0x8,
		0x10, 0x20, 0x40, 0x80,
		0x100, 0x200, 0x400, 0x800,
		0x1000, 0x2000, 0x4000, 0x8000,
		~0x1, ~0x2, ~0x4, ~0x8,
		~0x10, ~0x20, ~0x40, ~0x80,
		~0x100, ~0x200, ~0x400, ~0x800,
		~0x1000, ~0x2000, ~0x4000, ~0x8000};
# define LNPATT2 68
long lspatt[LNPATT2] = {0, 0xffffffff, 0x55555555, 0xaaaaaaaa,
		0x1, 0x2, 0x4, 0x8,
		0x10, 0x20, 0x40, 0x80,
		0x100, 0x200, 0x400, 0x800,
		0x1000, 0x2000, 0x4000, 0x8000,
		0x10000, 0x20000, 0x40000, 0x80000,
		0x100000, 0x200000, 0x400000, 0x800000,
		0x1000000, 0x2000000, 0x4000000, 0x8000000,
		0x10000000, 0x20000000, 0x40000000, 0x80000000,
		~0x1, ~0x2, ~0x4, ~0x8,
		~0x10, ~0x20, ~0x40, ~0x80,
		~0x100, ~0x200, ~0x400, ~0x800,
		~0x1000, ~0x2000, ~0x4000, ~0x8000,
		~0x10000, ~0x20000, ~0x40000, ~0x80000,
		~0x100000, ~0x200000, ~0x400000, ~0x800000,
		~0x1000000, ~0x2000000, ~0x4000000, ~0x8000000,
		~0x10000000, ~0x20000000, ~0x40000000, ~0x80000000};

leng(start)
unsigned short *start;
{
	unsigned char *cp = (unsigned char *)start;
	unsigned short *sp = (unsigned short *)start;
	unsigned long *lp = (unsigned long *)start;
	register int i;
}

patt(start, stop)
unsigned char *start;
unsigned char *stop;
{
	if (tsize & sizeof(char))
		pattb(start, stop);
	if (tsize & sizeof(short))
		pattw(((int)start) & (~1), ((int)stop) & (~1));
	if (tsize & sizeof(long))
		pattl(((int)start) & (~3), ((int)stop) & (~3));
}

pattb(start, stop)
unsigned char *start;
register unsigned char *stop;
{
	register unsigned char *addr;
	register unsigned char cpatt, rpatt;
	char n;

	printf("  Byte Pattern Test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);
	for (n = 0; n < BNPATT2; n++) {
		cpatt = bspatt[n];
		if (verbose)
			printf("\r    Writing   %x:    ", cpatt);
		for (addr = start; addr <= stop; addr++)
			*addr = cpatt;
		if (getlocal())
			return 1;
		if (verbose)
			printf("\r    Verifying %x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) {
			rpatt = *addr;
			if (rpatt != cpatt && error(addr, cpatt, rpatt))
				return 1;
		}
		if (getlocal())
			return 1;
	}
	if (verbose)
		printf("\r                     \r");
	return 0;
}

pattw(start, stop)
unsigned short *start;
register unsigned short *stop;
{
	register unsigned short *addr;
	register unsigned short cpatt, rpatt;
	short n;

	printf("  Word Pattern Test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);
	for (n = 0; n < WNPATT2; n++) {
		cpatt = wspatt[n];
		if (verbose)
			printf("\r    Writing   %x:    ", cpatt);
		for (addr = start; addr <= stop; addr++)
			*addr = cpatt;
		if (getlocal())
			return 1;
		if (verbose)
			printf("\r    Verifying %x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) {
			rpatt = *addr;
			if (rpatt != cpatt && error(addr, cpatt, rpatt))
				return 1;
		}
		if (getlocal())
			return 1;
	}
	if (verbose)
		printf("\r                     \r");
	return 0;
}

pattl(start, stop)
unsigned long *start;
register unsigned long *stop;
{
	register unsigned long *addr;
	register unsigned long cpatt, rpatt;
	long n;

	printf("  Long Pattern Test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);
	for (n = 0; n < LNPATT2; n++) {
		cpatt = lspatt[n];
		if (verbose)
			printf("\r    Writing   %x:    ", cpatt);
		for (addr = start; addr <= stop; addr++)
			*addr = cpatt;
		if (getlocal())
			return 1;
		if (verbose)
			printf("\r    Verifying %x:    ", cpatt);
		for (addr = start; addr <= stop; addr++) {
			rpatt = *addr;
			if (rpatt != cpatt && error(addr, cpatt, rpatt))
				return 1;
		}
		if (getlocal())
			return 1;
	}
	if (verbose)
		printf("\r                     \r");
	return 0;
}

/*
**	Should I modify this to accept the function to call as an argument?
*/
walk(start, stop)
unsigned short *start;
unsigned short *stop;
{
	register unsigned short *rstart, *rstop, *addr1, *addr2;
	register unsigned short cpatt, pattc;
	short n;

	printf("  Walk Test: Start=0x%x, Stop=0x%x\n", (int)start, (int)stop);
	for (n = 0; n < NPATT; n++) {
		cpatt = wspatt[n];
		pattc = ~cpatt;
		for (rstart = start; rstart < stop; rstart += 0x1000) {
			printf("\r    Writing   %x:    ", cpatt);
			for (addr1 = start; addr1 <= stop; addr1++)
				*addr1 = cpatt;
			rstop = rstart + 0xfff;	/* note automatic conversion */
			rstop = (rstop <= stop ? rstop : stop);
			printf("\r    Walking   %x:    ", pattc);
			if (walk1(rstart, rstop, cpatt))
				return 1;
			printf("\r    Test A    %x:    ", cpatt);
			for (addr1 = start; addr1 < rstart; addr1++)
				if (*addr1 != cpatt && 
				    error(addr1, cpatt, *addr1))
					return 1;
			printf("\r    Test B    %x:    ", cpatt);
			for (addr1 = rstop + 1; addr1 < stop; addr1++)
				if (*addr1 != cpatt && 
				    error(addr1, cpatt, *addr1))
					return 1;
			if (getlocal())
				return 1;
		}
	}
	printf("\r                     \r");
	return 0;
}

walk1(start, stop, cpatt)
unsigned short *start;
register unsigned short *stop, cpatt;
{
	register unsigned short *addr, *addr2;
	register unsigned short pattc, rpatt;
	
	pattc = ~cpatt;
	for (addr = start; addr <= stop; addr++) {
		*addr = pattc;
		for (addr2 = start; addr2 <= stop; addr2++) {
			rpatt = *addr2;
			if (rpatt != cpatt && addr2 != addr && 
			    error(addr2, cpatt, rpatt))
				return 1;
		}
		rpatt = *addr;
		if (rpatt != pattc && error(addr, pattc, rpatt))
			return 1;
		*addr = cpatt;
		if (getlocal())
			return 1;
	}
	for (addr = start; addr <= stop; addr++) {
		rpatt = *addr;
		if (rpatt != cpatt && error(addr, cpatt, rpatt))
			return 1;
	}
	return 0;
}

ping(start, stop)
unsigned short *start;
register unsigned short *stop;
{
	register unsigned short *rstart, *rstop, *addr1;

	printf("  Ping-pong Test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);
	for (rstart = start; rstart < stop; rstart += 0x1000) {
		for (addr1 = start; addr1 <= stop; addr1++)
			*addr1 = 0;
		rstop = rstart + 0xfff;	/* note automatic conversion of fff */
		rstop = (rstop <= stop ? rstop : stop);
		printf("\r    ping-pong %x to %x        ",(int)start, (int)stop);
		if(ping1(rstart, rstop))
			return 1;
		for (addr1 = start; addr1 < rstart; addr1++)
			if (*addr1 != 0 && error(addr1, 0, *addr1))
				return 1;
		for (addr1 = rstop + 1; addr1 < stop; addr1++)
			if (*addr1 != 0 && error(addr1, 0, *addr1))
				return 1;
		if (getlocal())
			return 1;
	}
	printf("\r                              \r");
	return 0;
}

ping1(start, stop)
unsigned short *start, *stop;
{
	register unsigned short *addr1, *addr2, *addr3, *addr4;
	register unsigned short caddr1, caddr2, caddr3, caddr4;
	short n;

	for (addr1 = start; addr1 <= stop; addr1++)
		*addr1 = 0;
	for (addr1 = start, addr2 = stop; addr1 < addr2; addr1++, addr2--) {
		*addr1 = 0xffff;
		*addr2 = 0xffff;
		for (addr3=start, addr4=stop; addr3 <= addr1; addr3++, addr4--) {
			if (*addr3 != 0xffff && error(addr3, 0xffff, *addr3))
				return 1;
			if (*addr4 != 0xffff && error(addr4, 0xffff, *addr4))
				return 1;
		}
		for (addr3 = addr1+1, addr4 = addr2-1; addr3 <= addr4;
			addr3++, addr4--) {
			if (*addr3 != 0 && error(addr3, 0, *addr3))
				return 1;
			if (*addr4 != 0 && error(addr4, 0, *addr4))
				return 1;
		}

		if (getlocal())
			return 1;
	}
	for ( --addr1, ++addr2; addr1 >= start; addr1--, addr2++) {
		*addr1 = 0;
		*addr2 = 0;
		for (addr3=start, addr4=stop; addr3 < addr1; addr3++, addr4--) {
			if (*addr3 != 0xffff && error(addr3, 0xffff, *addr3))
				return 1;
			if (*addr4 != 0xffff && error(addr4, 0xffff, *addr4))
				return 1;
		}
		for (addr3 = addr1, addr4 = addr2; addr3 <= addr4;
			addr3++, addr4--) {
			if (*addr3 != 0 && error(addr3, 0, *addr3))
				return 1;
			if (*addr4 != 0 && error(addr4, 0, *addr4))
				return 1;
		}

		if (getlocal())
			return 1;
	}
	return 0;
	
}


error(addr, wrote, read)
register unsigned short *addr, wrote, read;
{
	int i;

	i = perror("Error at %x: wrote %x, read %x\n", (int)addr, wrote, read);
	lerrs++;
	terrs++;
	toterrs++;
	*addr = wrote;			/* try to reset to correct value */
	return i;
}


/*
**	This test should be replaced by one that would, say, have
**	an addq	in every location but the first few and would return
**	a value that could be tested.
*/
exec(start, stop)
unsigned short *start, *stop;
{
	register unsigned short *addr;
	printf("  Exec Test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);

	for (addr = start; addr < stop-1; addr++)
		*addr = 0x4e71; /* nop */
	/* The rts can't be at stop because of instruction prefetching */
	*(stop-1) = 0x4e75;	/* rts */
	*(start) = 0x4280;	/* clr D0 */
	printf("\r    Jumping to test area   ");
	((int (*)())start)();
	printf("\r    Returned from test area");
	printf("\r                           \r");
	return (0);
}

# define ADDRLEN 32

uniq(start, stop)
unsigned long *start;
register unsigned long *stop;
{
	register unsigned long *addr;
	register unsigned long raddr, saddr;
	short n;

	printf("  Uniqueness test: Start = 0x%x, Stop = 0x%x\n", (int)start,
		(int)stop);
	for (n = 0; n < ADDRLEN; n++) {
		printf("\r    seed %x    ",n);
		saddr = (((unsigned long)addr >> n)
		  | ((unsigned long)addr << (ADDRLEN-n)));
		for (addr = start; addr <= stop; addr++)
			*addr = saddr;
		for (addr = start; addr <= stop; addr++) {
			raddr = *addr;
			if (raddr != saddr && error(addr, saddr, raddr))
				return 1;
		}
		if (getlocal())
			return 1;
	}
	printf("\r                           \r");
	return (0);
}
