#include <stdio.h>
#include <nlist.h>
#include "sadie.h"

struct nlist nl[] = {
	{ "_directory" },
	{ "" },
};

char	*mach[NMACHTYPES + 1] = { "V20", "V25", "Q10", "V10", 0};
char	buf[SADIE_BSIZE];
int	directory[NMACHTYPES * NDIAGNOSTICS];
char	fname[30];

main(argc, argv)
	int argc;
	char *argv[];
{
	register int i, n, f;
	register int recno, testfile;
	register char **mp;

	/* merge all executables, initializing directory structure. */
	for (i = 1, recno = 0, testfile = 0; i < argc; i++) {
	    for (mp = mach; *mp; mp++) {
		sprintf(fname, "%s/%s", *mp, argv[i]);
		if ((f = open(fname, 0)) < 0) {
			directory[testfile++] = -1;
			fprintf(stderr, "%8d:  -------: %s\n", testfile, fname);
		} else {
			directory[testfile++] = recno;
			fprintf(stderr, "%8d: %8d: %s\n", 
						testfile, recno, fname);
			while (read(f, buf, SADIE_BSIZE) > 0) {
				write(1, buf, SADIE_BSIZE);
				recno++;
			}
			close(f);
		}
	    }
	}

	/* patch "directory" to reflect the image format. */
	for (testfile = 0, mp = mach; *mp; testfile++, mp++) {
		sprintf(fname, "%s/sadie", *mp);
		if ((f = open(fname, 2)) < 0) {
			fprintf(stderr, "%s not found??\n",fname);
			exit(1);
		}
		nlist(fname, nl);
		if (nl[0].n_type == 0) {
			fprintf(stderr,"%s not found in namelist of %s\n",
				nl[0].n_name, fname);
			exit(1);
		}
		i = nl[0].n_value + 32 - SADIE_BASE;
		fprintf(stderr,"patching SADIE directory in %s at %x\n",
			fname, i);
		lseek(f, i, 0);
		write(f, directory, sizeof(directory));
	}
	fprintf(stderr,"done image construction and directory patching\n");
}
