#include "saio.h"
#include "sais68k.h"
#include "../is68kdev/sdreg.h"

extern int ignore_intr;

main()
{
	struct sddevice *sdaddr = (struct sddevice *)&vme_stdio[0xFFFFE0];
	register int ninter = 0;
	register int ninterok = 0;
	register int i;

	printf("\n--- %i Interrupt Diagnostic ---\n\n");

	if (!probe(&sdaddr->sdba,&sdaddr->sdba)) {
		printf("sd: not present\n");
		return (-1);
	}
	if (sdaddr->sdcs == 0xffff) {
		printf("sd: not ready\n");
		return (-1);
	}
	_splx(0x2000);
	while (1) {
		ignore_intr = 1;		/* ignore the interrupt */
		sdaddr->sdcs = SD_IE | SD_SIZE | SD_CBSY;
		for (i = 10000; i ; i--)
			if (ignore_intr == 0)
				break;
		if (ignore_intr == 1)
			printf("device not interrupting\n");
		else
			ninterok++;
		ninter++;
		if (getlocal())
			break;
	}
	_splx(0x2700);
	printf("%d of %d interrupts serviced\n", ninterok, ninter);
	exit();
}
