#include "sadie.h"
#include "saio.h"
#include "sais68k.h"
#include "../h/reboot.h"
#include <a.out.h>

extern char	*start;
extern int	autoboot;
extern int	howto;
extern int	devtp;

/*
 * Some optimizations were made in the standalone tape drivers to avoid 
 * excess tape motions to determine the the blocksize.  The MINI_ROOT
 * image must be writen to tape with a block size of SADIE_BSIZE.
 */
int	sadie_blocksize = SADIE_BSIZE;

/*
 * The following structure has the types of tape drives that boot tapes
 * can be run from.  If a machine has more that one of these drives, the
 * first one will be tried first.
 */
char *tape_controllers[] = { 
	"ts", 
#ifdef	QBUS
	"tm", 
#endif	QBUS
	0};

char buffer[8*1024];
char tapebuf[50], diskbuf[50], default_miniroot[50];

/*
 * Copy from to in 8K units. Intended for use in system installation.
 */
main()
{
	register int from, to;
	register int record;
	register int saddr;
	register char **tape;
	extern int errno;

	printf("\n--- %i Miniroot Installer ---\n\n");
	to = getdev(diskbuf);
	for (tape = tape_controllers; *tape; tape++) {
		sprintf(tapebuf, "%s(0,%d)", *tape, NMACHTYPES);
		if ((from = open(tapebuf, 0)) >= 0)
			break;
	}
	if (*tape == 0) {
		printf("cant find tape drive!!\n");
		exit();
	}
	for (record = 0; ; record++) {
		int rcc, wcc;

		rcc = read(from, buffer, sizeof (buffer));
		if (rcc == 0)
			break;
		if (rcc < 0) {
			printf("Record %d: read error, errno=%d\n",
				record, errno);
			break;
		}
		if (rcc < sizeof (buffer))
			printf("Record %d: read short; expected %d, got %d\n",
				record, sizeof (buffer), rcc);
		wcc = write(to, buffer, rcc);
		if (wcc < 0) {
			printf("Record %d: write error: errno=%d\n",
				record, errno);
			break;
		}
		if (wcc < rcc) {
			printf("Record %d: write short; expected %d, got %d\n",
				record, rcc, wcc);
			break;
		}
	}
	close (from);
	close (to);

	/* rewind the tape */
	sprintf(tapebuf, "%s(0,0)", *tape);
	from = open(tapebuf, 0);
	close(from);

	strcat(diskbuf,"vmunix");
	if (saddr = load(diskbuf)) {
		howto = RB_SINGLE;
		booty(saddr);
	}
	printf("Cant load %s\n", diskbuf);
	exit();
}

getdev(buf)
	char *buf;
{
	register int i = -1;

	if (get_default()) {
		printf("\nInstall miniroot on '%s'? (default yes): ", 
			default_miniroot);
		gets(buf);
		stripwhite(buf);
		if (buf[0] == 0 || buf[0] == 'Y' || buf[0] == 'y')
			i = open(default_miniroot, 1);
		strcpy(buf, default_miniroot);
	}
 
	while (i < 0) {
		printf("\nWhere should the miniroot be installed? 'dev(?,1)': ");
		gets(buf);
		stripwhite(buf);
		i = open(stripwhite(buf), 1);
	}
	return (i);
}

get_default()
{
	register char *p, *q;
	register struct devsw *ds = devsw;
	register int i;

	for (ds = devsw; ds->dv_bootf; ds++)
		if (((ds->dv_flags&DEV_MEDIA_MASK) == DEV_DISK) && 
		    (ds->dv_flags & DEV_AUTOBOOT)) {
			p = default_miniroot;
			q = ds->dv_name;
			while (*q) *p++ = *q++;
			q = ds->dv_bootf;
			while (*q && *q != ')')
				*p++ = *q++;
			p--;
			*p++ = '1';
			*p++ = ')';
			*p = 0;
			autoboot = 1;
			if ((i = open(default_miniroot, 1)) >= 0) {
				close(i);
				autoboot = 0;
				return 1;
			}
			autoboot = 0;
		}
	return 0;
}

load(file)
	register char *file;
{
	union {				/* KLUDGE: for sm block transfer */
		struct exec exec;
		char dummy[520];
	} X;
#define	x	X.exec
	register int i, io;
	register char *addr;

	if ((io = open(file, 0)) < 0)
		goto ret0;

	i = read(io, (char *)&x, sizeof x);
	if (i != sizeof x || x.a_magic != 0407) {
		printf("file not bootable\n");
		goto ret0;
	}
	printf("%d", x.a_text);
	x.a_entry &= 0x0FFFFFFF;
	addr = (char *)x.a_entry;
	if (addr+(x.a_text+x.a_data+x.a_bss) >= start)
		goto nomem;
	if (read(io, addr, x.a_text) != x.a_text)
		goto shread;
	addr += x.a_text;
	printf("+%d", x.a_data);
	if (read(io, addr, x.a_data) != x.a_data)
		goto shread;
	addr += x.a_data;
	printf("+%d", x.a_bss);
	bzero(addr, x.a_bss);
	devtp = makedev(major(devsw[iob[io-3].i_ino.i_dev].dv_kermajmin),
		(iob[io-3].i_unit << 3 ) | (iob[io-3].i_fpart & 0x7) );
	close(io);
	printf(" start 0x%x", x.a_entry);
	autoboot = 0; /**/
	printf("\n");
	return(x.a_entry);

shread:	printf("short read\n");
	goto ret0;

nomem:	printf("too big\n");
ret0:	close(io);
	return(0);
}
