#define BSIZE	512

unsigned char	buf1[2*BSIZE];
unsigned char	*pbuf1, *pbuf2;
int		bufsiz;
int 		werr, rerr, verr;

main()
{
	register int start, end;
        register int inc, i;
	int fi, nlap;
        char buf[50];

	printf("\n--- %i Standalone Disk Test ---\n\n");

loop:	werr = 0; rerr = 0; verr = 0;
        do  {
                printf("device: "); gets(buf);
                fi = open(buf, 2);
        } while (fi < 0);
	do  {
		printf("Block size (default is %x bytes): ", BSIZE);
		gets(buf);
		if (buf[0])
		{
			bufsiz = getnum(buf);
			if (bufsiz < 0)
				printf("Illegal number\n");
			if (bufsiz & 1)
			{
				printf("Block size must be even\n");
				bufsiz = -1;
			}
		}
		else
			bufsiz = BSIZE;
	} while (bufsiz < 0);
	do  {
		printf("Starting block number (default 1): ");
		gets(buf);
		start =  getnum(buf);
		if (start == 0)
			start = 1;
		else if (start < 0)
			printf("Illegal number\n");
	} while (start < 0);
	do  {
		printf("Ending block number (default 1000): ");
		gets(buf);
		end =  getnum(buf);
		if (end == 0)
			end = 1000;
		else if (end < 0)
			printf("Illegal number\n");
	} while (end < 0);
	do  {
		printf("Block increment (default 1): ");
		gets(buf);
		inc = getnum(buf);
		if (inc == 0)
			inc = 1;
		else if (inc <= 0)
			printf("Illegal number\n");
	} while (inc < 0);
	printf("Address of disk buffer area (");
	if (bufsiz > BSIZE)
		printf("NO DEFAULT");
	else
		printf("default 0x%x",buf1);
	printf(") : ");
	gets(buf);
	if (buf[0])
		pbuf1 = (unsigned char *)gethex(buf);
	else
		pbuf1 = buf1;
	pbuf2 = pbuf1 + bufsiz;
	do  {
		printf("Number of Laps (0 means forever, default 1): ");
		gets(buf);
		if (!buf[0]) 
			nlap = 1;
		else {
			nlap = getnum(buf);
			if (nlap < 0)
				printf("Illegal number\n");
		}
	} while (nlap < 0);

	for (i = 0 ; ((nlap == 0) ? 1 : (i < nlap)) ; i++) {
	    printf("Lap %d                             \n",i);
	    if (dtest(fi, start, end, inc, 0x00) == -1)
		break;
	    if (dtest(fi, start, end, inc, 0xFF) == -1)
		break;
	    if (dtest(fi, start, end, inc, 0xAA) == -1)
		break;
	    if (dtest(fi, start, end, inc, 0x55) == -1)
		break;
	    if (dtest(fi, start, end, inc, -1) == -1)
		break;
	    if (dtest(fi, start, end, inc, -2) == -1)
		break;
	}
	printf("\nDisk Test: %d Write-errors, %d Read-errors, %d Verify-errors\n",
		werr,rerr,verr);
	close(fi);
	goto loop;
}

dtest(fi, start, end, inc, pat)
{
	register int i, bno, count;

	if (pat == -1) {
		printf("  PATTERN = RAMP               \n");
		for (i = 0; i < bufsiz; i++)	/* load pattern */
			pbuf1[i] = i;
	} else if (pat == -2) {
		printf("  PATTERN = BLOCK NUMBER       \n");
	} else {
		printf("  PATTERN = %x                 \n", pat);
		for (i = 0; i < bufsiz; i++)	/* load pattern */
			pbuf1[i] = pat;
	}

	printf("\r    Write pattern             ");
	for (bno = start; bno <= end; bno += inc) {
		if (pat == -2) {
			for (i = 0; i < bufsiz; i++)	/* load pattern */
				pbuf1[i] = bno;
		}
		if (getlocal() == 'x')
			return -1;
		lseek(fi, bno*bufsiz, 0);
		if (write(fi, pbuf1, bufsiz) != bufsiz) {
			werr++;
			printf("Bad write on block %d\n", bno);
		}
	}
	printf("\r    Read/Verify pattern       ");
	for (bno = start; bno <= end; bno += inc) {
    		for (i = 0; i < bufsiz; i++)	/* clear pattern */
			pbuf2[i] = 0xFE;
		if (getlocal() == 'x')
			return -1;
		lseek(fi, bno*bufsiz, 0);
		if (read(fi, pbuf2, bufsiz) != bufsiz) {
			rerr++;
			printf("Bad read on block %d\n", bno);
			continue;
		}
		/* check pattern */
		if (pat == -2) {
			for (i = 0; i < bufsiz; i++)	/* load pattern */
				pbuf1[i] = bno;
		}
		for (i = 0; i < bufsiz; i++)
			if (pbuf1[i] != pbuf2[i]) {
				verr++;
				printf("Bad read compare on block %d", bno);
				printf(" index %d expected %x got %x\n",
					i, pbuf1[i], pbuf2[i]);
				break;
			}
	}
	printf("\r                                \r");
	return 0;
}
