#include "saio.h"

devread(io)
	register struct iob *io;
{
	register int cc;

	io->i_flgs |= F_RDDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, READ);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}

devwrite(io)
	register struct iob *io;
{
	register int cc;

	io->i_flgs |= F_WRDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, WRITE);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}

devopen(io)
	register struct iob *io;
{
	return ((*devsw[io->i_ino.i_dev].dv_open)(io));
}

devclose(io)
	register struct iob *io;
{
	badclose(io);
	return ((*devsw[io->i_ino.i_dev].dv_close)(io));
}

devioctl(io, cmd, arg)
	register struct iob *io;
	int cmd;
	caddr_t arg;
{
	return ((*devsw[io->i_ino.i_dev].dv_ioctl)(io, cmd, arg));
}

/*ARGSUSED*/
nullsys(io)
	struct iob *io;
{
}

/*ARGSUSED*/
nullioctl(io, cmd, arg)
	struct iob *io;
	int cmd;
	caddr_t arg;
{
	return (ECMD);
}

#ifdef	QBUS
int	elstrategy(), elopen();
int	hpstrategy(), hpopen();
int	rkstrategy(), rkopen();
int	rastrategy(), raopen(), raioctl();
int	rlstrategy(), rlopen();
int	smstrategy(), smopen();
int	rxstrategy(), rxopen(), rxioctl();
int	tmstrategy(), tmopen(), tmclose();
int	tsstrategy(), tsopen(), tsclose();
int	dastrategy(), daopen(), daclose();
int	ilstrategy(), ilopen(), ilclose();
int	exstrategy(), exopen(), exclose();

/*
 * Standalone dev switch.  Devices must be listed in auto-boot search priority
 */
struct devsw devsw[] = {
	{"el",	makedev(1,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			elstrategy,elopen,nullsys,nullioctl },
	{"hp", 	makedev(2,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			hpstrategy,hpopen,nullsys,nullioctl },
	{"rk",	makedev(3,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			rkstrategy,rkopen,nullsys,nullioctl },
	{"ra",	makedev(4,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			rastrategy,raopen,nullsys,raioctl   },
	{"rl",	makedev(5,0), "(0,40b)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			rlstrategy,rlopen,nullsys,nullioctl },
	{"sm",	makedev(6,0), "(2,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			smstrategy,smopen,nullsys,nullioctl },
	{"rx",	makedev(7,0), "(2,0)vmunix",	DEV_FLOPPY|DEV_AUTOBOOT,
			rxstrategy,rxopen,nullsys,rxioctl,  },
	{"tm",	8, "(0,2)",	    		DEV_TAPE|DEV_AUTOBOOT,
			tmstrategy,tmopen,tmclose,nullioctl },
	{"ts",	9, "(0,2)",  	  		DEV_TAPE|DEV_AUTOBOOT,
			tsstrategy,tsopen,tsclose,nullioctl },
	{"il",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT,
			ilstrategy,ilopen,ilclose,nullioctl },
	{"ex",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT,
			exstrategy,exopen,exclose,nullioctl },
	{"da",	0, 0,				DEV_DART|DEV_CLUST,
			dastrategy,daopen,daclose,nullioctl },
	{0, 	0, 0, 			
			0,0,0,0 },
};
#else	VBUS
int	sdstrategy(), sdopen();
int	smstrategy(), smopen();
int	gdstrategy(), gdopen();
int	tsstrategy(), tsopen(), tsclose();
int	dastrategy(), daopen(), daclose();
int	exstrategy(), exopen(), exclose();
int	vbstrategy(), vbopen(), vbclose();
int	nwstrategy(), nwopen(), nwclose();

/*
 * Standalone dev switch.  Devices must be listed in auto-boot search priority
 */
struct devsw devsw[] = {
	{"sd",	makedev(1,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			sdstrategy,sdopen,nullsys,nullioctl },
	{"sm",	makedev(2,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			smstrategy,smopen,nullsys,nullioctl },
	{"gd",	makedev(3,0), "(0,0)vmunix",	DEV_DISK|DEV_AUTOBOOT,
			gdstrategy,gdopen,nullsys,nullioctl },
#ifdef	M68020
#ifdef	M68025
	{"ts",	9, "(0,1)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#else	M68025
	{"ts",	9, "(0,0)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	M68025
#else	M68020
	{"ts",	9, "(0,3)",  	  		DEV_TAPE|DEV_AUTOBOOT,
#endif	M68020
			tsstrategy,tsopen,tsclose,nullioctl },
	{"vb",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT|DEV_CLUST,
			vbstrategy,vbopen,vbclose,nullioctl },
	{"ex",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT,
			exstrategy,exopen,exclose,nullioctl },
	{"nw",	makedev(6,0), "(0,0)@",		DEV_NET|DEV_AUTOBOOT,
			nwstrategy,nwopen,nwclose,nullioctl },
	{"da",	0, 0,				DEV_DART|DEV_CLUST,
			dastrategy,daopen,daclose,nullioctl },
	{0, 	0, 0, 			
			0,0,0,0 },
};
#endif	VBUS
