/* 
 * VBUS 68025 Specific, 
 *	test external cache
 */

#include "../is68k/board.h"

main()
{
	register int *tag_a, *tag_b, *dat_a, *dat_b;
	register int i;

	printf("\n--- %i Standalone External Cache Test ---\n\n");
	extcache_inval();
	printf("	      -TAG-                  --DATA--\n");
loop:	extcache_read(0x400);
	for (i = 0 ; i < 512; i++) {
	    tag_a = (int *)(CTAG_A_BASE + CTAG_INCR*i);
	    tag_b = (int *)(CTAG_B_BASE + CTAG_INCR*i);
	    dat_a = (int *)(CDAT_A_BASE + CDAT_WINCR*i);
	    dat_b = (int *)(CDAT_B_BASE + CDAT_WINCR*i);
	    if (((*tag_a) & CTAG_VALID) || ((*tag_b) & CTAG_VALID)) {
		printf("  A:	%8x:%8x	%8x:%8x %8x %8x %8x\n",
			tag_a,*tag_a,*dat_a,*(dat_a+1),*(dat_a+2),*(dat_a+3));
		printf("  B:	%8x:%8x	%8x:%8x %8x %8x %8x\n",
			tag_b,*tag_b,*dat_b,*(dat_b+1),*(dat_b+2),*(dat_b+3));
	    }
	}
	goto loop;
}

extcache_inval()
{
	register int i;
	register int *tag_a, *tag_b, *dat_a, *dat_b;

	tag_a = (int *)CTAG_A_BASE; tag_b = (int *)CTAG_B_BASE;
	for (i = 0 ; i < NCTAGS; i++) {
		*tag_a = 0;
		*tag_b = 0;
		tag_a += (CTAG_INCR/sizeof(int));
		tag_b += (CTAG_INCR/sizeof(int));
	}
}
