/* ISI: $Header: M.V10.s,v 1.1 87/10/02 08:32:16 root Exp $ */
/* 
 *  VME Standalone Bootstrap::
 *	This file produces three versions of standalone initilization code;
 * 	One for regular stand alone programs, one for standalone BOOT, and 
 *	one for standalone BOOT in the PROM.  For all versions the label
 *	'start' should be on a page boundry (this can be accomplished by
 *	use of the '-T XXX000' option on the linker and having the object of
 *	this file the first file specified).  For the PROMBOOT version the 
 *	label 'start' should be localed twords the end of the logical address 
 *	space but not so far out that it runs into the invalid and io pages 
 *	(3E0000 is a good value for now). For the BOOT version the same value 
 *	for the -T option as PROMBOOT can be used, however the a.out header 
 *	must be modified by hand (chentry) so that the file is loaded somewhere 
 *	else initialy (such as 22000).
 *
 *	Registers d6 and d7 contain reboot information.
 *
 *	Debug trace skeleton:
 */
#define	DEBUG
#define LOCORE

#ifdef	DEBUG
#define	TRACE(xxx) 			movb	#xxx,SIO0_ADR 		\
					movw	#0x7FFF,d4		\
			L/**/xxx:	dbra	d4,L/**/xxx
#else	DEBUG
#define	TRACE(xxx)
#endif	DEBUG

#include "sadie.h"
#include "../h/reboot.h"
#include "../is68k/board.h"
#include "../is68kdev/ctcreg.h"
#include "../is68kdev/sioreg.h"

	MEMTRAP	=	0x000008		/* memory trap address */
	ILITRAP	=	0x000010		/* illegal instruction trap */
	INISTACK=	0x03B000		/* initial stack pointer */

	.text
	.globl	start
	.globl	_start
	.globl	__rtt
	.globl	__splx
	.globl	__parityon
	.globl	__parityoff
	.globl	__blink_errled
	.globl	_booty

start:	
_start:	
#ifdef	PROMBOOT
	/* cold start PROM entry */
	.long	INISTACK			/* C00000 reset SSP */
	.long	PROM+(Coldboot-start)		/* C00004 reset address */
Reboot:	jra	Boot				/* C00008 reboot entry */
Coldboot:					/* C0000A */
#endif	PROMBOOT

#ifdef	BOOT
	movl	#RB_ASKNAME+RB_LOGO,d7		/* Ask for name on cold start */
	movl	#-1,d6				/* flag first boot */

Boot:	movw	#0x2700,sr			/* set priority level to 7 */
	movw	#BSR_PARITYOFF,BSR		/* turn off parity */
	lea	INISTACK,sp
	reset
	movl	#0x0FFF,d0			/* let things warm up */
    1:	dbra	d0,1b

/* 
 * Initialize CTC baud rate chanels
 */
 	movl	#CTC0_ADR,a0			/* CTC 0 */
	movl	#CTC1_ADR,a1			/* CTC 1 */
	movw	BSR,d0				/* get switches */
	notw	d0				/* complement */
	andw	#BSR_CPUSPEED+BSR_BAUD,d0	/* speed and baud rate */
	lsrw	#4,d0				/* convert to index */
	lea	pc@(ctctab),a2
	movb	a2@(0,d0:W),d2			/* Pick up time constant */
	movb	#CTC_CNT,a0@
	movb	#CTC_CNT+CTC_TCF+CTC_CTRL,a0@ 
	movb	d2,a0@
	movb	#CTC_CNT,a1@
	movb	#CTC_CNT+CTC_TCF+CTC_CTRL,a1@
	movb	d2,a1@

/* 
 * Initialize SIO ports
 */
	lea	pc@(siodvtab),a2
	movb	a2@(0,d0:W),d2			/* division WW4 constant */
	movl	#SIO0_ADR+SIO_CTRL,a0		/* SIO 0 control */
	movl	#SIO1_ADR+SIO_CTRL,a1		/* SIO 1 control */
	movw	#8,d0
	lea	pc@(siotab),a2
    1:	movb	a2@,a0@
	movb	a2@+,a1@
	dbra	d0,1b
	movb	#SIOW0_REXT+4,a0@		/* reprogram divide constant */
	movb	d2,a0@
	movb	#SIOW0_REXT+4,a1@
	movb	d2,a1@
#else	BOOT
	lea	INISTACK,sp
#endif	BOOT

/* 
 * Initialize memory managment for a 1:1 logical to physical mapping
 */
	/* program the segment table */
	movl	#NSEGPERCTX-1,d1		/* one context worth */
	movl	#0x80,d0			/* all accesses are permited */
	movl	#SEGREGBASE,a0
    1:	movb	d0,a0@
	addl	#SEGNXTINCR,d0
	addl	#SEGREGINCR,a0			/* next segment in context */
	dbra	d1,1b

	/* program the page table */
	movl	#NPAGREG-1,d1			/* complete address space */
	movl	#0x00,d0
	movl	#PAGREGBASE,a0
    1:	movw	d0,a0@
	addl	#PAGNXTINCR,d0
	addl	#PAGREGINCR,a0
	dbra	d1,1b

#ifdef	PROMBOOT
/*
 *	Initialize all of memory on first boot, use virtual page 1 to physical
 *	page to be cleared.  Print out a "." for every megabyte found.
 */
	cmpl	#-1,d6
	jne	4f
	lea	pc@(imem0),a0
    1:	movw	#0x7fff,d0
    2:	dbra	d0,2b
	movb	a0@+,SIO0_ADR
	jne	1b

	lea	MEMTRAP,a1
	lea	pc@(3f),a0
	movl	a0,a1@
	movl	#0x1000,a1			/* virtual addr, use page 1 */
	movl	#PAGREGBASE+PAGREGINCR,a2	/* page register for vaddr */
	movl	#(0x1000/4)-1,d3		/* number of bytes in a page */
	movl	#0x0,d1				/* physical page number */
	movl	d1,d0				/* clear pattern */
	movl	#0x1000+MEMTRAP+4,a0		/* first pass virtual */
	movl	#(0x1000/4)-((MEMTRAP+4)/4)-1,d2/* number of bytes first pass */
    1:	movw	d1,a2@				/* map virtual to physical */
	tstw	a0@(4096-2)			/* whole page ??? */
	tstw	a0@(2048)
	tstw	a0@(1024)
	tstw	a0@(512)
	tstw	a0@(256)
	tstw	a0@(128)
	tstw	a0@
    2:	movl	d0,a0@				/* zero and test */
	cmpl	a0@+,d0
	jne	3f
	dbra	d2,2b				/* loop on page */
	addqw	#PAGNXTINCR,d1			/* next page */
	movl	d3,d2				/* full page */
	movl	a1,a0				/* reset virtual address */
	movw	d1,d4				/* put out a "." for each meg */
	andw	#0xFF,d4
	jne	1b
	movb	#0x2e,SIO0_ADR
	jra	1b
    3:	movw	#PAGNXTINCR,a2@			/* reset mapping for page 1 */
	lea	pc@(imem1),a0
    1:	movw	#0x7fff,d0
    2:	dbra	d0,2b
	movb	a0@+,SIO0_ADR
	jne	1b
#endif	PROMBOOT
/*
 * Reprogram pages 0x7E0-0x7FF in virtual to point to the standard IO segment 
 * in physical memory (pages 0xFE0-0xFFF)
 */
    4:	movl	#PAGREGBASE+0xFC0,a0
	movw	#0xFE0,d0
	movl	#NPAGPERSEG-1,d1		/* segment of page registers */
    1:	movw	d0,a0@
	addl	#PAGNXTINCR,d0
	addl	#PAGREGINCR,a0
	dbra	d1,1b

/*
 * Define the vector base register to point to 0.  On the 68000 the base
 * register is always zero, and an illegal instruction trap will occur if
 * you try to execute the 68010 instruction to redefine it.  Dont bother
 * cleaning up the stack after traps...
 */
	movl	#68000,d4
	lea	ILITRAP,a1
	lea	pc@(1f),a0
	movl	a0,a1@
	clrl	d0
	movl	d0,vb
	movl	#68010,d4
/*
 * Size physical memory by steping through first word of each page, waiting 
 * for a fault or write/read mismatch. Note write/read mismatch as end of 
 * usable memory, and fault as start of short io space.
 */
	/* fill in fault vector for recovery */
    1:	lea	MEMTRAP,a1
	lea	pc@(3f),a0
	movl	a0,a1@

	movl	#0x1000,a0			/* virtual addr, use page 1 */
	movl	#PAGREGBASE+PAGREGINCR,a1
	movl	#0,d0				/* compair fail page */
	movl	#PAGNXTINCR,d1			/* physical page */
	movl	#0xCACA,d2

    1:	movw	d1,a1@				/* map virtual to physical */
#ifdef	BOOT
	/* POSSIBLE PROBLEM WITH NON-PROM VERSION OF BOOT */
	movw	a0@,d3
	movw	d2,a0@
#else	BOOT
	movw	a0@,d2
#endif	BOOT
	cmpw	a0@,d2				/* note first mismatch */
	beq	2f
	tstl	d0
	jne	2f
	movl	d1,d0
	andw	#0xFF0,d0
    2:	addql	#PAGNXTINCR,d1
#ifdef	BOOT
	movw	d3,a0@				/* put back */
#endif	BOOT
	jra	1b

    3:	movw	#PAGNXTINCR,a1@			/* reset mapping for page 1 */
	andw	#0xFF0,d1
	tstl	d0
	jne	1f
	movl	d1,d0

/*
 * Reprogram pages 0x7D0-0x7DF in virtual to point to the short IO space
 */
    1:	movl	#PAGREGBASE+0xFA0,a0
	movl	#15,d3				/* 64K short io space */
	movl	d1,d2
    1:	movw	d2,a0@
	addl	#PAGNXTINCR,d2
	addl	#PAGREGINCR,a0
	dbra	d3,1b
/*
 * You get here either by a fault, or fall through. Reprogram pages of logical
 * link address space to point to the last pages of physical address space. 
 */
	movl	#12,d2				/* convert page to address */
	lsll	d2,d0
	movl	d0,a5				/* save top of memory */
	lsll	d2,d1
	movl	d1,a4				/* save address of shortio */

#ifdef	BOOT
	/* compute size of BOOT image and define stack pointer */
	movl	#_end+0xFFF,d1	
	subl	#start,d1
	andl	#0xFFF000,d1			/* to a page boundry */
	addl	#0x4000,d1			/* add 3 pages for stack and */
	subl	d1,d0				/* back up this amount */
	movl	d0,d5				/* boot firewall loading */
	movb	#12,d2
	lsrl	d2,d0				/* templete, access bits */
	lsrl	d2,d1				/* pages to reprogram */
	movl	#start-0x3000,d3
	lsrl	d2,d3
	movl	#PAGREGBASE,a1			/* page table for link space */
	lsll	#1,d3
	addl	d3,a1
    1:	movw	d0,a1@
	addw	#PAGNXTINCR,d0
	addl	#PAGREGINCR,a1
	dbra	d1,1b

/* 
 * Relocate out side of PROM (or load area) into the link space, which was 
 * just maped to the end of physical memory.
 */
	bsr	1f				/* compute source address */
    1:	movl	sp@+,d0				/* relative to current pc */
	andl	#0xFFF000,d0			/* back to last page boundry */
	movl	d0,a0
	lea	start,a1			/* destination address */
	movl	#_edata+4,d0			/* compute image size */
	subl	#start,d0
	lsrl	#2,d0				/* byte to long */
    1:	movl	a0@+,a1@+
	dbra	d0,1b
	jmp	1f				/* long jump */

    1:						/* running in link space */
#endif	BOOT
	lea	start-0x10,sp			/* define the stack pointer */
						/* it grows down from code */

/*
 * reprogram exception vector table to point to tperr
 */
	movl	#8,a0
	jra	2f
    1:	movl	#tperr,a0@+
    2:	cmpl	#0x3fc,a0
	jls	1b

/* 
 * clear bss
 */
	lea	_edata,a0
	lea	_end,a1
    1:	clrl	a0@+	
	cmpl	a0,a1
	jgt	1b

/*
 * jump to main, never to return
 */
	movl	d4,_cpuchip			/* type of chip */
	movl	a5,_topmem			/* high address */
	movl	a4,_shortio			/* address of short io */
	movl	d5,_sboot			/* start of boot in physical */
	movl	d6,_devtp
	movl	d7,_howto
	jsr	_cpux				/* find out cluster number */
	movl	d0,_vbnum
	jsr	_main
	jsr	_exit				/* if main should return */

	/* servie interrupts and traps */
tperr:	movml	#0xC0C0,sp@-			/* save [da][01] */
	jsr	_traperr
	movml	sp@+,#0x0303			/* restore [da][01] */
	tstl	_dorte				/* if dorte return */
	jeq	__rtt
	tstl	_ignore_intr
	jeq	1f
	clrl	_dorte
    1:	rte

/*
 * return to PROM
 */
__rtt:	movl	#RB_ASKNAME,d7			/* Ask for name after exit */
	movl	#0xFFFF,d6			/* not a cold boot */
	movl	#0xF000,d0			/* let things cool down */
    1:	dbra	d0,1b
	movl	SADIE_BASE-4,d0			/* check for fast return */
	cmpl	#SADIE_MAGIC,d0			/* to sadie! */
	jne	1f
	jmp	SADIE_BASE
    1:	jmp	PROM_REBOOT

__splx: movl	sp@(4),d1
	movw	sr,d0
	movw	d1,sr
	rts

__parityon:
	movw	BSR,d0
	andw	#CTXMASK,d0
	orw	#BSR_PARITYON,d0
	movw	d0,BSR
	rts

__parityoff:
	movw	BSR,d0
	andw	#CTXMASK,d0
	orw	#BSR_PARITYOFF,d0
	movw	d0,BSR
	rts

__blink_errled:
	rts

/*
 * Test-and-set primative.
 *  Sets the high-order bit of the pointed-to byte.
 *  Returns zero (failure) if the byte had been nonzero, else 1 (success).
 *  Routine is indivisible even in multi-processor environment
 *  IF the byte is in VME memory.
 */
	.globl	_tas
_tas:	movq	#0,d0
	movl	sp@(4),a0
	tas	a0@
	jne	1f
	addqw	#1,d0
    1:	rts

	.globl	_DELAY
_DELAY:	movl	_cpuspeed,d1
    1:	movl	sp@(4),d0
    2:	dbf	d0,2b
	addqw	#1,d0
	subql	#1,d0
	jge	2b
	dbf	d1,1b
	addqw	#1,d1
	subql	#1,d1
	jge	1b
	rts

/*
 * before jumping off to execute image loaded by boot, define boot enviroment
 */
_booty:	movl	_howto,d7
	movl	_devtp,d6
	movl	sp@(4),a0
	jmp	a0@

imem0:	.asciz	"Initialize all memory "
imem1:	.asciz	"\r\n"
	.align	1

siotab:	.byte	0x18		/* WW0 Channel Reset			*/
	.byte	0x14		/* WW0 Reset Ext Status, Select WW4	*/
	.byte	0x44		/* WW4 X16 Clock, 1 Stop bit/char	*/
	.byte	0x13		/* WW0 Reset Ext Status, Select WW3	*/
	.byte	0xC1		/* WW3 Rx 8 bits/char, enable		*/
	.byte	0x15		/* WW0 Reset Ext Status, Select WW5	*/
	.byte	0xEA		/* WW5 Tx DTR, 8 bits/char, enable, RTS	*/
	.byte	0x11		/* WW0 Reset Ext Status, Select WW1	*/
	.byte	0x00		/* WW1 No interupts			*/
	.byte	0x00		/* WW0 Null code			*/

/* 
 * CTCTAB: Note that 1200 and 300 have the same entries in ctctab; they are 
 * distinguished by the baud rate divider in SIODVTAB. 
 */
ctctab:	
	.byte  	16			/* 10MHz	9600	*/
	.byte	19			/* 12MHz		*/
	.byte	18			/* 11MHz		*/
	.byte	13			/*  8MHz		*/

	.byte	8			/* 10MHz	19200	*/
	.byte	9			/* 12MHz		*/
	.byte	9			/* 11MHz		*/
	.byte	7			/*  8MHz		*/

	.byte	130			/* 10MHz	1200	*/
	.byte	151			/* 12MHz		*/
	.byte	144			/* 11MHz		*/
	.byte	104			/*  8MHz		*/

	.byte	130			/* 10MHz	300	*/
	.byte	151			/* 12MHz		*/
	.byte	144			/* 11MHz		*/
	.byte	104			/*  8MHz		*/
siodvtab:	
	.byte  	SIOW4_X16+SIOW4_1STOP	/* 10MHz	9600	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz		*/

	.byte	SIOW4_X16+SIOW4_1STOP	/* 10MHz	19200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz		*/

	.byte	SIOW4_X16+SIOW4_1STOP	/* 10MHz	1200	*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X16+SIOW4_1STOP	/*  8MHz		*/

	.byte	SIOW4_X64+SIOW4_1STOP	/* 10MHz	300	*/
	.byte	SIOW4_X64+SIOW4_1STOP	/* 12MHz		*/
	.byte	SIOW4_X64+SIOW4_1STOP	/* 11MHz		*/
	.byte	SIOW4_X64+SIOW4_1STOP	/*  8MHz		*/
	.align	1

	.data
	.globl	_vme_short
	.globl	_vme_std
	.globl	_vme_stdio
	.set	_vme_short,VME_SHORTIO
	.set	_vme_std,VME_STANDARD
	.set	_vme_stdio,VME_STANDARDIO

	.globl	_errno
	.globl  _cpuchip
	.globl  _cpuspeed
	.globl  is68020
	.globl  _vbnum
	.globl  _topmem
	.globl  _shortio
	.globl	_dorte
	.globl	_ignore_intr
	.globl	_hadint
	.globl	_xbad144
	.globl	_howto
	.globl  _devtp
	.globl	_sboot
_errno:		.long	0
_cpuchip:	.long	68000
_cpuspeed: 	.long	1
_vbnum:		.long	0
is68020:	.long	0
_topmem:	.long	0
_shortio: 	.long	0
_dorte:		.long	0
_ignore_intr:	.long	0
_hadint: 	.long	0
_xbad144: 	.long	0
_howto:		.long	0
_devtp:		.long	0
_sboot: 	.long	0
	.long	0
