#ifndef	LOCORE
struct skydevice {
	short		comreg;		/* command register */
	short		stcreg;		/* status and control register */
	short		dt1reg;		/* data registers */
	short		dt2reg;
	short		mc1reg;		/* micro code registers */
	short		mc2reg;
};
#else	LOCORE
#define	SKYCOM		0
#define	SKYSTC		2
#define	SKYDT1		4
#define	SKYDT2		6
#define	SKYMC1		8
#define	SKYMC2		10
#endif	LOCORE

/* status and control register definitions */
#define	SKYMODE		0x0060		/* mode field mask */
#define SKYMODE_H0	0x0000		/* halted */
#define SKYMODE_H1	0x0020		/* halted */
#define SKYMODE_RUN	0x0040		/* running */
#define SKYMODE_SS	0x0060		/* single step */
#define	SKYRESET	0x0080		/* reset bit */
#define	SKYRDY		15		/* ready bit */
#define	SKYIDLE		14		/* idle bit */
#define	SKYDIR		13		/* i/o dirrection bit */
