/* Zilog SIO device registers. */
/*
 * Note that port B can be accessed as port A+2.
 */

#define NSIO		2

#ifdef	QBUS
#define SIO0_ADR	0xC21001
#define SIO1_ADR	0xC21003
#else	QBUS
#define SIO0_ADR	0xC1C011
#define SIO1_ADR	0xC1C013
#endif	QBUS

#ifndef LOCORE
/*
 * SIO chip device registers
 */
struct siodevice {
	unsigned char	sio_data;
	unsigned char	_1[3];	
	unsigned char	sio_ctrl;
};
#endif LOCORE

#define SIO_DATA	0
#define SIO_CTRL	4

/* read register 0  (status) */
#define SIOR0_RXRDY	0x01		/* Rx char available */
#define SIOR0_TXRDY	0x04		/* Tx buffer empty */
#define SIOR0_DCD	0x08		/* data carrier detect */
#define SIOR0_RING	0x10		/* ring indicator */
#define SIOR0_CTS	0x20		/* clear to send */
#define SIOR0_BREAK	0x80		/* break received */

/* read register 1  (special error status) */
#define SIOR1_PERR	0x10		/* parity error */
#define SIOR1_OERR	0x20		/* reciever overrun error */
#define SIOR1_FERR	0x40		/* framming error */

/* write register 0  (command register) */
#define SIOW0_RMASK	0x07	/* bits for register selection */
#define SIOW0_NULL	0x00	/* null code */
#define SIOW0_REXT	0x10	/* reset external & status interrupts */
#define SIOW0_RESET	0x18	/* channel reset */
#define SIOW0_RXINT	0x20	/* enable interrupt on next Rx char */
#define SIOW0_TXPEND	0x28	/* reset Tx interrupt char */
#define SIOW0_RERR	0x30	/* error reset */
#define SIOW0_RETINT	0x38	/* return from interrupt (port A only) */

/* write register 1  (recv/xmit interrupt ctrl) */
#define SIOW1_EXTINT	0x01	/* external interrupt enable */
#define SIOW1_TXINT	0x02	/* xmit interrupt enable */
#define SIOW1_STATVEC	0x04	/* status affects vector (port B only) */
#define SIOW1_RXDISBL	0x00	/* Rx intr disable */
#define SIOW1_RX1ST	0x08	/* Rx intr on 1st char */
#define SIOW1_RXALLPV	0x10	/* Rx interrupt on all chars w/parity vector */
#define SIOW1_RXALL	0x18	/* Rx interrupt on all chars */
#define SIOW1_RXMASK	0x18	/* Rx interrupt mask */
#define SIOW1_WRDYRT	0x20	/* wait/ready request on recv/xmit */
#define SIOW1_WRDYRF	0x40	/* wait/ready request function */
#define SIOW1_WRDYRE	0x80	/* wait/ready request enable */

/* write register 2  (interrupt vector, port B only) */

/* write register 3  (recv params & control) */
#define SIOW3_RXENBL	0x01	/* Rx enable */
#define SIOW3_AUTO	0x20	/* auto enable */
#define SIOW3_5BITS	0x00	/* 5 bits/char */
#define SIOW3_7BITS	0x40	/* 7 bits/char */
#define SIOW3_6BITS	0x80	/* 6 bits/char */
#define SIOW3_8BITS	0xC0	/* 8 bits/char */
#define SIOW3_BMASK	0xC0	/* mask for Rx bits/char */

/* write register 4  (parameter register) */
#define SIOW4_PENBL	0x01	/* parity enable */
#define SIOW4_PEVEN	0x02	/* even parity */
#define SIOW4_1STOP	0x04	/* 1 stop bit */
#define SIOW4_2STOP	0x0C	/* 2 stop bits */
#define SIOW4_X1	0x00	/* x1 clock mode */
#define SIOW4_X16	0x40	/* x16 clock mode */
#define SIOW4_X32	0x80	/* x32 clock mode */
#define SIOW4_X64	0xC0	/* x64 clock mode */
#define SIOW4_XMASK	0xC0	/* mask clock bits */

/* write register 5  (xmit params & control) */
#define SIOW5_RTS	0x02	/* request to send */
#define SIOW5_TXENBL	0x08	/* Tx enable */
#define SIOW5_BREAK	0x10	/* send break */
#define SIOW5_5BITS	0x00	/* 5 bits/char */
#define SIOW5_7BITS	0x20	/* 7 bits/char */
#define SIOW5_6BITS	0x40	/* 6 bits/char */
#define SIOW5_8BITS	0x60	/* 8 bits/char */
#define SIOW5_BMASK	0x60	/* mask for Tx bits/char */
#define SIOW5_DTR	0x80	/* data terminal ready */

#ifndef LOCORE
/* 
 * structure for storing baud rate parameters
 */
struct daspeeds {
	char da_ctc;	/* time constant for CTC chip */
	char da_dart;	/* prescale constant for DART chip */
};
#endif
