/*
 * qbus hp controler:
 * registers and bits.
 */

struct hpdevice
{
	u_short	hpcs1;		/* control and status register 1 */
	short	hpwc;		/* word count register */
	u_short	hpba;		/* UNIBUS address register */
	u_short	hpda;		/* desired address register */
	u_short	hpcs2;		/* control and status register 2 */
	u_short	hpds;		/* drive Status */
	u_short	hper1;		/* error register 1 */
	u_short	hpas;		/* attention summary */
	u_short	hpla;		/* look ahead */
	u_short	hpdb;		/* data buffer */
	u_short	hpmr;		/* maintenance */ 
	u_short	hpdt;		/* drive type */
	u_short	hpsn;		/* serial number */
	u_short	hpof;		/* offset register */
	u_short	hpdc;		/* desired cylinder address register */
	u_short	hphr;		/* holding register */
	u_short	hpmr2;		/* maintenance register 2 */
	u_short	hper2;		/* error register 2 */
	u_short	hpec1;		/* burst error bit position */
	u_short	hpec2;		/* burst error bit pattern */
	u_short	hpbae;		/* bus address extention for 22 bit Qbus */
	u_short hpcs3;
};

/* Other bits of hpcs1 */
#define	HP_SC	0100000		/* special condition */
#define	HP_TRE	0040000		/* transfer error */
#define	HP_PSEL	0010000		/* port select */
#define	HP_DVA	0004000		/* drive available */
/* bits 8 and 9 are the extended address bits */
#define	HP_RDY	0000200		/* controller ready */
#define	HP_IE	0000100		/* interrhpt enable */
/* bits 5-1 are the command */
#define	HP_GO	0000001

/* commands */
#define	HP_NOP		000
#define	HP_SEEK		004		/* seek */
#define	HP_RECAL	006		/* recalibrate */
#define	HP_DCLR		010		/* drive clear */
#define	HP_RELEASE	012		/* release */
#define	HP_OFFSET	014		/* offset */
#define	HP_RTC		016		/* return to center-line */
#define	HP_PRESET	020		/* read-in preset */
#define	HP_PACK		022		/* pack acknowledge */
#define	HP_DMABAND	024		/* dma bandwidth set */
#define	HP_SEARCH	030		/* search */
#define	HP_WCDATA	050		/* write check data */
#define	HP_WCHDR	052		/* write check header and data */
#define	HP_WCOM		060		/* write */
#define	HP_WHDR		062		/* write header and data */
#define	HP_RCOM		070		/* read data */
#define	HP_RHDR		072		/* read header and data */
#define	HP_BOOT		074		/* boot */
#define	HP_FORMAT	076		/* format */

/* hpcs2 */
#define	HPCS2_DLT	0100000		/* data late */
#define	HPCS2_WCE	0040000		/* write check error */
#define	HPCS2_HPE	0020000		/* UNIBUS parity error */
#define	HPCS2_NED	0010000		/* nonexistent drive */
#define	HPCS2_NEM	0004000		/* nonexistent memory */
#define	HPCS2_PGE	0002000		/* programming error */
#define	HPCS2_MXF	0001000		/* missed transfer */
#define	HPCS2_MDPE	0000400		/* massbus data parity error (0) */
#define	HPCS2_OR	0000200		/* output ready */
#define	HPCS2_IR	0000100		/* input ready */
#define	HPCS2_CLR	0000040		/* controller clear */
#define	HPCS2_PAT	0000020		/* parity test */
#define	HPCS2_BAI	0000010		/* address increment inhibit */
/* bits 0-2 are drive select */

#define	HPCS2_BITS \
"\20\20DLT\17WCE\16UPE\15NED\14NEM\13PGE\12MXF\11MDPE\
\10OR\7IR\6CLR\5PAT\4BAI"

/* hpds */
#define	HPDS_ATA	0100000		/* attention active */
#define	HPDS_ERR	0040000		/* composite drive error */
#define	HPDS_PIP	0020000		/* positioning in progress */
#define	HPDS_MOL	0010000		/* medium on line */
#define	HPDS_WRL	0004000		/* write locked */
#define	HPDS_LST	0002000		/* last sector transferred */
#define	HPDS_PGM	0001000		/* programmable */
#define	HPDS_DPR	0000400		/* drive present */
#define	HPDS_DRY	0000200		/* drive ready */
#define	HPDS_VV		0000100		/* volume valid */
/* bits 1-5 are spare */
#define	HPDS_OM		0000001		/* offset mode */

#define	HPDS_DREADY	(HPDS_DPR|HPDS_DRY|HPDS_MOL|HPDS_VV)

#define	HPDS_BITS \
"\20\20ATA\17ERR\16PIP\15MOL\14WRL\13LST\12PGM\11DPR\10DRY\7VV\1OM"

/* hper1 */
#define	HPER1_DCK	0100000		/* data check */
#define	HPER1_UNS	0040000		/* drive unsafe */
#define	HPER1_OPI	0020000		/* operation incomplete */
#define	HPER1_DTE	0010000		/* drive timing error */
#define	HPER1_WLE	0004000		/* write lock error */
#define	HPER1_IAE	0002000		/* invalid address error */
#define	HPER1_AOE	0001000		/* address overflow error */
#define	HPER1_HCRC	0000400		/* header crc error */
#define	HPER1_HCE	0000200		/* header compare error */
#define	HPER1_ECH	0000100		/* ecc hard error */
#define	HPER1_WCF	0000040		/* write clock fail (0) */
#define	HPER1_FER	0000020		/* format error */
#define	HPER1_PAR	0000010		/* parity error */
#define	HPER1_RMR	0000004		/* register modification refused */
#define	HPER1_ILR	0000002		/* illegal register */
#define	HPER1_ILF	0000001		/* illegal function */

#define	HPER1_BITS \
"\20\20DCK\17UNS\16OPI\15DTE\14WLE\13IAE\12AOE\11HCRC\10HCE\
\7ECH\6WCF\5FER\4PAR\3RMR\2ILR\1ILF"

/* hphr */
/* EMULEX write these in hphr and then read back values */
#define	HPHR_MAXCYL	0100027		/* max cyl address */
#define	HPHR_MAXTRAK	0100030		/* max track address */
#define	HPHR_MAXSECT	0100031		/* max sector address */

/* hper2 */
#define	HPER2_BSE	0100000		/* bad sector error */
#define	HPER2_SKI	0040000		/* seek incomplete */
#define	HPER2_OPE	0020000		/* operator plug error */
#define	HPER2_IVC	0010000		/* invalid command */
#define	HPER2_LSC	0004000		/* loss of sector clock */
#define	HPER2_LBC	0002000		/* loss of bit clock */
#define	HPER2_MDS	0001000		/* multiple drive select */
#define	HPER2_DCU	0000400		/* dc power unsafe */
#define	HPER2_DVC	0000200		/* device check */
#define	HPER2_ACU	0000100		/* ac power unsafe */
/* bits 5 and 4 are spare */
#define	HPER2_DPE	0000010		/* data parity error (0) */
/* bits 2-0 are spare */

#define	HPER2_BITS \
"\20\20BSE\17SKI\16OPE\15IVC\14LSC\13LBC\12MDS\11DCU\10DVC\7ACU\4DPE"

/* hpof */
#define	HPOF_FMT16	0010000		/* 16 bit transfer mode */
#define	HPOF_ECI	0004000		/* ecc inhibit */
#define	HPOF_HCI	0002000		/* header compare inhibit */

/* THE SC21 ACTUALLY JUST IMPLEMENTS ADVANCE/RETARD... */
#define	HPOF_P400	0020		/*  +400 uinches */
#define	HPOF_M400	0220		/*  -400 uinches */
#define	HPOF_P800	0040		/*  +800 uinches */
#define	HPOF_M800	0240		/*  -800 uinches */
#define	HPOF_P1200	0060		/* +1200 uinches */
#define	HPOF_M1200	0260		/* -1200 uinches */

/* type codes for disk drives */
#define	HPDT_RP04	020
#define	HPDT_RP05	021
#define	HPDT_RP06	022
#define	HPDT_RP07	042
#define	HPDT_RM02	025
#define	HPDT_RM03	024
#define	HPDT_RM05	027
#define	HPDT_RM80	026
#define	HPDT_ML11A	0110
#define	HPDT_ML11B	0111

/*
 * Systems Industries kludge: use value in the serial # register to figure out 
 * real drive type.
 */
#define	SIMB_MB	0xff00		/* model byte value */
#define	SIMB_S6	0x2000		/* switch s6 */
#define	SIMB_LU	0x0007		/* logical unit (should = drive #) */

#define	SI9775D	0x0700		/* 9775 direct */
#define	SI9775M	0x0e00		/* 9775 mapped */
#define	SI9730D	0x0b00		/* 9730 direct */
#define	SI9730M	0x0d00		/* 9730 mapped */
#define	SI9766	0x0300		/* 9766 */
#define	SI9762	0x0100		/* 9762 */
#define	SICAPD	0x0500		/* Capricorn direct */
#define	SICAPN	0x0400		/* Capricorn mapped */
#define	SI9751D	0x0f00		/* Eagle direct */

#define	SIRM03	0x8000		/* RM03 indication */
#define	SIRM05	0x0000		/* RM05 pseudo-indication */
