/*
 * QBUS: DLV11-J Driver
 */

#include "dl.h"
#if	NDL > 0
/*
 * TODO:
 *  	This driver does not support the paper tape reader on an LT33.
 */
#include "bk.h"

#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "ioctl.h"
#include "tty.h"
#include "user.h"
#include "proc.h"
#include "map.h"
#include "buf.h"
#include "vm.h"
#include "conf.h"
#include "bk.h"
#include "file.h"
#include "uio.h"
#include "kernel.h"
#include "syslog.h"

#include "../is68kdev/pdma.h"
#include "../is68kdev/qbvar.h"
#include "../is68kdev/dlreg.h"

#ifdef	SYSV
#include "../sysv/sys/termio.h"
#endif	SYSV

int	dlprobe(), dlslave(), dlattach(), dlrint();
struct	qb_device *dlinfo[NDL];
u_short	*dlstd[] = { (u_short *)0x3FFD40, (u_short *)0x3FFD48,
		     (u_short *)0x3FFD50, (u_short *)0x3FFD58,
		     (u_short *)0x3FFD60, (u_short *)0x3FFD68,
		     (u_short *)0x3FFD70, (u_short *)0x3FFD78,
		     0 };
struct	qb_driver DLdriver =
	{ dlprobe, dlslave, dlattach, dlstd, "dl", dlinfo, "DL" };

int	dlstart(), dlxint(), dldma();
int	ttrstrt();
struct	tty dl_tty[NDL];
struct	pdma dlpdma[NDL];
int	ndl_tty = 0;

dlprobe(dladdr)
	register struct dldevice	*dladdr;
{
	extern int	cvec;

	dladdr->dl_xcsr |= DL_XCSR_XIE;
	DELAY(2000);
	dladdr->dl_xcsr &= ~DL_XCSR_XIE;
	if (cvec && cvec != 0x100)
		cvec -= 4;
	clevmax = clev_ttymax;
	clev_tty = MAX(clev, clev_tty);
	return (sizeof (struct dldevice));
}

dlslave(dladdr)
	register struct dldevice	*dladdr;
{
	return (1);
}

dlattach(qi)
	register struct qb_device	*qi;
{
	register struct pdma	*pdp = &dlpdma[ndl_tty];
	register struct tty	*tp = &dl_tty[ndl_tty];

	pdp->p_addr = (int)qi->qi_mi->qm_addr;
	pdp->p_arg = (int)tp;
	pdp->p_fcn = dlxint;
	ndl_tty++;
}

#ifdef	SYSV
int sv_dlproc();
#endif	SYSV

dlopen(dev, flag)
	dev_t	dev;
	int	flag;
{
	register int	dl = minor(dev);
	register struct tty	*tp = &dl_tty[dl];
	register struct dldevice *dladdr = (struct dldevice *)dlpdma[dl].p_addr;
 
	if (dl >= ndl_tty || dlpdma[dl].p_addr == 0)
		return (ENXIO);
	tp->t_addr = (caddr_t)&dlpdma[dl];
	tp->t_oproc = dlstart;
#ifdef	SYSV
	tp->svt_proc = sv_dlproc;
#endif	SYSV
	if ((tp->t_state & TS_ISOPEN) == 0) {
		ttychars(tp);
		if (tp->t_ispeed == 0) {
			tp->t_ospeed = tp->t_ispeed = B9600;
			tp->t_flags = EVENP | ODDP | ECHO;
		}
		dladdr->dl_rcsr |= DL_RCSR_RCVIE;
#ifdef	SYSV
		sv_ttinit(tp);
		map_state(tp, TOSV);
#endif	SYSV
	} else if ((tp->t_state&TS_XCLUDE) && 
	    ((u.u_uid!=0) || (u.u_procp->p_flag & SLOGIN)))
		return (EBUSY);
#ifdef	SYSV
	    if (u.u_procp->p_universe == UNIVERSE_SYSV)
		(void)(*sv_linesw[tp->svt_line].l_mdmint)(tp, 1);
	    else
#endif	SYSV
		(void)(*linesw[tp->t_line].l_modem)(tp, 1);
#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		return ((*sv_linesw[tp->svt_line].l_open)(dev, tp, flag));
	else
#endif	SYSV
		return ((*linesw[tp->t_line].l_open)(dev, tp));
}

dlclose(dev)
	dev_t	dev;
{
	register struct tty	*tp = &dl_tty[minor(dev)];

#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV) {
		(*sv_linesw[tp->svt_line].l_close)(tp);
		sv_ttyclose(tp);
		return;
	}
#endif	SYSV
	(*linesw[tp->t_line].l_close)(tp);
	ttyclose(tp);
}

dlread(dev, uio)
	dev_t	dev;
	struct uio	*uio;
{
	register struct tty	*tp = &dl_tty[minor(dev)];

#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		return ((*sv_linesw[tp->svt_line].l_read)(tp, uio));
	else
#endif	SYSV
		return ((*linesw[tp->t_line].l_read)(tp, uio));
}

dlwrite(dev, uio)
	dev_t	dev;
	struct uio	*uio;
{
	register struct tty	*tp = &dl_tty[minor(dev)];

#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		return ((*sv_linesw[tp->svt_line].l_write)(tp, uio));
	else
#endif	SYSV
		return ((*linesw[tp->t_line].l_write)(tp,uio));
}

dlrint(dl)
	int dl;
{
	register struct dldevice *dladdr = (struct dldevice *)dlpdma[dl].p_addr;
	register struct tty	*tp = &dl_tty[dl];
	register int	c, err;
	int	overrun = 0;

	do {
		c = (err = dladdr->dl_rbuf) & DL_RBUF_DMASK;
#ifdef	SYSV
		if (tp->t_universe == UNIVERSE_SYSV) {
			if (err & DL_RBUF_PERR) {
				if (tp->svt_iflag & SV_IGNPAR)
					continue;
			    	if (tp->svt_iflag & SV_PARMRK)
					;		/* ??? */
			}
			if (err & DL_RBUF_OVRNERR) {
				log(LOG_WARNING, "dl%d: overflow\n",dl);
				overrun++;
			}
			if (err & DL_RBUF_FRERR) {
			    	if (tp->svt_iflag & SV_IGNBRK)
					continue;
			    	if (tp->svt_iflag & SV_BRKINT)
					(*sv_linesw[tp->svt_line].l_input)
						(c, tp, L_BREAK);
			    	c = 0;
			}
			if (tp->svt_iflag & SV_ISTRIP)
				c &= 0177;
			else
				c &= 0377;
		} else {
#endif	SYSV
		if (err & DL_RBUF_FRERR) {
			if (tp->t_flags & RAW)
				c = 0;
			else
				c = tp->t_intrc;
		}
		if (err & DL_RBUF_OVRNERR) {
			log(LOG_WARNING, "dl%d: overflow\n",dl);
			overrun++;
		}
		if (err & DL_RBUF_PERR) {
			if (((tp->t_flags & (EVENP|ODDP)) == EVENP)
			  || ((tp->t_flags & (EVENP|ODDP)) == ODDP))
				continue;
		}
#ifdef	SYSV
		}
		if (tp->t_universe == UNIVERSE_SYSV)
			(*sv_linesw[tp->svt_line].l_input)(c, tp, 0);
		else
#endif	SYSV
		(*linesw[tp->t_line].l_rint)(c, tp);
	} while (dladdr->dl_rcsr & DL_RCSR_RCVDONE);
}

dlioctl(dev, cmd, data, flag)
	dev_t	dev;
	caddr_t	data;
{
	register int	error;
	register int	dl = minor(dev);
	register struct tty	*tp = &dl_tty[dl];

#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV) {
		if ((error = sv_ttiocom(tp, cmd, data)) > 0)
			return error;
		if (cmd == TCSETAF || cmd == TCSETA || cmd == TCSETAW)
			;		/* no param routine */
		if (cmd == TCSBRK)
			;		/* ??? */
		return 0;
	}
#endif	SYSV
	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, data, flag);
	if (error >= 0)
		return (error);
	error = ttioctl(tp, cmd, data, flag);
	if (error >= 0)
		return (error);
	else
		return (ENOTTY);
}

#ifdef	SYSV
sv_dlproc(tp, cmd)
register struct tty *tp;
register cmd;
{
	sv_proc(tp, cmd, dlstart, NULL);
}
#endif	SYSV
 

dlxint(tp)
	register struct tty *tp;
{
	register struct pdma	*dp = (struct pdma *)tp->t_addr;
	register int	s;

	if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0)
		return;
	s = splx(dlinfo[minor(tp->t_dev)]->qi_mi->qm_psl);
	tp->t_state &= ~TS_BUSY;
#ifdef	SYSV
	map_state(tp, TOSV);
#endif	SYSV
	if (tp->t_state & TS_FLUSH) {
		tp->t_state &= ~TS_FLUSH;
#ifdef	SYSV
		map_state(tp, TOSV);
#endif	SYSV
	} else {
		ndflush(&tp->t_outq, dp->p_mem-tp->t_outq.c_cf);
		dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	}
#ifdef	SYSV
	if (tp->t_universe == UNIVERSE_SYSV) {
		if ((*sv_linesw[tp->svt_line].l_output)(tp))
			dlstart(tp);
	} else
#endif	SYSV
	if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	else
		dlstart(tp);
}

dlstart(tp)
	register struct tty *tp;
{
	register struct pdma	*dp = (struct pdma *)tp->t_addr;
	register struct dldevice *dladdr = (struct dldevice *)dp->p_addr;
	register int	cc, s;
 
	s = splx(dlinfo[minor(tp->t_dev)]->qi_mi->qm_psl);
	if (tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP))
		goto out;
	if (tp->t_outq.c_cc <= TTLOWAT(tp)) {
		if (tp->t_state&TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
#ifdef	SYSV
			map_state(tp, TOSV);
#endif	SYSV
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}
	if (tp->t_outq.c_cc == 0)
		goto out;
	if (tp->t_flags & (RAW|LITOUT))
		cc = ndqb(&tp->t_outq, 0);
	else {
		cc = ndqb(&tp->t_outq, 0200);

		if (cc == 0) {
			cc = getc(&tp->t_outq);
			timeout(ttrstrt, (caddr_t)tp, (cc&0x7f) + 6);
			tp->t_state |= TS_TIMEOUT;
#ifdef	SYSV
			map_state(tp, TOSV);
#endif	SYSV
			goto out;
		}
	}
	tp->t_state |= TS_BUSY;
#ifdef	SYSV
	map_state(tp, TOSV);
#endif	SYSV
	dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	dp->p_end += cc;
	dladdr->dl_xcsr |= DL_XCSR_XIE;
out:	splx(s);
}

dlstop(tp, flag)
	register struct tty	*tp;
{
	register struct pdma	*dp = (struct pdma *)tp->t_addr;
	register int	s;

	s = splx(dlinfo[minor(tp->t_dev)]->qi_mi->qm_psl);
	if (tp->t_state & TS_BUSY) {
		dp->p_end = dp->p_mem;
		if ((tp->t_state&TS_TTSTOP)==0) {
			tp->t_state |= TS_FLUSH;
#ifdef	SYSV
			map_state(tp, TOSV);
#endif	SYSV
		}
	}
	splx(s);
}
#endif	NDL > 0
