/*
 * Example #1   HP3455A Voltmeter
 * Edit 01/19/81
 * REV C: 01/01/82
 * Preconditions:
 *      GPIB interface installed as System Controller
 *
 * Set up HP3455A Voltmeter:
 *      Talk Only switch off
 *      Address selected (e.g. a5=1,a4=1,a3=0,a2=0,a1=0)
 *
 * Make device table entry in ibup module:
 *        e.g.,
 *        { 0130, 070, 0, 2, 012, 2 }
 *
 * Compile C program and
 * load with utility and handler front-end routines
 *
 */

#define WRT     0
#define RD      1
#define CLR     2
#define TRG     3
#define REM     4

main(){ char v[16];
	float s;
	int i;

	ibup(REM,-1);   /* Put all devices in remote mode with local lockout */
	ibup(CLR,1);    /* clear the voltmeter */
	/* put hp3455a in fast ac volts, auto range, hold/manual trigger */
	ibup(WRT,1,'F3R7T3',6)
	/* average ten readings and print the result */
	for(s=0.0, i=0; i<10; i++){
		ibup(TRG,1);            /* trigger the voltmeter */
		ibup(RD,1,v,16);        /* read the voltage */
		s=+ atof(v); }
	printf("average= %14.5e\n", s/10.0); }
