/*	cp.c	0.0	85/04/01	*/
/*      256 port version: 7/14/87 MCR */
/* has Dave W's lp flush bug fix */
/*#define	DEBUG	/**/

#include "cp.h"
#if NCP > 0 || Ncp > 0
/*
 * Integrated Solutions {Intelligent} Communications Processor driver
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/ioctl.h"
#include "../h/tty.h"
#include "../h/map.h"
#include "../h/buf.h"
#include "../h/vm.h"

#include "../is68kdev/qbvar.h"
#include "../is68kdev/cpreg.h"

#include "../h/bk.h"
#include "../h/clist.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#define	TTY_NODELAY

/*
 * Definition of the driver for the auto-configuration program.
 */
u_short	*cpstd[] = {
#ifdef	M68020
	 	(u_short *)0xFFF520, 
		(u_short *)0xFFF560, 
		(u_short *)0xFFF580,
		(u_short *)0xFFF5A0,
		(u_short *)0xFFF5C0,
		(u_short *)0xFFF5C0,
		(u_short *)0xFFF600,
		(u_short *)0xFFF620,
		(u_short *)0xFFF660,
		(u_short *)0xFFF680,
		(u_short *)0xFFF6A0,
		(u_short *)0xFFF6C0,
		(u_short *)0xDFF520,
		(u_short *)0xDFF560,
		(u_short *)0xDFF580,
		(u_short *)0xDFF5A0,
		(u_short *)0xDFF5C0,
#else	M68020
	 	(u_short *)0x7FF520, 
		(u_short *)0x7FF560, 
		(u_short *)0x7FF580,
		(u_short *)0x7FF5A0,
		(u_short *)0x7FF5C0,
#endif	M68020
 		0 };
int	cpprobe(), cpslave(), cpattach(), cprint(), cpxint(), cptimer();
struct	qb_device *cpinfo[NCP];
struct	qb_driver CPdriver =
	{ cpprobe, cpslave, cpattach, cpstd, "cp", cpinfo, "CP" };

#define	ISPEED	B9600
#define	IFLAGS	(EVENP|ODDP|ECHO|CRMOD)

#define	MAXLINES	16
struct	tty cp_tty[NCP*MAXLINES];

/*
 * Local variables for the driver
 */
short	cp_nch[NCP*MAXLINES];		/* number of characters xmiting */
short	cp_nlines[NCP];			/* number of lines per controller */
struct	cp_lp {
	short		lp_state;
#define	LP_EXIST	0x01
#define	LP_CENTRON	0x02
#define	LP_OPEN		0x04
#define	LP_ASLP		0x08
#define	LP_TOUT		0x10
#define	LP_NOCHANGE	0x20
	short		lp_canon;
	short		lp_physcol;
	short		lp_logcol;
	short		lp_physline;
	short		lp_maxcol;
	struct buf	*lp_inbuf;
	struct buf	*lp_outbuf;
	char		*lp_outp;
	short		lp_outn;
}	cp_lp[NCP];

#define	LP_PRI		(PZERO+8)
#define	LP_BUFSIZE	(1024)
#define LP_TIMEOUT	(2*60)		/* 2 min timeout, 4 before message */

int	cpstart(), ttrstrt(), lptout();

/*
 * baud rate conversion	:                           1  1  2  4  9  1  3
 *			          1  1  1  2  3  6  2  8  4  8  6  9  8
 *			    5  7  1  3  5  0  0  0  0  0  0  0  0  .  .
 *			 0  0  5  0  4  0  0  0  0  0  0  0  0  0  2  4 */
char cp_bconv0[16] = {	 0, 0, 0, 1, 2, 3, 4, 4, 5, 6,10, 8, 9,11,12,15, };/**/
char cp_bconv1[16] = {	 0, 0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 8, 9,11,11,12, };/**/
char *cp_bconv;

static	int v;
extern unsigned short *battery_clock;

/*
 * Routine for configuration to force a cp to interrupt.
 */
cpprobe(cpaddr)
register struct cpdevice *cpaddr;
{
	/* issue a master clear */
	cpaddr->cp_sel = SEL_MC;
	while (cpaddr->cp_sel & SEL_MC)
		DELAY(100);

	/* 
	 * cause interrupt by setting small silo age time and writeing 
	 * something in the silo
	 */
	v = freevec();
	cpaddr->cp_isr = (ISR_IE << 8) | v;
	cpaddr->cp_sel = SEL_SILO;
	cpaddr->cp_pr = 1;		/* silo age time */
	cpaddr->cp_swr = SWR_VDP;	/* simulate reception of character */
	DELAY(100000);
	return (sizeof (struct cpdevice));
}

cpslave(qi)
struct qb_device *qi;
{
	return (1);
}

cpattach(qi)
struct qb_device *qi;
{
	register struct cpdevice *cpaddr=(struct cpdevice *)qi->qi_mi->qm_addr;
	register short conf;

	cpaddr->cp_sel = SEL_MC;
	while (cpaddr->cp_sel & SEL_MC)
		DELAY(100);
	conf = cpaddr->cp_sel;
	cp_nlines[qi->qi_ctlr] = conf&SEL_CONF_NLINES;
	cp_lp[qi->qi_ctlr].lp_state = 0;
	cpaddr->cp_sel = SEL_SILO;
	cpaddr->cp_pr = (40 << 8) | 11;	/* silo fill level | silo age time */
	cpaddr->cp_isr = (ISR_IE << 8) | v;
	printf("	%d terminal lines", cp_nlines[qi->qi_ctlr]);
	if (conf & SEL_CONF_BR) {
		printf(", baud rate table 1");
		cp_bconv = cp_bconv1;
	} else
		cp_bconv = cp_bconv0;
	if (conf & SEL_CONF_LP) {
		cp_lp[qi->qi_ctlr].lp_state |= LP_EXIST;
		if (qi->qi_flags)
			cp_lp[qi->qi_ctlr].lp_maxcol = qi->qi_flags;
		else
			cp_lp[qi->qi_ctlr].lp_maxcol = LP_MAXCOL;
		printf(",\n					%d column ", 
			cp_lp[qi->qi_ctlr].lp_maxcol);
		if (conf & SEL_CONF_LPCEN) {
			cp_lp[qi->qi_ctlr].lp_state |= LP_CENTRON;
			printf("centronics printer");
		} else
			printf("data products printer");
	}
	if (conf & SEL_CONF_QIC2)
		printf(",\n					qic2");
	if (conf & SEL_CONF_CLK && battery_clock == 0) {
		printf(",\n					 battery clock");
		battery_clock = (unsigned short *)cpaddr;
	}
	if (conf & SEL_CONF_DRV)
		printf(",\n					drv11");
	printf(" ");
}

cpopen(dev, flag)
dev_t dev;
int flag;
{
	register struct tty *tp;
	register int unit, cp, line, s;
	register struct qb_device *qi;

	if (ISLP(dev))
		return(lpopen(dev, flag));

	unit = minor(dev);
	cp = CPUNIT(unit);
	line = CPLINE(unit);

	if (cp > NCP || line >= cp_nlines[cp] || (qi = cpinfo[cp])== 0 || 
		qi->qi_alive == 0)
			return (ENXIO);
	tp = &cp_tty[unit];
	tp->t_addr = (caddr_t)qi->qi_mi->qm_addr;
	tp->t_oproc = cpstart;
	tp->t_state |= TS_WOPEN;

	if ((tp->t_state&TS_ISOPEN) == 0) {
		ttychars(tp);
		tp->t_ispeed = tp->t_ospeed = ISPEED;
		tp->t_flags = IFLAGS;
		cpparam(unit);
	} else if (tp->t_state&TS_XCLUDE && u.u_uid!=0)
		return (EBUSY);

	if ((tp->t_state & TS_XCLUDE) && (u.u_procp->p_flag & SLOGIN))
		return (EBUSY);

	/* Wait for carrier, then process line discipline specific open. */
	s = splx(qi->qi_mi->qm_psl);
	if (cpmdm(tp->t_addr, line, 1, 1))
		tp->t_state |= TS_CARR_ON;

#ifdef TTY_NODELAY
	if ((flag & FNDELAY) == 0)
#endif
	    while ((tp->t_state&TS_CARR_ON)==0) {
		tp->t_state |= TS_WOPEN;
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
		if ((tp->t_state & TS_XCLUDE) && (u.u_procp->p_flag & SLOGIN)){
			splx(s);
			return (EBUSY);
		}
	    }
	splx(s);

	return ((*linesw[tp->t_line].l_open)(dev, tp));
}

cpclose(dev, flag)
dev_t dev;
int flag;
{
	register struct tty *tp;
	register struct cpdevice *cpaddr;
	register int unit, line, state, s;

	if (ISLP(dev)) {
		lpclose(dev, flag);
		return;
	}

	unit = minor(dev);
	line = CPLINE(unit);
	tp = &cp_tty[unit];
	cpaddr = (struct cpdevice *)tp->t_addr;
	(*linesw[tp->t_line].l_close)(tp);

	cpaddr->cp_brk &= ~(1<<line);

	state = tp->t_state;
	if (state&(TS_HUPCLS|TS_WOPEN) || (state&TS_ISOPEN)==0)
		(void) cpmdm(cpaddr, line, 1, 0);
#ifdef	NOMDM
	tp->t_flags &= ~NOMDM;
#endif	NOMDM
	ttyclose(tp);
	if (state&(TS_HUPCLS|TS_WOPEN) || (state&TS_ISOPEN)==0)
		(void) cpmdm(cpaddr, line, 0, 0);
	else
		(void) cpmdm(cpaddr, line, 0, 1);
	s = splx(cpinfo[CPUNIT(unit)]->qi_mi->qm_psl);
	cpaddr->cp_sel = line << SEL_SHIFT;
	cpaddr->cp_pr = 0;
	splx(s);
}

cpread(dev, uio)
dev_t dev;
struct uio *uio;
{
	register struct tty *tp = &cp_tty[minor(dev)];

	if (ISLP(dev))
		return (EIO);		/* cant read printer */

	return ((*linesw[tp->t_line].l_read)(tp, uio));
}

cpwrite(dev, uio)
dev_t dev;
struct uio *uio;
{
	register struct tty *tp = &cp_tty[minor(dev)];

	if (ISLP(dev))
		return(lpwrite(dev, uio));

	return ((*linesw[tp->t_line].l_write)(tp, uio));
}

cpint(cp)
register int cp;
{
	ushort	isr = ((struct cpdevice *)cpinfo[cp]->qi_mi->qm_addr)->cp_isr;

#ifdef	DEBUG
cprintf("int %x ",isr);/**/
#endif	DEBUG
	switch (isr & 0xFF) {
		case ISR_SI:
			cp_sint(cp);
			break;

		case ISR_TI:
			cp_tint(cp);
			break;

		case ISR_CI:
			cp_cint(cp);
			break;

		case ISR_PI:
			lpint(cp);
			break;

		case ISR_RI:
		case ISR_NI:
			break;
	}
}

/*
 * silo service interrupt
 */
cp_sint(cp)
register int cp;
{
	register struct tty *tp;
	register ushort c;
	register struct cpdevice *cpaddr = (struct cpdevice *)
						(cpinfo[cp]->qi_mi->qm_addr);
	register struct tty *tp0 = &cp_tty[cp<<4];
	register int overrun = 0;

	/* Loop fetching characters from the silo for this cp.  */
	while ((c = cpaddr->cp_swr) & SWR_VDP) {
		tp = tp0 + ((c&SWR_LN_MASK)>>SWR_LN_SHIFT);
		if ((tp->t_state&TS_ISOPEN) == 0)
			continue;
		if ((c & SWR_DO) && overrun++ == 0)
		    if (c & SWR_PE)
			printf("cp%d: silo overflow\n", cp);
		    else
			printf("cp%d: line %d overflow\n", 
			    cp, (c&SWR_LN_MASK)>>SWR_LN_SHIFT);
		if (c & SWR_PE)
			if ((tp->t_flags&(EVENP|ODDP))==EVENP
			 || (tp->t_flags&(EVENP|ODDP))==ODDP )
				continue;
		if (c & SWR_FE)
			/*
			 * At framing error (break) generate null (in raw mode,
			 * for getty), or interrupt (cooked/cbreak mode)
			 */
			if (tp->t_flags&RAW)
				c = 0;
			else
				c = tp->t_intrc;

#if NBK > 0 || Nbk > 0
		if (tp->t_line == NETLDISC) {
			c &= 0177;
			BKINPUT(c, tp);
		} else
#endif
			(*linesw[tp->t_line].l_rint)(c, tp);
	    }
}

/*
 * Ioctl for CP.
 */
cpioctl(dev, cmd, data, flag)
caddr_t data;
{
	register int unit = minor(dev);
	register int line = unit & 0xF;
	register struct tty *tp = &cp_tty[unit];
	register int error;

	if (ISLP(dev))
		return lpioctl(dev, cmd, data, flag);

	if ((error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, data, flag)) >= 0)
		return (error);
	if ((error = ttioctl(tp, cmd, data, flag)) >= 0) {
		if (cmd == TIOCSETP || cmd == TIOCSETN ||
		    cmd == TIOCLSET || cmd == TIOCLBIS || cmd == TIOCLBIC)
			cpparam(unit);
		return (error);
	}
	switch (cmd) {
	    case TIOCSBRK:
		((struct cpdevice *)(tp->t_addr))->cp_brk |= 1<<line;
		break;

	    case TIOCCBRK:
		((struct cpdevice *)(tp->t_addr))->cp_brk &= ~(1<<line);
		break;

	    case TIOCSDTR:
		cpmdm(tp->t_addr, line, 1, 1);
		break;

	    case TIOCCDTR:
		cpmdm(tp->t_addr, line, 1, 0);
		break;

	    default:
		return (ENOTTY);
	}
	return (0);
}

/*
 * Set parameters from open or stty into the CP hardware registers.
 */
cpparam(unit)
register int unit;
{
	register struct cpdevice *cpaddr;
	register struct tty *tp = &cp_tty[unit];
	register int lpr, line = unit&0xF;
	register int s;

	/*
	 * Block interrupts so parameters will be set before line interrupts.
	 */
	s = splx(cpinfo[CPUNIT(unit)]->qi_mi->qm_psl);
	if ((tp->t_ispeed)==0) {
		tp->t_state |= TS_HUPCLS;
		cpmdm(tp->t_addr, line, 1, 0);
		splx(s);
		return;
	}
	lpr = (cp_bconv[tp->t_ispeed]<<4) | cp_bconv[tp->t_ospeed];
	if ((tp->t_ispeed) == B134)
		lpr |= PR_BITS6|PR_PENABLE|PR_HDUPLX;
	else if (tp->t_flags & (RAW|LITOUT))
		lpr |= PR_BITS8;
	else
		lpr |= PR_BITS7|PR_PENABLE;
	if ((tp->t_flags&EVENP) == 0)
		lpr |= PR_OPAR;
	if ((tp->t_ospeed) == B110)
		lpr |= PR_TWOSB;
	lpr |= PR_XOFF;			/* allways do XOFF quickly */
	cpaddr = (struct cpdevice *)tp->t_addr;
	cpaddr->cp_sel = line << SEL_SHIFT;
	cpaddr->cp_pr = lpr;
# ifdef DEBUG
cprintf("line %d lpr=%x\n",line,lpr);
# endif DEBUG
	splx(s);
}

/*
 * CP transmitter interrupt. Restart each line which used to be active but has
 * terminated transmission since the last interrupt.
 */
cp_tint(cp)
int cp;
{
	register struct tty *tp;
	register ushort line;
	register struct cpdevice *cpaddr = 
			(struct cpdevice *)cpinfo[cp]->qi_mi->qm_addr;
	register ushort tcr = cpaddr->cp_tcr;

	for (line = 0, tp = &cp_tty[cp<<4] ; tcr ; line++, tp++) {
		if (tcr & (1 << line)) {
			tcr ^= (1 << line);
			tp->t_state &= ~TS_BUSY;
			if (tp->t_state&TS_FLUSH)
			    tp->t_state &= ~TS_FLUSH;
			else {
			    cpaddr->cp_sel = line << SEL_SHIFT;
			    /* 
			     * flush number asked to transmit - residual not 
			     * transmitted because of XOFF recieved.
			     */
			    ndflush(&tp->t_outq, cp_nch[(cp*MAXLINES)+line] -
				cpaddr->cp_bc);
			}

			if (tp->t_line)
			    (*linesw[tp->t_line].l_start)(tp);
			else
			    cpstart(tp);
		}
	}
}

/*
 * Start (restart) transmission on the given CP line.
 */
cpstart(tp)
register struct tty *tp;
{
	register struct cpdevice *cpaddr;
	register int unit, nch, s;
	register ushort line;
	int stradr;

	/* prevent state of the tp from changing. */
	s = splx(cpinfo[CPUNIT(minor(tp->t_dev))]->qi_mi->qm_psl);

	/* If it's currently active, or delaying, no need to do anything. */
	if (tp->t_state&(TS_TIMEOUT|TS_BUSY|TS_TTSTOP))
		goto out;
	/*
	 * If there are sleepers, and output has drained below low water mark, 
	 * wake up the sleepers.
	 */
	if (tp->t_outq.c_cc<=TTLOWAT(tp)) {
		if (tp->t_state&TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state&TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}

	/* Now restart transmission unless the output queue is empty. */
	if (tp->t_outq.c_cc == 0)
		goto out;

	if (tp->t_flags & (RAW|LITOUT))
		nch = ndqb(&tp->t_outq, 0);
	else {
		nch = ndqb(&tp->t_outq, 0200);

		/* If first thing on queue is a delay process it. */
		if (nch == 0) {
			nch = getc(&tp->t_outq);
			timeout(ttrstrt, (caddr_t)tp, (nch&0x7f)+6);
			tp->t_state |= TS_TIMEOUT;
			goto out;
		}
	}

	/* If characters to transmit, restart transmission. */
	if (nch) {
		unit = minor(tp->t_dev);
		line = CPLINE(unit);
# ifdef DEBUG
cprintf("start %d ",line);/**/
# endif DEBUG
		cpaddr = (struct cpdevice *)tp->t_addr;
		tp->t_state |= TS_BUSY;
		cpaddr->cp_sel = line << SEL_SHIFT;
		stradr = svtop(tp->t_outq.c_cf);
		cpaddr->cp_bah = hiword(stradr);
		cpaddr->cp_bal = loword(stradr);
		cpaddr->cp_bc = cp_nch[unit] = nch;
		line = 1 << line;
		cpaddr->cp_tcr = line;
	}
out:	splx(s);
}

/*
 * Stop output on a line, e.g. for ^S/^Q or output flush.
 */
cpstop(tp, flag)
register struct tty *tp;
{
	register struct cpdevice *cpaddr = (struct cpdevice *)tp->t_addr;
	register int unit, s;

	/*
	 * Block input/output interrupts while messing with state.
	 */
	s = splx(cpinfo[CPUNIT(minor(tp->t_dev))]->qi_mi->qm_psl);
	if (tp->t_state & TS_BUSY) {
		if ((tp->t_state&TS_TTSTOP)==0)
			tp->t_state |= TS_FLUSH;
	}
	splx(s);
}

/*
 * Reset state of driver if bus reset was necessary.
 */
cpreset()
{
	register int cp, unit;
	register struct tty *tp;
	register struct qb_device *qi;
	register int i;

	for (cp = 0; cp < NCP; cp++) {
		qi = cpinfo[cp];
		if (qi == 0 || qi->qi_alive == 0)
			continue;
		printf(" CP%d", cp);
		((struct cpdevice *)qi->qi_mi->qm_addr)->cp_sel = SEL_MC;
		tp = &cp_tty[unit = cp * MAXLINES];

		for (i = 0; i < MAXLINES; unit++, i++, tp++) {
			if (tp->t_state & (TS_ISOPEN|TS_WOPEN)) {
				cpparam(unit);
				cpmdm(tp->t_addr, i, 1, 1);
				tp->t_state &= ~TS_BUSY;
				cpstart(tp);
			}
		}
	}
}

cpmdm(cpaddr, line, enable, assert)
register struct cpdevice *cpaddr;
{
	register ushort ln = 1 << line;

	if (enable)
		cpaddr->cp_ler |= ln;
	else
		cpaddr->cp_ler &= ~ln;
	if (assert)
		cpaddr->cp_acr |= ln;
	else
		cpaddr->cp_acr &= ~ln;

	return (cpaddr->cp_dcr & ln);
}

/*
 * carrier detect interrupt; deal with carrier transitions.
 */
cp_cint(cp)
register int cp;
{
	register struct tty *tp = &cp_tty[cp<<4];
	register ushort line;
	register ushort dcr = ((struct cpdevice *)
				cpinfo[cp]->qi_mi->qm_addr)->cp_dcr;

	for (line = 0; line < MAXLINES ; line++, tp++) {
#ifdef NOMDM			/* INTEGRATED SOLUTIONS addition to ioctl.h */
	    if (tp->t_flags&NOMDM)
		dcr |= (1<<line);		/* force carrier detect on */
#endif
	    if (dcr & (1<<line)) {
		if ((tp->t_state&TS_CARR_ON) == 0) {
			tp->t_state |= TS_CARR_ON;
			wakeup((caddr_t)&tp->t_rawq);
		}
	    } else {
		if (tp->t_state&TS_CARR_ON) {
			gsignal(tp->t_pgrp, SIGHUP);
			gsignal(tp->t_pgrp, SIGCONT);
			cpmdm(tp->t_addr, line, 1, 0);
			ttyflush(tp, FREAD|FWRITE);
		}
		tp->t_state &= ~TS_CARR_ON;
	    }
	}
}

lpopen(dev, flag)
dev_t dev;
int flag;
{
	register int cp = CPUNIT(minor(dev));
	register struct cp_lp *lp = &cp_lp[cp];
	register struct qb_device *qi = cpinfo[cp];

	if (cp > NCP || qi == 0 || qi->qi_alive == 0 ||
	    lp->lp_state&LP_OPEN || (lp->lp_state&LP_EXIST) == 0 )
			return (ENXIO);
	lp->lp_state |= LP_OPEN;
	lp->lp_inbuf = geteblk(LP_BUFSIZE);
	lp->lp_outbuf = geteblk(LP_BUFSIZE);
	lp->lp_outp = lp->lp_outbuf->b_un.b_addr;
	lp->lp_outn = 0;
	lp->lp_logcol = lp->lp_physcol = 0;
	lp->lp_physline = 0;
	lp->lp_canon = LPCANON(dev);
/*	lpcanon(cp, '\f'); /**/
	return (0);
}

lpclose(dev, flag)
dev_t dev;
int flag;
{
	register int cp = CPUNIT(minor(dev));
	register struct cp_lp *lp = &cp_lp[cp];

/*	lpcanon(cp, '\f');	/**/
	lpflush(cp);
	brelse(lp->lp_inbuf);
	brelse(lp->lp_outbuf);
	lp->lp_state &= ~LP_OPEN;
}

lpioctl(dev, cmd, data, flag)
caddr_t data;
{
	register int cp = CPUNIT(minor(dev));

	if (cmd == TIOCFLUSH) {
		lpflush(cp);
		return 0;
	} else
		return ENOTTY;
}

lpwrite(dev, uio)
dev_t dev;
struct uio *uio;
{
	register int cp = CPUNIT(minor(dev));
	register struct cp_lp *lp = &cp_lp[cp];
	register unsigned n;
	register char *p;
	register int error;

	while (n = min(LP_BUFSIZE, (unsigned)uio->uio_resid)) {
		p = lp->lp_inbuf->b_un.b_addr;
		error = uiomove(p, (int)n, UIO_WRITE, uio);
		if (error)
			return (error);
		do
			lpcanon(cp, *p++);
		while (--n);
	}
	return (0);
}

lpcanon(cp, c)
register int cp, c;
{
	register struct cp_lp *lp = &cp_lp[cp];
	register int logcol, physcol;

	if (lp->lp_canon&LP_CANON_RAW) {
		lpoutput(cp, c);
		return;
	} 
	if (lp->lp_canon&LP_CANON_CAP) {
		register c2;

		if (c>='a' && c<='z')
			c += 'A'-'a'; 
		else
		    switch (c) {
			case '{':	c2 = '(';	goto esc;

			case '}':	c2 = ')';	goto esc;

			case '`':	c2 = '\'';	goto esc;

			case '|':	c2 = '!';	goto esc;

			case '~':	c2 = '^';

			esc:	lpcanon(cp, c2);
				lp->lp_logcol--;
				c = '-';
		    }
	}
	logcol = lp->lp_logcol;
	physcol = lp->lp_physcol;

	switch(c) {
	    case ' ':
		logcol++;
		break;

	    case '\t':
		logcol = (logcol+8) & ~7;
		break;

	    case '\f':
		if (lp->lp_physline == 0 && physcol == 0)
			break;			/* fall into ... */

	    case '\n':
		lpoutput(cp, c);
		if (c == '\f')
			lp->lp_physline = 0;
		else
			lp->lp_physline++;
		physcol = 0;			/* fall into ... */

	    case '\r':
		logcol = 0;
		break;

	    case '\b':
		if (logcol > 0)
			logcol--;
		break;

	    default:
		if (logcol < physcol) {
			lpoutput(cp, '\r');
			physcol = 0;
		}
		if (logcol < lp->lp_maxcol) {
			while (logcol > physcol) {
				lpoutput(cp, ' ');
				physcol++;
			}
			lpoutput(cp, c);
			physcol++;
		}
		logcol++;
	}
	if (logcol > 1000)			/* ignore long lines  */
		logcol = 1000;
	lp->lp_logcol = logcol;
	lp->lp_physcol = physcol;
}

lpoutput(cp, c)
int cp, c;
{
	register struct cp_lp *lp = &cp_lp[cp];

	while (1)
	    if (lp->lp_outn < LP_BUFSIZE) {
		lp->lp_outn++;
		*lp->lp_outp++ = c;
		return;
	    } else
		lpflush(cp);
}

lpflush(cp)
int cp;
{
	register int s;
	register struct cp_lp *lp = &cp_lp[cp];
	register struct cpdevice *cpaddr = 
				(struct cpdevice *)cpinfo[cp]->qi_mi->qm_addr;
	int stradr;

	s = splx(cpinfo[cp]->qi_mi->qm_psl);
	while (lp->lp_outn) {
		cpaddr->cp_sel = SEL_LP;
		lp->lp_outp = lp->lp_outbuf->b_un.b_addr;
		stradr = svtop(lp->lp_outp);
		cpaddr->cp_bah = hiword(stradr);
		cpaddr->cp_bal = loword(stradr);
		cpaddr->cp_bc = lp->lp_outn;
		lp->lp_state |= LP_ASLP;
		if ((lp->lp_state & LP_TOUT) == 0) {
			lp->lp_state |= LP_TOUT;
			timeout(lptout, (caddr_t)cp, LP_TIMEOUT*hz);
		}
		cpaddr->cp_sr |= LSR_GO;
		sleep((caddr_t)lp, LP_PRI);
	}
	splx(s);
}

lpint(cp)
int cp;
{
	register struct cp_lp *lp = &cp_lp[cp];

	if ((lp->lp_state & (LP_EXIST|LP_ASLP)) == 0) {
		printf("cp%d: stray printer interrupt\n",cp);
		return;
	}
	lp->lp_state &= ~(LP_ASLP|LP_NOCHANGE);
	lp->lp_outn = 0;
	wakeup((caddr_t)lp);
}

lptout(cp)
int cp;
{
	register struct cp_lp *lp = &cp_lp[cp];
	register struct cpdevice *cpaddr;
	register short status;

/*	printf("lptout %d state %x ",cp,lp->lp_state); /**/
	if ((lp->lp_state & LP_ASLP) == 0) {	/* no longer waiting */
		lp->lp_state &= ~LP_TOUT;
		return;
	}
	if (lp->lp_state & LP_NOCHANGE) {
		cpaddr  = (struct cpdevice *)cpinfo[cp]->qi_mi->qm_addr;
		cpaddr->cp_sel = SEL_LP;
		status = cpaddr->cp_sr;
#ifdef PRINTERGLITCH
		printf("cp%d: printer ", cp);
		if ((status&LSR_CABLE) == 0)
			printf("not cabled correctly");
		else if ((status&LSR_SEL) == 0)
			printf("not online");
		else if (status&LSR_PAPE)
			printf("out of paper");
		else if ((status&LSR_RDY) == 0)
			printf("not ready");
		else
			printf("not responding");
		printf("\n");
#endif PRINTERGLITCH
		lp->lp_state &= ~LP_NOCHANGE;
	} else
		lp->lp_state |= LP_NOCHANGE;
	timeout(lptout, (caddr_t)cp, LP_TIMEOUT*hz);
}
#endif
