/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)locore.s	6.36 (Berkeley) 3/12/86
 */
#define FP_SKY  	/* comment to disable sky save/restore on switch */
/*#define KPROF	0x10000	/* enable kernel profiling */
#define	C_segptes /**/
#define	C_newptes /**/

#include "errno.h"
#include "param.h"
#include "psl.h"
#include "pte.h"
#include "pcb.h"
#include "trap.h"
#include "scb.h"
#include "board.h"
#include "../is68kdev/sioreg.h"
#include "../is68kdev/ctcreg.h"
#include <syscall.h>
#ifdef	FP_SKY
#include "../is68kdev/skyreg.h"
#endif	FP_SKY
#ifdef	SYSV
#include "../sysv/sys/filehdr.h"
#endif	SYSV

/* DEVICE SPECIFIC */
#include "dl.h"				/* QBUS */
#include "dz.h"				/* QBUS */
#include "dh.h"				/* QBUS */
#include "rx.h"				/* QBUS */
#include "gp.h"				/* VMEBUS */
#include "vb.h"				/* VMEBUS */
#include "nw.h"				/* VMEBUS */

/*
 *	Debug trace skeleton:
 */
#define TRACE(xxx)			movb	xxx,SIO0_ADR		\
					movl	d4,sp@-			\
					movl	#0x8000,d4		\
			9:		dbra	d4,9b			\
					movl	sp@+,d4

#define TRACEOUT			jmp	0xC0004A

#ifdef	VBUS
/*	.globl	_vme_short /**/
	.globl	_vme_std
	.globl	_vme_stdio
/*	.globl	_vme_ext /**/
/*	.set	_vme_short,VME_SHORTIO /**/
	.set	_vme_std,VME_STANDARD
	.set	_vme_stdio,VME_STANDARDIO
/*	.set	_vme_ext,VME_EXTENDED /**/
#endif	VBUS

/*
 * User structure is UPAGES at top of kernel space.
 */
	.globl	_u
	.set	_u,	MAXU_ADDR - IOPAGES*NBPG - UPAGES*NBPG
	.set	CADDR1,	_u - NBPG
	.set	CADDR2,	CADDR1 - NBPG
#ifdef	QBUS
	.set	CADDRa,	MAXU_ADDR - NPAGPERSEG*NBPG
#else	QBUS
	.set	CADDRa,	MAXU_ADDR - IOPAGES*NBPG - NPAGPERSEG*NBPG
#endif	QBUS
	.set	CADDRb,	CADDRa + NBPG
	.set	CADDRc,	CADDRb + NBPG
	.set	CADDRd,	CADDRc + NBPG

/*
 * HIBANKS is the number of high page banks used by the kernel
 */
#ifdef	QBUS
#define	HIBANKS	1
#else	QBUS
#define	HIBANKS	2
#endif	QBUS

/*
 * Define constants for use in PGREG macro
 */
#define	PAGRI(a)	a/**/PAGIDX	=	(a >>  (PGSHIFT - PAGREGSHIFT))
	PAGRI(_u)
	PAGRI(CADDR1)
	PAGRI(CADDR2)
	PAGRI(CADDRa)
	PAGRI(CADDRb)
	PAGRI(CADDRc)
	PAGRI(CADDRd)

/*
 * System page table
 */
#define	vaddr(x)	((((x)-_Sysmap)/4)*NBPG+0)
#define	SYSMAP(mname, vname, pidx, npte)	\
	.globl	_/**/mname;			\
_/**/mname:					\
	.space	npte*4;				\
	.globl	_/**/vname;			\
	.set	_/**/vname,vaddr(_/**/mname);	\
	pidx

	.data
	.align	1
	SYSMAP(Sysmap	 ,Sysbase   ,PAGRI(_Sysbase)   ,SYSPTSIZE )
	SYSMAP(Usrptmap	 ,usrpt	    ,PAGRI(_usrpt)     ,USRPTSIZE )
	SYSMAP(Forkmap	 ,forkutl   ,PAGRI(_forkutl)   ,UPAGES )
	SYSMAP(Xswapmap	 ,xswaputl  ,PAGRI(_xswaputl)  ,UPAGES )
	SYSMAP(Xswap2map ,xswap2utl ,PAGRI(_xswap2utl) ,UPAGES )
	SYSMAP(Swapmap	 ,swaputl   ,PAGRI(_swaputl)   ,UPAGES )
	SYSMAP(Pushmap	 ,pushutl   ,PAGRI(_pushutl)   ,UPAGES )
	SYSMAP(Vfmap	 ,vfutl	    ,PAGRI(_vfutl)     ,UPAGES )
	SYSMAP(mcrmap	 ,mcr 	    ,PAGRI(_mcr)       ,1 )
	SYSMAP(mmap	 ,vmmap	    ,PAGRI(_vmmap)     ,1 )
	SYSMAP(msgbufmap ,msgbuf    ,PAGRI(_msgbuf)    ,MSGBUFPTECNT )
	SYSMAP(camap	 ,cabase    ,PAGRI(_cabase)    ,16*CLSIZE )
	SYSMAP(ecamap	 ,calimit   ,PAGRI(_calimit)   ,0 )
	SYSMAP(Mbmap	 ,mbutl	    ,PAGRI(_mbutl)     ,NMBCLUSTERS*CLSIZE+CLSIZE )
	SYSMAP(shortiomap,vme_short ,PAGRI(_vme_short) ,(64*1024)/NBPG)
#ifndef	is68k_kobj
#if	NGP > 0
	SYSMAP(vidbufmap ,vidbuf    ,PAGRI(_vidbuf)    ,NGP*((1024*1024)/NBPG))
#endif	NGP > 0
#if	NVB > 0
	SYSMAP(vbmap	 ,vb        ,PAGRI(_vb)        ,(256*1024)/NBPG)
#endif	NVB > 0
#if	NNW > 0
	SYSMAP(nwmap0	 ,nw0       ,PAGRI(_nw0)       ,(256*1024)/NBPG)
	SYSMAP(nwmap1	 ,nw1       ,PAGRI(_nw1)       ,(256*1024)/NBPG)
#endif	NNW > 0
#endif	is68k_kobj
	SYSMAP(usrdevmap ,usrdev    ,PAGRI(_usrdev)    ,(1024*1024)/NBPG)
	SYSMAP(eSysmap	 ,esysmap   ,PAGRI(_esysmap)   ,0 )

	.globl	_Syssize
	.set	_Syssize,(_eSysmap - _Sysmap) / 4

/*
 * Translate virtual address to corresponding page register. Assumes that the 
 * mapping is straight thru!
 */
#define	PGREG(a)	(PAGREGBASE  + a/**/PAGIDX)

#define	FC_UD		0x1		/* function code for user data */
#define	FC_UC		0x2		/* function code for user code */
#define	PSL_IPLN	PSL_IPL2	/* must be higher than PSL_IPLC */
#define	PSL_IPLS	PSL_IPL2	/* must be higher than PSL_IPLC */
#define	PSL_IPLC	PSL_IPL1
#define	SCRATCH_STACK	start
#ifdef	QBUS
#define	MOVSEG		movw
#else	QBUS
#define	MOVSEG		movb
#endif	QBUS

/*
 * Initialization
 */
	.text
	.globl	start
start:	movw	#PSL_IPL7,sr		/* make sure interrupts are disabled */
	lea	SCRATCH_STACK,sp	/* temporary stack */
	movl	d7,_howto		/* how to boot */
	movl	d6,_devtype		/* major number of boot device */

	/* 
	 * Set up scb so if we trap out we end up in the PROM, for DEBUG.
	 */
	lea	0,a0
	movl	a0,vb			/* set vector base register to 0 */
	addl	#8,a0
	movw	#NSCBVEC-1-2,d0
	lea	PROM_REBOOT,a1
    1:	movl	a1,a0@+
	dbra	d0,1b

	/*
	 * Set context register and source/destination function codes for "movs"
	 */
	movl	#FC_UD,d0
	movl	d0,sfc			/* set source/destination function */
	movl	d0,dfc			/* code registers to user data */
	movw	#(1<<CTXSHIFT),CXW	/* set user context to #1 */

	/*
	 * Initialize all the segment registers.  Context #0 maps straight
	 * thru to the page registers, supervisor/user read/write. Contexts
	 * #1 thru #NCTX-1 are all made invalid. Because of the way in which the
	 * segment registers are addressed, the outer loop iterates thru the
	 * segments while the inner loop iterates thru the contexts. We're 
	 * assuming that the bootstrapper has set us up in an environment 
	 * consistent with this, and that we're not blowing our feet out from 
	 * under ourselves.
	 */
	movl	#SEGPROT_ALL,d3		/* segment read/write */
	movl	#(SEGPROT_NO|SEGINVALID),d0	/* invalid segment */
	lea	SEGREGBASE,a1		/* first segment register context #0 */
	movl	#NSEGPERCTX-1,d1	/* number of segments to be set up */
    1:	movl	a1,a0
	MOVSEG	d3,a0@			/* set segment reg for context #0 */
	addl	#SEGREGINCR,a1		/* segment reg for context #0 pass*/
	addw	#SEGNXTINCR,d3		/* next context #0 page reg set */
	movl	#NCTX-2,d2		/* additional contexts to be set up */
    2:	addl	#SEGCTXINCR,a0		/* segment register for next context */
	MOVSEG	d0,a0@			/* invalidate segment in this context */
	dbra	d2,2b			/* loop thru contexts for segment */
	dbra	d1,1b			/* loop thru all 64 segments */

	/*
	 * Now for the page registers.  They go straight through too.
	 */
	lea	PAGREGBASE,a0		/* a0 -> first page register */
	movl	#0,d2			/* page frame #0 */
	movw	#NPAGREG-1,d1		/* number of page registers to set up */
    1:	movw	d2,a0@			/* set up this page register */
	addw	#PAGNXTINCR,d2		/* d2 selects next page frame */
	lea	a0@(PAGREGINCR),a0	/* a0 -> next page register */
	dbra	d1,1b			/* loop thru all page registers */

#ifdef	VBUS
	/*
	 * Reprogram pages 0x7E0-0x7FF in virtual to point to the IO segment in 
	 * physical (0xFE0-0xFFF)
	 */
	movl	#PAGREGBASE+0xFC0,a0
	movw	#0xFE0,d0
	movl	#NPAGPERSEG-1,d1	/* one segment of page registers */
    1:	movw	d0,a0@
	addl	#PAGNXTINCR,d0
	addl	#PAGREGINCR,a0
	dbra	d1,1b
#endif	VBUS

	/*
	 * Initialize portion of Sysmap used for Sysmap itself: kernel code, 
	 * data, and bss.
 	 */
	movl	#_Sysmap,d0
	andl	#NONT_MASK,d0
	movl	d0,a0
	movl	a0,a1
	movl	#_Sysbase,d0		/* Base of mapped region */
	movl	#_end+NBPG-1,d1
	subl	d0,d1
	andl	#(NONT_MASK&(~(NBPG-1))),d0
	movl	#PGSHIFT,d2
	lsrl	d2,d0
	orl	#PG_V|PG_KW|PG_CACHEK,d0
	lsrl	d2,d1
	subl	#1,d1
    1:	movl	d0,a0@+
	addl	#1,d0
	dbra	d1,1b

	/* 
	 * turn off cache bits for pte's which map the system pte's
	 */
    1:	movl	#_Sysmap,d0
	movl	d0,d1
	andl	#(NONT_MASK&(~(NBPG-1))),d1
	lsrl	d2,d1
	lsll	#2,d1
	addl	a1,d1
	movl	d1,a0			/* Sysmap entry for Sysmap */
	movl	#_Syssize,d1		/* # of pte's in sysmap */
	lsll	#2,d1			/* # of bytes of pte's in Sysmap */
	addl	#NBPG-1,d1
	lsrl	d2,d1			/* number of pte's to map Sysmap */
	subl	#1,d1
    1:	movl	a0@,d0
	andl	#~PG_CACHEK,d0		/* turn off cache */
	movl	d0,a0@+
	dbra	d1,1b

	/*
	 * Write protect as much kernel code as possible. NOTE: kernel is a
	 * 407 image so there is no padding between text and data, leaving a
	 * small portion of kernel code which could be overwritten.
	 */
	movl	#start,d0
	movl	d0,d1
	andl	#(NONT_MASK&(~(NBPG-1))),d1
	lsrl	d2,d1
	lsll	#2,d1
	addl	a1,d1
	movl	d1,a0			/* Sysmap entry for start */
	movl	#_etext,d1
	subl	d0,d1
	lsrl	d2,d1
	subl	#1,d1
    1:	movl	a0@,d0
	andl	#~PG_PROT,d0		/* remove old protection */
	orl	#PG_KR,d0		/* add new protection */
	movl	d0,a0@+
	dbra	d1,1b

	/*
	 * Size & zero memory.
	 */
#ifdef	QBUS
	lea	_edata,a0		/* beginning of region to be zeroed */
	movl	#MAXU_ADDR-(4*4096)-4,d1 /* maximum end of region to zero */
	subl	a0,d1			/* maximum number of bytes to be zero */
	lsrl	#2,d1			/* maximum number of longs to be zero */

	lea	0+SCB_BUSERR,a1
	movl	a1@,d0			/* hang on to bus error vector */
	movl	#2f,a1@			/* put in our own bus error vector */
	movw	#0xCACA,d3

    1:	movw	d3,a0@			/* test memory.  may cause bus error */
	cmpw	a0@,d3
	jne	2f
	clrl	a0@+			/* clear memory */
	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b			/* loop till bus error or max */

    2:	movl	d0,a1@			/* replace bus error vector */
	movl	a0,d0
	movl	#PGSHIFT,d1		/* convert pointer to page number */
	lsrl	d1,d0
	subl	_detachedmem,d0
	movl	d0,_maxmem
	movl	d0,_physmem
	movl	d0,_freemem
#else	QBUS
	lea	_edata,a0		/* zero from here to end of page */
	movw	#NBPG,d1
	subw	a0,d1
	andw	#NBPG-1,d1
	movl	#0,d0
	jra	2f
    1:	movb	d0,a0@+
    2:	dbra	d1,1b

    	movl	a0,d0			/* convert address to page */
	movl	#PGSHIFT,d1
	lsrl	d1,d0			/* d0 is physical page to fondle */
	lea	CADDR1,a0		/* virtual address of page to fondle */
	lea	PGREG(CADDR1),a1	/* page register for virtual address */

	clrl	_maxmem
	movl	0+SCB_BUSERR,d1
	movl	#5f,0+SCB_BUSERR	/* patch in our own bus error vector */

    1:	movw	d0,a1@			/* map physical to virtual */
	tstw	a0@(NBPG-2)		/* fondle page, looking for bus error */
	tstw	a0@(NBPG/2)
	tstw	a0@(NBPG/4)
	tstw	a0@(NBPG/8)
	tstw	a0@(256)
	tstw	a0@(128)
	tstw	a0@
	tstl	_maxmem			/* already found end of phys mem? */
	jne	4f			/*   yes -- keep looking for short io */
	movw	#0xCACA,a0@		/*   no -- test page with write/read */
	cmpw	#0xCACA,a0@		/*	compare error? */
	jeq	2f
	movl	d0,_maxmem		/*	  yes -- end of phys mem! */
	jra	4f			/*	    keep looking for short io */
    2:	movl	a0,a2			/*	  no -- zero the page */
	movw	#(NBPG/4)-1,d2
	movl	#0,d3
    3:	movl	d3,a2@+
	dbra	d2,3b
    4:	addw	#1,d0			/* check next page */
	jra	1b

    5:					/* GOT A BUS ERROR! */
	movl	d1,0+SCB_BUSERR		/* restore bus error vector */
	movl	d0,_shortmem		/* found short io */
	tstl	_maxmem			/* did we already find end of phys? */
	jeq	1f			/*   no, so this is it */
	movl	_maxmem,d0		/*   yes, so go get it */
    1:	subl	_detachedmem,d0
	movl	d0,_maxmem
	movl	d0,_physmem
	movl	d0,_freemem
#endif	QBUS

	/*
	 * Allocate and setup page table and _u area for proc[0]. 
	 */
	movl	#_end+NBPG-1,d0		/* first page for proc 0 page table */
	andw	#-NBPG,d0
	movl	#PGSHIFT,d1
	lsrl	d1,d0
	movl	d0,d2
	movl	d0,d3
	orl	#PG_V|PG_KW,d0
	movl	d0,_Usrptmap		/* map it into usrpt */
#ifdef	QBUS
	movl	d0,d4
	lslw	#PAGVALSHIFT,d4
	movw	d4,PGREG(_usrpt)
#else	QBUS
	movw	d0,PGREG(_usrpt)
#endif	QBUS

	lea	_usrpt+NBPG-(UPAGES*4),a0/* last ptes are for _u area */
	lea	PGREG(_u),a1		/* map also to _u */
	movl	a1,a2
	movl	#UPAGES-1,d1
    1:	addl	#1,d0
	movl	d0,a0@+
#ifdef	QBUS
	movl	d0,d4
	lslw	#PAGVALSHIFT,d4
	movw	d4,a1@
#else	QBUS
	movw	d0,a1@
#endif	QBUS
	addl	#PAGREGINCR,a1
	dbra	d1,1b

#ifdef	QBUS
	movl	#NPAGPERSEG-IOPAGES-UPAGES-1,d0
#else	QBUS
	movl	#NPAGPERSEG-UPAGES-1,d0	/* IOPAGES are in their own HIBANK */
#endif	QBUS
    	movl	#(PAGINVPAGE<<PAGVALSHIFT),d1
    1:	subl	#PAGREGINCR,a2 		/* invalidae other pages in segment */
    	movw	#d1,a2@
	dbra	d0,1b

	subw	#1,d3			/* last logical page in use */
	lsrw	#PAGSEGSHIFT,d3		/* highest segment in use */
	movl	d3,_maxsysseg

	/*
	 * invalidate unused system segments
	 */
	addw	#1,d3			/* first unused logical segment */
	movw	d3,d1
	movl	#SEGREGBASE,d0
	swap	d0
#ifdef	VBUS
	lslw	#(SEGREGSHIFT-16),d1
#endif	VBUS
	addw	d1,d0
	swap	d0
	movl	d0,a0
	negw	d3
	addw	#NSEGPERCTX-3,d3
	movl	#(SEGPROT_NO|SEGINVALID),d0

    1:	MOVSEG	d0,a0@
	addl	#SEGREGINCR,a0
	dbra	d3,1b

	lea	_u+(UPAGES*NBPG),sp	/* set stack pointer to top of _u */

	/* 
	 * Initialize (slightly) the pcb
	 */
	lea	_u,a0
	movl	sp,a0@(PCB_SP)
	movw	sr,a0@(PCB_PSL+2)
	movl	#_usrpt,a0@(PCB_P0BR)
	movl	#AST_NONE+0,a0@(PCB_P0LR)
	movl	#_usrpt+(MAXU_ADDR>>PGSHIFT)-(4*UPAGES),a0@(PCB_P1BR)
	movl	#(MAXU_ADDR>>PGSHIFT)/*-UPAGES*/,a0@(PCB_P1LR)
	movl	#1,a0@(PCB_SZPT)
	movl	#U_REDZONE_MAGIC,a0@(U_STACK)

	/*
	 * copy the template scb to vector base region (location 0).
	 */
	lea	_scb,a0
	lea	0,a1
	movw	#NSCBVEC-1,d0
    1:	movl	a0@+,a1@+
	dbra	d0,1b

	TRACE(#0xA); TRACE(#0xD);	/* Output "\n" */
	addl	#UPAGES+1,d2
	movl	d2,sp@-

	.globl	_START
_START:	jsr	_main
	addl	#4,sp

	lea	NBPG,a0
	movl	a0,usp
	movw	#0,sp@-
	pea	0			/* user pc */
	movw	#PSL_USERSET,sp@-
	rte				/* go run icode */

	.globl	_DELAY
_DELAY:	movl	_cpuspeed,d1
    1:	movl	sp@(4),d0
    2:	dbf	d0,2b
	addw	#1,d0
	subl	#1,d0
	jge	2b
	dbf	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	rts

/************************************************************************/

/*
 * Interrupt vector routines. Following globals are for convienience in namelist
 */
	.globl	_waittime
	.globl	traps
	.globl	iret
	.globl	dorte

#define	SCBVEC(name)	.align 1;  .globl _X/**/name;  _X/**/name
#define	TRAP(x)		PEEXT(x); jra traps
#define	PEEXT(x)	clrw sp@-; pea x	/* push exception extention */
#define	PUSHR		movml #<d0-d1,a0-a1>,sp@-
#define	POPR		movml sp@+,#<d0-d1,a0-a1>
#define	PUSHED		(4*4)			/* offset around saved regs */
#define	TCODE		PUSHED			/* offset to trap code */
#define	TTYPE		(PUSHED+2)		/* offset to trap type */
#define	EEXT		6			/* size exception extension */
#define	ESF		(EEXT+PUSHED)		/* offset to exception frame */
#define	INC(counter)	addl #1,_cnt+counter	/* increment event counter */
#define	IBEG		IINC; subl #EEXT,sp; PUSHR; /* start of interrupt */
#define	RTE(n)		IDEC; INC(n); jra iret	/* end of interrupt */
#define	IINC		addl #1,_int_svc	/* increment interrupt depth */
#define	IDEC		subl #1,_int_svc	/* decrement interrupt depth */

/*
 * collapse various stack formats to 4-word format 0 if ESF_SOFT bit is on in 
 * the stack format/vector offset word. Used to send signals to process, and 
 * for nofault recovery.
 */
#define	COLLAPSE(x)	\
    5:	cmpw	#ESF_FMT/**/x,sp@(ESF_VEC); jne 5f; /* stack format x to */    \
	movw	#ESF_FMT0,sp@(ESF_VEC+ESF_ISIZE/**/x-ESF_ISIZE0); /* fmt0 */   \
	movl	sp@(ESF_PC),sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy pc */\
	movw	sp@(ESF_SW),sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0);/* copy sr */\
	lea	sp@(ESF_ISIZE/**/x-ESF_ISIZE0),sp; jra 2b /* collapse size */

SCBVEC(stray):
SCBVEC(ctcint0):
SCBVEC(ctcint1):
SCBVEC(ctcint2):	TRAP(T_STRAY)
SCBVEC(adderr):		clrb sp@(ESF_FADDR)
			TRAP(T_ADDERR)
SCBVEC(illins):		TRAP(T_RESOPFLT)
SCBVEC(zerodiv):	TRAP(T_ZERODIV)
SCBVEC(chk):		TRAP(T_CHK)
SCBVEC(trapv):		TRAP(T_TRAPV)
SCBVEC(privvio):	TRAP(T_PRIVINFLT)
SCBVEC(l1010em):	TRAP(T_L1010EM)
SCBVEC(l1111em):	TRAP(T_L1111EM)
SCBVEC(fmterr):		TRAP(T_FMTERR)
#ifndef	SYSV
SCBVEC(trap0):		TRAP(T_TRAP+(0<<16))
#endif	SYSV
SCBVEC(trap9):		TRAP(T_TRAP+(9<<16))
SCBVEC(trap10):		TRAP(T_TRAP+(10<<16))
SCBVEC(trap11):		TRAP(T_TRAP+(11<<16))
SCBVEC(trap12):		TRAP(T_TRAP+(12<<16))
SCBVEC(trap13):		TRAP(T_TRAP+(13<<16))
SCBVEC(trap14):		TRAP(T_TRAP+(14<<16))
SCBVEC(trap15):
#ifdef	DEBUGGER
			btst	#5,sp@; jne	dbg_excpt
#endif
			TRAP(T_BPTFLT)
SCBVEC(trace):
			/* ignore trace traps if trace bit is not set! */
			btst	#7,sp@; jne	1f; rte
#ifdef	DEBUGGER
    1:			btst	#5,sp@; jne	dbg_excpt
#endif
    1:			TRAP(T_TRCTRAP)


traps:	PUSHR				/* save [da][01] temporary registers */
traps0:	movl	usp,a0			/* save user sp */
	pea	a0@
	jsr	_trap			/* call generic trap handler */
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_TRAP)		/* keep count */

iret:	movw	#PSL_IPL7,sr		/* raise priority to protect ast */
	tstb	_ast
	jne	6f			/* branch if pending async soft trap */
    1:	POPR				/* restore [da][01] */
	addl	#EEXT,sp		/* pop exception extention */

dorte:	bclr	#ESF_SOFT_BIT,sp@(ESF_VEC)
	jne	5f			/* branch if frame must be collapsed */

	/* check for excessive stack growth, clobbering u area */
    2:	cmpl	#U_REDZONE_MAGIC,_u+U_STACK
	jne	3f

	/* chech for stack pointer getting near uarea */
	cmpl	#_u+U_STACK+512,sp
	jgt	4f
	cmpl	#SCRATCH_STACK,sp
	jlt	4f
    3:	tstl	_panicstr		/* disregaurd on panic */
	jne	4f
	pea	panic_stackovf		/* kernel stack overflow!! */
	jsr	_panic
    4:	rte				/**** return from trap/interrupt ****/

    5:	andw	#ESF_FMTMSK,sp@(ESF_VEC)/* isolate stack format */
	cmpw	#ESF_FMT0,sp@(ESF_VEC)	/* format 0 does not collapse */
	jeq	2b

	COLLAPSE(8)

    5:	pea	panic_iret		/* bad stack format */
	jsr	_panic

	/* Handle asynchronious soft trap */
    6:	movw	sp@(ESF+ESF_SW),d0
	andw	#PSL_HIGH,d0		/* are we returning to low priority? */
	jne	1b			/* no, leave ast pending */
	bclr	#AST_SOFT,_ast		/* check/clear software ast */
	jne	_Xsoftintr
	bclr	#AST_TIC,_ast		/* check/clear softclock ast */
	jne	_Xsoftclock
	btst	#AST_USR,_ast		/* check/clear user resched ast */
	jeq	1b
	movw	sp@(ESF+ESF_SW),d0	/* must be user ast */
	andw	#PSL_CURMOD,d0		/* leave pending */
	jne	1b			/* if not return to user mode */
	bclr	#AST_USR,_ast		/* clear ast and go service in trap */
	movw	#T_ASTFLT,sp@(TTYPE)
	jra	traps0

SCBVEC(nmi):
#ifndef	KPROF
#ifdef	DEBUGGER
	jra	dbg_excpt
#endif	DEBUGGER
#ifdef	QBUS
	clrw sp@-;  movw #T_NMI,sp@-;  movw BSR,sp@-;  movw d0,BSR;  jra traps
#else	QBUS
	TRAP(T_NMI)
#endif	QBUS
#else	KPROF
	/*
	 * To prepare QBUS 68010 CPU board for kprof profiling at level 7:
	 *	- Inject profile clock into 8A (8640) pin 7, BHALTL.
	 * To prepare VBUS 68010 CPU board for kprof profiling at level 7:
	 *	-  Bend up 9M (S113) pin 1 (AC fail), and inject profile clock 
	 *	   into chip pin.
	 * To prepare VBUS 68020 CPU board for kprof profiling at level 7:
	 *	-  Bend up U58 (LS32) pin 5, and ground that chip pin. This 
	 *	   disables latching of BSR on NMI interrupts, so that status 
	 *	   for bus errors is not lost.
	 *	-  Remove R5, which connects to AC fail on the bus. 
	 *	-  Inject profile clock into U82(LS113) pin 13.
	 */
	.data
	.globl	_kprof_magic
_kprof_magic:	.long	0x12345678
	.comm	_kprof_enable,4
	.comm	_kprof_su,2*4
	.comm	_kprof_spsl,8*4
	.comm	_kprof_upsl,8*4
	.comm	_kprof,KPROF*4
	.comm	_kprof_swtch,4
	.comm	_kprof_buse,4
	.comm	_kprof_sysc,4
	.comm	_kprof_pid,(20+32)*4	/* first 20 plus last 32 pid's */
	.comm	_kprof_pid_cnt,(20+32)*4
	.comm	_kprof_pid_nam,(20+32)*8
	.text

	IBEG
	tstb	_kprof_enable+3		/* skip if not enabled */
	jeq	3f
	cmpl	#SCRATCH_STACK,sp	/* dont look at pid if swtching */
	jlt	2f
	clrl	d0
	movl	_u+U_PROCP,a0		
	movw	a0@(P_PID),d0
	movl	d0,d1
	cmpw	#20,d0
	jle	1f
	andw	#0x1F,d0
	addl	#20,d0
    1:	lsll	#2,d0
	lea	_kprof_pid,a0
	addl	d0,a0
	movl	d1,a0@
	lea	_kprof_pid_cnt,a0
	addl	d0,a0
	addl	#1,a0@
	lea	_kprof_pid_nam,a0
	lsll	#1,d0
	addl	d0,a0
	lea	_u+U_COMM,a1		
	movl	a1@+,a0@+
	movl	a1@,a0@
    2:	clrl	d0
	movw	sp@(ESF+ESF_SW),d0	/* get psl */
	movw	d0,d1
	andl	#PSL_HIGH,d0
	lsrw	#PSL_IPL_SHIFT-2,d0	/* define kprof_[su]psl index */
	andl	#PSL_CURMOD,d1		/* test system mode */
	jeq	1f			/* jump if user mode */
	addl	#1,_kprof_su+4		/* accumulate system mode stats */
	jmi	4f;			/* jump if auto-shutoff */
	movl	sp@(ESF+ESF_PC),d1	/* get pc */
	andl	#NONT_MASK,d1
	lsrl	#2,d1			/* >>4, &(KPROF-1), <<2 */
	andl	#((KPROF-1)<<2),d1
	lea	_kprof,a0
	addl	d1,a0
	addl	#1,a0@
	lea	_kprof_spsl,a0
	jra	2f
    1:	addl	#1,_kprof_su		/* user mode */
	jmi	4f;			/* jump if auto-shutoff */
	lea	_kprof_upsl,a0
    2:	addl	d0,a0
	addl	#1,a0@
    3:	RTE	(V_INTR)
    4:	clrl	_kprof_enable		/* disable */
	RTE	(V_INTR)
#endif	KPROF

SCBVEC(ctcint3):
	movb	#CTC_RETI0,CTC_RETI	/* clear the interupt */
	movb	#CTC_RETI1,CTC_RETI
SCBVEC(lclock):
	IBEG
#ifndef	is68k_kobj
#if	NVB > 0
	jsr	_vbcheck		/* 010's and standalone dont use IPI */
	subw	#1,tictoc
	jgt	1f
	movw	_fastclock,tictoc
#endif	NVB > 0
#endif	is68k_kobj
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_hardclock		/* hardclock(pc,psl) */
	addl	#8,sp
	addl	#1,_intrcnt+I_CLOCK
    1:	RTE	(V_INTR)		/* temp so not to break vmstat -= HZ */

/* 
 * AST HANDLERS: exception extension stuff and regs are already pushed
 */
SCBVEC(softclock):
	movw	#PSL_IPLC,sr
	movw	sp@(ESF+ESF_SW),sp@-
	clrw	sp@-
	movl	sp@(4+ESF+ESF_PC),sp@-
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	jra	iret

SCBVEC(softintr):
	movw	#PSL_IPLS,sr
	jsr	_softint
	jra	iret

/*
 * T_SEGVIO:  attempt to access location outside of user address space
 * T_PROTFLT: attempt to write into a read-only page
 * T_SEGFLT:  attempt to access valid location with no page bank resources
 * T_PAGEFLT: attempt to access valid logical location in currently invalid page
 * T_BUSERR:  bummer
 */
SCBVEC(buserr):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_buse		/* kprof: count bus errors */
    1:
#endif	KPROF
	clrb	sp@(ESF_FADDR)		/* might not always be zero!!! */
	clrw	sp@-			/* upper processor status longword */
	pea	T_PAGEFLT		/* hopeful trap type (code=0) */
	PUSHR				/* save temporary registers */

#ifdef	QBUS
	movl	#0x40,d0		/* segment register bank select */
	orw	sp@(ESF+ESF_FADDR),d0	/* or in upper word of fault addr */
	swap	d0			/* shift to upper word of d0 */
	movb	CXR,d0
	lslw	#8,d0			/* get context in bits 15-12 */
	movl	d0,a0
	btst	#10,d0			/* check invalid page bit */
	jeq	3f
					/* page reg is invalid (3FC or 3FD) */
	movw	a0@,d0			/* get contents of segment register */
	andw	#0x003F,d0		/* mask all but page register set */
	orw	#0x0080,d0		/* select page register bank */
	swap	d0
	movw	sp@(ESF+ESF_FADDR+2),d0	/* get lower word of fault addr */
	clrb	d0			/* bit 0 must be zero */
	movl	d0,a0
	movw	a0@,d0			/* get contents of page register */
	lsrw	#3,d0			/* paged-out page (3FC)? */
	jcc	traps0			/*   yes, go service page fault */
    2:	movw	#T_SEGVIO,sp@(TTYPE)
	jra	traps0			/*   no, go service seg violation */
    4:	movw	#T_SEGFLT,sp@(TTYPE)
	jra	traps0

    3:	btst	#9,d0			/* check protection bit */
	jeq	4f
	cmpw	#0x40,sp@(ESF+ESF_FADDR)
	jhs	2b			/* if user access to on-board IO */
	movw	a0@,d0			/* get contents of segment register */
	andw	#0xFF,d0
	jeq	2b			/* seg vio */
	cmpw	#1,d0
	jeq	4b			/* seg fault */
	movw	#T_PROTFLT,sp@(TTYPE)
	jra	traps0			/* write to a read-only segment */

    4:	movw	#T_BUSERR,sp@(TTYPE)
	jra	traps0			/* not invalid page & not protection */
#else	QBUS
	movw	CBX,d1
	andw	#CTXMASK,d1
	movl	#SEGCTXSHIFT,d0
	lslw	d0,d1			/* get context in proper place */
	movl	#0,d0
	movw	sp@(ESF+ESF_FADDR),d0	/* upper word of fault addr */
	swap	d0			/* shift to upper word of d0 */
	orw	d1,d0
	orl	#SEGREGBASE,d0
	movl	d0,a0

	movl	sp@(ESF+ESF_FADDR),d1	/* get fault addr */
	movl	#PGSHIFT-PAGREGSHIFT,d0
	lsrl	d0,d1
	andl	#(NPAGPERSEG-1)<<PAGREGSHIFT,d1
	movb	a0@,d0			/* get contents of segment register */
	jeq	1f			/* (SEGPROT_NO | SEGINVALID) */
	cmpb	#(SEGPROT_NO|SEGPAGEDOUT),d0
	jeq	2f
	andl	#(NPAGBANKS-1),d0	/* mask all but page bank */
	lsll	#PAGSEGSHIFT+PAGREGSHIFT,d0
	orl	d1,d0
	orl	#PAGREGBASE,d0
	movl	d0,a0
	movw	a0@,d0			/* get contents of page register */
	btst	#PAGINVBIT,d0		/* invalid page */
	jeq	3f			/* jump if page is valid */
	btst	#PAGOUTBIT,d0		/* invalid and paged-out page ?? */
	jne	traps0			/* service page fault */
    1: 	movw	#T_SEGVIO,sp@(TTYPE)
	jra	traps0			/* service segmentation violation */
    2:	movw	#T_SEGFLT,sp@(TTYPE)
	jra	traps0			/* service segmentation fault */
    3:	movw	#T_PROTFLT,sp@(TTYPE)
	jra	traps0			/* write to a read-only segment */
#endif	QBUS

/*
 * System call service: Trap #1 is typical user system call. Signal and 
 * longjmp cleanup use traps #2 - #8, and go to Sigcleanup() via a 
 * negative-number syscall.  The traps are 4-word stack format 0, but may need 
 * to return with a larger stack format obtained from the user. Here we allocate
 * larger exception stack frame, slide the 4-word format up to the top of the 
 * allocated area, and change its format so that if it is actually used, it will
 * collapse back to 4 words.
 */
#define	SIG_CLEAN_SYSCALL(x,n)	\
	subl	#(ESF_ISIZE/**/x-ESF_ISIZE0),sp;/* allocate for format x */ \
	movw	sp@(ESF_SW+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_SW);	\
	movl	sp@(ESF_PC+ESF_ISIZE/**/x-ESF_ISIZE0),sp@(ESF_PC);	\
	movw	#(ESF_SOFT|ESF_FMT/**/x),sp@(ESF_VEC);			\
	PEEXT(T_SYSCALL + (-n << 16)); jra 2b	/* syscall -n */

#ifdef	SYSV
SCBVEC(trap0):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_sysc		/* kprof: count system calls */
    1:
#endif	KPROF
	clrw	sp@-			/* align psl, part of EEXT */
	movw	#T_SYSCALL,sp@-		/* push type, part of EEXT */
	movw	d0,sp@-			/* push code, part of EEXT */
	PUSHR				/* save temp regs */
	movl	usp,d0			/* save user sp */
	movl	d0,sp@-
	cmpw	#NCRMAGIC,_u+U_FILEMAG	/* for NCR compatibility */
	beq	1f
	movl	#32,sp@-		/* no of args (passed on the stack) */
	movl	#_u+U_ARG,sp@-		/* start of u arg area */
	addl	#4,d0			/* user sp + 4 */
	movl	d0,sp@-
	jsr	_copyin
	addl	#12,sp
	bra	2f
    1:
#define	ARG1OFF	_u+U_ARG
#define	ARG2OFF	_u+U_ARG+4
#define	ARG3OFF	_u+U_ARG+8
#define	ARG4OFF	_u+U_ARG+12
#define	ARG5OFF	_u+U_ARG+16
#define	ARG6OFF	_u+U_ARG+20
#define	ARG7OFF	_u+U_ARG+24
#define	ARG8OFF	_u+U_ARG+28
	movl	a0,ARG1OFF		/* args passed in registers */
	movl	d1,ARG2OFF
	movl	a1,ARG3OFF
	movl	d2,ARG4OFF
	movl	a2,ARG5OFF
	movl	d3,ARG6OFF
	movl	a3,ARG7OFF
	movl	d4,ARG8OFF
    2:
	jsr	_sysv_syscall		/* call system call handler */
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_SYSCALL)
	jra	iret
#endif	SYSV

SCBVEC(trap1):
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_sysc		/* kprof: count system calls */
    1:
#endif	KPROF
	clrw	sp@-			/* align psl, part of EEXT */
	movw	#T_SYSCALL,sp@-		/* push type, part of EEXT */
	movw	d0,sp@-			/* push code, part of EEXT */
	jne	1f
	movw	d1,sp@
	movml	#<a0-a6>,_u+U_ARG
	jra	2f
    1:	movml	#<d1,a0-a6>,_u+U_ARG
    2:	PUSHR				/* save temp regs */
	movl	usp,a0			/* save user sp */
	pea	a0@
	jsr	_syscall		/* call system call handler */
	movl	sp@+,a0
	movl	a0,usp			/* restore user sp */
	INC	(V_SYSCALL)
	jra	iret

SCBVEC(trap2):	SIG_CLEAN_SYSCALL(B,7)	/* trampoline format B, syscall -7 */
SCBVEC(trap3):	SIG_CLEAN_SYSCALL(A,6)	/* trampoline format A, syscall -6 */
SCBVEC(trap4):	SIG_CLEAN_SYSCALL(9,5)	/* trampoline format 9, syscall -5 */
SCBVEC(trap5):	SIG_CLEAN_SYSCALL(8,4)	/* trampoline format 8, syscall -4 */
SCBVEC(trap6):	SIG_CLEAN_SYSCALL(2,3)	/* trampoline format 2, syscall -3 */
SCBVEC(trap8):				/* trampoline format 0, syscall -2 */
	PEEXT(T_SYSCALL + (-2 << 16)); jra	2b
SCBVEC(trap7):				/* longjmp cleanup, syscall -1 */
	PEEXT(T_SYSCALL + (-1 << 16)); jra	2b

/************************************************************************/

	.globl	_badaddr
/*
 * badaddr(addr, len)
 *	See if access addr with a len type instruction causes a bus or address 
 *	error. Len is length of access (1=byte, 2=short, 4=long).
 */
_badaddr:
	movl	sp@(4),a0		/* address to be tested */
	movl	sp@(8),d1		/* size of operand (1, 2, or 4) */
	movw	sr,d0
	movl	d0,a1			/* save old sr in a1 */
	movl	#0,d0			/* hopeful return value: 0 */
	orw	#PSL_HIGH,sr		/* disable interrupts */
	movl	0+SCB_BUSERR,sp@-	/* save old bus error vector */
	movl	0+SCB_ADRERR,sp@-	/* save old address error vector */
	movl	#8f,0+SCB_BUSERR	/* set new bus error vector */
	movl	#9f,0+SCB_ADRERR	/* set new address error vector */
	tstl	d1
	jle	3f			/* READ operation */
	lsrw	#1,d1			/* byte operation? */
	jcc	1f			/*   no */
	tstb	a0@			/*   yes -- try to access byte */
    1:	lsrw	#1,d1			/* short operation? */
	jcc	2f			/*   no */
	tstw	a0@			/*   yes -- try to access short */
    2:	lsrw	#1,d1			/* long operation? */
	jcc	4f			/*   no */
	tstl	a0@			/*   yes -- try to access long */
	jra	4f
    3:	negl	d1			/* WRITE operation */
	lsrw	#1,d1			/* byte operation? */
	jcc	1f			/*   no */
	movb	d0,a0@			/*   yes -- try to access byte */
    1:	lsrw	#1,d1			/* short operation? */
	jcc	2f			/*   no */
	movw	d0,a0@			/*   yes -- try to access short */
    2:	lsrw	#1,d1			/* long operation? */
	jcc	4f			/*   no */
	movl	d0,a0@			/*   yes -- try to access long */
    4:	movl	sp@+,0+SCB_ADRERR	/* restore old address error vector */
	movl	sp@+,0+SCB_BUSERR	/* restore old bus error vector */
	movl	a1,d1
	movw	d1,sr			/* restore old interrupt priority */
	rts				/* return value in d0 */

    8:	addw	#1,d0			/* BUS ERROR modify return value */
	orw	#ESF_SSW_10_RR,sp@(ESF_SSW)
	jra	dorte			/* return from bus error exception */

    9:	addw	#8,d0			/* ADDRESS ERROR modify return value */
	orw	#ESF_SSW_10_RR,sp@(ESF_SSW)
	jra	dorte			/* return from address error exceptn */

/* addupc(pc, &u.u_prof, nticks)
/*	struct uprof {			/* profile arguments */
/*		short	*pr_base;	/* buffer base */
/*		unsigned pr_size;	/* buffer size */
/*		unsigned pr_off;	/* pc offset */
/*		unsigned pr_scale;	/* pc scaling */
/*	} u_prof;
/* */
	.globl	_addupc
_addupc:movl	sp@(8),a1		/* &u.u_prof */
	movl	sp@(4),d0
	subl	a1@(8),d0		/* corrected pc */
	jlt	9f
	lsrl	#1,d0			/* logical right shift */
	movl	a1@(12),d1
	lsrl	#1,d1			/* ditto for scale */
	movl	d0,sp@-
	movl	d1,sp@-
	jsr	ulqmul
	addl	#8,sp
	lsll	#1,d0			/* quad right shift 14 */
	roxll	#1,d1
	jcs	9f
	lsll	#1,d0
	roxll	#1,d1
	jcs	9f
	movw	d1,d0
	clrw	d1
	swap	d0
	swap	d1
	jne	9f
	andw	#0xFFFE,d0
	cmpl	a1@(4),d0		/* length */
	jhs	9f
	addl	a1@,d0			/* base */
	movl	d0,a0
	movl	_nofault,sp@-
	movl	#8f,_nofault
	movsw	a0@,d1
	addl	sp@(16),d1
	movsw	d1,a0@
    7:	movl	sp@+,_nofault
    9:	rts
    8:	clrl	a1@(12)
	jra	7b

ulqmul:
	movl	d2,sp@-
	movw	sp@(10),d0	/* d0 = alo */
	mulu	sp@(12),d0	/* d0 = bhi*alo */
	movw	sp@(14),d1	/* d1 = blo */
	mulu	sp@(8),d1	/* d1 = ahi*blo */
	addl	d1,d0		/* d0 = (ahi*blo) + (bhi*alo) ... carry in x */
	movl	#0,d1
	addxl	d1,d1		/* d1 = carry from previous add */
				/* d0-1 = (ahi*blo) + (bhi*alo) */
	swap	d1
	swap	d0
	movw	d0,d1
	clrw	d0		/* d0-1 = ((ahi*blo) + (bhi*alo)) * (2**16) */
	movw	sp@(14),d2	/* d2 = blo */
	mulu	sp@(10),d2	/* d2 = alo*blo */
	addl	d2,d0		/* add (alo*blo) to d0 ... carry in x */
	movw	sp@(12),d2	/* d2 = bhi */
	mulu	sp@(8),d2	/* d2 = ahi*bhi */
	addxl	d2,d1		/* add (ahi*bhi) to d1, plus carry from prev */
	movl	sp@+,d2
	rts

	.globl	_useracc
_useracc:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tuseracc
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) ruseracc() */
	jne	_ruseracc
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),d0		/* user virtual address */
	movl	d0,d1			/* upper address must be zero */
	andl	#~NONT_MASK,d1
	jeq	1f
    	movl	#0,d0
	rts
    1:	movl	d0,a0
	movl	#NBPG,d1
	movl	a0,a1
	addl	sp@(8),a1
	subl	#1,a1			/* address of last byte */
	movl	_nofault,sp@-
	movl	#4f,_nofault
	tstl	sp@(16)			/* 1 => READ */
	jeq	2f

    1:	movsb	a0@,d0			/* check for read access */
	addl	d1,a0
	cmpl	a0,a1
	jgt	1b
	movsb	a1@,d0
	jra	3f

    2:	movsb	a0@,d0			/* check for write access */
	movsb	d0,a0@
	addl	d1,a0
	cmpl	a0,a1
	jgt	2b
	movsb	a1@,d0
	movsb	d0,a1@

    3:	movl	#1,d0
    1:	movl	sp@+,_nofault
	rts
    4:	movl	#0,d0
	jra	1b

	.globl	_kernacc
_kernacc:
	movl	#1,d0
	rts				/* KLUDGE success */

	movl	sp@(4),a0		/* system virtual address */
	movl	#NBPG,d1
	movl	a0,a1
	addl	sp@(8),a1
	subl	#1,a1			/* address of last byte */
	movl	_nofault,sp@-
	movl	#4b,_nofault
	tstl	sp@(16)
	jeq	2f

    1:	movb	a0@,d0			/* check for read access */
	addl	d1,a0
	cmpl	a0,a1
	jgt	1b
	movb	a1@,d0
	jra	3b

    2:	movb	a0@,d0			/* check for write access */
	movb	d0,a0@
	addl	d1,a0
	cmpl	a0,a1
	jgt	2b
	movb	a1@,d0
	movb	d0,a1@
	jra	3b

	.globl	_noproc
	.comm	_noproc,4
	.globl	_runrun
	.comm	_runrun,4
	.globl	_setrq
	.globl	_remrq
	.globl	__insque
	.globl	__remque
/*
 * setrq(p): 	Called at spl6().  p->p_stat should be SRUN.
 */
_setrq:	movl	sp@(4),a0
	tstl	a0@(P_RLINK)
	jeq	1f
	pea	panic_setrq
	jsr	_panic

    1:	movl	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1			/* put on queue which is p->p_pri / 4 */
	movl	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1
	movl	a1,a0@			/* insert at end of queue */
	movl	a1@(4),d0
	movl	d0,a0@(4)
	movl	a0,a1@(4)
	movl	d0,a1
	movl	a0,a1@
	lea	_whichqs,a1		/* mark queue non-empty */
	movl	a1@,d0
	bset	d1,d0
	movl	d0,a1@
	rts

/*
 * remrq(p): 	Called at spl6().
 */
_remrq:	movl	sp@(4),a0
	movl	#0,d1
	movb	a0@(P_PRI),d1
	lsrw	#2,d1
	movl	_whichqs,d0
	bclr	d1,d0
	jne	1f
	movl	d0,_whichqs
	pea	panic_remrq
	jsr	_panic
    1:	movl	a0@,a1
	movl	a0@(4),d1
	cmpl	d1,a1
	jne	1f
	movl	d0,_whichqs
    1:	movl	d1,a1@(4)
	exg	d1,a1
	movl	d1,a1@
	clrl	a0@(P_RLINK)
	rts

__insque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0		/* new */
	movl	sp@(8),a1		/* pred */
	movl	a1@,d0			/* succ */
	movl	d0,a0@
	movl	a1,a0@(4)
	movl	a0,a1@
	movl	d0,a1
	movl	a0,a1@(4)
	movw	d1,sr
	rts

__remque:
	movw	sr,d1
	orw	#PSL_HIGH,sr
	movl	sp@(4),a0
	movl	a0@,a1
	movl	a0@(4),d0
	movl	d0,a1@(4)
	exg	d0,a0
	movl	a1,a0@
	movw	d1,sr
	rts

	.globl	_swtch
	.globl	_waitloc
/*
 * swtch: switch to another process.
 */
_swtch:	movw	sr,_u+PCB_PSL+2
	movl	#1,_noproc
	clrl	_runrun

	/* determine highst priority nonempty queue */
    1:	orw	#PSL_HIGH,sr		/* disable interrupts */
	movl	_whichqs,d0
	movl	#0,d1
	jra	3f
    2:	addw	#1,d1
    3:	lsrl	#1,d0			/* find an active queue */
	jcs	4f			/* jump if active */
	jne	2b

	bclr	#AST_SOFT,_ast		/* no active queue, check ast's */
	jne	2f
	bclr	#AST_TIC,_ast
	jne	3f
	stop	#PSL_IPL0		/* no ast's, go idle */

_waitloc:
	jra	1b			/* try again */

    2:	movw	#PSL_IPLS,sr		/* service software ASTs */
	jsr	_softint
	jra	1b

    3:	movw	#PSL_IPLC,sr		/* service clock ast */
	movl	#PSL_IPL0,sp@-
	pea	_waitloc		/* push pc (idle address) */
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	jra	1b

	/* found nonempty run queue, remove first entry */
    4:	movw	d1,d0
	lslw	#3,d0
	lea	_qs,a1
	lea	a1@(0,d0:w),a1		/* a1 -> queue header */
	movl	a1@,a0			/* a0 -> first entry in queue */
	cmpl	a1,a0			/* make sure queue not empty */
	jne	1f
    2:	pea	panic_swtch
	jsr	_panic

    1:	movl	a0@,d0			/* unlink item from queue */
	movl	d0,a1@			/* unlink from queue header */
	exg	d0,a1
	movl	d0,a1@(4)		/* unlink from successor */
	cmpl	d0,a1			/* if queue is now empty, */
	jne	1f
	movl	_whichqs,d0		/* mark queue empty */
	bclr	d1,d0
	movl	d0,_whichqs

    1:	clrl	_noproc
	tstl	a0@(P_WCHAN)
	jne	2b
	cmpb	#SRUN,a0@(P_STAT)
	jne	2b
	clrl	a0@(P_RLINK)
	movl	a0@(P_ADDR),a1
	movl	a1@,_masterpaddr
	INC	(V_SWTCH)

#ifdef	QBUS
	movb	CXR,d1
	andw	#~CTXMASK,d1
	orb	#(1<<CTXSHIFT),d1	/* user context #1 */
	movw	d1,CXW
#else	QBUS
	movw	CBX,d1
	andw	#~CTXMASK,d1
	orb	#(1<<CTXSHIFT),d1	/* user context #1 */
	movw	d1,CBX
#endif	QBUS
	movml	#<d2-d7,a2-a7>,_u
	movl	a1,a2			/* save pointer to uarea pte's */

	movl	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_refptes
	addl	#8,sp

	movl	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#(MAXU_ADDR>>PGSHIFT),d1
	subw	d0,d1
	movl	d1,sp@			/* num of ptes */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_refptes
	lea	sp@(12),sp

#ifdef	FP_SKY
	.globl	_save_sky
	.globl	_restore_sky
_save_sky:
	movl	_skybase,d2		/* SKY FPP save context */
	jeq	5f
	movl	d2,a3
	movl    _u+U_PROCP,a0
	tstb	a0@(P_FLAG)		/* high bit of p_flag is sky map bit */
	jge	5f
	movw	a3@(SKYSTC),d2
	andw	#SKYMODE,d2
	cmpw	#SKYMODE_RUN,d2		/* dont save if mode not Run Enable */
	jne	5f
	lea	_u+U_SKY,a4
    1:	movw	a3@(SKYSTC),d2
	btst	#SKYIDLE,d2
	jeq	2f
	movw	#0x1063,a4@+		/* noop */
	jra	4f
    2:	btst	#SKYRDY,d2
	jeq	1b
	movw	#SKYMODE_SS,a3@(SKYSTC)	/* set single step mode */
    1:	movw	a3@(SKYSTC),d2
	btst	#SKYDIR,d2
	jeq	2f
	movw	a3@(SKYDT1),d2
	jra	3f
    2:	movw	d2,a3@(SKYDT1)
    3:	movw	a3@(SKYSTC),d2
	btst	#SKYRDY,d2
	jne	1b
    	movw	a3@(SKYCOM),d2
	subw	#1,d2
	movw	d2,a4@+
    	movw	#SKYRESET,a3@(SKYSTC)	/* set reset bit */
	movw	#0x1000,a3@(SKYCOM)	/* initialize */
	movw	#0x1000,a3@(SKYCOM)	/* initialize */
	movw	#0x1001,a3@(SKYCOM)	/* sp_r add */
	movw	#SKYMODE_RUN,a3@(SKYSTC)
    4:	movw	#0x1063,a3@(SKYCOM)	/* noop */
    	movw	#0x1040,a3@(SKYCOM)	/* context save */
	lea	a3@(SKYDT1),a3
	movl	#8-1,d2
    1:	movl	a3@,a4@+
	dbra	d2,1b
    5:
#endif	FP_SKY

	lea	SCRATCH_STACK,sp	/* KLUDGE tmp stack, for NMI's! */
	lea	PGREG(_u),a1
	movw	#UPAGES-1,d1
    1:	movl	a2@+,d2
#ifdef	QBUS
	lslw	#PAGVALSHIFT,d2		/* convert pte */
#endif	QBUS
	movw	d2,a1@
	addl	#PAGREGINCR,a1
	dbra	d1,1b
#ifdef	KPROF
	tstb	_kprof_enable+3
	jeq	1f
	addl	#1,_kprof_swtch		/* kprof: count context switches */
    1:
#endif	KPROF

	/*
	 * Invalidate all NSEGPERCTX segments for the user context.
	 */
	lea	SEGREGBASE+(1<<SEGCTXSHIFT),a0	/* user context #1 */
	movl	#SEGREGINCR,d1
	movl	#(SEGPROT_NO|SEGINVALID),d0
	movl	#NSEGPERCTX-1,d2
    1:	MOVSEG	d0,a0@
	addl	d1,a0
	dbra	d2,1b

	movml	_u,#<d2-d7,a2-a7>
	movl	#NPAGBANKS-HIBANKS,_minusrseg

	movl	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_newptes
	addl	#8,sp

	movl	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#(MAXU_ADDR>>PGSHIFT),d1
	subw	d0,d1
	movl	d1,sp@			/* num of pages */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_newptes
	lea	sp@(12),sp

#ifdef	FP_SKY
_restore_sky:
	movl	_skybase,d0
	jeq	2f
	movl	d0,a0
	movl	_u+U_PROCP,a1		/* u.u_procp */
	tstb	a1@(P_FLAG)		/* high bit of p_flag is sky map bit */
	jge	2f
	movw	a0@(SKYSTC),d0
	andw	#SKYMODE,d0
	cmpw	#SKYMODE_RUN,d0
	jne	2f
	movw	#0x1041,a0@(SKYCOM)	/* context restore */
	lea	_u+U_SKY,a1
	movw	a1@+,d0
	movl	#8-1,d1
    1:	movl	a1@+,a0@(SKYDT1)
	dbra	d1,1b
    	movw	d0,a0@(SKYCOM);
    2:
#endif	FP_SKY

	movl	_u+PCB_SSWAP,d0
	jeq	1f
	clrl	_u+PCB_SSWAP
	movl	d0,sp@
	movw	_u+PCB_PSL+2,sr
	jsr	_longjmp
    1:	movl	#0,d1
	movw	_u+PCB_PSL+2,d1
	jra	splx

	.globl	_setjmp
	.globl	_longjmp
	.globl	_resume
/*
 * Non-local goto's
 */
_setjmp:movl	sp@+,a1			/* return address */
	movl	sp@,a0			/* jmpbuf */
	movml	#<d2-d7,a2-a7>,a0@
	movl	a1,a0@(12*4)		/* return pc */
	movl	#0,d0			/* zero return value */
	jmp	a1@			/* return */

_longjmp:
	movl	sp@(4),a0		/* jmpbuf */
	movl	a6,d0			/* save fp in case we panic */
	movml	a0@+,#<d2-d7,a2-a6>
	movl	a0@+,a1			/* to be new sp */
	cmpl	sp,a1			/* must be a pop */
	jge	1f
	movl	d0,a6			/* put frame pointer back */
	link	a6,#0			/* for stack backtrace */
	pea	panic_ljmp
	jsr	_panic			/* no return */
    1:	movl	a1,sp
	movl	a0@,a1			/* return pc */
	movl	a0,d0			/* nonzero return value */
	jmp	a1@			/* return */

_resume:movw	sr,_u+PCB_PSL+2
	movml	#<d2-d7,a2-a7>,_u
	rts

	.globl	_setsoftclock
_setsoftclock:
	movw	sr,d0
	andw	#PSL_HIGH,d0		/* are we running at low priority? */
	jeq	1f
	bset	#AST_TIC,_ast		/*   no -- set ast pending & return */
	rts
    1:	movw	#PSL_IPLC,sr
	pea	PSL_IPL0
	movl	sp@(4),sp@-
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	movw	#PSL_IPL0,sr
	rts

/* set software ast interrupt pending, must be called at splhigh! */
	.globl	_siron
_siron:	bset	#AST_SOFT,_ast
	rts

	.globl	_splx
	.globl	_spl
	.globl	_spl0
	.globl	_spl1
	.globl	_splsoftclock
	.globl	_splsoft
	.globl	_splnet
	.globl	_spl4
	.globl	_spl5
	.globl	_spltty
	.globl	_splimp
	.globl	_spl6
	.globl	_spl7
	.globl	_splhigh
	.globl	_splclock
	.globl	_splbio

_splx:	movl	sp@(4),d1
splx:	movw	d1,d0
	andw	#PSL_HIGH,d0
	jeq	_spl0
	clrl	d0
	movw	sr,d0
	movw	d1,sr
	rts

_spl:	clrl	d0
	movw	sr,d0
	rts

_spl0:	clrl	d0
	movw	sr,d0
    1:	movw	#PSL_IPL7,sr		/* raise priority to protect ast */
	tstb	_ast
	jeq	2f
	bclr	#AST_SOFT,_ast
	jne	3f
	bclr	#AST_TIC,_ast
	jne	4f
    2:	andw	#PSL_LOW,sr		/* drop to low priority */
	rts

    3:	movw	#PSL_IPLS,sr		/* service software ASTs */
	jsr	_softint
	jra	1b

    4:	movw	#PSL_IPLC,sr
	movl	d0,sp@-			/* save previous sr */
	pea	PSL_CURMOD
	movl	sp@(8),sp@-		/* push pc (return address) */
	jsr	_softclock		/* softclock(pc,psl) */
	addl	#8,sp
	movl	sp@+,d0			/* return value */
	jra	1b

_splnet:clrl	d0
	movw	sr,d0
	movw	#PSL_IPLN,sr
	rts

_splsoft:
	clrl	d0
	movw	sr,d0
	movw	#PSL_IPLS,sr
	rts

_splsoftclock:
	clrl	d0
	movw	sr,d0
	movw	#PSL_IPLC,sr
	rts

_spl1:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL1,sr
	rts

#ifdef	QBUS
_splbio:
_splimp:
#endif	QBUS
_spl4:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL4,sr
	rts

#ifdef	M68020
_spltty:
#endif	M68020
_spl5:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL5,sr
	rts

#ifdef	M68010
_spltty:			/* QBUS: on board sio is at level 6 ! */
#endif	M68010
#ifdef	VBUS
_splimp:
_splbio:
#endif	VBUS
_splclock:
_spl6:	clrl	d0
	movw	sr,d0
	movw	#PSL_IPL6,sr
	rts

_splhigh:
_spl7:	clrl	d0
	movw	sr,d0
	orw	#PSL_HIGH,sr
	rts

	.globl	_copyin
	.globl	_copyout
	.globl	_copyinstr
	.globl	_copyoutstr
	.globl	_copystr
	.globl	_fubyte
	.globl	_fuibyte
	.globl	_fuword
	.globl	_fuiword
	.globl	_subyte
	.globl	_suibyte
	.globl	_suword
	.globl	_suiword
_copyin:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyin
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rcopyin() */
	jne	_rcopyin
#endif	defined(SYSV) && defined(RFS)
	cmpl	#510,sp@(12)
	jhs	_bcopyin
	movl	sp@(4),a0
	movl	sp@(8),a1

	movw	a0,d0			/* check for one addr even & one odd */
	movw	a1,d1
	eorw	d1,d0
	movl	sp@(12),d1
	jle	5f
	movl	_nofault,sp@-
	movl	#6f,_nofault
	lsrw	#1,d0
	jcs	4f

	movw	a0,d0			/* check for both addrs odd */
	lsrw	#1,d0
	jcc	1f
	movsb	a0@+,d0
	movb	d0,a1@+
	subl	#1,d1
	movl	d1,sp@(16)		/* adjust count! */
    1:	lsrl	#2,d1
	jra	2f

    1:	movsl	a0@+,d0
	movl	d0,a1@+
    2:	dbf	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b

	movl	sp@(16),d1
	andl	#3,d1
	jra	4f

    3:	movsb	a0@+,d0
	movb	d0,a1@+
    4:	dbf	d1,3b
	addw	#1,d1
	subl	#1,d1
	jge	3b

	movl	sp@+,_nofault
    5:	movl	#0,d0
	rts

    6:	movl	sp@+,_nofault
	movl	#EFAULT,d0
	rts

_copyout:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyout
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rcopyout() */
	jne	_rcopyout
#endif	defined(SYSV) && defined(RFS)
	cmpl	#510,sp@(12)
	jhs	_bcopyout
	movl	sp@(4),a0
	movl	sp@(8),a1

	movw	a0,d0			/* check for one addr even & one odd */
	movw	a1,d1
	eorw	d1,d0
	movl	sp@(12),d1
	jle	5f
	movl	_nofault,sp@-
	movl	#6f,_nofault
	lsrw	#1,d0
	jcs	4f

	movw	a0,d0			/* check for both addrs odd */
	lsrw	#1,d0
	jcc	1f
	movb	a0@+,d0
	movsb	d0,a1@+
	subl	#1,d1
	movl	d1,sp@(16)		/* adjust count! */
    1:	lsrl	#2,d1
	jra	2f

    1:	movl	a0@+,d0
	movsl	d0,a1@+
    2:	dbf	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b

	movl	sp@(16),d1
	andl	#3,d1
	jra	4f

    3:	movb	a0@+,d0
	movsb	d0,a1@+
    4:	dbf	d1,3b
	addw	#1,d1
	subl	#1,d1
	jge	3b

	movl	sp@+,_nofault
    5:	movl	#0,d0
	rts
    6:
	movl	sp@+,_nofault
	movl	#EFAULT,d0
	rts

/* bzero user address space */
	.globl	_u_bzero
_u_bzero:				/* u_bzero(us, bcount) */
	movl	sp@(4),a0
	movl	sp@(8),d1		/* byte count */
	jle	4f
	movl	d2,sp@-
	movl	_nofault,sp@-
	movl	#5f,_nofault
	clrl	d2
    	movl	d1,d0
	lsrw	#1,d0
	jcc	1f
	movsb	d2,a0@+
	subl	#1,d1
    1:	movl	d1,d0
	lsrl	#5,d0
	andl	#0x1F,d1
	jra	2f
    1:	movsl	d2,a0@+; movsl d2,a0@+; movsl d2,a0@+; movsl d2,a0@+;
	movsl	d2,a0@+; movsl d2,a0@+; movsl d2,a0@+; movsl d2,a0@+;
    2:	dbra	d0,1b
	addw	#1,d0
	subl	#1,d0
	jge	1b
	movl	d1,d0
	lsrw	#1,d0
	jra	2f
    1:	movsw	d2,a0@+
    2:	dbra	d0,1b
	andw	#1,d1
	jeq	3f
	movsb	d2,a0@+
    3:	movl	sp@+,_nofault
	movl	sp@+,d2
    4:	movl	#0,d0
	rts
    5:	movl	sp@+,_nofault
	movl	sp@+,d2
	movl	#EFAULT,d0
	rts

#if	defined(SYSV) && defined(RFS)
/* upath: called from RFS routines to copyin a string from user space.  */
	.globl	_upath
_upath:					/* upath(us, kd, maxlen) */
	/* Note that the original System V upath does not do any */
	/* copy when the length is unacceptable. But this one does */
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) spath() */
	jne	_spath
	movl	sp@(4),d0		/* user virtual */
	movl	d0,d1			/* make shure upper address is zero */
	andl	#~NONT_MASK,d1
	jeq	1f
	movl	#-1,d0			/* illegal address return code*/
	rts
    1:	movl	d0,a0
	movl	sp@(8),a1		/* kernel destination */
    	clrl	d0			/* found null return code*/
	movl	sp@(12),d1		/* get max len copied */
	subl	#1,d1
	jlt	3f			/* return 0 */
    	movl	_nofault,sp@-
	movl	#5f,_nofault
    1:	movsb	a0@+,d0
	movb	d0,a1@+
	jeq	4f
    	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	jra	2f
_spath:
	movl	sp@(4),a0		/* kernel source */
    1:	movl	sp@(8),a1		/* kernel destination */
    	clrl	d0			/* found null return code*/
	movl	sp@(12),d1		/* get max len copied */
	subl	#1,d1
	jlt	3f			/* return 0 */
    	movl	_nofault,sp@-
	movl	#5f,_nofault
    1:	movb	a0@+,a1@+
	jeq	4f
    	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
    2:	movl	#-2,d0			/* no null return code*/
    1:  movl	sp@+,_nofault
    3:	rts
    
/*
 * Watch out below, the refernce to the non-existant forth argument
 * is correct.  Someone added some code for nofault above that mucks 
 * around with the stack causing arg0 -> arg1, arg1 -> arg2 and so on.
 */
  4:	subl	sp@(16),d1
	negl	d1			/* set lencopied */
	movl	d1,d0			/* a null path name returns 1 */
	jra	1b
    5:	movl	#-1,d0			/* illegal address return code*/
	jra	1b

/* rcopyfault: catches faults in remote moves */
	.globl	_rcopyfault
_rcopyfault:
	movl	#EFAULT,d0
	rts
#endif	defined(SYSV) && defined(RFS)

_copyinstr:				/* copyinstr(us, kd, maxlen, &len) */
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyinstr
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) copystr() */
	jne	_copystr
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0		/* user source */
	movl	sp@(8),a1		/* kernel destination */

	clrl	d0			/* found null return code*/
	movl	sp@(12),d1		/* get max len copied */
	subl	#1,d1
	jlt	3f
    	movl	_nofault,sp@-
	movl	#4f,_nofault
    1:	movsb	a0@+,d0
	movb	d0,a1@+
	jeq	2f
    	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	addl	#1,d1
	movl	#ENOENT,d0		/* no null return code*/
    2:	movl	sp@+,_nofault
    3:	movl	sp@(16),a0		/* &lencopied */
	cmpl	#0,a0
	jeq	1f			/* skip if NULL */
	subl	sp@(12),d1
	negl	d1
	movl	d1,a0@			/* set lencopied */
    1:	rts
    4:	movl	#EFAULT,d0		/* illegal address return code*/
	jra	2b

_copyoutstr:				/* copyoutstr(ks, ud, maxlen, &len) */
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tcopyoutstr
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rcopyoutstr() */
	jne	_rcopyoutstr
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0		/* kernel source */
	movl	sp@(8),a1		/* user destination */
	clrl	d0			/* found null return code*/
	movl	sp@(12),d1		/* get max len copied */
	subl	#1,d1
	jlt	3f
    	movl	_nofault,sp@-
	movl	#4f,_nofault
    1:	movb	a0@+,d0
	movsb	d0,a1@+
	jeq	2f
    	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	addl	#1,d1
	movl	#ENOENT,d0		/* no null return code*/
    2:	movl	sp@+,_nofault
    3:	movl	sp@(16),a0		/* &lencopied */
	cmpl	#0,a0
	jeq	1f			/* skip if NULL */
	subl	sp@(12),d1
	negl	d1
	movl	d1,a0@			/* set lencopied */
    1:	rts
    4:	movl	#EFAULT,d0		/* illegal address return code*/
	jra	2b

_copystr:				/* copystr(ks, kd, maxlen, &len) */
	movl	sp@(4),a0		/* kernel source */
	movl	sp@(8),a1		/* kernel destination */
	clrl	d0			/* found null return code*/
	movl	sp@(12),d1		/* get max len copied */
	subl	#1,d1
	jlt	3f
    	movl	_nofault,sp@-
	movl	#4f,_nofault
    1:	movb	a0@+,a1@+
	jeq	2f
    	dbra	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b
	addl	#1,d1
	movl	#ENOENT,d0		/* no null return code*/
    2:	movl	sp@+,_nofault
    3:	movl	sp@(16),a0		/* &lencopied */
	cmpl	#0,a0
	jeq	1f			/* skip if NULL */
	subl	sp@(12),d1
	negl	d1
	movl	d1,a0@			/* set lencopied */
    1:	rts
    4:	movl	#EFAULT,d0		/* illegal address return code*/
	jra	2b

_fubyte:
_fuibyte:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tfubyte
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rfubyte() */
	jne	_rfubyte
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	clrl	d0
	movsb	a0@,d0
	movl	sp@+,_nofault
	rts

_fuword:
_fuiword:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tfuword
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rfuword() */
	jne	_rfuword
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	movsl	a0@,d0
	movl	sp@+,_nofault
	rts

_subyte:
_suibyte:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tsubyte
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rsubyte() */
	jne	_rsubyte
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	movsb	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts

_suword:
_suiword:
#ifdef	TRFS
	tstl	_u+U_TCLIENT
	jne	_Tsuword
#endif	TRFS
#if	defined(SYSV) && defined(RFS)
	movl	_u+U_PROCP,a0
	tstw	a0@(P_SYSID)		/* if(server()) rsuword() */
	jne	_rsuword
#endif	defined(SYSV) && defined(RFS)
	movl	sp@(4),a0
	movl	sp@(8),d0
	movl	_nofault,sp@-
	movl	#fserr,_nofault
	movsl	d0,a0@
	clrl	d0
	movl	sp@+,_nofault
	rts

fserr:
	movl	#-1,d0
	movl	sp@+,_nofault
	rts

	.globl	_copyseg
_copyseg:
	movl	sp@(8),d0		/* page frame number */
#ifdef	QBUS
	lslw	#PAGVALSHIFT,d0
#endif	QBUS
	movl	sp@(4),a0		/* user virtual source */
	movw	PGREG(CADDR2),sp@-
	movw	d0,PGREG(CADDR2)
	lea	CADDR2,a1		/* kernel virtual destination */
	movw	#(NBPG/4)-1,d0		/* long count */
    1:	movsl	a0@+,d1
	movl	d1,a1@+
	dbra	d0,1b
	movw	sp@+,PGREG(CADDR2)
	movl	#0,d0
	rts

	/* 
	 * quick block copy a page
	 */
	.globl	_qbcopyp
_qbcopyp:
	movl	sp@(4),a0		/* source */
	movl	sp@(8),a1		/* destination */
	movw	#(NBPG>>2)-1,d0		/* change to long count (truncated) */
    1:	movl	a0@+,a1@+		/* long copy loop */
	dbf	d0,1b			/* entry point of long copy loop */
	rts

	.globl	_clearseg
_clearseg:
	movl	sp@(4),d0		/* page frame number */
#ifdef	QBUS
	lslw	#PAGVALSHIFT,d0
#endif	QBUS
	movw	PGREG(CADDR1),sp@-
	movw	d0,PGREG(CADDR1)
	movl	#0,d1
	lea	CADDR1,a0
	movw	#(NBPG/4)-1,d0		/* long count */
    1:	movl	d1,a0@+
	dbra	d0,1b
	movw	sp@+,PGREG(CADDR1)
	movl	#0,d0
	rts

	.globl	_getmeml
_getmeml:
	movl	sp@(4),d0		/* physical address */
	movl	#(PGSHIFT),d1
	lsrl	d1,d0			/* physical page */
#ifdef	QBUS
	lslw	#PAGVALSHIFT,d0
#endif	QBUS
	movw	sp@(4+2),d1
	andw	#NBPG-1,d1		/* offset within page */
	movw	PGREG(CADDRc),sp@-
	movw	PGREG(CADDRd),sp@-
	movw	d0,PGREG(CADDRc)
	addw	#1,d0
	movw	d0,PGREG(CADDRd)
	lea	CADDRc,a0		/* virtual page address */
	movl	a0@(0,d1:w),d0
	movw	sp@+,PGREG(CADDRd)
	movw	sp@+,PGREG(CADDRc)
	rts

	.globl	_putmeml
_putmeml:
	movl	sp@(4),d0		/* physical address */
	movl	#PGSHIFT,d1
	lsrl	d1,d0			/* physical page */
#ifdef	QBUS
	lslw	#PAGVALSHIFT,d0
#endif	QBUS
	movw	sp@(4+2),d1
	andw	#NBPG-1,d1		/* offset within page */
	movw	PGREG(CADDRc),sp@-
	movw	PGREG(CADDRd),sp@-
	movw	d0,PGREG(CADDRc)
	addw	#1,d0
	movw	d0,PGREG(CADDRd)
	lea	CADDRc,a0		/* virtual page address */
	movl	sp@(8+4),a0@(0,d1:w)
	movw	sp@+,PGREG(CADDRd)
	movw	sp@+,PGREG(CADDRc)
	rts

	.globl	_blkclr
	.globl	_ovbcopy
_blkclr: jmp	_bzero
_ovbcopy:jmp	_bcopy

	.globl	_doadump
_doadump:
	link	a6,#0
	movml	#<d2-d7,a2-a7>,_u	/* update pcb for running process */
	jsr	_dumpsys
	unlk	a6
	rts

	.globl	__reboot
__reboot:
	movl	_howto,d7
	movl	_devtype,d6
	jmp	PROM_REBOOT

#ifdef	VBUS
	.globl	_parityon
_parityon:
	movw	BSR,d0			/* enable parity */
	andw	#CTXMASK,d0
	orw	#BSR_PARITYON,d0
	movw	d0,BSR
	rts

	.globl	_parityoff
_parityoff:
	movw	BSR,d0			/* disable parity */
	andw	#CTXMASK,d0
	orw	#BSR_PARITYOFF,d0
	movw	d0,BSR
	rts
#endif	VBUS

	/*
	 * Test-and-set primative. Sets the high-order bit of the 
	 * pointed-to byte. Returns zero (failure) if the byte had 
	 * been nonzero, else 1 (success). Routine is indivisible even 
	 * in multi-processor environment IF the byte is in VME memory.
	 */
	.globl	_tas
_tas:	movl	#0,d0
	movl	sp@(4),a0
	tas	a0@
	jne	1f
	addw	#1,d0
   1:	rts

	.globl	_byterev
_byterev:
	movl	sp@(4),a0		/* address of byte string */
	movl	a0,a1
	movl	sp@(8),d1		/* length of string */
	addl	#1,d1
	lsrl	#1,d1
	jra	2f

    1:	movw	a1@,d0
	rolw	#8,d0
	movw	d0,a1@+
    2:	dbf	d1,1b
	addw	#1,d1
	subl	#1,d1
	jge	1b

	movl	a1,d0
	rts

/*
 * cksum(sum, string, len, sumlen)
 *  	16 bit checksum of byte string s
 */ 
	.globl	_cksum
_cksum:
	movl	d2,sp@-			/* save d2 */
	movl	sp@(8),d0		/* sum */
	movl	sp@(12),a0		/* address of byte string */
	movl	a0,d2
	tstl	sp@(16)			/* length of string */
	jeq	9f			/* zero length string, return */
	andb	#0xF,cc			/* X clerar x bit */
	btst	#0,sp@(20+3)			/* swap bytes ?? */
	jne	4f

	/* sum is word alligned, dont swap bytes */
	btst	#0,d2
	jeq	1f

	/* odd start address, do first byte, and then swap bytes */
	subl	#1,sp@(16)		/* X */
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addw	d2,d0			/* X */
	jra	5f

	/* even address, sum alligned */
    1:	movl	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	jra	3f
    2:	movw	a0@+,d2
	addxw	d2,d0			/* X */
    3:	dbf	d1,2b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
	jra	8f

	/* sum is not word alligned, swap bytes */
    4:	btst	#0,d2
	jeq	5f

	/* odd start address, do first byte, and then dont swap bytes */
	subl	#1,sp@(16)		/* X */
	clrl	d2
	movb	a0@+,d2
	addw	d2,d0			/* X */
	jra	1b

	/* even address, sum misalligned, swap bytes */
    5:	movl	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	jra	7f
    6:	movw	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
    7:	dbf	d1,6b
	btst	#0,sp@(16+3)
	jeq	8f

	/* odd length, take care of last byte */
	clrl	d2
	movb	a0@+,d2
	addxw	d2,d0			/* X */

	/* fold in last carry bit */
    8:	clrl	d2
	addxw	d2,d0			/* X */

    9:	movl	sp@+,d2			/* restore d2 */
	rts

/*
 * Do a 16 bit one's complement sum of a given number of words
 * The word pointer may not be odd
 */
	.globl	_ocsum
_ocsum:
	movl	sp@(4),a0	/* get ptr */
	movl	sp@(8),d0	/* get word count */
	movl	d2,sp@-		/* save a reg */
	movl	d0,d2		/* save the count */
	lsrl	#1,d0		/* make d0 longs */
	movl	#0,d1		/* zero accumulator */
	jra	1f		/* into loop */
				/* run in 68010 loop mode til we get a carry */
    2:	addl	a0@+,d1		/* add in long */
    1:	dbcs	d0,2b		/* continue until carry or done */
	jcc	3f		/* if no carry, we're done */
	addl	#1,d1		/* add in carry */
	jra	1b		/* and go back to test for carry again */
    3:	btst	#0,d2		/* another short? */
	jeq	1f		/* no, go away */
	movl	#0,d0		/* must do unsigned add */
	movw	a0@,d0		/* get the short */
	addl	d0,d1		/* add it in */
	jcc	1f
	addl	#1,d1
				/* Now add in high word to low word as above */
    1:	movl	d1,d0
	lsrl	#8,d0		/* get high word in d0 */
	lsrl	#8,d0		/* and clear high do as well */
	andl	#0xFFFF,d1	/* clear high d1 */
	addw	d1,d0		/* add in just the low word */
	movl	#0,d1		/* doesn't clear x bit */
	addxw	d1,d0		/* add in final carry */
	movl	sp@+,d2		/* restore reg */
	rts			/* all done */

#ifdef	DEBUGGER
	.globl	dbg_excpt
/* debugger exception handler */
dbg_excpt:
	movl	NMIVEC,_dbg_nmi_sav	/* redirect nmi because of */
	movl	#2f,NMIVEC		/* halt button bounce      */
	movw	#PSL_IPL7,sr		/* mask all interrupts */
	movl	sp,_dbg_ex_frame	/* save frame addr */
	movml	#<d0-d7,a0-a6>,_dbg_reg_sav
	movl	usp,a0			/* save usp */
	movl	a0,_dbg_usp_sav
	movl	sp,_dbg_ssp_sav		/* save ssp */
#ifdef	M68020
	movl	#CCACHE_CLEAR,d0
	movec	d0,cac			/* disable cache */
#endif	M68020
        clrl    d1                      /* adjust stack frame size */
        movb    sp@(6),d1
        lsrw    #4,d1
	lea	3f,a1			/* test for valid format */
	tstb	a1@(0,d1:w)
	jne	1f
	pea	panic_badfmt
	jsr	_panic
    1:	lea	4f,a1			/* pick frame size, given format */
	movb	a1@(0,d1:w),d0
	addl	d0,_dbg_ssp_sav		/* save a7 as usp or ssp */
	movl	_dbg_ssp_sav,_dbg_reg_sav+(15*4)
	btst	#5,sp@
	bne	1f
	movl	_dbg_usp_sav,_dbg_reg_sav+(15*4)
    1:	jsr	_dbg			/* go to debugger */
	movl	_dbg_usp_sav,a0		/* back from debugger */
	movl	a0,usp			/* restore usp */
#ifdef	M68020
	movl	#CCACHE_CLEAR|CCACHE_ENABLE,d0
	movec	d0,cac			/* clear and enable cache */
#endif	M68020
	movml  _dbg_reg_sav,#<d0-d7,a0-a6>
        movl    _dbg_nmi_sav,NMIVEC	/* restore nmi vector */
    2:	rte

/* STACK FORMAT:0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F */
#ifdef	M68010
    3:	.byte	1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0
#else	M68010
    3:	.byte	1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0
#endif	M68010
    4:	.byte	ESF_ISIZE0, ESF_ISIZE1, ESF_ISIZE2, 0, 0, 0, 0, 0
	.byte	ESF_ISIZE8, ESF_ISIZE9, ESF_ISIZEA, ESF_ISIZEB, 0, 0, 0, 0
	.align	1

	.globl _trap15
_trap15:trap	#15
	rts
#endif	DEBUGGER

/************************************************************************/

#define	SIOCONT(cont)	cont*20

SCBVEC(siorint0):
	IBEG
	addl	#1,_intrcnt+I_SIO
	clrl sp@-;  jsr _siorint;  addl #4,sp
	RTE (V_INTR)

SCBVEC(siosint0):
	IBEG
	addl	#1,_intrcnt+I_SIO
	clrl sp@-;  jsr	_siosint;  addl #4,sp
	RTE (V_INTR)

SCBVEC(sioeint0):
	IBEG
	addl	#1,_intrcnt+I_SIO
	clrl sp@-;  jsr	_sioeint;  addl #4,sp
	RTE (V_INTR)

SCBVEC(sioxint0):
	IBEG
	addl	#1,_intrcnt+I_SIO
	movl	#SIOCONT(0),d0
	jra	siodma

SCBVEC(siorint1):
	IBEG
	addl	#1,_intrcnt+I_SIO
	pea 1;  jsr _siorint;  addl #4,sp
	RTE (V_INTR)

SCBVEC(siosint1):
	IBEG
	addl	#1,_intrcnt+I_SIO
	pea 1;  jsr _siosint;  addl #4,sp
	RTE (V_INTR)

SCBVEC(sioeint1):
	IBEG
	addl	#1,_intrcnt+I_SIO
	pea 1;  jsr _sioeint;  addl #4,sp
	RTE (V_INTR)

SCBVEC(sioxint1):
	IBEG
	addl	#1,_intrcnt+I_SIO
	movl	#SIOCONT(1),d0
	jra	siodma


/*
 * SIO pseudo dma routine:
 *	d0 - port number * sizeof(struct pdma)
 */
	.align	1
	.globl	siodma
siodma:
	addl	#_sio_pdma,d0
	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register base address */
	movb	#SIOW0_TXPEND,a0@(SIO_CTRL)	/* reset transmit int pending */
	jra	2f
    1:	movl	a1@+,d1			/* p_mem */
	cmpl	a1@+,d1			/* p_end > p_mem ? */
	bhs	4f			/* no, go call sioxint */
	exg	d1,a1
	movb	a1@+,a0@		/* adata = *p_mem++ */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register base address */
	movb	a0@(SIO_CTRL),d1
	andb	#SIOR0_TXRDY,d1
	jne	1b			/* if not TXRDY, all done */
    3:	movl	#SIO0_ADR+SIO_CTRL,a0	/* force to PORTA */
	movb	#SIOW0_RETINT,a0@
	RTE	(V_PDMA)
    4:	movl	d0,sp@-			/* save d0 */
	movl	a1@+,sp@-		/* push tty address as arg */
	movl	a1@,a1			/* get address of interrupt routine */
	jsr	a1@			/* call interrupt routine */
	addl	#4,sp			/* pop arg (tty address) */
	movl	sp@+,d0			/* restore d0 */
	jra	3b

#ifdef	QBUS
#ifndef	is68k_kobj
#if	NDL > 0
#define	DLCONT(cont)	cont*20
/*
 * DL pseudo dma routine:
 *	d0 - controller number * 20
 */
	.align	1
	.globl	dldma
dldma:
	addl	#_dlpdma,d0
	jra	2f
    1:
	movl	a1@+,d1			/* p_mem */
	cmpl	a1@+,d1			/* p_mem < p_end ? */
	bhs	3f			/* no, go call dlxint */
	exg	d1,a1
	movb	a1@+,a0@(7)		/* dl_xbuf = *p_mem++ !!!QBUS BYTE */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:
	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register address */
	movb	a0@(5),d1		/* get dl_xcsr status !!QBUS BYTE */
	jlt	1b			/* if not TRDY, all done */
	RTE	(V_PDMA)
    3:
	clrb	a0@(5)			/* turn off XIE int dl_xcsr */
	movl	d0,sp@-			/* save d0 */
	movl	a1@+,sp@-		/* push tty address as arg */
	movl	a1@,a1			/* get address of interrupt routine */
	jsr	a1@			/* call interrupt routine */
	addl	#4,sp			/* pop arg (tty address) */
	movl	sp@+,d0			/* restore d1 */
	RTE	(V_PDMA)
#endif	NDL > 0
#endif	is68k_kobj

#ifndef	is68k_kobj
#if	NDZ > 0
#define	DZCONT(cont)	cont*8*20
/*
 * DZ pseudo dma routine:
 *	d0 - controller number * 8 * 20
 */
	.align	1
	.globl	dzdma
dzdma:
	addl	#_dzpdma,d0
	jra	2f
    1:
	andw	#7,d1			/* clear garbage bits (word!) */
	mulu	#20,d1
	addl	d1,a1			/* point at line's pdma structure */
	movl	a1@+,d1			/* p_mem */
	cmpl	a1@+,d1			/* p_mem < p_end ? */
	bhs	3f			/* no, go call dzxint */
	exg	d1,a1
	movb	a1@+,a0@(7)		/* dztbuf = *p_mem++ !!!QBUS BYTE */
	exg	d1,a1
	movl	d1,a1@(-8)
    2:
	movl	d0,a1			/* pdma structure base */
	movl	a1@+,a0			/* device register address */
	movb	a0@,d1			/* get line number !!!QBUS BYTE */
	jlt	1b			/* if not TRDY, all done */
	RTE	(V_PDMA)
    3:
	movl	d0,sp@-			/* save d0 */
	movl	a1@+,sp@-		/* push tty address as arg */
	movl	a1@,a1			/* get address of interrupt routine */
	jsr	a1@			/* call interrupt routine */
	addl	#4,sp			/* pop arg (tty address) */
	movl	sp@+,d0			/* restore d1 */
	jra	2b			/* check for another line */
#endif	NDZ > 0
#endif	is68k_kobj

/************************************************************************/
/* 18 BIT ADDRESSABLE BUFFERS (NOTE: THESE ARE IN THE TEXT SPACE!!!) */

	.globl	_buffers18
_buffers18:
	.long	buffers18
buffers18:
	.space	NBUF18*MAXBSIZE

#ifndef	is68k_kobj
#if	NDH > 0
	.align	1
	.globl	_dh_buf
_dh_buf:
	.space	CBSIZE*NDH*16
#endif	NDH > 0
#endif	is68k_kobj

#ifndef	is68k_kobj
#if	NRX > 0
	.align	1
	.globl	_rxerr
_rxerr:	.space	Nrx*6*2			/* 6 shorts per device */
#endif	NRX > 0
#endif	is68k_kobj
#endif	QBUS

/************************************************************************/

	.globl	_refbits
_refbits:
	movl	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_refptes
	addl	#8,sp

	movl	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#(MAXU_ADDR>>PGSHIFT),d1
	subw	d0,d1
	movl	d1,sp@			/* num of ptes */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_refptes
	lea	sp@(12),sp
	rts

#ifndef	C_segptes
	.globl	_segptes
/*	segptes(pte, maxlen) */
_segptes:
	movl	d2,sp@-
	movl	d3,sp@-
	movl	#0,d1
	movl	sp@(12),a0		/* pte */
	movw	sp@(16+2),d2		/* maxlen */
	jle	2f
	subw	#1,d2
	movw	#((PG_V>>16)&0xFFFF),d3
    1:	movw	a0@,d0
	andw	d3,d0
	orw	d0,d1
	addl	#4,a0
    	dbra	d2,1b
    2:	movl	sp@(16),d0
	tstw	d1
	jne	1f
	negl	d0
    1:	movl	sp@+,d3
	movl	sp@+,d4
	rts
#endif	C_segptes

#ifdef	QBUS
#ifndef	C_newptes
is68k_prot:		/* this is a read-only array */
	.byte	SEGPROT_NO, SEGPROT_NO, SEGPROT_ALL, SEGPROT_REO
	.byte	SEGPROT_ALL, SEGPROT_NO, SEGPROT_NO, SEGPROT_NO
	.byte	SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, SEGPROT_NO
	.byte	SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, SEGPROT_REO


	.globl	_newptes
/*	newptes(pte, v, size) */
_newptes:
	link	a6,#_Fnewptes
	movml	#_Snewptes,a6@(_Fnewptes)
	movw	a6@(16+2),d7		/* d7   size: if (size <= 0) return; */
	jle	7f
	movl	a6@(8),a5		/* a5   pointer to pte */
	lea	is68k_prot,a3		/* a3   pointer to protection vector */
	movl	#SEGREGINCR,d3		/* d3   seg reg incr */
	movl	#0,d4
	movb	CXR,d4
	lsrw	#CTXSHIFT,d4		/* d4   context # */
	cmpl	#_eSysmap,a5
	jhs	1f
	cmpl	#_Sysmap,a5
	jlo	1f
	movl	#0,d4
    1:	movl	#0,d0			/*      get virtual page address */
	movw	a6@(12+2),d0
	movl	d0,d5
	andw	#(NPAGPERSEG-1),d5
	movl	d4,d1
	rorl	#4,d1
	movw	d0,d1
	lsrw	#4,d1
	orw	#0x40,d1
	swap	d1
	movl	d1,a4			/* a4   pointer to seg */
	movl	#NPAGPERSEG,d0
	subw	d5,d0
	rorl	#4,d5			/* d5   page offset in upper half */
    9:	tstw	d7			/*      DONE if size <= 0 */
	jle	7f
	cmpw	d7,d0			/*      i = min(i,size) */
	jle	1f
	movw	d7,d0
    1:	movl	#0,d2
	movb	a5@,d2			/* d2   get pte protection */
	lsrw	#3,d2
	andw	#15,d2
	movl	d0,sp@-
	pea	a5@
	jbsr	_segptes
	addl	#8,sp
	movw	d0,d6			/* d6   pages in bank to program (i) */
	jeq	7f
	jlt	8f
	movw	a4@,d0			/*      contents of seg register */
	movw	d0,d1
	andw	#SEGPROTMASK,d1
	jne	6f
	movl	d4,sp@-			/*      00 -> SEGPROT_NO access */
	jbsr	_segalloc
	addl	#4,sp
	movw	d0,a4@
    6:	andw	#0x3F,d0
	movw	d0,d5			/*      get bank number */
	orb	a3@(0,d2:w),d0
	movw	d0,a4@			/*      update segment protection */
	orw	#0x80,d5
	swap	d5
	movl	d5,a0			/* a0   is pointer to page register */
	jra	4f
    1:	movl	a5@,d0
	jge	2f			/*      is page valid bit set ? */
	andw	#PG_PFNUM,d0
	lslw	#2,d0
	movw	d0,a0@			/*      valid page register */
	jra	3f
    2:	movw	#0xff0,a0@		/*      paged out */
    3:	subw	#1,d7
	addl	#0x1000,a0
	addl	#4,a5			/*      on to next pte */
    4:	dbra	d6,1b
    1: 	addl	d3,a4			/*      increment segment reg pointer */
    	movl	#16,d0			/*      next segment */
    	movl	#0,d5
    	movl	#0,d1			/*	pte->pg_prot != prot */
	movb	a5@,d1
	lsrw	#3,d1
	andw	#15,d1
	cmpw	d2,d1
	jeq	9b
	movl	a4,d1			/*	!(seg & 0x10000) */
	andl	d3,d1
	jeq	9b
	addl	d3,a4
	jra	9b
    8:	negw	d6
	movw	a4@,d0			/*      contents of seg register */
	movw	d0,d1
	andw	#0xC0,d1
	jne	6b			/*	jump if seg allocated */
    	movw	#1,a4@
	subw	d6,d7			/*      size -= i */
	aslw	#2,d6
	addw	d6,a5			/*      pte += i */
	jra	1b
    7:	movml	a6@(_Fnewptes),#_Snewptes
	unlk	a6
	rts
_Fnewptes = -(9 * 4)
_Snewptes = 0x38fC			 /*      d7,d6,d5,d4,d3,d2   a5,a4,a3 */
#endif	C_newptes
#else	QBUS
#ifndef	C_newptes
is68k_prot:		/* this is a read-only array */
	.byte	SEGPROT_NO, SEGPROT_NO, SEGPROT_ALL, SEGPROT_REO
	.byte	SEGPROT_ALL, SEGPROT_NO, SEGPROT_NO, SEGPROT_NO
	.byte	SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, SEGPROT_NO
	.byte	SEGPROT_NO, SEGPROT_NO, SEGPROT_NO, SEGPROT_REO

	.globl	_newptes
/*	newptes(pte, v, size) */
_newptes:
	link	a6,#_Fnewptes
	movml	#_Snewptes,a6@(_Fnewptes)
	movw	a6@(16+2),d7		/* d7   size: if (size <= 0) return; */
	jle	7f
	movl	a6@(8),a5		/* a5   pointer to pte */
	lea	is68k_prot,a3		/* a3   pointer to protection vector */
	movl	#SEGREGINCR,d3		/* d3   seg reg incr */
	movl	#0,d4
	movw	CXR,d4
	andw	#CTXMASK,d4		/* d4   context # */
	cmpl	#_eSysmap,a5
	jhs	1f
	cmpl	#_Sysmap,a5
	jlo	1f
	movl	#0,d4
    1:	movl	#0,d0			/*      get virtual page address */
	movw	a6@(12+2),d0
	movl	d0,d5
	andw	#(NPAGPERSEG-1),d5
	lsrw	#4,d0			/*      align segment portion */
	swap	d0			/*      move to upper half */
	movw	d4,d0
	movl	#SEGCTXSHIFT,d1
	lslw	d1,d0			/*      context portion in lower half */
	orl	#SEGREGBASE,d0
	movl	d0,a4			/* a4   is pointer to seg register */
	movl	#NPAGPERSEG,d0
	subw	d5,d0
	rorl	#PAGSEGSHIFT,d5		/* d5   page offset in upper half */
    9:	tstw	d7			/*      DONE if size <= 0 */
	jle	7f
	cmpw	d7,d0			/*      i = min(i,size) */
	jle	1f
	movw	d7,d0
    1:	movl	d0,sp@-
	pea	a5@
	jbsr	_segptes
	addl	#8,sp
	movw	d0,d6			/* d6   pages in bank to program (i) */
	jeq	7f
	jlt	8f
	movb	a4@,d0			/*      contents of seg register */
	movw	d0,d1
	andw	#SEGPROTMASK,d1
	jne	6f
	movl	d4,sp@-			/*      00 -> SEGPROT_NO access */
	jbsr	_segalloc
	addl	#4,sp
	movb	d0,a4@
    6:	movl	#0,d1
	movb	a5@,d1			/*      get pte protection */
	lsrw	#3,d1
	andw	#15,d1
	andw	#(NPAGBANKS-1),d0
	movw	d0,d5			/*      get bank number */
	orb	a3@(0,d1:w),d0
	movb	d0,a4@			/*      update segment protection */
	roll	#PAGSEGSHIFT+PAGREGSHIFT,d5;
	orl	#PAGREGBASE,d5
	movl	d5,a0			/* a0   is pointer to page register */
	jra	4f
    1:	movl	a5@,d0
	jge	2f			/*      is page valid bit set ? */
	andw	#PG_PFNUM,d0
	movw	d0,a0@			/*      valid page register */
	jra	3f
    2:	movw	#((1<<PAGINVBIT)|(1<<PAGOUTBIT)),a0@	/* invalid page */
    3:	subw	#1,d7
	addl	#PAGREGINCR,a0
	addl	#4,a5			/*      on to next pte */
    4:	dbra	d6,1b
    1: 	addl	d3,a4			/*      increment segment reg pointer */
    	movl	#NPAGPERSEG,d0		/*      next segment */
    	movl	#0,d5
	jra	9b
    8:	negw	d6
	movb	a4@,d0			/*      contents of seg register */
	movw	d0,d1
	andw	#SEGPROTMASK,d1
	jne	6b			/*	jump if seg allocated */
    	movb	#(SEGPROT_NO|SEGPAGEDOUT),a4@
	subw	d6,d7			/*      size -= i */
	aslw	#2,d6
	addw	d6,a5			/*      pte += i */
	jra	1b
    7:	movml	a6@(_Fnewptes),#_Snewptes
	unlk	a6
	rts
_Fnewptes = -(8 * 4)
_Snewptes = 0x38f8			 /*      d7,d6,d5,d4,d3   a5,a4,a3 */
#endif	C_newptes
#endif	QBUS

	.globl _un_mod
_un_mod:
	movl	sp@(4),a0
	movl	a0@,d0
	bclr	#PG_M_BIT,d0
	movl	d0,a0@
	rts

	.globl _un_ref
_un_ref:
	movl	sp@(4),a0
	movl	a0@,d0
	bclr	#PG_R_BIT,d0
	movl	d0,a0@
	rts

	.globl _reload_pt
_reload_pt:
	movl	#0,d0
	movw	_u+PCB_P0LR+2,d0
	movl	d0,sp@-			/* num of ptes */
	clrl	sp@-			/* virtual page */
	movl	_u+PCB_P0BR,sp@-	/* pte */
	jsr	_newptes
	addl	#8,sp
	movl	#0,d0
	movw	_u+PCB_P1LR+2,d0
	movl	#(MAXU_ADDR>>PGSHIFT),d1
	subw	d0,d1
	movl	d1,sp@			/* num of pages */
	movl	d0,sp@-			/* virtual page */
	movl	_u+PCB_P1BR,d1
	lslw	#2,d0
	addl	d0,d1
	movl	d1,sp@-			/* pte */
	jsr	_newptes
	lea	sp@(12),sp
	rts

#ifdef	QBUS
	/* system virtual to physical address translation through hardware */
	.globl	_svtop
_svtop:	movl	sp@(4),d0	/* virtual address */
	movl	d0,d1
	movl	d0,a1
	andl	#0x3f0000,d0	/* form segment register address */
	orl	#0x400001,d0
	movl	d0,a0
	movb	a0@,d0		/* pick up contents of segment register */
	andl	#0x3F,d0	/* form page register address */
	swap	d0
	andl	#0xf000,d1
	orl	d1,d0
	orl	#0x800000,d0
	movl	d0,a0
	movw	a0@,d0		/* pick up contents of page register */
	andl	#0xffc,d0	/* align physical page */
	movl	#10,d1
	asll	d1,d0
	movl	a1,d1
	andl	#0xfff,d1	/* or in page offset */
	orl	d1,d0		/* return physical address */
	rts

	/* user virtual to physical address translation through hardware */
	.globl	_uvtop
_uvtop:
	movl	sp@(4),d0	/* virtual address */
	movl	d0,d1
	movl	d0,a1
	andl	#0x3f0000,d0	/* form segment register address */
	orl	#0x401001,d0	/* context #1 hardcoded! */
	movl	d0,a0
	movb	a0@,d0		/* pick up contents of segment register */
	andl	#0x3F,d0	/* form page register address */
	swap	d0
	andl	#0xf000,d1
	orl	d1,d0
	orl	#0x800000,d0
	movl	d0,a0
	movw	a0@,d0		/* pick up contents of page register */
	andl	#0xffc,d0	/* align physical page */
	movl	#10,d1
	asll	d1,d0
	movl	a1,d1
	andl	#0xfff,d1	/* or in page offset */
	orl	d1,d0		/* return physical address */
	rts
#endif	QBUS

/******* D A T A ***********************************************************/
	.data
	.globl	_VSCR0
	.globl	_VSCR1
	.globl	_VSCR2
	.globl	_VSCR3
	.set	_VSCR0,	CADDRa
	.set	_VSCR1,	CADDRb
	.set	_VSCR2,	CADDRc
	.set	_VSCR3,	CADDRd
	PAGRI(_VSCR0)
	PAGRI(_VSCR1)
	PAGRI(_VSCR2)
	PAGRI(_VSCR3)

	.globl	_SCR0
	.globl	_SCR1
	.globl	_SCR2
	.globl	_SCR3
	.set	_SCR0,	PGREG(_VSCR0)
	.set	_SCR1,	PGREG(_VSCR1)
	.set	_SCR2,	PGREG(_VSCR2)
	.set	_SCR3,	PGREG(_VSCR3)

	.align	1
/* icode */
	.globl	_icode
	.globl	_szicode
	.globl	_initflg
	.globl	_initi
icode:	movml	pc@(2f),#<d0-d1,a0-a1>	/* load syscall args into regs */
	trap	#1			/* do execve syscall */
	movl	#1,d1
	movl	#SYS_exit,d0
	trap	#1			/* do exit syscall */
    1:	jra	1b			/* loop here if cannot execute init */

    2:	.long	SYS_execve		/* d0: syscall: SYS_execve */
	.long	5f-icode		/* d1: file: "/etc/init" */
	.long	3f-icode		/* a0: argv: ("init", "-?", NULL) */
	.long	4f-icode		/* a1: envp: (NULL) */
    3:	.long	initi-icode		/* "init" */
	.long	6f-icode		/* "?" -> to m|s|M|S in startup */
    4:	.long	0			/* NULL */
    5:	.ascii	"/etc/"
initi:	.asciz	"init"
	.space	40			/* leave space for longer inits */
    6:	.byte	0x2D			/* '-' */
initflg:.byte	0x3F			/* '?' multi/single/GWS flag */
	.byte	0x00			/* '\0' */
	.align	1
_icode:		.long	icode		/* pointer to icode */
_szicode:	.long	_icode-icode	/* length of icode */
_initflg:	.long	initflg		/* pointer to init flag */
_initi:		.long	initi		/* pointer to first letter of "init" */

/* signal trampoline code */
	.globl	_sigcode
	.globl	_szsigcode
	.align	1
sigcode:
	bras	1f			/* +0:  stack format 0 entry */
	bras	2f			/* +2:  stack format 2 entry */
	bras	3f			/* +4:  stack format 8 entry */
	bras	4f			/* +6:  stack format 9 entry */
	bras	5f			/* +8:  stack format A entry */
	bras	6f			/* +10: stack format B entry */
		/* stack format 0 */
    1:	bsrs	8f			/* save regs and call handler */
    1:	trap	#8			/* restore sig mask and return */
	bras	1b
		/* stack format 2 */
    2:	bsrs	8f			/* save regs and call handler */
    1:	trap	#6			/* restore sig mask and return */
	bras	1b
		/* stack format 8 */
    3:	bsrs	8f			/* save regs and call handler */
    1:	trap	#5			/* restore sig mask and return */
	bras	1b
		/* stack format 9 */
    4:	bsrs	8f			/* save regs and call handler */
    1:	trap	#4			/* restore sig mask and return */
	bras	1b
		/* stack format A */
    5:	bsrs	8f			/* save regs and call handler */
    1:	trap	#3			/* restore sig mask and return */
	bras	1b
		/* stack format B */
    6:	bsrs	8f			/* save regs and call handler */
    1:	trap	#2			/* restore sig mask and return */
	bras	1b
    8:	link	a6,#-16			/* just like a real stack frame */
	movml	#<d0-d1,a0-a1>,a6@(-16)	/* save regs d0-d1, a0-a1 */
	movml	a6@(8),#<d0-d1,a0-a1>	/* get our args and handler ptr */
	movml	#<d0-d1,a0-a1>,sp@-	/* push our args as args to handler */
	jsr	a1@			/* handler(sig, code, psigctx) */
	movml	a6@(-16),#<d0-d1,a0-a1>	/* restore regs */
	unlk	a6			/* just like a real stack frame */
	rtd	#16			/* pop the args we were called with */
	.align	1
_sigcode:	.long	sigcode
_szsigcode:	.long	_sigcode-sigcode

#ifdef	SYSV
/* sigcode for System V */
	.globl	_sysv_sigcode
	.globl	_sysv_szsigcode
	.align	1
sysv_sigcode:
	bras	1f			/* +0:  stack format 0 entry */
	bras	2f			/* +2:  stack format 2 entry */
	bras	3f			/* +4:  stack format 8 entry */
	bras	4f			/* +6:  stack format 9 entry */
	bras	5f			/* +8:  stack format A entry */
	bras	6f			/* +10: stack format B entry */
		/* stack format 0 */
    1:	bsrs	8f			/* save regs and call handler */
    1:	trap	#8			/* restore sig mask and return */
	bras	1b
		/* stack format 2 */
    2:	bsrs	8f			/* save regs and call handler */
    1:	trap	#6			/* restore sig mask and return */
	bras	1b
		/* stack format 8 */
    3:	bsrs	8f			/* save regs and call handler */
    1:	trap	#5			/* restore sig mask and return */
	bras	1b
		/* stack format 9 */
    4:	bsrs	8f			/* save regs and call handler */
    1:	trap	#4			/* restore sig mask and return */
	bras	1b
		/* stack format A */
    5:	bsrs	8f			/* save regs and call handler */
    1:	trap	#3			/* restore sig mask and return */
	bras	1b
		/* stack format B */
    6:	bsrs	8f			/* save regs and call handler */
    1:	trap	#2			/* restore sig mask and return */
	bras	1b
    8:	link	a6,#-20			/* just like a real stack frame */
	movml	#<d0-d2,a0-a1>,a6@(-20)	/* save regs d0-d2, a0-a1 */
	movml	a6@(8),#<d0-d2,a0-a1>	/* get our args and handler ptr */
	bsrs	9f			/* push return pc !! */
	movml	a6@(-20),#<d0-d2,a0-a1>	/* restore regs */
	unlk	a6			/* just like a real stack frame */
	rtd	#20			/* pop the args we were called with */
    9:	movw	cc,sp@-			/* CC over PC, to make it look as if
					   trap occured here */
	cmpl	#NCRMAGIC,d2		/* check filemagic */
	beq	1f
	movw	#0,sp@-			/* pad word */
	movl	#0,sp@-			/* code: always 0 */
	movl	d0,sp@-			/* signo */
    1:
	jmp	a1@
	.align	1
_sysv_sigcode:	.long	sysv_sigcode
_sysv_szsigcode:	.long	_sysv_sigcode-sysv_sigcode

#endif	SYSV

/************************************************************************/
	.globl	_ast
	.globl	_bus
	.globl	_clev_bio
	.globl	_clev_biomax
	.globl	_clev_clock
	.globl	_clev_clockmax
	.globl	_clev_imp
	.globl	_clev_impmax
	.globl	_clev_tty
	.globl	_clev_ttymax
	.globl	_cpu
	.globl	_devtype
	.globl	_have_68881
	.globl	_howto
	.globl	_masterpaddr
	.globl	_maxsysseg
	.globl	_minusrseg
	.globl	_nofault
	.globl	_spysp
	.globl	_upages
	.globl	is68020
_ast:		.long	0
#ifdef	QBUS
_clev_bio:	.long	1
_clev_biomax:	.long	4
_clev_clock:	.long	5
_clev_clockmax:	.long	6
_clev_imp:	.long	1
_clev_impmax:	.long	4
_clev_tty:	.long	1
_clev_ttymax:	.long	6
#else	QBUS
_clev_bio:	.long	2
_clev_biomax:	.long	6
_clev_clock:	.long	6
_clev_clockmax:	.long	6
_clev_imp:	.long	2
_clev_impmax:	.long	6
_clev_tty:	.long	2
_clev_ttymax:	.long	5
#endif	QBUS
_cpu:		.long	68010
_devtype:	.long	0
_have_68881:	.long	0
_howto:		.long	0
_masterpaddr:	.long	0
_maxsysseg:	.long	0
_minusrseg:	.long	NPAGBANKS - HIBANKS
_nofault:	.long	0
_spysp:		.long	0
_upages:	.long	UPAGES
is68020:	.long	0x0
tictoc:		.word	0

#ifdef	QBUS
_bus:		.asciz	"QBUS"
#else	QBUS
_bus:		.asciz	"VMEBUS"
#endif	QBUS
panic_ljmp:	.asciz	"longjmp"
panic_setrq:	.asciz	"setrq"
panic_remrq:	.asciz	"remrq"
panic_swtch:	.asciz	"swtch"
panic_iret:	.asciz	"iret"
panic_badfmt:	.asciz	"exception format"
panic_stackovf:	.asciz	"kernel stack overflow"
panic_trap:	.asciz	"trap/syscall patch failed"
die_processor:	.asciz	"You need a 68010 processor, instead of a 68000.\r\n"
swtch_fmt:	.asciz	"swtch: PID=%d PPID=%d\n"
	.text
