static char *RCSid = "$Header: das.c,v 1.1 87/10/01 15:54:16 root Exp $";

/*
 * $Log:	das.c,v $
 * Revision 1.1  87/10/01  15:54:16  root
 * Initial revision
 * 
 * Revision 1.2  86/07/09  10:23:15  brad
 *  addition of disassembly code.
 * 
 * Revision 1.1  86/04/22  13:16:41  mark
 * Initial revision
 * 
 */

#if !KERNEL || DEBUGGER

/* dump text portion of object file as instructions and symbols ... */

/*
 *  #define STANDALONE -> das.c used to make bsd standalone disassembler
 *  #define KERNEL     -> das.c used for kernel debugger
 *  #define ADB        -> das.c used for bsd machine level debugger adb
 *  #define SDB        -> das.c used for sysv symbolic debugger sdb
 *  #define DIS        -> das.c used for sysv standalone disassembler dis
 */

#include <stdio.h>
#include <a.out.h>

#ifdef	KERNEL
#include "machine/defs.h"
#else	KERNEL
#include <machine/defs.h>
#endif	KERNEL

#ifdef	SDB
extern int *badproc, *adrtoprocp();			/* KLUDGE */
#endif	SDB

#ifndef iws
#define N_DATOFF(x) \
	(N_OLDOFF(x) + (x).a_text)
#define N_TROFF(x) \
	(N_DATOFF(x) + (x).a_data)
#define N_DROFF(x) \
	(N_DATOFF(x) + (x).a_data + (x).a_trsize)
#endif iws

#ifdef STANDALONE
long dot;
short debug;
#else STANDALONE
extern long dot;
#endif STANDALONE


int invalid;
long d_value;			/* data value to reprint as symbol */
long d_address;			/* address of data value to reprint as symbol */
char *d_linep;			/* KLUDGE, see usages following! */

short codeonly;
short noaddr;
short allhex;


#if (!KERNEL && !SDB && !DIS)
FILE *das_infile;
struct exec filhdr;
struct sym_table {
	struct sym_table *next;	/* pointer to next table entry */
	int snumb;		/* symbol table entry number of this symbol */
	unsigned char type;	/* type of this symbol */
	long value;		/* value of this symbol */
	char *name;		/* name of this symbol, asciz form */
} *symhead = NULL;

struct reloc_table {
	struct reloc_table *next_r;	/* pointer to next table entry */
	struct sym_table *symb_r;		/* pointer to symbol entry */
	long off_r;			/* offset of relocation */
} *reloc_head = NULL;
#endif

char line[200];
short clx;			/* code buffer index counts */
char *linep;			/* inst buffer pointer */
char *glob_linep;		/* used by sdb (sorry about that) */
#define SOURCE_COL 33		/* starting column for decoded instructions */
#define TAB_WIDTH 8		/* number of spaces generated by a \t */

static char *aregs[8] = {
	"a0", "a1", "a2", "a3", "a4", "a5", "fp", "sp"
};

char *badop = "\t???";

char *brname[16] = {
	"ra", "sr", "hi", "ls", "cc", "cs", "ne", "eq",
	"vc", "vs", "pl", "mi", "ge", "lt", "gt", "le"
};

char *condname[16] = {
	"t",  "f",  "hi", "ls", "cc", "cs", "ne", "eq",
	"vc", "vs", "pl", "mi", "ge", "lt", "gt", "le"
};

char *shname[4] = {
	"as", "ls", "rox", "ro"
};

char *opname[4] = {
	"tst", "chg", "clr", "set"
};

int omove (), obranch (), oimmed (), oprint ();
int oneop (), soneop (), oreg (), aoreg (), ochk ();
int olink (), omovem (), oquick (), omoveq ();
int otrap (), oscc (), opmode (), shift ();
int extend (), biti (), oconst (), odbcc ();
int omovep (), omovec (), omoves (), mvspec ();
int olea (), odiv ();
int ocallm (), opack (), ochk2 (), bfoneop (), bftwoop ();
int ocas (), ocas2 (), otrapcc (), regpair ();
int fops (), fbcc (), fdbcc (), fscc (), ftrapcc ();
long instfetch (), sxtword();
long look_up ();
char *printval ();

extern char *malloc ();
extern char *strcpy ();

struct opdesc {
	unsigned mask, match;
	int (*opfun) ();
	char *farg;
} opdecode[] =
{	/* order is important below */
	/* move instructions */
	0xF000, 0x1000, omove,	"b",
	0xF000, 0x2000, omove,	"l",
	0xF000, 0x3000, omove,	"w",

	/* branches */
	0xF000, 0x6000, obranch, 0,

	/* op class 0  */
	0xFFC0, 0x00C0, ochk2,	"b",
	0xFF00, 0x0000, oimmed,	"or",
	0xFFC0, 0x02C0, ochk2,	"w",
	0xFF00, 0x0200, oimmed,	"and",
	0xFFC0, 0x04C0, ochk2,	"l",
	0xFF00, 0x0400, oimmed,	"sub",
	0xFFF8, 0x06C0, oreg,	"\trtm\td%d",
	0xFFF8, 0x06C8, aoreg,	"\trtm\t%s",
	0xFFC0, 0x06C0, ocallm, 0,
	0xFF00, 0x0600, oimmed,	"add",
	0xFFFF, 0x0AFC, ocas2,	"b",
	0xFFC0, 0x0AC0, ocas,	"b",
	0xFF00, 0x0A00, oimmed,	"eor",
	0xFFFF, 0x0CFC, ocas2,	"w",
	0xFFC0, 0x0CC0, ocas,	"w",
	0xFF00, 0x0C00, oimmed,	"cmp",
	0xFFFF, 0x0EFC, ocas2,	"l",
	0xFFC0, 0x0EC0, ocas,	"l",
	0xFFC0, 0x0E00, omoves,	"b",
	0xFFC0, 0x0E40, omoves,	"w",
	0xFFC0, 0x0E80, omoves,	"l",
	0xF138, 0x0108, omovep,	"movep",
	0xF100, 0x0100, biti,	0,
	0xF800, 0x0800, biti,	0,

	/* op class 4 */
	0xFFC0, 0x40C0, mvspec,	"sr,",
	0xFF00, 0x4000, soneop,	"negx",
	0xFFC0, 0x42C0, mvspec,	"cc,",
	0xFF00, 0x4200, soneop,	"clr",
	0xFFC0, 0x44C0, mvspec,	",cc",
	0xFF00, 0x4400, soneop,	"neg",
	0xFFC0, 0x46C0, mvspec,	",sr",
	0xFF00, 0x4600, soneop,	"not",
	0xFFF8, 0x4808, olink,	0,
	0xFFC0, 0x4800, oneop,	"nbcd",
	0xFFF8, 0x4840, oreg,	"\tswap\td%d",
	0xFFF8, 0x4848, oreg,	"\tbkpt\t#%d",
	0xFFC0, 0x4840, oneop,	"pea",
	0xFFF8, 0x4880, oreg,	"\textw\td%d",
	0xFFF8, 0x48C0, oreg,	"\textl\td%d",
	0xFFF8, 0x49C0, oreg,	"\textbl\td%d",
	0xFB80, 0x4880, omovem,	0,
	0xFFC0, 0x4AC0, oneop,	"tas",
	0xFF00, 0x4A00, soneop,	"tst",
	0xFFC0, 0x4C00, regpair,	"mul",
	0xFFC0, 0x4C40, regpair,	"div",
	0xFFF0, 0x4E40, otrap,	0,
	0xFFF8, 0x4E50, olink,	0,
	0xFFF8, 0x4E58, aoreg,	"\tunlk\t%s",
	0xFFF8, 0x4E60, aoreg,	"\tmove\t%s,usp",
	0xFFF8, 0x4E68, aoreg,	"\tmove\tusp,%s",
	0xFFFF, 0x4E70, oprint,	"reset",
	0xFFFF, 0x4E71, oprint,	"nop",
	0xFFFF, 0x4E72, oconst,	"stop",
	0xFFFF, 0x4E73, oprint,	"rte",
	0xFFFF, 0x4E74, oconst,	"rtd",
	0xFFFF, 0x4E75, oprint,	"rts",
	0xFFFF, 0x4E76, oprint,	"trapv",
	0xFFFF, 0x4E77, oprint,	"rtr",
	0xFFFE, 0x4E7A, omovec, 0,
	0xFFC0, 0x4E80, oneop,	"jsr",
	0xFFC0, 0x4EC0, oneop,	"jmp",
	0xF1C0, 0x4180, ochk,	"w",
	0xF1C0, 0x4100, ochk,	"l",
	0xF1C0, 0x41C0, olea,	"lea",

	0xF0F8, 0x50C8, odbcc,	0,
	0xF0FF, 0x50FA, otrapcc,	0,
	0xF0FF, 0x50FB, otrapcc,	0,
	0xF0FF, 0x50FC, otrapcc,	0,
	0xF0C0, 0x50C0, oscc,	0,
	0xF100, 0x5000, oquick,	"addq",
	0xF100, 0x5100, oquick,	"subq",

	0xF000, 0x7000, omoveq,	0,

	0xF1C0, 0x80C0, odiv,	"divu",
	0xF1F0, 0x8100, extend,	"sbcd",
	0xF1F0, 0x8140, opack,	"pack",
	0xF1F0, 0x8180, opack,	"unpk",
	0xF1C0, 0x81C0, odiv,	"divs",
	0xF000, 0x8000, opmode,	"or",

	0xF1C0, 0x91C0, opmode,	"sub",
	0xF130, 0x9100, extend,	"subx",
	0xF000, 0x9000, opmode,	"sub",

	0xF1C0, 0xB1C0, opmode,	"cmp",
	0xF138, 0xB108, extend,	"cmpm",
	0xF100, 0xB000, opmode,	"cmp",
	0xF100, 0xB100, opmode,	"eor",

	0xF1C0, 0xC0C0, odiv,	"mulu",
	0xF1C0, 0xC1C0, odiv,	"muls",
	0xF1F8, 0xC188, extend,	"exg",
	0xF1F8, 0xC148, extend,	"exg",
	0xF1F8, 0xC140, extend,	"exg",
	0xF1F0, 0xC100, extend,	"abcd",
	0xF000, 0xC000, opmode,	"and",

	0xF1C0, 0xD1C0, opmode,	"add",
	0xF130, 0xD100, extend,	"addx",
	0xF000, 0xD000, opmode,	"add",

	0xF9C0, 0xE8C0, bfoneop, 0,
	0xF9C0, 0xE9C0, bftwoop, 0,
	0xF100, 0xE000, shift,	"r",
	0xF100, 0xE100, shift,	"l",

	0xFFFF, 0xF27A, ftrapcc,	0,
	0xFFFF, 0xF27B, ftrapcc,	0,
	0xFFFF, 0xF27C, ftrapcc,	0,
	0xFFF8, 0xF248, fdbcc,	0,
	0xFFC0, 0xF240, fscc,	0,
	0xFFC0, 0xF280, fbcc,	"w",
	0xFFC0, 0xF2C0, fbcc,	"l",
	0xFFC0, 0xF300, oneop,	"fsave",
	0xFFC0, 0xF340, oneop,	"frestore",
	0xFE00, 0xF200, fops,	0,
	0, 0, 0, 0
};

#ifdef STANDALONE
main (argc, argv)
int argc;
char *argv[];
{
	long ins;
	long limit, locn;
	char proc_name[100];

	das_infile = NULL;		/* for later use as flag */
	proc_name[0] = '\0';
	argv++;			/* skip invocation name */
	while (--argc > 0) {
		if (argv[0][0] == '-')
			switch (argv[0][1]) {
			case 'p': 
				argv++;
				argc--;
				proc_name[0] = '_';
				strcpy (&proc_name[1], *argv);
				break;
			case 'a': 		/* donot print addr & bytes */
				noaddr++;
				codeonly++;
				break;
			case 'c': 		/* donot print instr bytes */
				codeonly++;
				break;
			case 'h': 		/* print all number in hex */
				allhex++;
				break;
			case '!': 
				debug++;
				break;
			default: 
				fprintf (stderr, "option `%c' ignored\n",
					argv[0][1]);

			}
		else {
			if (das_infile != NULL) {
				fprintf (stderr,
					"too many filenames, `%s' ignored\n",
					argv[0]);

			} else if ((das_infile = fopen (argv[0], "r")) == NULL) {
				fprintf (stderr, "can't open %s for input\n",
					argv[0]);
				exit (1);
			}
		}
		argv++;		/* skip over processed arg */
	}

	if (das_infile == NULL)
		das_infile = stdin;

	fread (&filhdr, sizeof filhdr, 1, das_infile);

	if (N_BADMAG (filhdr)) {
		fprintf (stderr, "file is not in object file format\n");
		exit (1);
	}

	if (filhdr.a_syms > 0) {
		read_sym (filhdr.a_syms);
	}
	if (filhdr.a_trsize > 0) {
		read_reloc (filhdr.a_trsize);
	}

	if (proc_name[0] == '\0') {
		/* disassemble the whole file */
		dot = filhdr.a_entry;
		limit = filhdr.a_text;
		if (filhdr.a_magic == OMAGIC && filhdr.a_entry != 0)
			/* correct for kernels and standalone utilities */
			limit += filhdr.a_entry;
		fseek (das_infile, N_TXTOFF(filhdr), 0);
	} else {
		/* disassemble the named routine */
		/* first lookup the name as given */
		dot = look_up (&proc_name[1], &limit);
		if (dot == -1)
			/* then with leading underscore */
			dot = look_up (proc_name, &limit);
		if (dot == -1) {
			fprintf (stderr, "symbol `%s' not found\n", proc_name);
			exit (1);
		}
		locn = dot;
		if (filhdr.a_magic == OMAGIC && filhdr.a_entry != 0)
			/* correct for kernels and standalone utilities */
			locn = dot - filhdr.a_entry;
		fseek (das_infile, N_OLDOFF(filhdr) + locn, 0);
	}

	if (debug)
		fprintf (stderr, "sym=%x, limit=%x\n", dot, limit);
	while (dot < limit) {
	if (debug)
		fprintf (stderr, "sym=%x, limit=%x\n", dot, limit);
		d_address = 0;		/* data reprint flag */
		d_linep = NULL;	
		linep = &line[0];	/* reset line pointer to beginning */
		psymbol (dot, 1);
		if (!noaddr)
			printf ("0x%lx:\t", dot);
		clx = TAB_WIDTH + 1;/* first column in code part */
		ins = instfetch (2);
		print_ins (ins);
		if (!codeonly && clx < SOURCE_COL) {
			clx = ((clx + 7) & ~7) + 1;/* force to tab stop */
			while (clx < SOURCE_COL) {
				putchar ('\t');
				clx += TAB_WIDTH;
			}
		}
		if (d_address) {
			d_linep = linep;	/* mark for possible erasure */
			LPrintf("\t; #0x%x = ", d_value);
			/* print symbol table offset */
			preloc(d_address, d_value);
		}
		printf ("%s\n", line);
	}
	exit (0);
}

#else STANDALONE

#if (!KERNEL && !SDB && !DIS)
/* substitute routine for main when not a STANDALONE */
init_das (file_name)
char *file_name;
{
	char proc_name[100];

	das_infile = NULL;		/* for later use as flag */
	proc_name[0] = '\0';


	if ((das_infile = fopen (file_name, "r")) == NULL) {
		fprintf (stderr, "can't open %s for input\n",
			file_name);
		exit (1);
	}

	if (das_infile == NULL)
		das_infile = stdin;

	fread (&filhdr, sizeof filhdr, 1, das_infile);

	if (N_BADMAG (filhdr)) {
		fprintf (stderr, "file is not in object file format\n");
		exit (1);
	}

	if (filhdr.a_syms > 0) {
		read_sym (filhdr.a_syms);
	}
	if (filhdr.a_trsize > 0) {
		read_reloc (filhdr.a_trsize);
	}

}
#endif /* KERNEL, SDB, DIS*/


das_print_ins(inst, printit)
long inst;
int printit;
{

	d_address = 0;		/* address/data reprint flag */
	linep = &line[0];	/* reset line pointer to beginning */
	glob_linep = &line[0];	/* for sdb */

	invalid = 0;
	codeonly = 1;		/* do not print opcodes */
	clx = TAB_WIDTH + 1;	/* first column in code part */
	print_ins (inst);

	if (d_address) {
#ifdef	SDB
		if (adrtoprocp(d_value) != badproc) {
#endif	SDB
		d_linep = linep;	/* mark for possible erasure */
		LPrintf("\t; #0x%x = ",d_value);
		/* never have relocations in non-standalone mode,
		 * hence use of "psymbol(d_value, 0)" vice
		 * "preloc(d_address, d_value)" below
		 */
		psymbol(d_value, 0);	/* print symbol table offset */
#ifdef	SDB
		}
#endif	SDB
	}
	if (printit)
		printf ("%s", line);
#ifdef	ADB
	flushbuf();
#endif	ADB
	return invalid;
}
#endif STANDALONE 

#if (!KERNEL && !SDB && !DIS)
/* print symbol which matches val, if any;
 * otherwise, if not is_label then print the value
 */
psymbol (val, is_label)
register long val;
int is_label;
{
	register struct sym_table *s, *t;

	for (s = symhead, t = NULL; s != NULL; t = s, s = s->next) {
		if (val == s->value) {
			if (is_label == 0)
				LPrintf ("%s", s->name);
			else if ((s->type & ~N_EXT) == N_TEXT) {
				if (noaddr)
					printf ("%s:\n", s->name);
				else if (codeonly)
					printf ("\t%s:\n", s->name);
				else
					printf ("\t\t\t%s:\n", s->name);
			}
			/* else data variable offset matches dot, */
			/* nothing to do */
			return;
		} else if (val < s->value)
			break;
	}
	if (is_label == 0) {
		/* if val is within a reasonable (positive) delta,
		 *  print as "symbol+offset".
		 * NOTE: there is nothing magic about 128 for the delta,
		 * it is just "reasonable", as most structs are less
		 * than 128 bytes long
		 */
		register long diff;

#ifdef	STANDALONE
#define	MAXDIFF 128
#else	STANDALONE
#define	MAXDIFF MAXINT
#endif	STANDALONE
		if (t != NULL && (diff = val - t->value) > 0 && diff < MAXDIFF)
			LPrintf ("%s+%s", t->name, printval (diff));
		else {
			LPrintf ("0x%lx", val);
			/* eliminate a "0xnnnn = 0xnnnn" data reprint */
			if (d_linep != NULL)
				*d_linep = '\0';
		}
	}
}

/* print a relocation's symbol for the value */
preloc (loc, val)
register long loc;
long val;
{
	register struct reloc_table *r;

	for (r = reloc_head; r != NULL; r = r->next_r)
		if (r->off_r == loc) {
			LPrintf ("%s", r->symb_r->name);
 			if (val != 0)
 				LPrintf ("+%s", printval (val));
			reloc_head = r->next_r;
			/* start at following entry next time */
			return;
		} else if (r->off_r > loc)
			break;

	psymbol (val, 0);	/* try non external value */
}

/* lookup the (text) symbol and pass back its address and
 * the address of the next higher addressed text symbol.
 */
long
look_up (name, next)
char *name;
long *next;
{
	register struct sym_table *s;
	long addr = -1;
	int matched = 0;

	for (s = symhead; s != NULL; s = s->next) {
		if ((s->type & ~N_EXT) == N_TEXT)
			if (matched && addr < s->value) {
				*next = s->value;
				return (addr);
			} else if (strcmp (name, s->name) == 0) {
				addr = s->value;
				matched++;
			}

	}
	/* return limit of the text segment, */
	/* as a following text symbol was not found */
	if (filhdr.a_magic == OMAGIC && filhdr.a_entry != 0)
		/* correct for kernels and standalone utilities */
		*next = filhdr.a_text + filhdr.a_entry;
	else
		*next = filhdr.a_text;
	return (addr);
}


/* build linked list of symbols ordered by increasing value */
read_sym (sym_size)
unsigned long sym_size;
{
	struct nlist s;
	register struct sym_table *st, *last, *t;
	int sym_numb = -1;
	unsigned str_size;
	char *strings;
	register char *p;
	extern char *index();

	fseek (das_infile, N_STROFF (filhdr), 0);
	if (fread (&str_size, sizeof (str_size), 1, das_infile) != 1) {
		printf ("no string table (old object format?)\n");
#ifdef ADB
		flushbuf();
#endif ADB
		exit (1);
	}
	strings = (char *) malloc (str_size);
	if (strings == NULL) {
		printf ("no memory for string table\n");
#ifdef ADB
		flushbuf();
#endif ADB
		exit (1);
	}
	if (fread (strings + sizeof (str_size), str_size - sizeof (str_size),
				1, das_infile) != 1) {
		printf ("error reading string table\n");
#ifdef ADB
		flushbuf();
#endif ADB
		exit (1);
	}

	fseek (das_infile, N_SYMOFF (filhdr), 0);
	while (sym_size > 0) {
		fread (&s, sizeof s, 1, das_infile);
		if (feof (das_infile))
			break;
		sym_numb++;
		sym_size -= sizeof s;
		if (s.n_type & N_STAB)
			continue;
		p = &strings[s.n_un.n_strx];
		if (s.n_type == N_TEXT && index (p, '.'))
			continue;
		st = (struct sym_table *) malloc (sizeof (*st));
		st->name = p;
		st->type = s.n_type;
#ifdef STANDALONE
		st->value = (s.n_type == (N_EXT | N_UNDF)) ?
			0x80000000 : s.n_value;
#else 
		st->value = s.n_value;	
#endif STANDALONE

		st->snumb = sym_numb;

		for (last = NULL, t = symhead; t != NULL; last = t, t = t->next)
			if (t->value > st->value)
				break;
		if (last == NULL)
			symhead = st;
		else
			last->next = st;
		st->next = t;
	}
}

/* build linked list of relocation tokens */
read_reloc (size)
unsigned long size;
{
	struct relocation_info r;
	struct sym_table *s;
	register struct reloc_table *rt, *tail = NULL;

	fseek (das_infile, N_TROFF (filhdr), 0);
	while (size > 0) {
		fread (&r, sizeof (r), 1, das_infile);
		if (feof (das_infile))
			break;
		size -= sizeof (r);
#ifdef iws
		if (r.r_segment != R_EXT)
			continue;
#else
		if (!r.r_extern)
			continue;
#endif iws
		rt = (struct reloc_table *) malloc (sizeof (*rt));
		rt->off_r = r.r_address;
		for (s = symhead; s != NULL; s = s->next)
			if (s->snumb == r.r_symbolnum) {
				rt->symb_r = s;
				break;
			}
		if (tail == NULL)
			reloc_head = rt;
		else
			tail->next_r = rt;
		tail = rt;
	}
	if (tail != NULL)
		tail->next_r = NULL;
}
#endif /* KERNEL, SDB, DIS */

print_ins(inst)
register long inst;
{
	register struct opdesc *p;

	/* this messes up "orb" instructions ever so slightly, */
	/* but keeps us in sync between routines... */
	if (inst == 0) {
		LPrintf ("\t.word 0");
		return;
	}

	for (p = opdecode; p->mask; p++)
		if ((inst & p->mask) == p->match) {
			(*p->opfun) (inst, p->farg);
			return;
		}

	LPrintf (badop);
	invalid++;
}

long
sxtword (i)
register long i;
{
	return (i > 32767 ? i - 65536 : i);
}

#ifdef	STANDALONE
getnextbyte()
{
	return getc(das_infile);
}
#endif	STANDALONE

long
instfetch (size)
int size;
{
	register int ans = 0;
	register int s;

	s = size;
	while (s--) {
		ans <<= 8;
		ans |= getnextbyte() & 0377;
		dot++;
	}
	if (!codeonly) {
		if (size == 2)
			printf ("%04x ", (unsigned short) ans);
		else
			printf ("%08lx ", ans);
		clx += size * 2 + 1;
	}
	return (ans);
}

printea (mode, reg, size)
int mode, reg;
int size;
{
	long value;
#if (!KERNEL)
	union kludge {
		double d;
		float f;
		long l[2]
	} kluj;
#endif

	switch (mode) {
	case 0: 
		LPrintf ("d%d", reg);
		break;

	case 1: 
		LPrintf ("%s", aregs[reg]);
		break;

	case 2: 
		LPrintf ("%s@", aregs[reg]);
		break;

	case 3: 
		LPrintf ("%s@+", aregs[reg]);
		break;

	case 4: 
		LPrintf ("%s@-", aregs[reg]);
		break;

	case 5: 
		LPrintf ("%s@(%s)",
			aregs[reg], printval (sxtword (instfetch (2))));
		break;

	case 6: 
		indexwd (reg);
		break;

	case 7: 
		switch (reg) {
		case 0: 
			value = instfetch (2);
			LPrintf ("%s:w", printval (value));
			break;

		case 1: 
			value = instfetch (4);
			preloc (dot - 4, value);
			break;

		case 2: 
			LPrintf ("pc@(%s)",
				printval (sxtword (instfetch (2) + 2)));
			break;

		case 3: 
			indexwd (16);
			break;

		case 4: 
			if (size <= 2)
				LPrintf ("#0x%x", instfetch (2));
			else if (size == 4) {
				d_address = dot;
				d_value = instfetch(4);
				LPrintf ("#0x%x", d_value);
#if (!KERNEL)
			} else if (size == 6) {
				/* floating single precision */
				/* KLUDGE: size is really 4,
				 * but need to distinguish from long case 
				 */
				kluj.l[0] = instfetch(4);
				LPrintf ("#0f%g", kluj.f);
			} else if (size == 8) {
				/* floating double precision */
				kluj.l[0] = instfetch(4);
				kluj.l[1] = instfetch(4);
				LPrintf ("#0d%g", kluj.d);
			} else if (size == 12) {
				/* Floating extended and packed decimal */
				/* can't give real value, so do in hex */
				LPrintf ("#0x%08x", instfetch (4));
				LPrintf ("%08x", instfetch (4));
				LPrintf ("%08x", instfetch (4));
#endif (!KERNEL)
			}
			break;

		default: 
			LPrintf ("???");
			invalid++;
			break;
		}
		break;

	default: 
		LPrintf ("???");
		invalid++;
	}
}

printEA (ea)
int ea;
{
	printea ((ea >> 3) & 07, ea & 07, 0);
}

union index_word {
	unsigned short word;
	struct {
#ifdef vax
		unsigned short disp: 8;
		unsigned short usefull: 1;
		unsigned short scale: 2;
		unsigned short sz: 1;
		unsigned short reg: 3;
		unsigned short isareg: 1;
#else
		unsigned short isareg: 1;
		unsigned short reg: 3;
		unsigned short sz: 1;
		unsigned short scale: 2;
		unsigned short usefull: 1;
		unsigned short disp: 8;
#endif vax
	} brief;
	struct {
#ifdef vax
		unsigned short ixsel: 3;
		unsigned short zfill: 1;
		unsigned short bdsize: 2;
		unsigned short isupp: 1;
		unsigned short bsupp: 1;
		unsigned short usefull: 1;
		unsigned short scale: 2;
		unsigned short sz: 1;
		unsigned short reg: 3;
		unsigned short isareg: 1;
#else
		unsigned short isareg: 1;
		unsigned short reg: 3;
		unsigned short sz: 1;
		unsigned short scale: 2;
		unsigned short usefull: 1;
		unsigned short bsupp: 1;
		unsigned short isupp: 1;
		unsigned short bdsize: 2;
		unsigned short zfill: 1;
		unsigned short ixsel: 3;
#endif vax
	} full;
};

indexwd (reg)
int reg;
{
	long bdisp, odisp;
	union index_word ixwd;

	ixwd.word = instfetch (2);
	if (!ixwd.brief.usefull) {
		bdisp = (char) ixwd.brief.disp;
		if (reg == 16) {
			bdisp += 2;
			LPrintf ("pc@");
		} else
			LPrintf ("%s@", aregs[reg]);
		LPrintf ("(%s,%c%d:%c*%c)",
			printval (bdisp),
			(ixwd.brief.isareg ? 'a' : 'd'),
			ixwd.brief.reg, (ixwd.brief.sz ? 'l' : 'w'),
			"1248"[ixwd.brief.scale]);
		return;
	}

	/* now comes the really groady part */
	if (reg == 16)
		LPrintf ("%spc@(", (ixwd.full.bsupp ? "z" : ""));
	else if (ixwd.full.bsupp)
		LPrintf ("za@(");
	else
		LPrintf ("%s@(", aregs[reg]);

	switch (ixwd.full.bdsize) {
	case 0: 		/* this is really an error, but oh, well... */
	case 1: 
		LPrintf ("0");
		break;
	case 2: 
		bdisp = sxtword (instfetch (2));
		LPrintf ("%s", printval (bdisp));
		break;
	case 3: 
		bdisp = instfetch (4);
		preloc (dot - 4, bdisp);
		break;
	}

	if (ixwd.full.ixsel & 04) {
		LPrintf (")[%c%d:%c*%c,",
			(ixwd.full.isareg ? 'a' : 'd'),
			ixwd.full.reg, (ixwd.full.sz ? 'l' : 'w'),
			"1248"[ixwd.full.scale]);
	} else {
		if (ixwd.full.isupp)
			LPrintf (")");
		else
			LPrintf (",%c%d:%c*%c)",
				(ixwd.full.isareg ? 'a' : 'd'),
				ixwd.full.reg, (ixwd.full.sz ? 'l' : 'w'),
				"1248"[ixwd.full.scale]);
		if (ixwd.full.ixsel != 0)
			LPrintf ("[");
	}
	if (ixwd.full.ixsel != 0) {
		switch (ixwd.full.ixsel & ~04) {
		case 0: 	/* this is really an error, but oh, well... */
		case 1: 
			LPrintf ("0]");
			break;
		case 2: 
			odisp = sxtword (instfetch (2));
			LPrintf ("%s]", printval (odisp));
			break;
		case 3: 
			odisp = instfetch (4);
			preloc (dot - 4, odisp);
			LPrintf ("]");
			break;
		}
	}
}

mapsize (inst)
int inst;
{
	inst >>= 6;
	inst &= 03;
	return ((inst == 0) ? 1 : (inst == 1) ? 2 : (inst == 2) ? 4 : -1);
}

char
suffix (size)
register int size;
{
	return ((size == 1) ? 'b' : (size == 2) ? 'w' :
		(size == 4) ? 'l' : '?');
}

omove (inst, s)
int inst;
char *s;
{
	int size;

	LPrintf ("\tmov%c\t", *s);
	size = ((*s == 'b') ? 1 : (*s == 'w') ? 2 : 4);
	printea ((inst >> 3) & 07, inst & 07, size);
	*linep++ = ',';
	printea ((inst >> 6) & 07, (inst >> 9) & 07, size);
}

obranch (inst, dummy)
int inst;
{
	int disp = inst & 0377;
	int cond = (inst >> 8) & 017;
	char leng;

	leng = 's';
	if (disp == 0) {
		leng = ' ';
		disp = sxtword (instfetch (2)) - 2;
	} else if (disp == 255) {
		leng = 'l';
		disp = instfetch (4) - 4;
	} else if (disp > 127) {
		disp |= ~0377;
	}
	LPrintf ("\tb%s%c\t", brname[cond], leng);
#ifdef ADB
	disp += 2;	/* "glue-ish" dot branch alignment kluge */
#endif ADB

#ifdef STANDALONE
 	if (cond == 1)		/* bsr */
 		psymbol (dot + disp, 0);
 	else
 		LPrintf ("0x%x", dot + disp);
#else
	psymbol (dot + disp, 0);
#endif
}

odbcc (inst, dummy)
int inst;
{
	int disp;
	register int cond = (inst >> 8) & 017;

	disp = sxtword (instfetch (2)) - 2;
 	LPrintf ("\tdb%s\td%d,0x%x",
 		(cond == 1 ? "ra" : condname[cond]),
 			/* use "dbra" in place of "dbf" */
 		inst & 07, dot + disp);
}

oscc (inst, dummy)
int inst;
{
	register int cond = (inst >> 8) & 017;

	LPrintf ("\ts%s\t", condname[cond]);
	printea ((inst >> 3) & 07, inst & 07, 1);
}

biti (inst, dummy)
int inst;
{
	LPrintf ("\tb%s\t", opname[((inst >> 6) & 03)]);
	if (inst & 0x0100)
		LPrintf ("d%d,", (inst >> 9) & 07);
	else
		LPrintf ("#%d,", instfetch (2));
	printEA (inst);
}

opmode (inst, opcode)
int inst;
{
	register int mode = ((inst >> 6) & 07);
	register int reg = ((inst >> 9) & 07);
	int size;

	size = (mode == 0 || mode == 4) ? 1 :
		(mode == 1 || mode == 3 || mode == 5) ? 2 : 4;
	LPrintf ("\t%s%c\t", opcode, suffix (size));
	if (mode >= 4 && mode <= 6) {
		LPrintf ("d%d,", reg);
		printea ((inst >> 3) & 07, inst & 07, size);
	} else {
		printea ((inst >> 3) & 07, inst & 07, size);
		LPrintf (",%c%d", (mode <= 2) ? 'd' : 'a', reg);
	}
}

shift (inst, ds)
int inst;
char *ds;
{
	int rx, ry;
	char *opcode;
	if ((inst & 0xC0) == 0xC0) {
		opcode = shname[((inst >> 9) & 03)];
		LPrintf ("\t%s%s\t", opcode, ds);
		printEA (inst);
	} else {
		opcode = shname[((inst >> 3) & 03)];
		LPrintf ("\t%s%s%c\t", opcode, ds, suffix (mapsize (inst)));
		rx = ((inst >> 9) & 07);
		ry = (inst & 07);
		if (inst & 0x0020)
			LPrintf ("d%d,d%d", rx, ry);
		else
			LPrintf ("#%d,d%d", (rx ? rx : 8), ry);
	}
}

oimmed (inst, opcode)
int inst;
char *opcode;
{
	register int size = mapsize (inst);
	register int mode = (inst >> 3) & 07;
	register int reg = inst & 07;
	long const;

	if (size > 0) {
		if (size == 4) {
			d_address = dot;
			d_value = const = instfetch (4);
		} else
			const = instfetch (2);
		LPrintf ("\t%s%c\t#0x%x,", opcode, suffix (size), const);
		if (mode == 7 && reg == 4)/* ccr or sr is destination */
			LPrintf ((size == 1 ? "cc" : "sr"));
		else
			printea (mode, reg, size);
	} else {
		LPrintf (badop);
		invalid++;
	}
}



/* special oreg() for aregs to handle fp and sp nicely */
aoreg (inst, opcode)
int inst;
char *opcode;
{

	LPrintf (opcode, aregs[inst & 07]);
}

oreg (inst, opcode)
int inst;
char *opcode;
{
	LPrintf (opcode, (inst & 07));
}

extend (inst, opcode)
int inst;
char *opcode;
{
	register int size = mapsize (inst);
	int ry = (inst & 07), rx = ((inst >> 9) & 07);
	char c;

	c = ((inst & 0x1000) ? suffix (size) : ' ');
	LPrintf ("\t%s%c\t", opcode, c);
	if (*opcode == 'e') {
		if (inst & 0x0080)
			LPrintf ("d%d,%s", rx, aregs[ry]);
		else if (inst & 0x0008)
			LPrintf ("%s,%s", aregs[rx], aregs[ry]);
		else
			LPrintf ("d%d,d%d", rx, ry);
	} else if ((inst & 0xF000) == 0xB000)
		LPrintf ("%s@+,%s@+", aregs[ry], aregs[rx]);
	else if (inst & 0x8)
		LPrintf ("%s@-,%s@-", aregs[ry], aregs[rx]);
	else
		LPrintf ("d%d,d%d", ry, rx);
}

olink (inst, dummy)
int inst;
{
	long disp;

	if (inst & 0x8)
		disp = instfetch (4);
	else
		disp = sxtword (instfetch (2));
	LPrintf ("\tlink\t%s,#%s", aregs[inst & 07], printval (disp));
}

otrap (inst, dummy)
int inst;
{
	LPrintf ("\ttrap\t#%d", inst & 017);
}

mvspec (inst, opcode)
int inst;
char *opcode;
{
	LPrintf ("\tmovw\t");
	if (*opcode == ',') {
		printEA (inst);
		LPrintf ("%s", opcode);
	} else {
		LPrintf ("%s", opcode);
		printEA (inst);
	}
}

oneop (inst, opcode)
int inst;
char *opcode;
{
	LPrintf ("\t%s\t", opcode);
	printEA (inst);
}

pregmask (mask)
register int mask;
{
	register int i;
	register int flag = 0;

	LPrintf ("#<");
	for (i = 0; i < 16; i++) {
		if (mask & 1) {
			if (flag)
				*linep++ = ',';
			else
				flag++;
			LPrintf ("%c%d", (i < 8) ? 'd' : 'a', i & 07);
		}
		mask >>= 1;
	}
	LPrintf (">");
}

omovem (inst, dummy)
int inst;
{
	register int i, list = 0, mask = 0100000;
	register int reglist = instfetch (2);

	if ((inst & 070) == 040) {/* predecrement */
		for (i = 15; i > 0; i -= 2) {
			list |= ((mask & reglist) >> i);
			mask >>= 1;
		}
		for (i = 1; i < 16; i += 2) {
			list |= ((mask & reglist) << i);
			mask >>= 1;
		}
		reglist = list;
	}
	LPrintf ("\tmovem%c\t", (inst & 0100) ? 'l' : 'w');
	if (inst & 02000) {
		printEA (inst);
		*linep++ = ',';
		pregmask (reglist);
	} else {
		pregmask (reglist);
		*linep++ = ',';
		printEA (inst);
	}
}

ochk (inst, s)
int inst;
char *s;
{
	LPrintf ("\tchk%s\t", s);
	printea ((inst >> 3) & 07, inst & 07, (*s == 'w') ? 2 : 4);
	LPrintf (",d%d", (inst >> 9) & 07);
}

odiv (inst, opcode)
int inst;
char *opcode;
{
	LPrintf ("\t%s\t", opcode);
	printEA (inst);
	LPrintf (",d%d", (inst >> 9) & 07);
}

olea (inst, dummy)
int inst;
{
	LPrintf ("\tlea\t");
	printEA (inst);
	LPrintf (",%s", aregs[(inst >> 9) & 07]);
}

soneop (inst, opcode)
int inst;
char *opcode;
{
	register int size = mapsize (inst);

	if (size > 0) {
		LPrintf ("\t%s%c\t", opcode, suffix (size));
		printEA (inst);
	} else {
		LPrintf (badop);
		invalid++;
	}
}

oquick (inst, opcode)
int inst;
char *opcode;
{
	register int size = mapsize (inst);
	register int data = ((inst >> 9) & 07);

	if (data == 0)
		data = 8;
	if (size > 0) {
		LPrintf ("\t%s%c\t#%d,", opcode, suffix (size), data);
		printEA (inst);
	} else {
		LPrintf (badop);
		invalid++;
	}
}

omoveq (inst, dummy)
int inst;
{
	register int data = (unsigned char) (inst & 0377);

	LPrintf ("\tmoveq\t#0x%02x,d%d", data, (inst >> 9) & 07);
}

oprint (inst, opcode)
int inst;
char *opcode;
{
	LPrintf ("\t%s", opcode);
}

oconst (inst, opcode)
int inst;
char *opcode;
{
	LPrintf ("\t%s\t#0x%x", opcode, (unsigned int) instfetch (2));
}

omovep (inst, opcode)
int inst;
char *opcode;
{
	int areg = inst & 07;
	int dreg = (inst >> 9) & 07;
	long disp = sxtword (instfetch (2));

	LPrintf ("\t%s%c\t", opcode,
			(inst & 0100 ? 'l' : 'w'));
	if (inst & 0200)
		LPrintf ("d%d,%s@(%s)", dreg, aregs[areg], printval (disp));
	else
		LPrintf ("%s@(%s),d%d", aregs[areg], printval (disp), dreg);
}

char *
getctlreg (op2)
int op2;
{
	switch (op2 & 0x0FFF) {
	case 0x0000: 
		return ("sfc");
	case 0x0001: 
		return ("dfc");
	case 0x0002: 
		return ("cac");
	case 0x0800: 
		return ("usp");
	case 0x0801: 
		return ("vbr");
	case 0x0802: 
		return ("caa");
	case 0x0803: 
		return ("msp");
	case 0x0804: 
		return ("isp");
	default: 
		invalid++;
		return ("???");
	}
}

omovec (inst, dummy)
int inst;
char *dummy;
{
	char regtype, *ctlreg;
	int regnumb;
	int info = instfetch (2);

	regtype = (info & 0x8000) ? 'a' : 'd';
	regnumb = (info >> 12) & 07;
	ctlreg = getctlreg (info);
	LPrintf ("\tmovec\t");
	if (inst & 01)
		LPrintf ("%c%d,%s", regtype, regnumb, ctlreg);
	else
		LPrintf ("%s,%c%d", ctlreg, regtype, regnumb);
}

omoves (inst, s)
int inst;
char *s;
{
	char regtype;
	int regnumb, size;
	int info = instfetch (2);

	regtype = (info & 0x8000) ? 'a' : 'd';
	regnumb = (info >> 12) & 07;
	size = ((*s == 'b') ? 1 : (*s == 'w') ? 2 : 4);
	LPrintf ("\tmoves%c\t", *s);
	if (info & 0x0800) {
		LPrintf ("%c%d,", regtype, regnumb);
		printea ((inst >> 3) & 07, inst & 07, size);
	} else {
		printea ((inst >> 3) & 07, inst & 07, size);
		LPrintf (",%c%d", regtype, regnumb);
	}
}

bfoneop (inst, dummy)
int inst;
{
	unsigned short extwd = instfetch (2);

	LPrintf ("\tbf%s\t", opname[((inst >> 9) & 03)]);

	printEA (inst);
	if (extwd & 0x0800) {
		LPrintf ("{d%d:", (extwd >> 6) & 07);
	} else {
		LPrintf ("{%d:", (extwd >> 6) & 0x1f);
	}
	if (extwd & 0x0020) {
		LPrintf ("d%d}", extwd & 07);
	} else {
		LPrintf ("%d}", extwd & 0x1f);
	}
}

bftwoop (inst, dummy)
int inst;
{
	unsigned short extwd = instfetch (2);
	short bfins = 0;
	char *opcode;

	switch ((inst >> 9) & 03) {
	case 0: 
		opcode = "extu";
		break;
	case 1: 
		opcode = "exts";
		break;
	case 2: 
		opcode = "ffo";
		break;
	case 3: 
		opcode = "ins";
		bfins++;
		break;
	}
	LPrintf ("\tbf%s\t", opcode);

	if (bfins) {
		LPrintf ("d%d,", (extwd >> 12) & 07);
	}

	printEA (inst);
	if (extwd & 0x0800) {
		LPrintf ("{d%d:", (extwd >> 6) & 07);
	} else {
		LPrintf ("{%d:", (extwd >> 6) & 0x1f);
	}
	if (extwd & 0x0020) {
		LPrintf ("d%d}", extwd & 07);
	} else {
		int width = extwd & 0x1f;
		if (width == 0) width = 32;
		LPrintf ("%d}", width);
	}

	if (!bfins) {
		LPrintf (",d%d", (extwd >> 12) & 07);
	}
}

ocallm (inst, dummy)
int inst;
{
	LPrintf ("\tcallm\t#%d,", instfetch (2));
	printEA (inst);
}

ocas (inst, s)
int inst;
char *s;
{
	unsigned short extwd = instfetch (2);

	LPrintf ("\tcas%s\td%d,d%d,", s, extwd & 07, (extwd >> 6) & 07);
	printEA (inst);
}

ocas2 (inst, s)
int inst;
char *s;
{
	unsigned short extwd1, extwd2;
	int r1, r2;

	extwd1 = instfetch (2);
	extwd2 = instfetch (2);

	r1 = (extwd1 & 0x8000) ? 'a' : 'd';
	r2 = (extwd2 & 0x8000) ? 'a' : 'd';
	LPrintf ("\tcas2%s\td%d:d%d,d%d:d%d,%c%d@:%c%d@",
		s, extwd1 & 07, extwd2 & 07,
		(extwd1 >> 6) & 07, (extwd2 >> 6) & 07,
		r1, (extwd1 >> 12) & 07, r2, (extwd2 >> 12) & 07);
}

ochk2 (inst, s)
int inst;
char *s;
{
	unsigned short extwd = instfetch (2);

	LPrintf ("\t%s%s\t", (extwd & 0x0800) ? "chk2" : "cmp2", s);
	printea ((inst >> 3) & 07, inst & 07,
		(*s == 'b') ? 1 : (*s == 'w') ? 2 : 4);
	LPrintf (",%c%d", (extwd & 0x8000) ? 'a' : 'd', (extwd >> 12) & 07);
}

opack (inst, opcode)
int inst;
char *opcode;
{
	int rx = (inst & 07), ry = ((inst >> 9) & 07);

	LPrintf ("\t%s\t", opcode);
	if (inst & 0x8)
		LPrintf ("%s@-,%s@-", aregs[rx], aregs[ry]);
	else
		LPrintf ("d%d,d%d", rx, ry);
	LPrintf (",#0x%04x", instfetch (2));
}

otrapcc (inst, dummy)
int inst;
{
	register int cond = (inst >> 8) & 017;
	char s;
	int val;

	switch (inst & 07) {
	case 2: 
		val = instfetch (2);
		s = 'w';
		break;
	case 3: 
		val = instfetch (4);
		s = 'l';
		break;
	case 4: 
		s = ' ';
		break;
	}
	LPrintf ("\ttrap%s%c", condname[cond], s);
	if (s == 'w')
		LPrintf ("\t#0x%04x", val);
	else if (s == 'l')
		LPrintf ("\t#0x%08x", val);
}

regpair (inst, opcode)
int inst;
char *opcode;
{
	register short extwd = instfetch (2);
	int reg1, reg2;
	char us, *sz, havepr;

	us = (extwd & 0x0800) ? 's' : 'u';
	reg1 = (extwd >> 12) & 07;
	reg2 = extwd & 07;
	sz = "l";
	if (extwd & 0x0400)
		havepr = 1;
	else if (reg1 != reg2) {
		/* div?ll case */
		sz = "ll";
		havepr = 1;
	} else
		havepr = 0;

	LPrintf ("\t%s%c%s\t", opcode, us, sz);
	printea ((inst >> 3) & 07, inst & 07, 4);
	if (havepr) {
		LPrintf (",d%d:d%d", reg2, reg1);
	} else
		LPrintf (",d%d", reg1);
}


/* 68881 floating point processor routines */

char fformat[] = "lsxpwdbp";
/* for formats:	l  s  x   p   w  d  b  p?	*/
int fsize[] = { 4, 6, 12, 12, 2, 8, 1, 0};
/* fsize[s] == 6 is a kludge to distinguish 'l' and 's' immediates */

char *fopname[] = {
	/* zero entries are redundant encodings and will be flagged */
	"mov", "int", "sinh", "intrz",
	"sqrt",	0, "lognp1", 0,
	"etoxm1", "tanh", "atan", 0, 
	"asin", "atanh", "sin", "tan",
	"etox", "twotox", "tentox", 0,
	"logn", "log10", "log2", 0,
	"abs", "cosh", "neg", 0,
	"acos", "cos", "getexp", "getman",
	"div", "mod", "add", "mul",
	"sgldiv", "rem", "scale", "sglmul",
	"sub", 0, 0, 0,
	0, 0, 0, 0,
	"", "", "", "", 			/* sincos is special */
	"", "", "", "", 			/* sincos is special */
	"cmp", 0, "tst", 0,
	0, 0, 0, 0,
	/* 0x40 to 0x7f are reserved and checked elsewhere */
};

fops (inst, dummy)
int inst;
{
	int cmd = instfetch (2);

	switch ((cmd >> 13) & 07) {
	case 0:	fop_reg_reg (inst, cmd); break;
	case 1: /* reserved encoding */
		LPrintf ("\tfreserved???\n");
		invalid++;
		break;
	case 2:	fop_ea_reg (inst, cmd); break;
	case 3: fmov_ea (inst, cmd); break;
	case 4: fmovec (inst, cmd, 0); break;
	case 5: fmovec (inst, cmd, 1); break;
	case 6: fmovem (inst, cmd, 0); break;
	case 7: fmovem (inst, cmd, 1); break;
	}
}

fop_reg_reg (inst, cmd)
int inst, cmd;
{
	int op = cmd & 0x7f;

	if (op >= 0x40 || fopname[op] == 0) {
		LPrintf ("\tfreserved???");
		invalid++;
		return;
	}
	if (fopname[op][0] == '\0') {
		/* handle fsincosx op */
		LPrintf ("\tfsincosx\tf%d,f%d:f%d", (cmd >> 10) & 07,
			cmd & 07, (cmd >> 7) & 07);
		return;
	}
	if (op == 0x3A) {
		/* handle ftstx op */
		LPrintf ("\tftstx\tf%d", (cmd >> 10) & 07);
		return;
	}
	/* finally all others */
	LPrintf ("\tf%sx\tf%d,f%d",
		fopname[op], (cmd >> 10) & 07, (cmd >> 7) & 07);
}

fop_ea_reg (inst, cmd)
int inst, cmd;
{
	int op = cmd & 0x7f;
	int fmt = (cmd >> 10) & 07;
	short sincos = 0;
	char szch = fformat[fmt];

	if (fmt == 7 && (inst & 0xCF) == 0) {
		/* handle fmovecr op */
		LPrintf ("\tfmovecr\t#%d,f%d", op, (cmd >> 7) & 07);
		return;
	}

	if (op >= 0x40 || fopname[op] == 0) {
		LPrintf ("\tfreserved???");
		invalid++;
		return;
	}

	if (fopname[op][0] == '\0') {
		/* handle fsincos op */
		LPrintf ("\tfsincos%c\t", szch);
		sincos++;
	} else
		LPrintf ("\tf%s%c\t", fopname[op], szch);

	printea ((inst >> 3) & 07, inst & 07, fsize[fmt]);
	if (op != 0x3A) {
		/* all except ftst op have destination */
		LPrintf (",f%d", (cmd >> 7) & 07);
		if (sincos) {
			/* fsincos has two destination */
			LPrintf (":f%d", cmd & 07);
		}
	}
}

fmov_ea (inst, cmd)
int inst, cmd;
{
	int kfactor = cmd & 0x7f;
	int fmt = (cmd >> 10) & 07;

	LPrintf ("\tfmov%c\tf%d,", fformat[fmt], (cmd >> 7) & 07);
	printea ((inst >> 3) & 07, inst & 07, fsize[fmt]);

	if (fmt == 3) {
		/* need to sign extend the number */
		if (kfactor > 63)
			kfactor |= ~0x3f;
		LPrintf ("{%d}", kfactor);
	} else if (fmt == 7) {
		LPrintf ("{d%d}", (kfactor >> 4) & 07);
	}
}

fmovec (inst, cmd, dir)
int inst, cmd, dir;
{
	register int reglist = (cmd >> 10) & 07;
	char *creg;

	switch (reglist) {
	case 0:
		LPrintf ("\tfreserved???"); invalid++; return;
	case 1:
		creg = "fpiar"; break;
	case 2:
		creg = "fpsr"; break;
	case 4:
		creg = "fpcr"; break;
	default:
		LPrintf ("\tfmoveml\t");
		if (dir == 0) {
			printEA (inst);
			*linep++ = ',';
			fcregmask (reglist);
		} else {
			fcregmask (reglist);
			*linep++ = ',';
			printEA (inst);
		}
		return;
	}

	LPrintf ("\tfmovel\t");
	if (dir == 0) {
		printea ((inst >> 3) & 07, inst & 07, 4);
		LPrintf (",%s", creg);
	} else {
		LPrintf ("%s,", creg);
		printEA (inst);
	}
}

fcregmask (mask)
register int mask;
{
	short flag = 0;

	LPrintf ("#<");
	if (mask & 04) {
		LPrintf ("fpcr");
		flag++;
	}
	if (mask & 02) {
		if (flag)
			*linep++ = ',';
		LPrintf ("fpsr");
		flag++;
	}
	if (mask & 01) {
		if (flag)
			*linep++ = ',';
		LPrintf ("fpiar");
	}
	LPrintf (">");
}

fmovem (inst, cmd, dir)
int inst, cmd, dir;
{
	register int reglist = cmd & 0xff;

	if (cmd & 0x0800) {
		/* register list is in a data register */
		reglist = (reglist >> 4) & 07;
	} else if ((inst & 070) == 040) {/* predecrement */
		register int i, list, mask;

		list = 0; mask = 0x80;
		for (i = 7; i > 0; i -= 2) {
			list |= ((mask & reglist) >> i);
			mask >>= 1;
		}
		for (i = 1; i < 8; i += 2) {
			list |= ((mask & reglist) << i);
			mask >>= 1;
		}
		reglist = list;
	}

	LPrintf ("\tfmovemx\t");
	if (dir == 0) {
		printEA (inst);
		*linep++ = ',';
		if (cmd & 0x0800)
			LPrintf ("d%d", reglist);
		else
			fregmask (reglist);
	} else {
		if (cmd & 0x0800)
			LPrintf ("d%d", reglist);
		else
			fregmask (reglist);
		*linep++ = ',';
		printEA (inst);
	}
}

fregmask (mask)
register int mask;
{
	register int i;
	register int flag = 0;

	LPrintf ("#<");
	for (i = 0; i < 8; i++) {
		if (mask & 0x80) {
			if (flag)
				*linep++ = ',';
			else
				flag++;
			LPrintf ("f%d", i);
		}
		mask <<= 1;
	}
	LPrintf (">");
}

char *fcondname[32] = {
	"f",    "eq",  "ogt", "oge", "olt", "ole", "ogl",  "or",
	"un",   "ueq", "ugt", "uge", "ult", "ule", "neq",  "t",
	"sf",   "seq", "gt",  "ge",  "lt",  "le",  "gl",   "gle",
	"ngle", "ngl", "nle", "nlt", "nge", "ngt", "sneq", "st",
};

fbcc (inst, leng)
int inst;
char *leng;
{
	long disp;
	int cond = inst & 0x3F;

	if (*leng == 'w') {
		disp = sxtword (instfetch (2)) - 2;
	} else if (*leng == 'l') {
		disp = instfetch (4) - 2;
	}

	if (cond == 0 && *leng == 'w' && disp == -2)
		LPrintf ("\tfnop");
	else
		LPrintf ("\tfb%s%c\t0x%x",
			fcondname[cond], *leng, dot + disp);
}

fdbcc (inst, dummy)
int inst;
{
	long disp;
	register int cond = instfetch (2);

	disp = sxtword (instfetch (2)) - 2;
 	LPrintf ("\tfdb%s\td%d,0x%x",
		fcondname[cond], inst & 07, dot + disp);
}

fscc (inst, dummy)
int inst;
{
	register int cond = instfetch (2);

	LPrintf ("\tfs%s\t", fcondname[cond]);
	printea ((inst >> 3) & 07, inst & 07, 1);
}

ftrapcc (inst, dummy)
int inst;
{
	register int cond = instfetch (2);
	char s;
	int val;

	switch (inst & 07) {
	case 2: 
		val = instfetch (2);
		s = 'w';
		break;
	case 3: 
		val = instfetch (4);
		s = 'l';
		break;
	case 4: 
		s = ' ';
		break;
	}
	LPrintf ("\tftrap%s%c", fcondname[cond], s);
	if (s == 'w')
		LPrintf ("\t#0x%04x", val);
	else if (s == 'l')
		LPrintf ("\t#0x%08x", val);
}

/* Miscellaneous utility routines */

/*
 *	Print signed hex or decimal value based on "allhex".
 */
char *
printval (value)
long value;
{
	static char valbuf[20];

	if (allhex == 0)
		sprintf (valbuf, "%d", value);
	else {
		if (value < 0)
			sprintf (valbuf, "-0x%x", -value);
		else
			sprintf (valbuf, "0x%x", value);
	}
	return (valbuf);
}

#if	(STANDALONE || ADB)
/* 
 * LPrintf is modified from library routine "sprintf".
 * It prints into the string pointed to by linep and sets linep
 * to point to the next available char at end of the string, and
 * puts a \0 at that location as a (temporary) string terminator.
 */
/* VARARGS1 */
LPrintf (fmt, args)
char *fmt;
{
	struct _iobuf _strbuf;

	_strbuf._flag = _IOWRT + _IOSTRG;
	_strbuf._ptr = linep;
	_strbuf._cnt = &line[200] - linep;

	_doprnt (fmt, &args, &_strbuf);

	/* save the location of the next char */
	linep = _strbuf._ptr;
	*linep = '\0';
}
#endif	/*  STANDALONE || ADB */

#if	(SDB || DIS)
#include <stdio.h>
#include <varargs.h>

extern int _doprnt();

/*VARARGS2*/
int
LPrintf(format, va_alist)
char *format;
va_dcl
{
	FILE siop;
	va_list ap;

	siop._cnt = &line[200] - linep;
	siop._base = siop._ptr = (unsigned char *)linep;
	siop._flag = _IOWRT;
	siop._file = _NFILE;
	va_start(ap);
	_doprnt(format, ap, &siop);
	va_end(ap);
	linep = (char *)siop._ptr;
	*linep = '\0';
}
#endif	/* SDB || DIS */

#endif /* !KERNEL || DEBUGGER */
