/*
 * IS-68K20C VME CPU board constants
 */

#define	MEMR_MASK	0xF0000000	/* memory region mask */
#define	NONT_BASE	0x00000000	/* HS non translated address */
#define	NONT_MASK	0x0FFFFFFF	/* non-translated address space mask */
#define	SYSV_BASE	0x10000000	/* system virtual base */
#define	USRV_BASE	0x20000000	/* user virtual base */
#define	MAXU_ADDR	0x10000000	/* size of user virtual space */
#define	VME_STANDARD	0x70000000	/* VME nontranslated standard address */
#define	VME_SHORTIO	0x78000000  	/* VME nontranslated shortio address */
#define	VME_EXTENDED	0x80000000  	/* VME nontranslated extended address */

/* TRANSLATION BUFFER CONSTANTS */
#define TBUF_BASE_SYS	0x30000000
#define TBUF_BASE_USR	0x40000000
#define TBUF_INCR	0x00002000
#define	TBUF_INDEX_MASK	0x003FE000
#define TBUF_MASK	0xFFFFFFFF
#define	TBUF_MATCH_MASK	0x07E00000
#define TBUF_VALID	0x08000000
#define TBUF_INVALID	0x00000000
#define NTBUFS		512		/* for each mode */
#define	TBUF_BITS	\
"\20\40PG_V\37PG_RO\36PG_M\35PG_R\34V\25PG_CACHE\24PG_VMESTD"

/* ONBOARD IO SPACE REGISTERS */
#ifdef	LOCORE
#define UAR     	0x36000000	/* update error address register */
#define AST		0x38000000	/* asynchronous software trap */
#define	BSR		0x50000000	/* board status register */
#define	CTX		0x51000000	/* context register, write only */
#define	PROM		0x54000000	/* prom, read only */
#define	ESR		0x5c000000	/* error source reg, read only */
#else	LOCORE
#define	UAR		((unsigned int  *)0x36000000)
#define	AST		((unsigned int  *)0x38000000)
#define	BSR		((unsigned char *)0x50000000)
#define	CTX		((unsigned char *)0x51000000)
#define	PROM		((unsigned char *)0x54000000)
#define	ESR		((unsigned char *)0x5c000000)
		/* software copy of hardware register */
unsigned char		ctx;
unsigned char		bsr;
#endif	LOCORE

#define	BSR_W_LED0	0x80		/* 1 => turn OFF led DS3 */
#define	BSR_W_LED1	0x40		/* 1 => turn OFF led DS4 */
#define	BSR_W_PARITY	0x20		/* 1 => enable parity */
#define	BSR_W_CLOCK	0x10		/* 1 => enable 60Hz clock */
#define	BSR_W_DTR	0x08		/* 1 => DTR tty0 modem control */
#define	BSR_W_MOTCACHE	0x04		/* 1 => enable motorola cache */
#define	BSR_W_VMELW	0x02		/* 1 => disable longword */
#define	BSR_W_CACHE	0x01		/* 1 => enable external cache */

#define	BSR_E13		0x80		/* ON reads as zero */
#define	BSR_E14		0x40		/* ON reads as zero */
#define	BSR_E15		0x20		/* ON reads as zero */
#define	BSR_E16		0x10		/* ON reads as zero */
#define	BSR_DCD		0x08		/* tty0 Data Carrier Detect */
#define	BSR_CNODE	0x07		/* cluster node number */
#define	BSR_BAUD	(BSR_E13|BSR_E14)/* E13 and E14 determine baud rate */
#define BSR_BAUD_9600	(BSR_E13|BSR_E14)/* no jumpers at E13 or E14 */
#define BSR_BAUD_19200	(BSR_E13)	/* E13 jumpered */
#define BSR_BAUD_1200	(BSR_E14)	/* E14 jumpered */
#define BSR_BAUD_300	(0) 		/* E13 and E14 jumpered */
#define BSR_KEY_BOARD	(BSR_E15)	/* E26 determines type of KEYBOARD */
#define BSR_KEY_ISI	(BSR_E15)	/* no E26 jumper for ISI keyboard */
#define BSR_KEY_IWS	(0)		/* E26 jumpered for IWS keyboard */

#define NCTX		64		/* Number of Contexts */
#define CTX_SYS		0		/* system context */
#define CTX_INVALID	63		/* unallocated context */
#define	CTX_MASK	0x3F

#define	PROM_BASE	PROM
#define PROM_REBOOT	PROM+8

#define	ESR_UPDATE	0x80		/* if 0 then Cache Fill Parity Error */
#define	ESR_UPDATE_BIT	7
#define	ESR_NO_FP	0x40		/* if 0 then No Floating Point Unit */
#define	ESR_NO_FP_BIT	6
#define	ESR_PARITY_OK	0x20		/* if 0 then parity error */
#define	ESR_PARITY_OK_BIT	5
#define	ESR_PG_V	0x10		/* if 0 then page not valid */
#define	ESR_PG_V_BIT	4
#define	ESR_PROT_OK	0x08		/* if 0 then Protection Violation */
#define	ESR_PROT_OK_BIT	3
#define	ESR_ADDR_OK	0x04		/* if 0 then illegal address */
#define	ESR_ADDR_OK_BIT	2
#define	ESR_HSBER	0x02		/* if 0 then bus error on vme bus */
#define	ESR_HSBER_BIT	1
#define	ESR_PTP_OK	0x01		/* if 0 then Ptp Abort */
#define	ESR_PTP_OK_BIT	0
#define	ESR_BERMASK	0xFF		/* no illegal address bit */
#define	ESR_BERBITS	\
"\220\10UPARITY\7NOFP\6PARITY\5PG_~V\4PROTV\3ILLADR\2VMEBERR\1PTPABORT"
#define ESR_NMIBITS	ESR_BERBITS

/* PAGE TABLE POINTER (PTP) CONSTANTS */
#define PTP_BASE	0x60000000
#define PTP_INCR	0x00800000
#define PTP_MASK	0x00603FFF
#define	PTP_LSB		0x00200000
#define PTP_ADRMASK	0x0FFFF000
#define	PTP_ADRSHIFT	12
#define PTP_LSBMASK	0x00001000
#define PTP_LSBSHIFT	9
#define PTP_VALID	0x00400000
#define PTP_INVALID	0x00000000
#define	PTP_PGMAX	0x4000		/* highest page PTP can point to */
#define	PTP_PG		PTP_PGMAX	/* CORRECT DEFINITION */
#define NPTPS		32		/* for each context */

/* Update error register */
#define UPD_A_USED	0x00040000	/* which compartment used last */
#define UPD_ADDR	0x0003fff0	/* address bits <17:4> */

/* Virtual DMA table constants */
#define VDMA_BASE	0x34000000
#define VDMA_INCR	0x00000004
#define VDMA_MASK	0x004007FF
#define VDMA_VALID	0x00400000
#define VDMA_INVALID	0x00000000
#define	VDMA_SHIFT	11
#define NVDMAS		2048		/* number of VDMA entries */

/* Cache Tag constants */
#define CTAG_A_BASE	0x3A000000
#define CTAG_B_BASE	0x3A800000
#define CTAG_CTL_BASE	0x3A800000
#define CTAG_INCR	0x00000010
#define CTAG_MASK	0x00107FFF
#define CTAG_VALID	0x00100000
#define CTAG_INVALID	0x00000000
#define CTAG_MATCH	0x00007FFF
#define CTAG_CTL_MASK   0x00070000
#define CTAG_A_USEDLAST	0x00040000
#define CTAG_A_DIRTY	0x00020000
#define CTAG_B_DIRTY	0x00010000
#define NCTAGS		512		/* number of Cache Tag entries */

/* Cache Data constants */
#define CDAT_A_BASE	0x3C000000
#define CDAT_B_BASE	0x3C800000
#define CDAT_INCR	0x00000004	/* increment within a line */
#define CDAT_WINCR	0x00000010	/* increment to next line */
#define CDAT_MASK	0xFFFFFFFF
#define CDAT_WIDTH	16		/* byte width of line entry */
#define CDAT_WIDTHL	4		/* long width of line entry */
#define CDAT_W_SHIFT	4		/* byte shift width of line entry */
#define NCDATS		512		/* number of Data Cache entries */
#define NCDATSL		(NCDATS*CDAT_WIDTHL)

/* 68020 ON CHIP CACHE */
#define	CCACHE_CLEAR	0x08
#define	CCACHE_CE	0x04
#define	CCACHE_FREEZE	0x02
#define	CCACHE_ENABLE	0x01

