/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)user.h	7.1 (Berkeley) 6/4/86
 */

#ifdef KERNEL
#include "../machine/pcb.h"
#include "dmap.h"
#include "time.h"
#include "resource.h"
#include "uio.h"
#else
#include <machine/pcb.h>
#include <sys/dmap.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/uio.h>
#endif

/*
 * Per process structure containing data that
 * isn't needed in core when the process is swapped out.
 */
 
#define	MAXCOMLEN	32		/* <= MAXNAMLEN, >= sizeof(ac_comm) */
 
struct	user {
	struct	pcb u_pcb;
	struct	proc *u_procp;		/* pointer to proc structure */
	int	*u_ar0;			/* address of users saved R0 */
	char	u_comm[MAXCOMLEN + 1];

/* syscall parameters, results and catches */
	int	u_arg[8];		/* arguments to current system call */
	int	*u_ap;			/* pointer to arglist */
	label_t	u_qsave;		/* for non-local gotos on interrupts */
	union {				/* syscall return values */
		struct	{
			int	R_val1;
			int	R_val2;
		} u_rv;
#define	r_val1	u_rv.R_val1
#define	r_val2	u_rv.R_val2
		off_t	r_off;
		time_t	r_time;
	} u_r;
	char	u_error;		/* return error code */
	char	u_eosys;		/* special action on end of syscall */

/* 1.1 - processes and protection */
	struct ucred {
		uid_t	cr_uid;		/* effective user id */
		gid_t	cr_gid;		/* effective group id */
		uid_t	cr_ruid;	/* real user id */
		gid_t	cr_rgid;	/* real group id */
		gid_t	cr_groups[NGROUPS];/* groups, 0 terminated */
		u_short	cr_ref;		/* reference count */
	}	*u_cred;
#define	u_uid	u_cred->cr_uid
#define	u_ruid	u_cred->cr_ruid
#define	u_gid	u_cred->cr_gid
#define	u_rgid	u_cred->cr_rgid
#define	u_groups u_cred->cr_groups

/* 1.2 - memory management */
	size_t	u_tsize;		/* text size (clicks) */
	size_t	u_dsize;		/* data size (clicks) */
	size_t	u_ssize;		/* stack size (clicks) */
	struct	dmap u_dmap;		/* disk map for data segment */
	struct	dmap u_smap;		/* disk map for stack segment */
	struct	dmap *u_cdmap;		/* tmp ptr to disk map during fork */
	struct	dmap *u_csmap;		/* tmp ptr to disk map during fork */
	label_t u_ssave;		/* label variable for swapping */
	size_t	u_odsize, u_ossize;	/* for (clumsy) expansion swaps */
	time_t	u_outime;		/* user time at last sample */

/* 1.3 - signal management */
	int	(*u_signal[MAXSIG])();	/* disposition of signals */
	int	u_sigmask[MAXSIG];	/* signals to be blocked */
	int	u_sigonstack;		/* signals to take on sigstack */
	int	u_sigintr;		/* signals that interrupt syscalls */
	int	u_oldmask;		/* saved mask from before sigpause */
	int	u_code;			/* ``code'' to trap */
	struct	sigstack u_sigstack;	/* sp & on stack state variable */
#define	u_onstack	u_sigstack.ss_onstack
#define	u_sigsp		u_sigstack.ss_sp

/* 1.4 - descriptor management */
	struct	file *u_ofile[NOFILE];	/* file structures for open files */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
	int	u_lastfile;		/* high-water mark of u_ofile */
#define	UF_EXCLOSE 	0x1		/* auto-close on exec */
#define	UF_MAPPED 	0x2		/* mapped from device */
#define UF_FDLOCK	0x4		/* file desc locked (SysV style) */
	struct	vnode	*u_cdir;	/* current directory */
	struct	vnode	*u_rdir;	/* root directory of current process */
	struct	tty	*u_ttyp;	/* controlling tty pointer */
	dev_t	u_ttyd;			/* controlling tty dev */
	short	u_cmask;		/* mask for file creation */

/* 1.5 - timing and statistics */
	struct	rusage u_ru;		/* stats for this proc */
	struct	rusage u_cru;		/* sum of stats for reaped children */
	struct	itimerval u_timer[3];
	struct	timeval u_start;
	short	u_acflag;

	struct uprof {			/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;

/* 1.6 - resource controls */
	struct	rlimit u_rlimit[RLIM_NLIMITS];
	struct	quota *u_quota;		/* user's quota structure */
	int	u_qflags;		/* per process quota flags */

/* ISI: TRFS: */
	short		u_tok;		/* trfs longjump is setup */
	label_t		u_tsave;	/* longjump buffer */
	unsigned long	u_tcurrpid;	/* if client, rpid of cousin */
	unsigned long	u_tclient;	/* if cousin, rpid of client, else 0 */
	struct pathname	*u_tpnp;	/* pointer to remote pathname */
	unsigned long	u_trcdirmid;	/* mid for remote current dir */
	unsigned long	u_trrdirmid;	/* mid for remote root dir */
	unsigned char	u_tnsend;	/* recursion count */
	unsigned char	u_tdir;		/* directory information */
#define	TCDIR	(1<<0)			/* client's remote curr dir is here */
#define	TRDIR	(1<<1)			/* client's remote root dir is here */
	unsigned long	u_trpid[NOFILE+4];
	struct uio	*u_tuio;
	struct vnode	*u_texec;	/* if cousin, vnode to load */
	unsigned short	u_tlastsendseq;	/* last NONIDEM send sequence id # */
	unsigned long	u_tlastrpid;	/* last NONIDEM rpid replied to */
	unsigned char	u_tsrcxs;
	unsigned char	u_tdstxs;

/* ISI: floating point register save areas */
	union {
	    struct {
		    short U_sky;	/* sky ffp opcode (comreg save area) */
		    long  U_skyregs[8];	/* sky fpp registers */
	    } U_SKY;
	    struct {
		    u_char U_68881_regs[8*12 + 3*4];
		    u_char U_68881_state[0xC0];
	    } U_68881;
	    struct {
		    u_char U_68882_regs[8*12 + 3*4];
		    u_char U_68882_state[0xC0 + 32];
	    } U_68882;
	} U_FLOAT;
#define	u_sky		U_FLOAT.U_SKY.U_sky
#define	u_skyregs	U_FLOAT.U_SKY.U_skyregs
#define	u_68881_state	U_FLOAT.U_68881.U_68881_state
#define	u_68881_regs	U_FLOAT.U_68881.U_68881_regs

/* ISI: GWS: */
	unsigned char	u_gip;		/* GIP used by this process */

/* ISI: SYSV: stuff */
	char	u_nshmseg;		/* ISI: SYSV: Number of shared mem */
					/* segments currently attached to */
					/* the process */
	ushort	u_magic;		/* ISI: magic number of this process */
	ushort	u_filemagic;		/* ISI: SYSV: file magic */
 	struct rem_ids {		/* ISI: SYSV: for execing REMOTE text */
 		ushort	ux_uid;		/* uid of exec'd file */
 		ushort	ux_gid;		/* group of exec'd file */
 		ushort	ux_mode;	/* file mode (set uid, etc. */
 	} u_exfile;
#define u_exuid u_exfile.ux_uid
#define u_exgid u_exfile.ux_gid
#define u_exmode u_exfile.ux_mode
					/* ISI: SYSV: for Distributed UNIX */
	ushort 		u_rflags;	/* ISI: SYSV: flags for distribution */
#define FREMOTE	0x0002		/* file is remote  */
#define RFLOCK	0x0004		/* for remote record locking*/
	struct pathname	*u_rfspnp;	/* ISI: SYSV: peculiar to RFS */
	struct cookie	u_rrcookie;	/* ISI: SYSV: pointer to remote root inode */
	int		u_mntindx;	/* ISI: SYSV: mount index from sysid */
	struct sndd	*u_gift;	/* ISI: SYSV: gift from message      */
	struct cookie	 u_newgift;	/* ISI: SYSV: cookie to be returned to client*/
	struct response	*u_copymsg;	/* ISI: SYSV: copyout unfinished stuff */
	struct msgb	*u_copybp;	/* ISI: SYSV: copyin premeditated send    */
	char 		*u_msgend;	/* ISI: SYSV: last byte of copymsg+1 */
					/* ISI: SYSV: end of Distributed UNIX */
	
	struct pregion	*u_cpreg;	/* ISI: SYSV: temporary child pregion */
	struct vnode	*u_pdir;	/* ISI: SYSV: used only by link call  */

/* ioflag values: Read/Write, User/Kernel, Ins/Data */
#define	U_WUD	0
#define	U_RUD	1
#define	U_WKD	2
#define	U_RKD	3
#define	U_WUI	4
#define	U_RUI	5

#define	EXCLOSE	01

#define	U_RCDIR		0x0001	/* remote current directory */
#define	U_RRDIR		0x0002	/* remote root directory    */
#define	U_RSYS		0x0004	/* system call has gone remote */
#define	U_LBIN		0x0100	/* dotdot at lbin mount */
#define	U_DOTDOT	0x0200
#define U_RCOPY		0x0400	/* used by copyout for non-delay copy */

/* ISI: stack firewall */
#define U_REDZONE_MAGIC	0xCACAFECE
	int	u_stack[1];
};

/* u_eosys values */
#define	JUSTRETURN	1
#define	RESTARTSYS	2
#define NORMALRETURN	3

/* u_error codes */
#ifdef KERNEL
#include "errno.h"
#else
#include <errno.h>
#endif

#ifdef KERNEL
#define	crhold(cr)	(cr)->cr_ref++
struct ucred	*crget();
struct ucred	*crcopy();
struct ucred	*crdup();

extern	struct user u;
extern	struct user swaputl;
extern	struct user forkutl;
extern	struct user xswaputl;
extern	struct user xswap2utl;
extern	struct user pushutl;
extern	struct user vfutl;
#endif
