#ifdef	SYSV
#define	NPROC	(20 + 8 * MAXUSERS)	/* KLUDGE: must match param.c! */
/*
 * SYSV System parameter formulae.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -DHZ=xx -DTIMEZONE=x -DDST=x -DMAXUSERS=xx
 */
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/socket.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/vnode.h"
#include "../h/file.h"
#include "../h/callout.h"
#include "../h/clist.h"
#include "../h/cmap.h"
#include "../h/mbuf.h"
#include "../h/kernel.h"
#include "../ufs/inode.h"
#include "../ufs/quota.h"
#include "../specfs/fifo.h"
#include "../sysv/sys/region.h"
#include "../sysv/sys/stream.h"
#include "../sysv/sys/ipc.h"
#include "../sysv/sys/msg.h"
#include "../sysv/sys/shm.h"
#include "../h/map.h"

/*
 * stream constants
 */
#define	NQUEUE 80
#define	NSTREAM 30
#define	NBLK4096 4
#define	NBLK2048 16
#define	NBLK1024 10
#define	NBLK512 40
#define	NBLK256 20
#define	NBLK128 20
#define	NBLK64 20
#define	NBLK16 20
#define	NBLK4 20
#define	NMUXLINK 20
#define	NSTRPUSH 9
#define	NSTREVENT 20
#define	MAXSEPGCNT 0
#define	STRLOFRAC 80
#define	STRMEDFRAC 90
#define	STRMSGSZ 4096
#define	STRCTLSZ 1024

#define NMBLOCK \
   NBLK4096+NBLK2048+NBLK1024+NBLK512+NBLK256+NBLK128+NBLK64+NBLK16+NBLK4 + \
   ((NBLK4096+NBLK2048+NBLK1024+NBLK512+NBLK256+NBLK128+NBLK64+NBLK16+NBLK4)/4)

#define	NDBLOCK \
   NBLK4096+NBLK2048+NBLK1024+NBLK512+NBLK256+NBLK128+NBLK64+NBLK16+NBLK4

#define	NLOG 3
#define	LOGBSIZE 60

/*
 * stream configuration info
 */

u_int streamconf [] = {
	NBLK4,
	NBLK16,
	NBLK64,
	NBLK128,
	NBLK256,
	NBLK512,
	NBLK1024,
	NBLK2048,
	NBLK4096
	};

dblk_t	*dbfreelist[NCLASS];		/* data block freelists */
struct	dbalcst dballoc[NCLASS];	/* data block allocation parameters */

queue_t			*queue,		*queueNQUEUE;
struct	stdata		*streams,	*streamsNSTREAM;
mblk_t			*mblock;
dblk_t			*dblock;
struct	linkblk		linkblk[NMUXLINK];
struct	strevent	*strevent;

int nqueue = NQUEUE;
int nstream = NSTREAM;
int nmuxlink = NMUXLINK;
int nstrpush = NSTRPUSH;
int nstrevent = NSTREVENT;
int maxsepgcnt  = MAXSEPGCNT;
int strmsgsz  = STRMSGSZ;
int strctlsz  = STRCTLSZ;
int strlofrac  = STRLOFRAC;
int strmedfrac  = STRMEDFRAC;
int nmblock  = NMBLOCK;
int ndblock  = NDBLOCK;
int nclass  = NCLASS;

int log_cnt = NLOG;
int log_bsz = LOGBSIZE;
int log_log[NLOG];

/* #ifdef	MESG	when msg is made optional */
#define	MSGMAP	100
#define	MSGMAX	8192
#define	MSGMNB	16384
#define	MSGMNI	50
#define	MSGSSZ	8
#define	MSGTQL	40
#define	MSGSEG	1024
struct map	msgmap[MSGMAP];
struct msqid_ds	msgque[MSGMNI];
char msglock[MSGMNI];
int msgmapwant;
struct msg	msgh[MSGTQL];
struct msginfo	msginfo = {
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGSSZ,
	MSGTQL,
	MSGSEG
};
/* #endif	MESG	when msg is made optional */

#define SHMMAX	0x200000	 /* max shared memory segment size */
#define SHMMIN	ctob(1)		 /* min shared memory segment size */
#define SHMMNI	20		 /* # of shared memory identifiers */
#define SHMSEG	6		 /* max attached shared memory	  */
				 /* segments per process	  */
#define SHMALL	512		 /* max total shared memory system */
				 /* wide (in clicks)		  */
#define SHLBMAX 2		/* Max shared library		 */
#define	NPROCSH (NPROC / 5)	/* number of process using shared */
				/* memory or libraries		  */

int	shmmax = SHMMAX;
int	shmmni = SHMMNI;
int	shmmin = SHMMIN;
int	shmseg = SHMSEG;
int	shmall = SHMALL;
int	shlbmax = SHLBMAX;
int	nprocsh = NPROCSH;
/*	Data structures for Semaphores		*/

#include "../sysv/sys/sem.h"

#define SEMMAP	  10
#define SEMMNI	  10
#define SEMMNS	  60
#define SEMMNU	  30
#define SEMMSL	  25
#define SEMOPM	  10
#define SEMUME	  10
#define SEMVMX	  32767
#define SEMAEM	  16384


struct	semid_ds	sema[SEMMNI];
struct	sem		sem[SEMMNS];
struct	map		semmap[SEMMAP];
struct	sem_undo	sem_undo[NPROC];
struct	sem_undo	semu[((16+8*SEMUME)*SEMMNU+NBPW-1)/NBPW]; 
union	{
	ushort			semvals[1];
	struct	semid_ds	ds;
	struct	sembuf		semops[1];
	}		 semtmp[(MAX(2*SEMMSL,MAX(0x20,8*SEMOPM))+NBPW-1)/NBPW]; 
struct seminfo seminfo = {
	SEMMAP,
	SEMMNI,
	SEMMNS,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	16+8*SEMUME,
	SEMVMX,
	SEMAEM};

#include "../sysv/sys/sysinfo.h"
struct sysinfo sysinfo;

#ifdef	RFS

#define	NTIMOPEN	20	/* # opens on the TI module */
struct tim_tim {
	long 	 tim_flags;
	queue_t	*tim_rdq;
	mblk_t  *tim_iocsave;
};

struct tim_tim tim_tim[NTIMOPEN];
int tim_cnt = NTIMOPEN;

#define	NTRWOPEN	20	/* # opens on the TIRDWR module */
struct trw_trw {
	long 	 trw_flags;
	queue_t	*trw_rdq;
	mblk_t  *trw_mp;
};

struct trw_trw trw_trw[NTRWOPEN];
int trw_cnt = NTRWOPEN;

#define	LOOP_CNT	20	/* For loop back driver */

#include	"../sysv/sys/loop.h"

struct loop loop_loop[LOOP_CNT];
int loop_cnt = LOOP_CNT;

#define RFSNET_CNT	20	/* For RFS to Ethernet driver */
#include "../sysv/sys/rfs_enet.h"
struct rfsnet rfs_net[RFSNET_CNT];
struct rfs_net_match seq_matches[RFSNET_CNT];
int rfsnet_cnt = RFSNET_CNT;
 
int	bootstate = 0;		/* DU boot flag */
short	dufstyp = 3;		/* MOUNT_RFS,DU file system switch index */
int	nservers = 0;
int	idleserver = 0;
int	msglistcnt = 0;
struct	dinfo dinfo;

/* RFS tunable constants */
#define	NADVERTISE	25
#define	NRCVD	150
#define	NSNDD	100
#define	MAXGDP	24
#define	MINSERVE	3
#define	MAXSERVE	6
#define	NRDUSER	250
#define	RFHEAP	3072
#define	RFS_VHIGH	1
#define	RFS_VLOW	1
#define	NSRMOUNT	10
#define	NRFSMOUNT	10

#include "../h/types.h"
#include "../sysv/sys/sema.h"
#undef	dequeue
/*	Dequeue is a routine defined in RFS modules
 *	A macro with same name is present in systm.h
 */
#include "../sysv/sys/comm.h"
#include "../sysv/sys/mount.h"
#include "../sysv/sys/adv.h"
#include "../sysv/sys/nserve.h"
#include "../sysv/sys/cirmgr.h"

struct	advertise advertise[NADVERTISE];
int	nadvertise = NADVERTISE;
struct	rcvd	rcvd[NRCVD];
int	nrcvd = NRCVD;
struct	sndd	sndd[NSNDD];
int	nsndd = NSNDD;
struct	gdp	gdp[MAXGDP];
int	maxgdp = MAXGDP;
int	minserve = MINSERVE;
int	maxserve = MAXSERVE;
struct	rd_user	rd_user[NRDUSER];
int	nrduser = NRDUSER;
char	rfheap[RFHEAP];
int	rfsize = RFHEAP;
int	rfs_vhigh = RFS_VHIGH;
int	rfs_vlow = RFS_VLOW;
struct	srmnt	srmount[NSRMOUNT];
int	nsrmount = NSRMOUNT;
struct	rfsmount rfsmount[NRFSMOUNT];
int	nrfsmount = NRFSMOUNT;

#endif	RFS

#ifdef	SVVS_NS

#define	LO_CNT	4
#include "../sysv/svvs/lo.h"
int locnt = LO_CNT;
struct lo lo_lo[LO_CNT];

#define	TIVC_CNT	12
#include "../sysv/svvs/tivc.h"
int tivc_cnt = TIVC_CNT;
struct ti_tivc ti_tivc[TIVC_CNT];

#define	TIDG_CNT	12
#include "../sysv/svvs/tidg.h"
int tidg_cnt = TIDG_CNT;
struct ti_tidg ti_tidg[TIDG_CNT];

#define	TMUX_CNT	4
#define	TMUXL_CNT	3
#include "../sysv/svvs/tmux.h"
int tmxcnt = TMUX_CNT;
struct tmx tmx_tmx[TMUXL_CNT];
int tmxlcnt = TMUXL_CNT;
struct tmxl tmx_low[TMUXL_CNT];

#endif	SVVS_NS
#endif	SYSV
