# include <math.h>
# include <stdio.h>

#define	MODENEAR 0
#define	MODEZERO 1
#define	MODEMININF 2
#define	MODEPLUSINF 3

#define	PRECEXTENDED 0
#define	PRECSINGLE 1
#define	PRECDOUBLE 2

int fpcrsettings = 0;		/* DEFAULTS -- mode extended, round nearest */
int ifpcrsettings = 0;		/* DEFAULTS -- mode extended, round nearest */

# ifndef MC68881
ERROR -- THIS ONLY WORKS WITH THE MC68881
# endif MC68881

/*
**	This routine sets the rounding precision and mode for floating-point
**	calculations on the MC68881.  I expect it to be used mostly for mode.
**	Changes take effect immediately; the old precision and mode are lost.
*/
setfround(prec,mode)
{
	switch(prec) {
	  case PRECEXTENDED:
	  case PRECSINGLE:
	  case PRECDOUBLE:
		break;
	  default:
		fprintf(stderr, "Illegal floating rounding precision (%d); set to default (PRECEXTENDED)\n", prec);
		prec = PRECEXTENDED;
	}

	switch(mode) {
	  case MODENEAR:
	  case MODEZERO:
	  case MODEMININF:
	  case MODEPLUSINF:
		break;
	  default:
		fprintf(stderr, "Illegal floating rounding mode (%d); set to default (MODENEAR)\n", mode);
		mode = MODENEAR;
	}

	asm("	fmovl	fpcr,_fpcrsettings");
	fpcrsettings &= 0xffffff00;
	fpcrsettings |= ((prec << 6) | (mode << 4));
	asm("	fmovl	_fpcrsettings,fpcr");
	
}

/*
**	This routine sets the rounding precision and mode for the various
**	"nearest integer" functions (nint() and its cousins) on the MC68881.
**	This routine does not affect the ordinary rounding precision and mode,
**	which will be preserved by the nint()-like functions.
**	The consequences of changing the precision here are likely very subtle.
**	NOTE: Ordinary float/double --> integer conversions will still truncate.
*/
setiround(prec,mode)
{
	switch(prec) {
	  case PRECEXTENDED:
	  case PRECSINGLE:
	  case PRECDOUBLE:
		break;
	  default:
		fprintf(stderr, "Illegal NINT rounding precision (%d); set to default (PRECEXTENDED)\n", prec);
		prec = PRECEXTENDED;
	}

	switch(mode) {
	  case MODENEAR:
	  case MODEZERO:
	  case MODEMININF:
	  case MODEPLUSINF:
		break;
	  default:
		fprintf(stderr, "Illegal NINT rounding mode (%d); set to default (MODENEAR)\n", mode);
		mode = MODENEAR;
	}

	ifpcrsettings &= 0xff;
	ifpcrsettings |= ((prec << 6) | (mode << 4));
	
}
