#ifndef	NOFLOAT
static __dummy0()
{
	asm("	.globl	_$_sprintf");
	asm("	.globl	_$_fprintf");
	asm("	.globl	_$_printf");
	asm("	.globl	_$__doprnt");
}
#endif

#include <stdio.h>

#ifndef	NOFLOAT
/*#define	QUAD	/* temporary, to help debug floating point stuff */
#define	NFDIG	350
#else
#define	NFDIG	0
#endif

int
_doprnt (fmt, argp, iop)
  register char *fmt;
  register int *argp;
  FILE *iop;
  {
	register char *p, c;
	register short count, nchar = 0, width;
	char fplus, fminus, fblank, fsharp, fzero;
	short lzero, rzero;
	char prefix, *suffix;
	char buf[20+NFDIG];
	static char htab[] = "0123456789abcdef";
	static char Htab[] = "0123456789ABCDEF";

#ifndef	NOFLOAT
	int decpt, sign;
	double f;
	char fbuf[NFDIG];
	char expbuf[8];
#endif

	for (;;) {
	    {	register short prec;

		/* Scan till '%' or null.  Output that much. */
		{	register FILE *riop = iop;
			while ((c = *fmt++) != '%') {
				if (c == '\0')
					return nchar;
				putc (c, riop);
				nchar += 1;
			}
		}

		fplus = fminus = fblank = fsharp = fzero = 0;
  fscan:
		switch (c = *fmt++) {
		  case '+':	fplus += 1; goto fscan;
		  case '-':	fminus += 1; goto fscan;
		  case ' ':	fblank += 1; goto fscan;
		  case '#':	fsharp += 1; goto fscan;
		  case '0':	fzero += 1; goto fscan;
		}

		/* Now comes a digit string which may be a '*' */
		if (c == '*') {
			if ((width = *argp++) < 0) {
				width = -width;
				fminus += 1;
			}
			c = *fmt++;
		} else {
			width = 0;
			while (c >= '0' && c <= '9') {
				width = width * 10 + (c - '0');
				c = *fmt++;
			}
		}

		/* maybe a decimal point followed by more digits (or '*') */
		if (c == '.') {
			if ((c = *fmt++) == '*') {
				prec = *argp++;
				c = *fmt++;
			} else {
				prec = 0;
				while (c >= '0' && c <= '9') {
					prec = prec * 10 + (c - '0');
					c = *fmt++;
				}
			}
		} else
			prec = -1;
		
		if (c == 'l'  ||  c == 'h')
			c = *fmt++;

		prefix = lzero = rzero = 0;
		suffix = "";
		/* This switch statement must set up p and count. */
		count = 0;
		switch (c) {

		  case 'c':
			if (prec < 0)
				prec = 1;
			if (fzero  &&  width > prec)
				prec = width;
			*(p = buf) = (char)*argp++;
			count = 1;
			lzero = prec - count;
			break;

		  case 's':
			p = (char *)*argp++;
			{
				register char *q = p;
				while (*q++  &&  ++count != prec)
					;
			}
			break;

		  case 'd':
		  case 'D':
			{
				register i = *argp++, j;

				if (prec < 0)
					prec = 1;
				width -= 1;	/* to allow for prefix */
				if (i < 0) {
					prefix = '-';
					i = -i;
				} else if (fplus)
					prefix = '+';
				else if (fblank)
					prefix = ' ';
				else
					width += 1;  /* no prefix after all */
				if (fzero  &&  width > prec)
					prec = width;
				p = &buf[sizeof buf];
/*
**	At first glance it appears that i cannot be zero here, but it can.
**	For instance, negating 0x80000000 gives 0x80000000, which is still < 0.
**	This fix allows such large negative numbers to print correctly -WAT-
*/
				if (i < 0) {
					register unsigned k,l;

					k = i;
					while (l = k)
						*--p = l - ((k /= 10)*10) + '0';
				}
				else
					while (j = i)
						*--p = j - ((i /= 10)*10) + '0';
				count = &buf[sizeof buf] - p;
				lzero = prec - count;
			}
			break;

		  case 'x':
		  case 'X':
			{
				register unsigned n = (unsigned)*argp++;
				register char *tab;

				if (c == 'X')
					tab = Htab;
				else
					tab = htab;
				if (prec < 0)
					prec = 1;
				if (fzero  &&  width > prec)
					prec = width;
				p = &buf[sizeof buf];
				while (n) {
					*--p = tab[n & 0xF];
					n >>= 4;
				}
				count = &buf[sizeof buf] - p;
				lzero = prec - count;
				if (fsharp  &&  count) {
					prefix = c;
					width -= 2;
				}
			}
			break;

#ifdef	QUAD
		  case 'q':
		  case 'Q':
			{
				register unsigned n, m;
				register char *tab;

				if (c == 'Q')
					tab = Htab;
				else
					tab = htab;

				m = (unsigned)*argp++;
				n = (unsigned)*argp++;
				if (prec < 0)
					prec = 1;
				if (fzero  &&  width > prec)
					prec = width;
				p = &buf[sizeof buf];
				while (n | m) {
					*--p = tab[n & 0xF];
					n = n >> 4 | (m << 28);
					m >>= 4;
				}
				count = &buf[sizeof buf] - p;
				lzero = prec - count;
				if (fsharp  &&  count) {
					prefix = (c == 'Q' ? 'X' : 'x');
					width -= 2;
				}
			}
			break;
#endif

		  case 'u':
		  case 'U':
			{
				register unsigned n = (unsigned)*argp++, m;

				if (prec < 0)
					prec = 1;
				if (fzero  &&  width > prec)
					prec = width;
				p = &buf[sizeof buf];
				while (m = n)
					*--p = m - ((n /= 10) * 10) + '0';
				count = &buf[sizeof buf] - p;
				lzero = prec - count;
			}
			break;

		  case 'o':
		  case 'O':
			{
				register unsigned n = (unsigned)*argp++;
				if (prec < 0)
					prec = 1;
				if (fzero  &&  width > prec)
					prec = width;
				p = &buf[sizeof buf];
				while (n) {
					*--p = (n & 07) + '0';
					n >>= 3;
				}
				count = &buf[sizeof buf] - p;
				lzero = prec - count;
				if (fsharp  &&  count  &&  lzero < 1)
					lzero = 1;
			}
			break;

#ifndef	NOFLOAT
		  case 'e':
		  case 'E':
			if (prec < 0)
				prec = 6;
			if (count = cvt((f = *(double *)argp), prec + 1,
			  &decpt, &sign, 1, fbuf)) {
				prefix = lzero = rzero = 0;
				suffix = "";
				argp += sizeof (double) / sizeof (*argp);
				p = fbuf;
				break;
			}
			argp += sizeof (double) / sizeof (*argp);
  e_format:
			{
				register char *q = fbuf;
				register short i;

				width -= 1;
				if (sign)
					prefix = '-';
				else if (fplus)
					prefix = '+';
				else if (fblank)
					prefix = ' ';
				else
					width += 1;
				p = buf;
				*p++ = *q == '\0' ? '0' : *q++;
				if ((i = prec) != 0  ||  fsharp)
					*p++ = '.';
				while (i > 0  &&  *q != '\0') {
					--i;
					*p++ = *q++;
				}
				rzero = i;
				count = p - buf;
				p = buf;

				suffix = q = expbuf;
				*q = c;
				if ((i = (f == 0) ? 0 : decpt - 1) < 0) {
					i = -i;
					*++q = '-';
				} else
					*++q = '+';
				if (i >= 100) {
					q += 4;
					*q = '\0';
					*--q = i % 10 + '0';
					i /= 10;
					width--;
				}
				else {
					q += 3;
					*q = '\0';
				}
				*--q = i % 10 + '0';
				i /= 10;
				*--q = i + '0';
				width -= 4;
			}
			break;

		  case 'f':
			if (prec < 0)
				prec = 6;
			if (count = cvt(*(double *)argp, prec,
			  &decpt, &sign, 0, fbuf)) {
				prefix = lzero = rzero = 0;
				suffix = "";
				argp += sizeof (double) / sizeof (*argp);
				p = fbuf;
				break;
			}
			argp += sizeof (double) / sizeof (*argp);
  f_format:
			{
				register char *q = fbuf;
				register short i, j;

				width -= 1;
				if (sign  &&  decpt > -prec  &&
				    *q != '\0'  &&  *q != '0')
					prefix = '-';
				else if (fplus)
					prefix = '+';
				else if (fblank)
					prefix = ' ';
				else
					width += 1;
				p = buf;
				if ((i = decpt) <= 0)
					*p++ = '0';
				else
					do
						*p++ = *q == '\0' ? '0' : *q++;
					while (--i);
				if ((i = prec) > 0  ||  fsharp)
					*p++ = '.';
				j = decpt; /* This was inside loop.  HA! */
				while (--i >= 0  &&  p < &buf[sizeof buf] - 1) {
					*p++ = (++j <= 0  ||  *q == '\0') ?
						'0' : *q++;
				}
				count = p - buf;
				if (fzero  &&  width > prec)
					prec = width;
				lzero = prec - count;
				p = buf;
			}
			break;

		  case 'g':
			{
				register char *q = fbuf;
				register short i, j;

				if (prec < 0)
					prec = 6;
				if (count = cvt((f = *(double *)argp), prec,
				  &decpt, &sign, 1, q)) {
					prefix = lzero = rzero = 0;
					suffix = "";
					argp += sizeof(double) / sizeof(*argp);
					p = q;
					break;
				}
				argp += sizeof (double) / sizeof (*argp);
				if (f == 0)
					decpt = 1;
				i = prec;
				p = q;
				while (*p++)
					;
				if ((j = p - 1 - q) < i)
					i = j;
				while (--i >= 0  &&  q[i] == '0')
					;
				i++;
				if (decpt < -4  ||  decpt > prec) {
					prec = i - 1;
					c -= 'g' - 'e';
					goto e_format;
				} else {
					prec = i - decpt;
					goto f_format;
				}
			}
			break;
#endif

		  case '\0':
			fmt -= 1;
			continue;

		  default:
			*(p = buf) = c;
			count = 1;
			break;
		}
	    }

	    {	register FILE *riop = iop;
		register short i;

		width -= count;
		if ((i = rzero) > 0)
			width -= i;
		if ((i = lzero) > 0)
			width -= i;

		if (!fminus) {
			c = ' ';
			while (--width >= 0) {
				putc (c, riop);
				nchar += 1;
			}
		}

		if (c = prefix) {
			if (c == 'x'  ||  c == 'X') {
				putc ('0', riop);
				nchar += 1;
			}
			putc (c, riop);
			nchar += 1;
		}

		i = lzero;
		c = '0';
		while (--i >= 0) {
			putc (c, riop);
			nchar += 1;
		}

		while (--count >= 0) {
			putc (*p++, riop);
			nchar += 1;
		}

		i = rzero;
		c = '0';
		while (--i >= 0) {
			putc (c, riop);
			nchar += 1;
		}

		p = suffix;
		while (c = *p++) {
			putc (c, riop);
			nchar += 1;
		}

		if (fminus) {
			c = ' ';
			while (--width >= 0) {
				putc (c, riop);
				nchar += 1;
			}
		}
	    }
	}
}

#ifndef	NOFLOAT
/*
**	In the IEEE and SKY cases, cvt now returns a non-zero value if it
**	detects a NaN or Inf.  Thus printf will now print out NaN, Inf,
**	or -Inf, as appropriate.  There may be some who don't like this, but
**	it's better than what used to happen (i.e., printf would hang on
**	NaN and Inf). -WAT-
*/

static	__dummy()
{
	asm("	.globl fltused;  fltused:");
}

cvt (arg, ndigits, decpt, sign, eflag, buf)
  double arg;
  register short ndigits;
  register int *decpt;
  int *sign;
  register char *buf;
  {
	register short r2;
	double fi, fj;
	register char *p, *p1;
	double modf();

# ifdef IEEE
	if ((*(int *)&arg & 0x7ff00000) == 0x7ff00000) {
		if (((*(int *)&arg & 0xfffff)==0) && (*((int *)&arg + 1)==0)) {
			if (*(int *)&arg > 0) {
				strcpy(buf, "Inf");
				return 4;
			}
			else {
				strcpy(buf, "-Inf");
				return 5;
			}
		}
		else {
			strcpy(buf, "NaN");
			return 4;
		}
	}
# endif IEEE

	if (ndigits<0)
		ndigits = 0;
	if (ndigits>=NFDIG-1)
		ndigits = NFDIG-2;
	r2 = 0;
	*sign = 0;
	p = &buf[0];
	if (arg<0) {
		*sign = 1;
		arg = -arg;
	}
	arg = modf(arg, &fi);
	p1 = &buf[NFDIG];
	/*
	 * Do integer part
	 */
	if (fi != 0) {
		while (fi != 0) {
			fj = modf(fi/10, &fi);
			*--p1 = (int)((fj+.03)*10) + '0';
			r2++;
		}
		while (p1 < &buf[NFDIG])
			*p++ = *p1++;
	} else if (arg > 0) {
		while ((fj = arg*10) < 1) {
			arg = fj;
			r2--;
		}
	}
	p1 = &buf[ndigits];
	if (eflag==0)
		p1 += r2;
	*decpt = r2;
	if (p1 < &buf[0]) {
		buf[0] = '\0';
		return 0;
	}
	while (p<=p1 && p<&buf[NFDIG]) {
		arg *= 10;
		arg = modf(arg, &fj);
		*p++ = (int)fj + '0';
	}
	if (p1 >= &buf[NFDIG]) {
		buf[NFDIG-1] = '\0';
		return 0;
	}
	p = p1;
	*p1 += 5;
	while (*p1 > '9') {
		*p1 = '0';
		if (p1>buf)
			++*--p1;
		else {
			*p1 = '1';
			(*decpt)++;
			if (eflag==0) {
				if (p>buf)
					*p = '0';
				p++;
			}
		}
	}
	*p = '\0';
	return 0;
}

#endif
