/*	strcat.s	4.2	83/11/22	*/

/* strcat(s0, s1)
 * Concatenate s1 on end of s0.  s0's space must be large enough.
 * Returns s0.
 */

/*
 * char *
 * strcat(s0, s1)
 * register char *s0, *s1;
 * {
 *         register char *os0;
 * 
 *         os0 = s0;
 *         while (*s0++)
 *                 ;
 *         --s0;
 *         while (*s0++ = *s1++)
 *                 ;
 *         return(os0);
 * }
 */

#include "DEFS.h"

ENTRY(strcat)
	movl	sp@(4),a0	/* s0: dest */
	movl	sp@(8),a1	/* s1: source */
	movl	a0,d0		/* set return value before we lose it */
	movq	#-1,d1		/* dummy counter for dbcc */

    1:	tstb	a0@+		/* scan for terminating null */
	dbeq	d1,1b
	jne	1b		/* wow, still more */
	subql	#1,a0		/* back up to point at terminating null */

    2:	movb	a1@+,a0@+	/* copy string, including terminating null */
	dbeq	d1,2b
	jne	2b		/* wow, still more */
	rts
