/* signed long multiply: c = a * b */

#include "DEFS.h"

ASENTRY(lmul)
	tstb	is68020		/* test for 68020 */
	jeq	2f
	movl	sp@(4),d0
	mulsl	sp@(8),d0	/* 68020 instruction */
	rts

    2:	moveml	#0x3800,sp@-	/* save d2,d3,d4 */
	movl	sp@(16),d2	/*  d2 = a */
	movl	d2,d4		/* sign of result */
	jge	1f
	negl	d2
    1:	movl	sp@(20),d3	/*  d3 = a */
	jge	2f
	negl	d3
	negl	d4
    2:	movw	d2,d0		/* d0 = alo, unsigned */
	mulu	d3,d0		/* d0 = blo*alo, unsigned */
	movw	d2,d1		/* d1 = alo */
	swap	d2		/* swap alo-ahi */

	movw	d2,d2		/* check for zero ahi  */
	jne	4f		/* ahi not zero; do the multiply  */
	swap	d3		/* swap blo-bhi  */
	movw	d3,d3		/* check for zero bhi  */
	jeq	6f		/* if bhi also zero, we're done  */
	mulu	d3,d1		/* d1 = bhi*alo, unsigned  */
	jmp	7f		/* go put result together  */

    4:	mulu	d3,d2		/* d2 = blo*ahi, unsigned */
	swap	d3		/* swap blo-bhi */

	movw	d3,d3		/* check for zero bhi  */
	jne	5f		/* bhi not zero; do the multiply  */
	movl	d2,d1		/* no add; put result in right place  */
	jmp	7f		/* skip multiply and add  */

    5:	mulu	d3,d1		/* d1 = bhi*alo, unsigned */
	addl	d2,d1		/* d1 = (ahi*blo + alo*bhi) */

    7:	swap	d1		/* d1 = */
	clrw	d1		/*    (ahi*blo + alo*bhi)*(2**16) */
	addl	d1,d0		/* d0 = alo*blo + (ahi*blo + alo*bhi)*(2**16) */

    6:	tstl	d4		/* sign of result */
	jge	3f
	negl	d0
    3:	moveml	sp@+,#0x001C	/* restore d2,d3,d4 */
	rts
