/**/
/*	68000 SUPPORT LIBRARY						*/
/*	COPYRIGHT 1984 GREEN HILLS SOFTWARE				*/
/*	MAY 28, 1984							*/
/*	32 REMAINDER,DIVIDE, AND MULTIPLY PACKAGE			*/
/**/ 
/*	THIS PACKAGE IS DIVIDED INTO TWO PARTS. 			*/
/*	ALL REMAINDERS AND DIVIDES ARE DONE WITH ENTRY			*/
/*	POINTS TO A 32 BIT DIVIDE/REMAINDER ROUTINE.			*/
/*	THIS PACKAGE USES a0,a1,d0,d1,d2.				*/
/**/
/*	UNSIGNED AND SIGNED 32 BIT MULTIPLIES ARE IDENTICAL, 		*/
/*	AND ARE PERFORMED BY THE SAME ROUTINE. THIS ROUTINE		*/
/*	USES d0,d1,d2, AND a0.						*/
/**/
/*	32 BIT REMAINDER AND DIVIDE ROUTINE 				*/
/*	PARAMETERS IN d1 AND d2						*/
/*	THIS PACKAGE HAS BEEN TESTED ON 5000 RANDOM NUMBER 		*/
/*	PAIRS AGAINST THE VAX. THE NUMBER GENERATION SCHEME		*/
/*	GENERATED NUMBERS OF SIZE 1-32 BITS RANDOMLY, AND SHOULD	*/
/*	THEREFORE HAVE EXERCISED MOST CODE PATHS.			*/
/**/
/*	COMMENTS AND SUGGESTIONS FOR IMPROVEMENTS ARE WELCOME. 		*/

    9:	cmpl	#0xFFFF,d2	/* DIVISOR MORE THAN 16 BITS OF SIGNIF?	*/
	jhi	8f		/* YES, GOTO ITERATION DIVIDE		*/
	movw	d1,a1		/* STANDARD 32/16 DIVIDE WITHOUT LOSS 	*/
	clrw	d1
	swap	d1
	divu	d2,d1
	movl	d1,d0
	swap	d1
	movw	a1,d0
	divu	d2,d0
	movw	d0,d1
	clrw	d0
	swap	d0
	rts

    8:	movl	d1,d0
	clrw	d0
	swap	d0
	swap	d1
	clrw	d1
	movl	d2,a1
	moveq	#0xF,d2
    7:	addl	d1,d1		/* BEGIN DIVIDE BY ITERATION */
	addxl	d0,d0
	cmpl	d0,a1
	jhi	6f
	subl	a1,d0
	addqw	#1,d1
    6:	dbf	d2,7b
	rts

/* lmul, ulmul */
/* 32 BIT MULTIPLY ROUTINES */
	.globl	lmult
	.globl	ulmult
lmult:
ulmult:
	tstb	is68020		/* test for 68020 */
	jeq	1f
	mulsl	d1,d0
	rts
    1:	movl	d2,sp@-	/* SAVE d2 REGISTER */
	movl	d0,d2
	mulu	d1,d2
	movl	d2,a0
	movl	d0,d2
	swap	d2
	mulu	d1,d2
	swap	d1
	mulu	d1,d0
	addl	d2,d0
	swap	d0
	clrw	d0
	addl	d0,a0
	movl	a0,d0
	movl	sp@+,d2
	rts

/*	ulmodt */
/*	UNSIGNED 32 BIT REMAINDER  */
	.globl	ulmodt
ulmodt:	
	tstb	is68020		/* test for 68020 */
	jeq	1f
	exg	d0,d1
    	divull	d0,d0:d1	/* 68020 instruction */
	rts
    1:	movl	d2,sp@-		/* SAVE d2 */
	movl	d1,d2		/* SETUP PARAMETERS */
	movl	d0,d1
	jsr	9b		/* CALL UNSIGNED DIV/REM ROUTINE */
	movl	sp@+,d2		/* RESTORE d2 */
	rts

/*	uldiv */
/*	UNSIGNED 32 BIT DIVIDE */
	.globl	uldivt
uldivt:
	tstb	is68020		/* test for 68020 */
	jeq	1f
    	divul	d1,d0		/* 68020 instruction */
	rts
    1:	movl	d2,sp@-		/* SAVE d2 AND d3 */
	movl	d1,d2
	movl	d0,d1		/* LOAD UP PARAMETERS */
	jsr	9b
	movl	d1,d0
	movl	sp@+,d2
	rts

/*	lrem */
/*	SIGNED 32 BIT REMAINDER */
/*	IF DIVISOR IS NEGATIVE, RESULT IS NEGATIVE. */
	.globl	lmodt
lmodt:
	tstb	is68020		/* test for 68020 */
	jeq	1f
	exg	d0,d1
    	divsll	d0,d0:d1	/* 68020 instruction */
	rts
    1:	movl	d2,sp@-	/* SAVE d2 */
	movl	d1,d2
	jge	1f
	negl	d2
    1:	movl	d0,d1
	moveq	#0,d0		/* NEGATION FLAG OFF */
	tstl	d1
	jge	2f
	negl	d1
	notl	d0		/* NEGATION FLAG ON */
    2:	movl	d0,a0		/* MOVE FLAG TO A SAFE PLACE */
	jsr	9b
	movw	a0,d2
	jeq	3f
	negl	d0
    3:	movl sp@+,d2	/* RESTORE d2  */
	rts

/**/
/*	ldivt	 */
/*	SIGNED 32 BIT DIVIDE */
/*	IF DIVIDEND XOR DIVISOR IS NEGATIVE,*/
/*	RESULT MUST BE NEGATIVE. */
	.globl	ldivt
ldivt:
	tstb	is68020		/* test for 68020 */
	jeq	1f
    	divsl	d1,d0		/* 68020 instruction */
	rts
    1:	movl	d2,sp@-
	movl	d0,a0
	moveq	#0,d0
	movl	d1,d2
	jge	1f
	negl	d2		/* NEGATE OPERAND */
	notl	d0
    1:	movl	a0,d1
	jge	2f
	negl	d1		/* NEGATE OPERAND */
	notl	d0
    2:	movl	d0,a0		/* TUCK AWAY NEGATION FLAG */
	jsr	9b
	movl	a0,d2
	jeq	3f
	negl	d1
    3:	movl	d1,d0
	movl	sp@+,d2
	rts
