/*
 *	ISI: libgip defines
 */
#include <vt.h>

extern char *GIP_Error;
extern short *screen;

#define GIPclear	0
#define GIPand		1
#define GIPandReverse	2
#define GIPcopy		3
#define GIPandInverted	4
#define GIPnoop		5
#define GIPxor		6
#define GIPor		7
#define GIPnor		8
#define GIPequiv	9
#define GIPinvert	10
#define GIPorReverse	11
#define GIPcopyInverted	12
#define GIPorInverted	13
#define GIPnand		14
#define GIPset		15

#ifndef NOGIPSTRUCTS
typedef	struct _pixmap {
	short	width;		/* in pixels */
	short	height;		/* in pixels */
	short	refcnt;		/* reference count */
	char	tile;		/* 0: not a tile, 1: tile (pattern) */
	char	kind;		/* XY-FORMAT, Z-FORMAT, and # of planes */
	RASTER  *data;		/* ptr to an array of rasters */
} PIXMAP;
#endif NOGIPSTRUCTS

/* defines for the PIXMAP kind field */
#define XYFORMAT	(0x80)
#define ZFORMAT		(0x40)
#define CONSTANT	(0x20)
#define NPLANEMASK	(0x0f)	/* note max # of planes is 16 (ok for X!) */

#ifndef NOGIPSTRUCTS
typedef	struct _bitmap {
	short	width;		/* in pixels */
	short	height;		/* in pixels */
	short	refcnt;		/* reference count */
	char	kind;		/* unused  */
	RASTER  *data;		/* ptr to an array of rasters */
} BITMAP;
#endif NOGIPSTRUCTS

extern PIXMAP ScreenPixmap;
extern short  *gpfifo;
