#include <stdio.h>

#include <sys/param.h>		/**/
#include <sys/systm.h>		/**/
#include <sys/dk.h>		/**/
#include <sys/dkbad.h>		/**/
#include <sys/buf.h>		/**/
#include <sys/conf.h>		/**/
#include <sys/user.h>		/**/
#include <sys/map.h>		/**/
#include <sys/vm.h>		/**/
#include <sys/cmap.h>		/**/
#include <sys/uio.h>		/**/
#include <sys/kernel.h>		/**/
#include <sys/syslog.h>		/**/
#include <sys/types.h>		/**/
#include <sys/ioctl.h>		/**/
#include <is68kdev/qbvar.h>	/**/
#include <disktab.h>

struct disktab disktab;

struct flag {
	char	*name;
	int	on;
	int	*value;
} flags[] = {
	{ "nc", 0, &disktab.d_ncylinders },
	{ "nt", 0, &disktab.d_ntracks },
	{ "ns", 0, &disktab.d_nsectors },
	{ "pa", 0, &disktab.d_partitions[0].p_size },
	{ "pb", 0, &disktab.d_partitions[1].p_size },
	{ "pc", 0, &disktab.d_partitions[2].p_size },
	{ "pd", 0, &disktab.d_partitions[3].p_size },
	{ "pe", 0, &disktab.d_partitions[4].p_size },
	{ "pf", 0, &disktab.d_partitions[5].p_size },
	{ "pg", 0, &disktab.d_partitions[6].p_size },
	{ "ph", 0, &disktab.d_partitions[7].p_size },
	{ "ba", 0, &disktab.d_partitions[0].p_bsize },
	{ "bb", 0, &disktab.d_partitions[1].p_bsize },
	{ "bc", 0, &disktab.d_partitions[2].p_bsize },
	{ "bd", 0, &disktab.d_partitions[3].p_bsize },
	{ "be", 0, &disktab.d_partitions[4].p_bsize },
	{ "bf", 0, &disktab.d_partitions[5].p_bsize },
	{ "bg", 0, &disktab.d_partitions[6].p_bsize },
	{ "bh", 0, &disktab.d_partitions[7].p_bsize },
	{ "fa", 0, &disktab.d_partitions[0].p_fsize },
	{ "fb", 0, &disktab.d_partitions[1].p_fsize },
	{ "fc", 0, &disktab.d_partitions[2].p_fsize },
	{ "fd", 0, &disktab.d_partitions[3].p_fsize },
	{ "fe", 0, &disktab.d_partitions[4].p_fsize },
	{ "ff", 0, &disktab.d_partitions[5].p_fsize },
	{ "fg", 0, &disktab.d_partitions[6].p_fsize },
	{ "fh", 0, &disktab.d_partitions[7].p_fsize },
	{ "oa", 0, &disktab.d_partitions[0].p_offset },
	{ "ob", 0, &disktab.d_partitions[1].p_offset },
	{ "oc", 0, &disktab.d_partitions[2].p_offset },
	{ "od", 0, &disktab.d_partitions[3].p_offset },
	{ "oe", 0, &disktab.d_partitions[4].p_offset },
	{ "of", 0, &disktab.d_partitions[5].p_offset },
	{ "og", 0, &disktab.d_partitions[6].p_offset },
	{ "oh", 0, &disktab.d_partitions[7].p_offset },
};
#define NFLAGS	(sizeof(flags)/sizeof(struct flag))

int	anyflag=0;
int	terseflag=0;
int	quietflag=0;

main(ac, av)
int	ac;
char	*av[];
{
	int	i;
	char	name[100];

	if ( ac < 2 )
		usage();
	--ac, ++av;
	while ( ac ) {
		if ( strcmp("-t", *av) == 0 ) {
			terseflag++;
			anyflag++;
		}
		else if ( strcmp("-q", *av) == 0 ) {
			quietflag++;
			anyflag++;
		}
		else if ( **av == '-' ) {
			for (i=0; i<NFLAGS; ++i)
				if (strcmp(&av[0][1], flags[i].name) == 0) {
					flags[i].on++;
					anyflag++;
				}
		}
		else if ( **av == '/' )
			strcpy(name, *av);
		else {
			strcpy(name, "/dev/r");
			strcat(name, *av);
			strcat(name, "a");
		}
		--ac, ++av;
	}
	return(showst(name));
}

showst(d)
char	*d;
{
	int	fd, i;
	struct qb_diskst		diskst;
	register struct qb_diskst	*st = &diskst;

	fd = open(d, 0);
	if ( fd < 0 ) {
		if ( ! quietflag )
			perror(d);
		return(1);
	}
	if (ioctl(fd, DIOCGGEO, st) < 0 ) {
		if ( ! quietflag )
			perror(d);
		return(1);
	}
	mapinfo(&disktab, st);

	if ( anyflag == 0 ) {
		printf("ntracks    =%d\n", disktab.d_ntracks);
		printf("nsectors   =%d\n", disktab.d_nsectors);
		printf("ncylinders =%d\n", disktab.d_ncylinders);
		for(i=0; i<=7; ++i)
			printf("partition %c: size=%d, offset=%d\n",
		    	i+'a', disktab.d_partitions[i].p_size,
			    disktab.d_partitions[i].p_offset);
	}
	else if ( terseflag ) {
		printf("nt=%d\n", disktab.d_ntracks);
		printf("ns=%d\n", disktab.d_nsectors);
		printf("nc=%d\n", disktab.d_ncylinders);
		for(i=0; i<=7; ++i)
			printf("p%c=%d\n", i+'a',
			    disktab.d_partitions[i].p_size);
	}
	else if ( ! quietflag ) {
		for ( i=0; i<NFLAGS; ++i )
			if ( flags[i].on )
				printf("%s=%d\n", flags[i].name, *flags[i].value);
	}
	return(0);
}

mapinfo(dtp, st)
struct disktab		*dtp;
struct qb_diskst	*st;
{
	int	i;

	dtp->d_ntracks = ST_ntpc;
	dtp->d_nsectors = ST_nspt;
	dtp->d_ncylinders = ST_ncpd;
	for ( i=0; i<8; ++i ) {
		dtp->d_partitions[i].p_size = ST_size[i].nblocks;
		dtp->d_partitions[i].p_offset = ST_size[i].cyloff;
	}

}

usage()
{
	printf("usage: diskst <partition>\n\n");
	exit(1);
}
