#include	<is68k/cpu.h>

/* MUST MATCH machine/cpu.h DEFINITIONS!!! */
struct options {
	char	*op_name;
	int	op_mask;
	int	op_shift;
	char	*op_val[10];		/* KLUDGE number of selections */
} options[] = {
    {"SPEED",       0x00000007,  0, "UNSPEC", "8", "10", "11.1",
       "12", "16.67", "25", "33.3"},
    {"CPU",         0x00000038,	 3, "68010",  "68020",},
    {"COPROCESSOR", 0x000001C0,	 6, "NONE",   "68881", "SKY", "68881SKY",},
    {"BUS",         0x00000E00,	 9, "UNSPEC", "QBUS", "VMEBUS",},
    {"GRAPHICS",    0x00001000,	12, "FALSE",  "TRUE",},
    {"CLUSTER",     0x00002000,	13, "FALSE",  "TRUE",},
    {"DISKLESS",    0x00004000,	14, "FALSE",  "TRUE",},
    {"TRFS",        0x00008000,	15, "FALSE",  "TRUE",},
    {"NFS",         0x00010000,	16, "FALSE",  "TRUE",},
    {"SYSV",        0x00020000,	17, "FALSE",  "TRUE",},
    {0,             0,           0, 0,},
};

main(argc, argv)
char *argv[];
{
	struct options *op;
	char *s;
	register int type, i;

	type = getmachtype();

	if (argc == 2 || argc ==3 ) {
	    for (op = options; op->op_name; op++)
		if (strcmp(op->op_name, argv[1]) == 0) {
		    s = op->op_val[(type&op->op_mask)>>op->op_shift];
		    if (argc == 3) {
 			if (strcmp(s, argv[2]) == 0)
			    printf("TRUE\n");
			else
			    printf("FALSE\n");
		    }
		    else
			printf("%s\n", s);
		    exit(0);
		}
	    printf("machtype: unknown option '%s'\n", argv[1]);
	} else
	    for (op = options; op->op_name; op++) {
		printf("%16s  %s\n", op->op_name, 
			op->op_val[(type&op->op_mask)>>op->op_shift]);
	    }
}
