static	char *sccsid = "@(#)kill.c	4.4 (Berkeley) 4/20/86";
/*
 * kill - send signal to process
 */

#include <signal.h>
#include <ctype.h>

char *signm[] = { 0,
"HUP", "INT", "QUIT", "ILL", "TRAP", "IOT", "EMT", "FPE",	/* 1-8 */
"KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG",	/* 9-16 */
"STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU",	/* 17-24 */
#ifdef	is68k
"XFSZ", "VTALRM", "PROF", "WINCH", "USR2", "LOST", "USR1", 0,	/* 25-32 */
#else	is68k
"XFSZ", "VTALRM", "PROF", "WINCH", 0, "USR1", "USR2", 0,	/* 25-32 */
#endif	is68k
};

#ifdef	is68k
char *isi_signm[] = { 0,
0, 0, 0, 0, 0, 0, 0, 0,	/* 1-8 */
0, 0, 0, 0, 0, 0, 0, 0,	/* 9-16 */
0, 0, 0, 0, 0, 0, 0, 0,	/* 17-24 */
0, 0, 0, "REF", "ADJ", 0, 0, 0,	/* 25-32 */
};
#endif	is68k
char *cmdname;

main(argc, argv)
char **argv;
{
	register signo, pid, res;
	int errlev;
	extern char *sys_errlist[];
	extern errno;
	char *rindex();

	if ((cmdname = rindex(argv[0],'/')) == 0)
		cmdname = argv[0];
	else
		cmdname++;
	errlev = 0;
	if (argc <= 1) {
	usage:
		printf("usage: %s [ -sig ] pid ...\n", cmdname);
		printf("for a list of signals: %s -l\n", cmdname);
		exit(2);
	}
	if (*argv[1] == '-') {
		if (argv[1][1] == 'l') {
			for (signo = 0; signo <= NSIG; signo++) {
				if (signm[signo])
					printf("%s ", signm[signo]);
				if (signo == 16)
					printf("\n");
			}
			printf("\n");
			exit(0);
		} else if (isdigit(argv[1][1])) {
			signo = atoi(argv[1]+1);
			if (signo < 0 || signo > NSIG) {
				printf("%s: %s: number out of range\n", cmdname,
				    argv[1]);
				exit(1);
			}
		} else {
			char *name = argv[1]+1;
			for (signo = 0; signo <= NSIG; signo++)
				if (signm[signo] && !strcmp(signm[signo], name))
					goto foundsig;
#ifdef	is68k
			for (signo = 0; signo <= NSIG; signo++)
				if (isi_signm[signo] && !strcmp(isi_signm[signo], name))
					goto foundsig;
#endif	is68k
			printf("%s: %s: unknown signal; %s -l lists signals\n", cmdname, name, cmdname);
			exit(1);
foundsig:
			;
		}
		argc--;
		argv++;
	} else
		signo = SIGTERM;
	argv++;
	while (argc > 1) {
		if (!(isdigit(**argv) || **argv == '-'))
			goto usage;
		pid = atoi(*argv);
		if (strcmp(cmdname, "killpg") == 0)
			res = killpg(getpgrp(pid), signo);
		else
			res = kill(pid, signo);
		if (res<0) {
			printf("%s: %u: %s\n", cmdname, pid, sys_errlist[errno]);
			errlev = 1;
		}
		argc--;
		argv++;
	}
	return(errlev);
}
