static char *RCSid = "$Header: doprnt.c,v 1.1 86/02/28 15:33:43 root Exp $";

/*
 * $Log:	doprnt.c,v $
 * Revision 1.1  86/02/28  15:33:43  root
 * Initial revision
 * 
 */

_doprnt (fmt, argp, iop)
  register char *fmt;
  register int *argp;
  {
	register char *p, c;
	register short count, width;
	char fminus, fzero;
	char buf[20];
	static char *htab = "0123456789abcdef";
	static char *Htab = "0123456789ABCDEF";

	for (;;) {
		register short prec;

		/* Scan till '%' or null.  Output that much. */
		p = fmt;
		while ((c = *fmt++) != '%') {
			if (c == '\0') {
				_strout(fmt - p - 1, p, 0, 0, 0);
				return;
			}
		}
		_strout(fmt - p - 1, p, 0, 0, 0);

		fminus = fzero = 0;
  fscan:
		switch (c = *fmt++) {
		  case '-':	fminus += 1; goto fscan;
		  case '0':	fzero += 1; goto fscan;
		}

		/* Now comes a digit string which may be a '*' */
		if (c == '*') {
			if ((width = *argp++) < 0) {
				width = -width;
				fminus += 1;
			}
			c = *fmt++;
		} else {
			width = 0;
			while (c >= '0' && c <= '9') {
				width = width * 10 + (c - '0');
				c = *fmt++;
			}
		}

		/* maybe a decimal point followed by more digits (or '*') */
		if (c == '.') {
			if ((c = *fmt++) == '*') {
				prec = *argp++;
				c = *fmt++;
			} else {
				prec = 0;
				while (c >= '0' && c <= '9') {
					prec = prec * 10 + (c - '0');
					c = *fmt++;
				}
			}
		} else
			prec = -1;
		
		if (c == 'l'  ||  c == 'h')
			c = *fmt++;

		/* This switch statement must set up p and count. */
		count = 0;
		switch (c) {

		  case 'c':
			*(p = buf) = (char)*argp++;
			count = 1;
			break;

		  case 's':
			p = (char *)*argp++;
			{
				register char *q = p;
				while (*q++  &&  ++count != prec)
					;
			}
			break;

		  case 'd':
		  case 'D':
			{
				register i = *argp++, j;
				register char prefix = 0;

				if (i < 0) {
					prefix = '-';
					i = -i;
				}
				p = &buf[sizeof buf];
				j = i;
				do {
					*--p = j - ((i /= 10) * 10) + '0';
				} while (j = i);
				if (prefix)
					*--p = prefix;
				count = &buf[sizeof buf] - p;
			}
			break;

		  case 'x':
		  case 'X':
			{
				register unsigned n = (unsigned)*argp++;
				register char *tab;

				if (c == 'X')
					tab = Htab;
				else
					tab = htab;
				p = &buf[sizeof buf];
				do {
					*--p = tab[n & 0xF];
					n >>= 4;
				} while (n);
				count = &buf[sizeof buf] - p;
			}
			break;

#ifdef	QUAD
		  case 'q':
		  case 'Q':
			{
				register unsigned n, m;
				register char *tab;

				if (c == 'Q')
					tab = Htab;
				else
					tab = htab;

				m = (unsigned)*argp++;
				n = (unsigned)*argp++;
				p = &buf[sizeof buf];
				do {
					*--p = tab[n & 0xF];
					n = n >> 4 | (m << 28);
					m >>= 4;
				} while (n | m);
				count = &buf[sizeof buf] - p;
			}
			break;
#endif

		  case 'u':
		  case 'U':
			{
				register unsigned n = (unsigned)*argp++, m;

				p = &buf[sizeof buf];
				m = n;
				do {
					*--p = m - ((n /= 10) * 10) + '0';
				} while (m = n);
				count = &buf[sizeof buf] - p;
			}
			break;

		  case 'o':
		  case 'O':
			{
				register unsigned n = (unsigned)*argp++;
				p = &buf[sizeof buf];
				do {
					*--p = (n & 07) + '0';
					n >>= 3;
				} while (n);
				count = &buf[sizeof buf] - p;
			}
			break;

		  case '\0':
			fmt -= 1;
			continue;

		  default:
			*(p = buf) = c;
			count = 1;
			break;
		}

		if ((width -= count) < 0)
			width = 0;
		if (!fminus)
			width = -width;
		_strout(count, p, width, 0, fzero ? '0' : ' ');
	}
}

static
foo ()
{
	asm(".globl fltused;  fltused:;");
}
