/* Copyright (c) 1980 Regents of the University of California */

#include <sys/types.h>

#ifdef FLEXNAMES
#ifndef CROSS_DEV
#  include <a.out.h>
#  include <stab.h>
#else
#  include "../include/a.out.h"
#  include "../include/stab.h"
#endif CROSS_DEV
#else not FLEXNAMES
#  define ONLIST
#  include <a.out.h>
#  include <stab.h>
#endif FLEXNAMES

#define readonly
#define	NINST		800

#define	NEXP		20	/* max number of expr. terms per instruction */
#define	NARG		6	/* max number of args per instruction */
#define	NHASH		2503	/* hash table is dynamically extended */
#define	TNAMESIZE	32	/* maximum length of temporary file names */
#define	NLOC		4	/* number of location ctrs */
#define NBUFSIZ		12288

# ifndef	FLEXNAMES
#	ifndef	NCPS
#		define	NCPS	8	/* number of characters per symbol*/
#	endif
# else
#	ifdef NCPS
#		undef	NCPS
#	endif
#	define	NCPS	NBUFSIZ	/* needed to allocate yytext */
# endif

/*
 * Symbol types
 */
#define	XUNDEF	0x0
#define	XABS	0x2
#define	XTEXT	0x4
#define	XDATA	0x6
#define	XBSS	0x8
#define	XCOMM	0xA	/* internal use only: .comm symbols */

#define	XXTRN	0x1
#define	XTYPE	0x1E

#define	XFORW	0x20	/* Was forward-referenced when undefined */

#define	ERR	(-1)
#define	NBPW	32	/* Bits per word */

#define	AMASK	017

/*
 * Special register defines
 */
/* R_Dn 0..7 */
/* R_An 8..15 */
/* R_Fn 16..23 */

/* The following three must be contigious with R_Dn,R_An,R_Fn */
#define R_FPIAR	24
#define R_FPSR	25
#define R_FPCR	26

/* the following may not appear in any type of MOVEM instruction */
#define R_PC	27
#define R_ZPC	28
#define R_ZA	29
#define R_CC	30
#define R_SR	31
#define R_USP	32
#define R_VB	33
#define R_SFC	34
#define R_DFC	35
#define R_CAC	36
#define R_CAA	37
#define R_MSP	38
#define R_ISP	39

/*
 * Addressing modes
 */
#define	M_DREG		0
#define	M_AREG		1
#define	M_INDR		2
#define	M_INC		3
#define	M_DEC		4
#define	M_DISP		5
#define	M_INDEX		6
#define	M_ABSS		7
#define	M_ABSL		8
#define	M_PCDISP	9
#define	M_PCINDEX	10
#define	M_PREX		11
#define	M_POSTX		12
#define	M_PCPREX	13
#define	M_PCPOSTX	14
#define	M_IMM		15
#define	M_INVALID	16

/*
 * Actual argument syntax types
 */
#define	DREG	(1 << 0)
#define	AREG	(1 << 1)
#define	INC	(1 << 2)
#define	DEC	(1 << 3)
#define	DISP	(1 << 4)	/* M_DISP */
#define	ANINDIR	(1 << 5)	/* M_INDR, M_INDEX, M_PREX, M_POSTX */
#define	ABS	(1 << 6)	/* M_ABSW, M_ABSL */
#define	PCINDIR	(1 << 7)	/* M_PCDISP, M_PCINDEX, M_PCPREX, M_PCPOSTX */
#define	CC	(1 << 8)
#define	SR	(1 << 9)
#define	USP	(1 << 10)
#define	CREG	(1 << 11)	/* 680x0 control registers */
#define	REGLIST	(1 << 12)	/* various register list masks */
#define	REGPAIR	(1 << 13)	/* Dn:Dm */
#define	FREG	(1 << 14)	/* floating point register */
#define	FCNTL	(1 << 15)	/* fp control register */
#define	FSTAT	(1 << 16)	/* fp status register */
#define	FADDR	(1 << 17)	/* fp iaddr register */
#define	FREGPAIR	(1 << 18)	/* Fn:Fm */
#define	IMM	(1 << 20)
#define ATYPEMASK ((1<<21)-1)

#define	IMM_1	(1 << 21)	/* 1 */
#define	IMM_3	(1 << 22)	/* 1 thru 8 */
#define	IMB_3	(1 << 23)	/* 0 thru 7 */
#define	IMB_5	(1 << 24)	/* 0 thru 31 */
#define	IMM_SB	(1 << 25)	/* -128 thru 127 */
#define	IMM_B	(1 << 26)	/* -128 thru 255 */
#define	IMM_SW	(1 << 27)	/* -32768 thru 32767 */
#define	IMM_W	(1 << 28)	/* -32768 thru 65535 */
#define	IMM_L	(1 << 29)	/* whatever */
#define	IMM_F	(1 << 30)	/* single floating */
#define	IMM_D	(1 << 31)	/* double floating */

#define	IMM1	(IMM  | IMM_1)
#define	IMM3	(IMM  | IMM_3)
#define	IMB3	(IMM1 | IMB_3)
#define	IMB5	(IMB3 | IMM_3 | IMB_5)
#define	IMMSB	(IMB5 | IMM_SB)
#define	IMMB	(IMMSB| IMM_B)
#define	IMMSW	(IMMB | IMM_SW)
#define	IMMW	(IMMSW| IMM_W)
#define	IMML	(IMMW | IMM_L)
#define IMMF	(IMM  | IMM_F)
#define IMMD	(IMMF | IMM_D)

#define	MOST	(ANINDIR|DISP|ABS)
#define	NONIR	(INC|DEC|MOST|PCINDIR)

#define	CONT	(MOST|PCINDIR)
#define	MEM	(NONIR|IMML)
#define	MEMD	(NONIR|IMMD)

#define	ALT	(DREG|AREG|INC|DEC|MOST)

#define	DATASB	(DREG|NONIR|IMMSB)
#define	DATAB	(DREG|NONIR|IMMB)
#define	DATASW	(DREG|NONIR|IMMSW)
#define	DATAW	(DREG|NONIR|IMMW)
#define	DATAL	(DREG|NONIR|IMML)
#define	DATA	(DREG|NONIR|IMML)
#define	DATAF	(DREG|NONIR|IMMF)

#define	ALLSB	(DATASB)
#define	ALLB	(DATAB)
#define	ALLSW	(DATASW|AREG)
#define	ALLW	(DATAW |AREG)
#define	ALLL	(DATAL |AREG)
#define	ALL	(DATAL |AREG)

/*
 *	Argument data types
 *	Also used to tell outrel what it is relocating
 *	(possibly in combination with RELOC_PCREL and TYPNONE)
 */
#define	TYPB		0	/* byte */
#define	TYPW		1	/* word */
#define	TYPL		2	/* long */
#define	TYPQ		3	/* quad */
#define	TYPF		4	/* floating */
#define	TYPD		5	/* double floating */
#define	TYPNONE		6	/* when nothing */
#define	RELOC_PCREL	8	/* implicit argument to outrel; ==> PCREL */
#define	RELOC_LABEL	16	/* implicit argument to outrel; ==> LABEL */

#define	TYPMASK	7

/*
 *	reference types for loader
 */
#define	PCREL	1
#define	LEN1	2
#define	LEN2	4
#define	LEN4	6
#define	LEN8	8

extern	int	type_124[];	/* {1,2,4,8} ==> {TYPB, TYPW, TYPL, TYPQ} */
extern	int	ty_NORELOC[];	/* {TYPB..TYPD} ==> {1 if relocation not OK */
extern	int	ty_nbyte[];	/* {TYPB..TYPD} ==> {1,2,4,8} */
extern	int	ty_nlg[];	/* {TYPB..TYPD} ==> lg{1,2,4,8} */

#define	TMPC	7	
#define	HW	01
#define	FW	01	/* used to be 03 */
#define	DW	01	/* used to be 07 */

#define	round(x,y)	(((x)+(y)) & ~(y))

#define	STABTYPS	0340
#define	STABFLAG	0200

/*
 *	Follows are the definitions for the symbol table tags, which are
 *	all unsigned characters..
 *	High value tags are generated by the asembler for internal
 *	use.
 *	Low valued tags are the parser coded tokens the scanner returns.
 *	There are several pertinant bounds in this ordering:
 *		a)	Symbols greater than JXQUESTIONABLE
 *			are used by the jxxx bumper, indicating that
 *			the symbol table entry is a jxxx entry
 *			that has yet to be bumped.
 *		b)	Symbols greater than IGNOREBOUND are not
 *			bequeathed to the loader; they are truly
 *			for assembler internal use only.
 *		c)	Symbols greater than OKTOBUMP represent
 *			indices into the program text that should
 *			be changed in preceeding jumps or aligns
 *			must get turned into their long form.
 */

#define	TAGMASK		0xFF

#	define	JXACTIVE	0xFF	/*jxxx size unknown*/
#	define	JXNOTYET	0xFE	/*jxxx size known, but not yet expanded*/
#	define	JXALIGN		0xFD	/*align jxxx entry*/
#	define	JXINACTIVE	0xFC	/*jxxx size known and expanded*/

#define	JXQUESTIONABLE		0xFB

#	define	JXTUNNEL	0xFA	/*jxxx that jumps to another*/
#	define	OBSOLETE	0xF9	/*erroneously entered symbol*/

#define	IGNOREBOUND	0xF8		/*symbols greater than this are ignored*/
#	define	STABFLOATING	0xF7
#	define	LABELID		0xF6

#define	OKTOBUMP	0xF5
#	define	STABFIXED	0xF4

/*
 *	astoks.h contains reserved word codings the parser should
 *	know about
 */
#include "astoks.h"

/*
 *	The structure for one symbol table entry.
 *	Symbol table entries are used for both user defined symbols,
 *	and symbol slots generated to create the jxxx jump from
 *	slots.
 *	Caution: the instructions are stored in a shorter version
 *	of the struct symtab, using all fields in sym_nm and
 *	tag.  The fields used in sym_nm are carefully redeclared
 *	in struct Instab and struct instab (see below).
 *	If struct nlist gets changed, then Instab and instab may
 *	have to be changed.
 */

struct symtab{
		struct	nlist	s_nm;
		u_char	s_tag;		/* assembler tag */
		u_char	s_ptype;	/* if tag == NAME */
		u_char	s_jxoveralign;	/* if a JXXX, jumped over align */
		short	s_index;	/* which segment */
		struct	symtab *s_dest;	/* if JXXX, where going to */
#ifdef DJXXX
		short	s_jxline;	/* source line of the jump from */
#endif
};
/*
 *	Redefinitions of the fields in symtab for
 *	use when the symbol table entry marks a jxxx instruction.
 */
#define	s_jxbump	s_ptype		/* tag == JX..., how far to expand */
#define	s_jxfear	s_desc		/* how far needs to be bumped */
/*
 *	Redefinitions of fields in the struct nlist for symbols so that
 *	one saves typing, and so that they conform 
 *	with the old naming conventions.
 */
#ifdef	FLEXNAMES
#define	s_name	s_nm.n_un.n_name	/* name pointer */
#define	s_nmx	s_nm.n_un.n_strx	/* string table index */
#else 	not FLEXNAMES
#define	s_name	s_nm.n_name
#endif
#define	s_type	s_nm.n_type		/* type of the symbol */
#define	s_other	s_nm.n_other		/* other information for sdb */
#define	s_desc	s_nm.n_desc		/* type descriptor */
#define	s_value	s_nm.n_value		/* value of the symbol, or sdb delta */

struct insfmt {
	long	if_m0, if_m1, if_m2;
	short	if_opcode;
	int	(*if_build)();
};

struct	instab{
	struct	nlist	s_nm;		/* instruction name, type (opcode) */
	u_char	s_tag;			
	char	s_pad[3];		/* round to 20 bytes */
};
/*
 *	The fields nm.n_desc and nm.n_value total 6 bytes; this is
 *	just enough for the 6 bytes describing the argument types.
 *	We use a macro to define access to these 6 bytes, assuming that
 *	they are allocated adjacently.
 *	IF THE FORMAT OF STRUCT nlist CHANGES, THESE MAY HAVE TO BE CHANGED.
 *
 *	Instab is cleverly declared to look very much like the combination of
 *	a struct symtab and a struct nlist.
 */
struct	Instab{
#ifdef FLEXNAMES
	char	*I_name;
#else not FLEXNAMES
	char	I_name[NCPS];
#endif
	char	I_nfmt;
	char	I_nargs;
	short	I_opcode;
	struct insfmt *I_ifmt;
	u_char	I_s_tag;
	char	I_pad[3];		/* round to 20 bytes */
};
/*
 *	Redefinitions of fields in the struct nlist for instructions so that
 *	one saves typing, and conforms to the old naming conventions
 */
#define	i_opcode	s_nm.n_desc	/* use the same field as symtab.type */
#define	i_nargs		s_nm.n_other	/* number of arguments */
#define	i_nfmt		s_nm.n_type	/* number of instr formats */
#define	i_ifmt		s_nm.n_value	/* ptr to instr formats */

struct	arg {				/*one argument to an instruction*/
	long	a_atype;		/* argument type/class */
	char	a_amode;		/* addressing mode */
	char	a_areg1;
	char	a_areg2;
	char	a_ascale;		/* indexed mode scale factor */
	char	a_xsize;		/* a_xp size spec */
	char	a_bsize;		/* base disp size spec */
	char	a_osize;		/* outer disp size spec */
	struct	exp *a_xp;
	struct	exp *a_od;		/* indexed mode outer displacement */
	unsigned a_hasbf:1;		/* has bitfield selection */
	unsigned a_haskfac:1;		/* has (fmovemp) k-factor */
	unsigned a_bforeg:1;		/* bf offset part is register */
	unsigned a_bfwreg:1;		/* bf width part is register*/
	char	a_bfoff;		/* bf offset, reg #, or k-factor */
	char	a_bfwid;		/* bf width or reg # */
};

struct	exp {
	long	e_xvalue;		/* MUST be the first field (look at union Double) */
	long	e_yvalue;		/* MUST be second field; least sig word of a double */
	char	e_xtype;
	char	e_xloc;
	struct	symtab *e_xname;
};

#define doub_MSW e_xvalue
#define doub_LSW e_yvalue

union	Double {
	struct{
		long	doub_MSW;
		long	doub_LSW;
	} dis_dvalue;
	double	dvalue;
};

struct	Quad {
	long	quad_high_long;
	long	quad_low_long;
};

/*
 *	Magic layout macros
 */
#define 	MINBYTE	-128
#define		MAXBYTE	127
#define		MINWORD	-32768
#define		MAXWORD	32767

extern	struct	arg	arglist[NARG];	/*building operands in instructions*/
extern	struct	exp	explist[NEXP];	/*building up a list of expressions*/
extern	struct	exp	*xp;		/*current free expression*/
	/*
	 *	Communication between the scanner and the jxxx handlers.
	 *	lastnam:	the last name seen on the input
	 *	lastjxxx:	pointer to the last symbol table entry for
	 *			a jump from
	 */
extern	struct	symtab	*lastnam;
extern	struct	symtab	*lastjxxx;	
extern	struct	symtab	*lastlabel;

	/*
	 *	Lgensym is used to make up funny names for local labels.
	 *	lgensym[i] is the current funny number to put after
	 *	references to if, lgensym[i]-1 is for ib.
	 *	genref[i] is set when the label is referenced before
	 *	it is defined (i.e. 2f) so that we can be sure these
	 *	labels are always defined to avoid weird diagnostics
	 *	from the loader later.
	 */
extern	int	lgensym[10];
extern	char	genref[10];

extern	char	tmpn1[TNAMESIZE];	/* Interpass temporary */
extern	struct	exp	*dotp;		/* the current dot location */

extern	struct	exec	hdr;		/* a.out header */
extern	u_long	tsize;			/* total text size */
extern	u_long	dsize;			/* total data size */
extern	u_long	trsize;			/* total text relocation size */
extern	u_long	drsize;			/* total data relocation size */
extern	u_long	datbase;		/* base of the data segment */
	/*
	 *	Bitoff and bitfield keep track of the packing into 
	 *	bytes mandated by the expression syntax <expr> ':' <expr>
	 */
extern	int	bitoff;	
extern	long	bitfield;
	
	/*
	 *	The lexical analyzer builds up symbols in yytext.  Lookup
	 *	expects its argument in this buffer
	 */
extern	char	yytext[NCPS+2];		/* text buffer for lexical */
	/*
	 *	Variables to manage the input assembler source file
	 */
extern	int	lineno;			/*the line number*/
extern	char	*dotsname;		/*the name of the as source*/

extern	FILE	*tmpfil;		/* interpass communication*/

extern	int	passno;			/* 1 or 2 */

extern	int	anyerrs;		/*errors assembling arguments*/
extern	int	silent;			/*don't mention the errors*/
extern	int	savelabels;		/*save labels in a.out*/
extern	int	orgwarn;		/* questionable origin ? */
extern	int	useVM;			/*use virtual memory temp file*/
extern	int	jxxxJUMP;		/*use jmp instead of brw for jxxx */
extern	int	readonlydata;		/*initialized data into text space*/
extern 	int	for68020;		/*allow 68020/68881 addrmodes,instrs */
#ifdef DEBUG
extern	int	debug;
extern	int	toktrace;
#endif
	/*
	 *	Information about the instructions
	 */
extern	struct	instab	*itab[NINST];	/*maps opcodes to instructions*/
extern  readonly struct Instab instab[];

extern	int	curlen;			/*current literal storage size*/
extern	int	d124;			/*current pointer storage size*/
	
struct	symtab	**lookup();		/*argument in yytext*/
struct 	symtab	*symalloc();

long lseek();
char *strcat();
char *mktemp();
char *sbrk();
char *Calloc();
char *ClearCalloc();

#define outb(val) {dotp->e_xvalue++; if (passno==2) bputc((val), (txtfil));}
#define outw(val) {dotp->e_xvalue+=2; if (passno==2) bputw((val), (txtfil));}

#define outs(cp, lg) dotp->e_xvalue += (lg); if (passno == 2) bwrite((cp), (lg), (txtfil))

/*
 *	Most of the time, the argument to flushfield is a power of two constant,
 *	the calculations involving it can be optimized to shifts.
 */
#define flushfield(n) if (bitoff != 0)  Flushfield( ( (bitoff+n-1) /n ) * n)

/*
 * The biobuf structure and associated routines are used to write
 * into one file at several places concurrently.  Calling bopen
 * with a biobuf structure sets it up to write ``biofd'' starting
 * at the specified offset.  You can then use ``bwrite'' and/or ``bputc''
 * to stuff characters in the stream, much like ``fwrite'' and ``fputc''.
 * Calling bflush drains all the buffers and MUST be done before exit.
 */
struct	biobuf {
	short	b_nleft;		/* Number free spaces left in b_buf */
/* Initialize to be less than BUFSIZ initially, to boundary align in file */
	char	*b_ptr;			/* Next place to stuff characters */
	char	b_buf[BUFSIZ];		/* The buffer itself */
	off_t	b_off;			/* Current file offset */
	struct	biobuf *b_link;		/* Link in chain for bflush() */
};
#define	bputc(c,b) ((b)->b_nleft ? (--(b)->b_nleft, *(b)->b_ptr++ = (c)) \
		       : bflushc(b, c))
#define	bputw(w,b) (bputc(((w)>>8),b), bputc((w),b))
#define BFILE	struct biobuf

extern	BFILE	*biobufs;	/* head of the block I/O buffer chain */
extern	int	biofd;		/* file descriptor for block I/O file */
extern	off_t	boffset;	/* physical position in logical file */

	/*
	 *	For each of the named .text .data segments
	 *	(introduced by .text <expr>), we maintain
	 *	the current value of the dot, and the BFILE where
	 *	the information for each of the segments is placed
	 *	during the second pass.
	 */
extern	struct	exp	usedot[NLOC + NLOC];
extern		BFILE	*usefile[NLOC + NLOC];
extern		BFILE	*txtfil;/* file for text and data: into usefile */
	/*
	 *	Relocation information for each segment is accumulated
	 *	seperately from the others.  Writing the relocation
	 *	information is logically viewed as writing to one
	 *	relocation saving file for  each segment; physically
	 *	we have a bunch of buffers allocated internally that
	 *	contain the relocation information.
	 *
	 *	The internals to relbufdesc are known only in assyms.c
	 */
extern struct	relbufdesc	*rusefile[NLOC + NLOC];
extern struct	relbufdesc	*relfil;
