#ifndef lint
static	char sccsid[] = "@(#)format.c	4.3 2/27/86";
#endif
/*
 *
 *	UNIX debugger
 *
 */

#include "defs.h"

MSG		BADMOD;
MSG		NOFORK;
MSG		ADWRAP;

INT		mkfault;
CHAR		*lp;
L_INT		maxoff;
ADDR		sigint;
ADDR		sigqit;
STRING		errflg;
CHAR		lastc,peekc;
L_INT		dot;
INT		dotinc;
L_INT		expv;
L_INT		var[];


STRING		fphack;
rdfp()
{
	return(lastc= *fphack++);
}

scanform(icount,ifp,itype,ptype)
L_INT		icount;
STRING		ifp;
{
	STRING		fp;
	CHAR		modifier;
	INT		fcount, init=1;
	L_INT		savdot;
	BOOL exact;
	BOOL doit = 1;

	WHILE icount
	DO  fp=ifp;
	    savdot=dot; init=0;

	    IF init==0 ANDF (exact=(findsym(dot,ptype)==0)) ANDF maxoff
	    THEN printf("\n%s:%16t",cursym->n_un.n_name);
	    FI

	    /*now loop over format*/
	    WHILE *fp ANDF errflg==0
	    DO  IF digit(modifier = *fp)
		THEN fcount = 0;
			WHILE digit(modifier = *fp++)
			DO fcount *= 10;
			   fcount += modifier-'0';
			OD
			fp--;
			IF fcount==0 THEN fcount = 1; FI
		ELSE fcount = 1;
		FI

		IF *fp==0 THEN break; FI
#ifdef is68k
		fp=exform(fcount,fp,itype,ptype);
#else

		IF exact ANDF dot==savdot ANDF itype==ISP ANDF cursym->n_un.n_name[0]=='_' ANDF *fp=='i'
		THEN exform(1,"x",itype,ptype); fp++; printc(EOR); /* entry mask */

		ELSE fp=exform(fcount,fp,itype,ptype);
		FI
#endif is68k
	    OD
	    dotinc=dot-savdot;
	    dot=savdot;

	    IF errflg
	    THEN IF icount<0
		 THEN errflg=0; break;
		 ELSE error(errflg);
		 FI
	    FI
	    IF --icount
	    THEN dot=inkdot(dotinc);
	    FI
	    IF mkfault THEN error(0); FI
	OD
}

STRING
exform(fcount,ifp,itype,ptype)
INT		fcount;
STRING		ifp;
{
	/* execute single format item `fcount' times
	 * sets `dotinc' and moves `dot'
	 * returns address of next format item
	 */
	POS		w;
	L_INT		savdot, wx;

#ifdef is68k
	L_INT		offset;
	char		local_s[100];
/*  Used to change precision of floating point data read from word
 *  format as read from the a.out file.
 */
	union u_tag {
	    char   chr[8];
	    short  shrt[4];
	    int   integ[2];
	    float sflt;
	    double dbl;
	} u_flt; 
#endif is68k
	
	STRING		fp;
	CHAR		c, modifier, longpr;
	L_REAL		fw;
	struct{
		L_INT	sa;
		INT	sb,sc;
	};

	WHILE fcount>0
	DO	fp = ifp; c = *fp;
		longpr=(c>='A')&(c<='Z')|(c=='f')|(c=='4')|(c=='p');
#ifdef is68k
		if (itype==NSP || *fp=='a')
			wx = w = dot;
		else
			wx = w = get(dot&~1,itype);
#else
		IF itype==NSP ORF *fp=='a'
		THEN wx=dot; w=dot;
		ELSE w=get(dot,itype);
		     IF longpr
		     THEN wx=itol(get(inkdot(2),itype),w);
		     ELSE wx=w;
		     FI
		FI
#endif is68k
		IF c=='F'
#ifdef is68k
		THEN u_flt.integ[1] = get((inkdot(4)&~1),itype);
#else
		THEN fw.sb=get(inkdot(4),itype);
		     fw.sc=get(inkdot(6),itype);
#endif is68k
		FI
		IF errflg THEN return(fp); FI
		IF mkfault THEN error(0); FI
		var[0]=wx;
		modifier = *fp++;
		dotinc=(longpr?4:2);;

		IF charpos()==0 ANDF modifier!='a' THEN printf("%16m"); FI

		switch(modifier) {

		    case SPC: case TB:
			break;

		    case 't': case 'T':
			printf("%T",fcount); return(fp);

		    case 'r': case 'R':
			printf("%M",fcount); return(fp);

		    case 'a':
# ifndef is68k
			if (*fp == 'i')
			{
				if ((offset = findsym(dot,ptype))==0)
	    				printf("%s%16t",cursym->n_un.n_name);
				else
				{
	    				printf("%s+",cursym->n_un.n_name);
					printf("%-8X%16t",offset);
				}
			}
			else
				psymoff(dot,ptype,":%16t");
# else is68k
			psymoff(dot,ptype,":%16t");
#endif is68k
			dotinc=0; break;

		    case 'p':
			psymoff(var[0],ptype,"%16t"); break;

		    case 'u':
			printf("%-8u",w); break;

		    case 'U':
			printf("%-16U",wx); break;

		    case 'c': case 'C':
			IF modifier=='C'
#ifdef is68k
			THEN printesc(((char *)&w)[dot&1]);
			ELSE printc(((char *)&w)[dot&1]);
#else
			THEN printesc(w&LOBYTE);
			ELSE printc(w&LOBYTE);
#endif is68k
			FI
			dotinc=1; break;

		    case 'b': case 'B':
#ifdef is68k
			u_flt.integ[0] = w;

			sprintf(local_s,"%-8o",u_flt.chr[0]);
			printf("%s\n",local_s);
#else
			printf("%-8o",((char *)&w)[dot&1]);
#endif is68k
			printf("%-8o", w&LOBYTE); dotinc=1; break;

			case '1':
			printf("%-8r", w&LOBYTE); dotinc=1; break;

			case '2':
		    case 'w':
			printf("%-8r", w); break;

			case '4':
		    case 'W':
			printf("%-16R", wx); break;

		    case 's': case 'S':
			savdot=dot; dotinc=1;
#ifdef is68k
			WHILE (c=((char *)&w)[dot&1]) ANDF errflg==0
#else 
			WHILE (c=get(dot,itype)&LOBYTE) ANDF errflg==0
#endif is68k
			DO dot=inkdot(1);
			   IF modifier == 'S'
			   THEN printesc(c);
			   ELSE printc(c);
			   FI
#ifdef is68k
			   w=get(dot&~1,itype);
#endif is68k
			   endline();
			OD
			dotinc=dot-savdot+1; dot=savdot; break;

		    case 'x':
			printf("%-8x",w); break;

		    case 'X':
			printf("%-16X", wx); break;

		    case 'Y':
			printf("%-24Y", wx); break;

		    case 'q':
			printf("%-8q", w); break;

		    case 'Q':
			printf("%-16Q", wx); break;

		    case 'o':
			printf("%-8o", w); break;

		    case 'O':
			printf("%-16O", wx); break;

		    case 'i':
#ifdef is68k
			printins(dot,itype); break;
#else
			printins(0,itype,w); printc(EOR); break;
#endif is68k

		    case 'd':
			printf("%-8d", w); break;

		    case 'D':
			printf("%-16D", wx); break;

		    case 'f':

#ifdef is68k
	/*
	 * Avoid local printf floating point "junk code" and use the standard
	 * libc.a function for one good reason:  libc code works  local stuff 
	 * doesn't.  BN 071686
	 */
			u_flt.integ[0]=wx;

			sprintf(local_s,"%f\n",u_flt.sflt);
			printf("%s\n",local_s);
#else
			fw = 0;
			fw.sa = wx;
			IF (wx & ~0xFFFF00FF) == 0x8000
			THEN printf("(reserved oprnd)");
			ELSE printf("%-16.9f", fw);
			FI
#endif is68k
			dotinc=4; break;

		    case 'F':
#ifdef is68k
	/*
	 * Avoid local printf floating point "junk code" and use the standard
	 * libc.a function for one good reason:  the libc stuff works and
	 * the local stuff doesn't.  BN 071686
	 */
		        u_flt.integ[0]=wx;
		         
			sprintf(local_s,"%f\n",u_flt.dbl);
			printf("%s\n",local_s);
#else
		
			dotinc=8; break;
			fw.sa = wx;
			IF (wx & ~0xFFFF00FF) == 0x8000
			THEN printf("%-32s", "(reserved oprnd)");
			ELSE printf("%-32.18F", fw);
			FI
#endif is68k
			dotinc=8; break;

		    case 'n': case 'N':
			printc('\n'); dotinc=0; break;

		    case '"':
			dotinc=0;
			WHILE *fp != '"' ANDF *fp
			DO printc(*fp++); OD
			IF *fp THEN fp++; FI
			break;

		    case '^':
			dot=inkdot(-dotinc*fcount); return(fp);

		    case '+':
			dot=inkdot(fcount); return(fp);

		    case '-':
			dot=inkdot(-fcount); return(fp);

		    default: error(BADMOD);
		}
		IF itype!=NSP
		THEN	dot=inkdot(dotinc);
		FI
		fcount--; endline();
	OD

	return(fp);
}

shell()
{
#ifndef EDDT
#ifdef	is68k
	int		rc, status, unixpid;
#else	is68k
	INT		rc, status, unixpid;
#endif	is68k
	STRING		argp = lp;
	STRING		getenv(), shell = getenv("SHELL");
#ifdef VFORK
	char		oldstlp;
#endif

	if (shell == 0)
		shell = "/bin/sh";
	WHILE lastc!=EOR DO rdc(); OD
#ifndef VFORK
	IF (unixpid=fork())==0
#else
	oldstlp = *lp;
	IF (unixpid=vfork())==0
#endif
	THEN	signal(SIGINT,sigint); signal(SIGQUIT,sigqit);
		*lp=0; execl(shell, "sh", "-c", argp, 0);
		_exit(16);
#ifndef VFORK
	ELIF unixpid == -1
#else
	ELIF *lp = oldstlp, unixpid == -1
#endif
	THEN	error(NOFORK);
	ELSE	signal(SIGINT,1);
		WHILE (rc = wait(&status)) != unixpid ANDF rc != -1 DONE
		signal(SIGINT,sigint);
		prints("!"); lp--;
	FI
#endif
}


printesc(c)
{
	c &= STRIP;
	IF c==0177 THEN printf("^?");
	ELIF c<SPC
	THEN printf("^%c", c + '@');
	ELSE printc(c);
	FI
}

L_INT	inkdot(incr)
{
	L_INT		newdot;

	newdot=dot+incr;
	IF (dot NEQ newdot) >> 24 THEN error(ADWRAP); FI
	return(newdot);
}

digit(c)
{
	return c >= '0' && c <= '9';
}
