/*	defs.h	4.6	86/03/26	*/

/*
 * adb- is68k string table version; common definitions
 */
#include <machine/psl.h>
#include <machine/pte.h>
#include <machine/reg.h>

#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>

#include <ctype.h>
#include <a.out.h>
#include <sys/ptrace.h>

#include "mac.h"
#include "mode.h"
#include "head.h"

/* access modes */
#define RD	0
#define WT	1

#define NSP	0
#define	ISP	1
#define	DSP	2
#define STAR	4
#define STARCOM 0200

/*
 * Symbol types, used internally in calls to findsym routine.
 * One the VAX this all degenerates since I & D symbols are indistinct.
 * Basically we get NSYM==0 for `=' command, ISYM==DSYM otherwise.
 */
#define NSYM	0
#define DSYM	1		/* Data space symbol */
#define ISYM	DSYM		/* Instruction space symbol == DSYM on VAX */

#define BKPTSET	1
#define BKPTEXEC 2

#define USERPS	PSL
#define USERPC	PC

#ifdef is68k
#define BPT	0x4E4F0000		/* trap 15 for mc68000 */ 
#define TBIT	0x8000			/* PSL trace  bit      */
#else 
#define BPT	03
#define TBIT	020
#endif is68k

#define FD	0200

/* puns from <sys/ptrace.h> */
#define	CONTIN	PT_CONTINUE
#define SINGLE	PT_STEP


#ifdef	is68k
#define MAXOFF	MAXINT
#else	is68k
#define MAXOFF	255
#endif	is68k
#define MAXPOS	80
#define MAXLIN	128
#define EOR	'\n'
#define SPC	' '
#define TB	'\t'
#define QUOTE	0200
#define STRIP	0177
#define LOBYTE	0377
#define EVEN	-2

/* long to ints and back (puns) */
union {
	INT	I[2];
	L_INT	L;
} itolws;

#ifndef vax

#ifdef is68k
#define leng(a)		itol(0,a)
#define shorten(a)	((short)(a))	
#else
#define leng(a)		((long)((unsigned)(a)))
#define shorten(a)	((int)(a))
#endif is68k

#define itol(a,b)	(itolws.I[0]=(a), itolws.I[1]=(b), itolws.L)
#else
#define leng(a)		itol(0,a)
#define shorten(a)	((short)(a))
#define itol(a,b)	(itolws.I[0]=(b), itolws.I[1]=(a), itolws.L)
#endif

/* result type declarations */
L_INT		inkdot();
POS		get();
POS		chkget();
STRING		exform();
L_INT		round();
BKPTR		scanbkpt();
VOID		fault();

struct	pcb	pcb;
int	kernel;
int	kcore;
struct	pte *sbr;
int	slr;
int	masterpcbb;

#ifdef	is68k
long	ustart, ustack, eustack;
#endif	is68k

# define VME020_HIWATER 0x8000000
# define VMEBUS_HIWATER 0x800000
# define QBUS_HIWATER 0x400000 
# define MINPCVAL 0x44

#define NUM_FPS  	8	/* number of floating point registers  */
#define FP_SIZE		12	/* size of floating point reg. in bytes */
#define NUM_FP_STAT	3	/* number of floating point status regs.*/
#define STAT_SIZE	4	/* size of fp status regs. in bytes */
#define NUM_FP_BYTES	((NUM_FPS * FP_SIZE) + (NUM_FP_STAT * STAT_SIZE))

