/* clnt_simple.c - simplified front end to rpc */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (C) 1984, Sun Microsystems, Inc.
 *
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
modification history
--------------------
01f,29apr89,gae  added clnt_simpleExit to do tidy cleanup for tasks. 
		 changed clnt_simpleInit to return pointer to moduleStatics.
01d,30may88,dnw  changed to v4 names.
01c,29mar88,rdc   incorrect check of status returned by remGetHostByName
		  in callrpc fixed.
01b,11nov87,jlf   added wrs copyright, title, mod history, etc.
01a,01nov87,rdc   first VxWorks version
*/

#ifndef lint
static char sccsid[] = "@(#)clnt_simple.c 1.1 86/02/03 Copyr 1984 Sun Micro";
#endif

/* 
 * clnt_simple.c
 * Simplified front end to rpc.
 *
 */

#include "rpc.h"
#include "socket.h"
#include "utime.h"
#undef TRUE
#undef FALSE
#include "vxWorks.h"
#include "memLib.h"
#include "strLib.h"
#include "rpcGbl.h"


struct moduleStatics
    {
    CLIENT *client;
    int socket;
    int oldprognum;
    int oldversnum; 
    int valid;
    char *oldhost;
    };

struct moduleStatics *clnt_simpleInit ()

    {
    struct moduleStatics *pClnt_simple;

    pClnt_simple = 
	 (struct moduleStatics *) calloc (1, sizeof (struct moduleStatics)); 

    if (pClnt_simple == NULL)
	printErr ("clnt_simpleInit: out of memory!\n");
    else
	{
	pClnt_simple->oldhost = malloc (256);

	if (pClnt_simple->oldhost == NULL)
	    {
	    free ((char *)pClnt_simple);
	    printErr ("clnt_simpleInit: out of memory!\n");
	    }
	else
	    {
	    pClnt_simple->oldhost [0] = 0;
	    pClnt_simple->socket = RPC_ANYSOCK;
	    }
	}

    return (pClnt_simple);
    }

VOID clnt_simpleExit (pClnt_simple)
    struct moduleStatics *pClnt_simple;

    {
    if (pClnt_simple != NULL)
	{
	if (pClnt_simple->client)
	    clnt_destroy (pClnt_simple->client);
	if (pClnt_simple->socket > 0)
	    close (pClnt_simple->socket);
	if (pClnt_simple->oldhost != NULL)
	    free (pClnt_simple->oldhost);
	free ((char *)pClnt_simple);
	}
    }

callrpc(host, prognum, versnum, procnum, inproc, in, outproc, out)
	char *host;
	xdrproc_t inproc, outproc;
	char *in, *out;
{
	struct sockaddr_in server_addr;
	enum clnt_stat clnt_stat;
	int hp;
	struct timeval timeout, tottimeout;
	FAST struct moduleStatics *ms = taskModuleList->clnt_simple;

	if (ms->valid && ms->oldprognum == prognum && ms->oldversnum == versnum
		&& strcmp(ms->oldhost, host) == 0) {
		/* reuse old client */		
	}
	else {
		ms->valid = 0;
		close(ms->socket);
		ms->socket = RPC_ANYSOCK;
		if (ms->client) {
			clnt_destroy(ms->client);
			ms->client = NULL;
		}
/* XXX		if ((hp = gethostbyname(host)) == NULL) */
		if ((hp = hostGetByName (host)) == ERROR) 
			return ((int) RPC_UNKNOWNHOST);
		timeout.tv_usec = 0;
		timeout.tv_sec = 5;
/* XXX		bcopy(hp->h_addr, &server_addr.sin_addr, hp->h_length); */
		server_addr.sin_addr.s_addr = hp;
		server_addr.sin_family = AF_INET;
		server_addr.sin_port =  0;
		if ((ms->client = clntudp_create(&server_addr, prognum,
		    versnum, timeout, &ms->socket)) == NULL)
			return ((int) taskModuleList->rpc_createerr.cf_stat);
		ms->valid = 1;
		ms->oldprognum = prognum;
		ms->oldversnum = versnum;
		strcpy(ms->oldhost, host);
	}
	tottimeout.tv_sec = 25;
	tottimeout.tv_usec = 0;
	clnt_stat = clnt_call(ms->client, procnum, inproc, in,
	    outproc, out, tottimeout);
	/* 
	 * if call failed, empty cache
	 */
	if (clnt_stat != RPC_SUCCESS)
		ms->valid = 0;
	return ((int) clnt_stat);
}
