/* tickLib.c - VxWorks/pSOS clock tick support library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01d,25aug88,gae  documentation.
01c,30may88,dnw  changed to v4 names.
01b,28may88,jcf  fixed tickSet so it works.
		 documentation.
01a,19jan87,jcf  written
*/

/*
DESCRIPTION
This library provides a generic interface to pSOS kernel time management.
This includes:

    - announce a timer tick to pSOS,
    - get the current time in ticks,
    - set the current time in ticks.

SEE ALSO: "Architecture", taskLib (1), kernelLib (1)
*/

/* LINTLIBRARY */

#include "vxWorks.h"


/*******************************************************************************
*
* tickAnnounce - annouce a clock tick to pSOS
*
* This routine is used to inform pSOS of the passing of time.
* It should be called from an interrupt service routine that is
* connected to the system clock.
*
* SEE ALSO: psosAnnounceT (2)
*/

VOID tickAnnounce ()

    {
    psosAnnounceT ();
    }
/*******************************************************************************
*
* tickSet - set value of pSOS's tick counter
*
* SEE ALSO: tickGet (2), psosSetT (2)
*/

VOID tickSet (ticks)
    ULONG ticks;	/* new time in ticks */

    {
    int years, months, days, hours, minutes, seconds, date, time;

    seconds = ticks / sysClkRateGet ();
    minutes = seconds / 60;
    hours   = minutes / 60;
    days    = hours / 24;
    months  = days / 31;
    years   = months / 12;

    ticks   %= sysClkRateGet ();
    seconds %= 60;			/* 0 - 59 */
    minutes %= 60;			/* 0 - 59 */
    hours   %= 24;			/* 0 - 23 */
    days    %= 31;			/* 1 - 31 */
    days ++;
    months  %= 12;			/* 1 - 12 */
    months ++;

    date  = (years << 16) + (months << 8) + days;
    time  = (hours << 16) + (minutes << 8) + seconds;

    psosSetT (date, time, ticks);
    }
/*******************************************************************************
*
* tickGet - get value of pSOS's tick counter
*
* RETURNS: value of the pSOS clock
*
* SEE ALSO: tickSet (2), psosGetT (2)
*/

ULONG tickGet ()

    {
    int date;
    int time;
    short ticks;
    int hours;
    int mins;
    int secs;

    psosGetT (&date, &time, &ticks);

    hours = (time & 0xff0000) >> 16;
    mins  = (time & 0xff00) >> 8;
    secs  = (time & 0xff);

    return ((((((hours * 60) + mins) * 60) + secs) * sysClkRateGet ()) + ticks);
    }
