/* psosLib.c - internal VxWorks/pSOS kernel library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01e,25aug88,gae  documentation.
01d,03jul88,jcf  moved psosTaskExtend to kernelLib.c.
01c,30may88,dnw  changed to v4 names.
01b,28may88,jcf	 added psosSuperP to psosTaskExtend so usrRoot executes at
		  supervisor state.
01a,19jan88,jcf	 written.
*/

/*
DESCRIPTION
This module contains internal support routines for the VxWorks/pSOS interface.

SEE ALSO: psosALib (1)
*/

#include "vxWorks.h"

/*******************************************************************************
*
* psosPriorityToVx - pSOS task priority to VxWorks priority
*
* VxWorks priorities run from 0 to 255, 0 being the lowest most
* important priority and 255 being the highest least important.
*
* NOMANUAL
*/

int psosPriorityToVx (priority)
    int priority;

    {
    return (255 - priority);
    }
/*******************************************************************************
*
* idle - idle
*
* We drop to here if nothing else to do.
*
* NOMANUAL
*/

VOID idle ()

    {
    FOREVER;
    }
