/* unixALib.s - assembly language routines for tcpip */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
	.data
	.globl	_copyright_wind_river
	.long	_copyright_wind_river

/*
modification history
--------------------
01j,22jun88,dnw  removed unnecessary intLock()s in insque() and remque().
		 removed setjmp()/longjmp() to cALib.s.
01i,13feb87,dnw  changed setjmp and longjmp register lists to be processable
		   by Motorola assemblers.
		 added .data before copyright.
01h,13nov87,rdc  added setjmp and longjmp (temporary).
01g,24oct87,dnw  removed erroneous ';' at end of copyright.
01f,03apr87,ecs  added copyright.
01e,02apr87,jlf  removed .globl of tas, left behind after 01d.
01d,27mar86,rdc  moved tas() to vxALib.s for non-network systems.
01c,22dec86,dnw  more changes for assembler compatibility:
		   changed jeq/jne/jra to beq/bne/bra.
		   added .globl declarations of intLock(), intUnlock().
01b,30nov86,dnw  changed to be acceptable to various assemblers:
		   changed ".align 1" to ".even".
		   changed "mov" to "move"
		   replaced <n>[fb] labels with real labels.
01a,06aug86,rdc  written
*/ 

#define ASMLANGUAGE

	/* internals */

	.globl	_cksum
	.globl  __insque
	.globl  __remque

	.text
	.even

/**************************************************************************
* 
* cksum - compute check sum
*
* return 16bit one's complement sum of 'sum' and the 16bit one's 
* complement sum of the string 'string' of byte length 'len'.
* Complicated by 'len' or 'sumlen' not being even.
* 
* RETURNS  int
*
* int cksum (sum, string, len, sumlen);
*/ 
_cksum:	movel	d2,sp@-			/* save d2 */
	movel	sp@(8),d0		/* sum */
	movel	sp@(12),a0		/* address of byte string */
	movel	a0,d2
	tstl	sp@(16)			/* length of string */
	beq	ck9			/* zero length string, return */
	andb	#0xF,cc			/* X clerar x bit */
	btst	#0,sp@(20+3)		/* swap bytes ?? */
	bne	ck4

	/* sum is word alligned, dont swap bytes */
	btst	#0,d2
	beq	ck1

	/* odd start address, do first byte, and then swap bytes */
	subl	#1,sp@(16)	
	clrl	d2
	moveb	a0@+,d2
	rolw	#8,d2
	addw	d2,d0			/* X */
	bra	ck5

	/* even address, sum alligned */
ck1:	movel	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	bra	ck3
ck2:	movew	a0@+,d2
	addxw	d2,d0			/* X */
ck3:	dbra	d1,ck2
	btst	#0,sp@(16+3)
	beq	ck8

	/* odd length, take care of last byte */
	clrl	d2
	moveb	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
	bra	ck8

	/* sum is not word alligned, swap bytes */
ck4:	btst	#0,d2
	beq	ck5

	/* odd start address, do first byte, and then dont swap bytes */
	subl	#1,sp@(16)		/* X */
	clrl	d2
	moveb	a0@+,d2
	addw	d2,d0			/* X */
	bra	ck1

	/* even address, sum misalligned, swap bytes */
ck5:	movel	sp@(16),d1
	andb	#0xFE,d1
	rorl	#1,d1
	bra	ck7
ck6:	movew	a0@+,d2
	rolw	#8,d2
	addxw	d2,d0			/* X */
ck7:	dbra	d1,ck6
	btst	#0,sp@(16+3)
	beq	ck8

	/* odd length, take care of last byte */
	clrl	d2
	moveb	a0@+,d2
	addxw	d2,d0			/* X */

	/* fold in last carry bit */
ck8:	clrl	d2
	addxw	d2,d0			/* X */
ck9:	movel	sp@+,d2			/* restore d2 */
	rts

/****************************************************************************
* 
* insque - insert a node into a linked list
*
*/
__insque:
	movel	sp@(4),a0		/* new */
	movel	sp@(8),a1		/* pred */
	movel	a1@,d0			/* succ */
	movel	d0,a0@
	movel	a1,a0@(4)
	movel	a0,a1@
	movel	d0,a1
	movel	a0,a1@(4)
	rts

/****************************************************************************
* 
* remque - delete a node from a linked list
*
*/
__remque:
	movel	d0,d1
	movel	sp@(4),a0
	movel	a0@,a1
	movel	a0@(4),d0
	movel	d0,a1@(4)
	exg	d0,a0
	movel	a1,a0@
	rts
