/* pic_mvme215.c - jumpering of the Motorola MVME-215 shared memory board */

/*
modification history
--------------------
01b,04apr88,gae  removed calls to getBoard() and printPic().
01a,07nov87,jcf  written.
*/

/*
This module contains the jumpering of the Motorola MVME-215.
*/

#include "vxWorks.h"
#include "picture.h"


/*******************************************************************************
*
* drawMvme215 - draw shared memory board
*/

VOID drawMvme215 (pic)
    char *pic;

    {
    int i;
    int io_adrs = 0;
    int tmp = 0;

    if (bp_io == NONE)
	{
	bp_io = 0x800000;
	printf ("Warning shared memory address not defined, using 0x800000.\n");
	}

    /* io address */
    bp_io &= 0xffffff;
    tmp = ~((bp_io >> 16) | 0x3);
    for (i = 0; i < 16; i++)
	{
	io_adrs = io_adrs << 1;
	io_adrs |= (tmp >> i) & 0x1;
	}

    printAt (pic, 33, 1, "MVME-215 MEM");

    /* io address */
    jumperAt (pic, 38, 3, 8, HORIZONTAL, VERTICAL, (io_adrs >> 8));
    printAt (pic, 38, 4, "IO ADRS");

    jumperAt (pic, 47, 3, 8, HORIZONTAL, VERTICAL, io_adrs);
    printAt (pic, 47, 4, "IO ADRS");
    }
