/* if_loop.c - network loopback interface driver */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1980, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)if_loop.c	7.1 (Berkeley) 6/4/86
 */

/*
modification history
--------------------
02e,30may88,dnw  changed to v4 names.
02d,05jan88,rdc  added include of systm.h 
02c,02may87,dnw  clean up.
02b,03apr87,ecs  added copyright.
02a,02feb87,jlf  Removed CLEAN ifdefs.
*/

/*
 * Loopback interface driver for protocol testing and timing.
 */

#include "vxWorks.h"
#include "param.h"
#include "mbuf.h"
#include "socket.h"
#include "errno.h"
#include "ioctl.h"

#include "if.h"
#include "route.h"
#include "systm.h"

#ifdef	INET
#include "in.h"
#include "in_systm.h"
#include "in_var.h"
#include "ip.h"
#endif

#ifdef NS
#include "../netns/ns.h"
#include "../netns/ns_if.h"
#endif

IMPORT ipintr ();

#define	LOMTU	(1024+512)	/* maximum packet size */

struct ifnet loif;

/* forward declarations */

int looutput();
LOCAL int loioctl();

/**********************************************************************
*
* loattach - attach loopback interface
*/

VOID loattach()
    {
    FAST struct ifnet *ifp = &loif;

    ifp->if_name   = "lo";
    ifp->if_mtu    = LOMTU;
    ifp->if_flags  = IFF_LOOPBACK;
    ifp->if_ioctl  = loioctl;
    ifp->if_output = looutput;

    if_attach(ifp);
    }

/**********************************************************************
*
* looutput - output packet on loopback interface
*/

int looutput(ifp, m0, dst)
    struct ifnet *ifp;
    FAST struct mbuf *m0;
    struct sockaddr *dst;

    {
    int s;
    FAST struct ifqueue *ifq;
    struct mbuf *m;

    /*
     * Place interface pointer before the data
     * for the receiving protocol.
     */
    if (m0->m_off <= MMAXOFF && m0->m_off >= MMINOFF + sizeof(struct ifnet *))
	{
	m0->m_off -= sizeof(struct ifnet *);
	m0->m_len += sizeof(struct ifnet *);
	}
    else
	{
	MGET(m, M_DONTWAIT, MT_HEADER);
	if (m == (struct mbuf *)0)
	    return (ENOBUFS);
	m->m_off = MMINOFF;
	m->m_len = sizeof(struct ifnet *);
	m->m_next = m0;
	m0 = m;
	}

    *(mtod(m0, struct ifnet **)) = ifp;

    s = splimp();

    ifp->if_opackets++;

    switch (dst->sa_family)
	{
#ifdef INET
	case AF_INET:
	    ifq = &ipintrq;
	    if (IF_QFULL(ifq))
		{
		IF_DROP(ifq);
		m_freem(m0);
		splx(s);
		return (ENOBUFS);
		}
	    IF_ENQUEUE(ifq, m0);
	    netJobAdd (ipintr, 0);
	    break;
#endif
#ifdef NS
	case AF_NS:
	    ifq = &nsintrq;
	    if (IF_QFULL(ifq))
		{
		IF_DROP(ifq);
		m_freem(m0);
		splx(s);
		return (ENOBUFS);
		}
	    IF_ENQUEUE(ifq, m0);
	    schednetisr(NETISR_NS);
	    break;
#endif
	default:
	    splx(s);
	    printf("lo%d: can't handle af%d\n", ifp->if_unit, dst->sa_family);
	    m_freem(m0);
	    return (EAFNOSUPPORT);
	}

    ifp->if_ipackets++;
    splx(s);

    return (0);
    }

/**************************************************************************
*
* loioctl - handle loop ioctl request
*
* ARGSUSED
*/

LOCAL int loioctl(ifp, cmd, data)
    FAST struct ifnet *ifp;
    int cmd;
    caddr_t data;

    {
    int error = 0;

    switch (cmd)
	{
	case SIOCSIFADDR:
	    ifp->if_flags |= IFF_UP;
	    /* Everything else is done at a higher level. */
	    break;

	default:
	    error = EINVAL;
	}

    return (error);
    }
