/* irisToBsd.c - convert IRIS a.out.h header to BSD */

static char *copyright = "Copyright 1987, Wind River Systems, Inc.";

/*
modification history
--------------------
01b,05nov87,jlf  documentation, copyright
01a,19jun87,gae  written
*/

/*
SYNOPSIS
irisToBsd <file>

DESCRIPTION
This program reads an object file, in IRIS format, and changes it, in place,
to be a more standard BSD a.out file.

Programs compiled with the IRIS native compiler need to be passed through
this filter before they can be loaded by the VxWorks loader.
*/

#include <stdio.h>

#include "vxWorks.h"
#include "a_out.h"


/*******************************************************************************
*
* main - read specified file and modify header in place
*/

VOID main (argc, argv)
    int argc;
    char *argv [];

    {
    struct exec hdr;
    unsigned long entry;
    unsigned long trsize;
    unsigned long drsize;
    FILE *fp;
    FILE *fopen();

    if (argc < 2)
	error ("usage: irisToBsd file");

    fp = fopen (argv [1], "r+");

    if (fp == NULL)
	error ("irisToBsd: can't open %s\n", argv [1]);

    /* read object module header */

    if (fread (&hdr, sizeof (hdr), 1, fp) != 1)
	error ("irisToBsd: error reading file header.");

    /* get SYS_V info */

    trsize = hdr.a_entry;
    drsize = hdr.a_trsize;
    entry  = hdr.a_drsize;

    /* now make it be BSD */

    hdr.a_entry  = entry;
    hdr.a_trsize = trsize;
    hdr.a_drsize = drsize;

    fseek (fp, 0L, 0);

    if (fwrite (&hdr, sizeof (hdr), 1, fp) != 1)
	error ("irisToBsd: error writing file header.");

    fclose (fp);

    exit (OK);
    }
/*******************************************************************************
*
* error - print error message and die
*
* This routine prints an error message on the standard error output and
* aborts the program with the error status ERROR.  The error message is
* output with the specified format with the single specified argument.
*
* VARARGS1
*/

VOID error (format, arg)
    char *format;	/* format of error message */
    char *arg;		/* argument supplied to format (arbitrary type!) */

    {
    fprintf (stderr, format, arg);
    fprintf (stderr, "\n");
    exit (ERROR);
    }
