/* vxLib.c - miscellaneous support routines */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01g,01sep88,gae  documentation.
01f,22jun88,dnw  removed include of ioLib.h.
01e,05jun88,dnw  changed from kLib to vxLib.
		 removed taskRegsShow(), exit(), and breakpoint rtns to taskLib.
01d,30may88,dnw  changed to v4 names.
01c,28may88,dnw  removed reboot to rebootLib.
01b,21apr88,gae  added include of ioLib.h for READ/WRITE/UPDATE.
01a,28jan88,jcf	 written and soon to be redistributed.
*/

/*
DESCRIPTION
This module contains VxWorks support routines.

SEE ALSO: vxALib (1)
*/

#include "vxWorks.h"
#include "taskLib.h"
#include "iv68k.h"

IMPORT vxMemProbeTrap ();
IMPORT FUNCPTR intVecGet ();


/*******************************************************************************
*
* vxMemProbe - probe address for bus error
*
* This routine probes the specified address to see if it is readable or
* writable, as specified by the mode argument.  The address will be read/written
* as 1, 2, or 4 bytes as specified by the length argument (values
* other than 1, 2, or 4 yield unpredictable results).
* If the probe is a READ, then the value read will be returned in the
* location pointed to by the `pVal' argument.
* If the probe is a WRITE, then the value written will be taken from the
* location pointed to by the `pVal' argument.
* In either case, `pVal' should point to a value of the appropriate length, 
* 1, 2, or 4 bytes, as specified by the length argument.
*
* Note that only bus errors are trapped during the probe, and that the
* access must be otherwise valid (i.e. not generate an address error!).
*
* EXAMPLE
* .CS
* testMem (adrs)
*    char *adrs;
*    {
*    char testW = 1;
*    char testR;
*
*    if (vxMemProbe (adrs, WRITE, 1, &testW) == OK)
*        printf ("value %d written to adrs %x\n", testW, adrs);
*
*    if (vxMemProbe (adrs, READ, 1, &testR) == OK)
*        printf ("value %d read from adrs %x\n", testR, adrs);
*    }
* .CE
*
* INTERNAL
* This routine functions by setting the bus error trap vector to vxMemProbeTrap
* and then trying to read/write the specified byte.
* If the address doesn't exist, vxMemProbeTrap will return ERROR.
* Note that this routine saves and restores the bus error vector that was
* there prior to this call.  The entire procedure is done with interrupts
* locked out.
*
* RETURNS:
*  OK if the probe is successful, or
*  ERROR if the probe caused a bus error
*/

STATUS vxMemProbe (adrs, mode, length, pVal)
    FAST char *adrs;	/* address to be probed          */
    int mode;		/* READ or WRITE                 */
    int length;		/* 1, 2, or 4                    */
    FAST char *pVal;	/* where to return value,        */
			/* or ptr to value to be written */

    {
    STATUS status;
    int oldLevel = intLock ();			/* lock out CPU */
    FUNCPTR oldVec = intVecGet (IV_BUS_ERROR);	/* save bus error vector */

    intVecSet (IV_BUS_ERROR, vxMemProbeTrap);	/* replace bus error vector */

    /* do probe */

    if (mode == READ)
	status = vxMemProbeSup (length, adrs, pVal);
    else
	status = vxMemProbeSup (length, pVal, adrs);


    /* replace old bus error vector and unlock */

    intVecSet (IV_BUS_ERROR, oldVec);
    intUnlock (oldLevel);

    return (status);
    }
/*******************************************************************************
*
* sysMemProbe - probe address for bus error (obsolete)
*
* THIS ROUTINE IS OBSOLETE.
*
* It is provided temporarily for compatibility with existing code.
* References to it should be replaced with references to the routine
* vxMemProbe (2) because someday soon sysMemProbe will cease to exist.
*
* This routine probes the specified address to see if it is readable
* as a one byte quantity.
* It is exactly equivalent to the following call to vxMemProbe (2):
* .CS
*  vxMemProbe (adrs, READ, 1, &test);
* .CE
*
* RETURNS:
*  OK if the probe is successful, or
*  ERROR if the probe caused a bus error
*/

STATUS sysMemProbe (adrs)
     char *adrs;	/* address to be probed */

     {
     char test;

     return (vxMemProbe (adrs, READ, 1, &test));
     }
