/* vxALib.s - miscellaneous assembly language routines */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
	.data
	.globl	_copyright_wind_river
	.long	_copyright_wind_river

/*
modification history 
--------------------
01e,10apr89,dab  fixed bug in vxTas() - changed bne to bmi.
01d,01sep88,gae  documentation.
01c,05jun88,dnw  changed from kALib to vxALib.
01b,30may88,dnw  changed to v4 names.
01a,15mar88,jcf  written and soon to be redistributed.
*/

/*
DESCRIPTION
This module contains VxWorks support routines.

SEE ALSO: vxLib (1)
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "asm.h"

	.text
	.even

	/* internals */

	.globl _vxMemProbeSup
	.globl _vxMemProbeTrap
	.globl _vxTas		


	/* externals */

	.globl _sysKernelTrap
	.globl _exit

	.text
	.even

/*******************************************************************************
*
* vxMemProbeSup - vxMemProbe support routine
*
* This routine is called to try to read byte, word, or long, as specified
* by length, from the specified source to the specified destination.
*
* NOMANUAL

* STATUS vxMemProbeSup (length, src, dest)
*     int length;	/* length of cell to test (1, 2, 4) *
*     char *src;	/* address to read *
*     char *dest;	/* address to write *

*/

_vxMemProbeSup:
	link	a6,#0

	movel	a6@(ARG2),a0	/* get source address */
	movel	a6@(ARG3),a1	/* get destination address */

	clrl	d0		/* preset status = OK */

	movel	a6@(ARG1),d1	/* get length */
	cmpl	#1,d1
	bne	vmp10
	moveb	a0@,a1@		/* move byte */
	bra	vmpRtn

vmp10:
	cmpl	#2,d1
	bne	vmp20
	movew	a0@,a1@		/* move word */
	bra	vmpRtn

vmp20:
	movel	a0@,a1@		/* move long */

	/* NOTE: vmpRtn is known by vxMemProbTrap for 68000 because 68000
	 * can't know where to return exactly. */
vmpRtn:
	unlk	a6
	rts

/*******************************************************************************
*
* vxMemProbeTrap - vxMemProbe support routine
*
* This entry point is momentarily attached to the bus error exception vector.
* It simply sets d0 to ERROR to indicate that
* the bus error did occur, and returns from the interrupt.
*
* 68010 & 68020 NOTE:
* The instruction that caused the bus error must not be run again so we
* have to set some special bits in the exception stack frame.
*
* 68000 NOTE:
* On the 68000, the pc in the exception stack frame is NOT necessarily
* the address of the offending instruction, but is merely "in the vicinity".
* Thus the 68000 version of this trap has to patch the exception stack
* frame to return to a known address before doing the RTE.
*
* NOMANUAL
*/

_vxMemProbeTrap:		/* we get here via the bus error trap */

#if (CPU==MC68000)
	addql	#8,a7		/* throw away extra bus error info on stack */
	movel	#vmpRtn,a7@(2)	/* patch return address (see note above) */
#endif

#if (CPU==MC68010)
	/* The special status word needs to have the rr bit set, only
	 * on the 68010.  This prevents the offending instruction from
	 * being run again. */

	moveb	#0x80,d0	/* rr bit is the upper bit */
	orb	d0,a7@(8)	/* Set it in special status register */
#endif

#if (CPU==MC68020)
	/* In the 68020, we reset the RC and RB flags of the special
	 * status word to prevent the bus cycle from being re-run.
	 * We'll also reset the DF flag just in case */

	moveb	#0xce,d0	/* reset bits 4, 5 and 0 */
	andb	d0,a7@(0xa)	/* ssw is always at offset 0xa */
#endif

	movel	#-1,d0		/* set status to ERROR */
	rte			/* return to the subroutine */
/*******************************************************************************
* 
* vxTas - C callable test-and-set primitive
*
* This routine provides a C callable interface to the 680x0 test-and-set
* instruction.  The `tas' instruction is executed on the specified
* address.
*
* RETURNS:
*   TRUE if value had been not set (but now is),
*   FALSE if value was already set.

* BOOL vxTas (address)
*     char *address;		/* address to be tested *

*/
_vxTas:		
	moveq	#0,d0		
	movel	sp@(4),a0
	tas	a0@	
	bmi	t1
	addqw	#1,d0		
t1:	rts
