/* mathALib - C callable math routines for the MC68881/2 */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
	.data
	.globl	_copyright_wind_river
	.long	_copyright_wind_river

/*
modification history 
--------------------
01h,10feb89,gae  fixed d1 bug in all functions.
	   +pxm  added sincos, rmod, floor, ceil, trunc, round, entier,
                 irint & iround.
01g,19aug88,gae  documentation.
01f,28may88,dnw  removed extra spaces in .word declarations that may have
		   been screwing up the VMS port.
01e,13feb88,dnw  added .data before .asciz above, for Intermetrics assembler.
01d,04dec87,gae  removed most HOST_TYPE dependencies - fp codes hand assembled.
01c,23nov87,gae  added included asm.h and special HOST_IRIS version.
01b,18nov87,jlf  documentation and alphabetized
01a,16nov87,terry arden + rdc   written
*/

/*
DESCRIPTION
This library provides a C interface to the high level math functions
on the MC68881/2 floating point coprocessor.  Each routine has the following
format:

 . save f7
 . calculate fp function using double parameter 
 . transfer result to parameter storage
 . store result to d0, d1 reg.'s
 . restore old f7

WARNING
This library only works if there is a MC68881/2 coprocessor in the system!
Attempts to use these routines with no coprocessor present will result
in illegal instruction traps.

SEE ALSO: fppLib (1)
*/

#define ASMLANGUAGE
#include "vxWorks.h"
#include "asm.h"


        .text
	.even
	.globl  _mathInit
        .globl  _tanh
        .globl  _cosh
        .globl  _sinh
        .globl  _log2
        .globl  _log10
        .globl  _log
        .globl  _exp
        .globl  _atan
        .globl  _acos
        .globl  _asin
        .globl  _tan
        .globl  _cos
        .globl  _sin
        .globl  _sqrt
        .globl  _fabs

	.globl  _sincos
	.globl  _rmod
	.globl  _floor
	.globl  _ceil
	.globl  _trunc
	.globl  _round
	.globl  _entier
	.globl  _iround
	.globl  _irint

/*******************************************************************************
*
* mathInit - initialize floating point math package
*
* This null routine is provided so the linker will pull in the math library.
*
* WARNING
* This library only works if there is a MC68881/2 coprocessor in the system!

* VOID mathInit ()

*/

_mathInit:
	rts

/*******************************************************************************
*
* acos - floating point arc-cosine
*

* double acos (dblParam)
*     double dblParam;

*/

_acos:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex	f7,sp@-
	facosd	a6@(ARG1),f7
	fmoved	f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex	sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x579c,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* asin - floating point arcsine
*

* double asin (dblParam)
*     double dblParam;

*/
_asin:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fasind  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x578c,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* atan - floating point arctangent
*

* double atan (dblParam)
*     double dblParam;

*/
_atan:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fatand  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x578a,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* cos - floating point cosine
*

* double cos (dblParam)
*     double dblParam;

*/
_cos:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fcosd   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x579d,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* cosh - floating point hyperbolic cosine
*

* double cosh (dblParam)
*     double dblParam;

*/
_cosh:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fcoshd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5799,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* exp - floating point inverse natural logarithm (e ** (x))
*

* double exp (dblParam)
*     double dblParam;

*/
_exp:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fetoxd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5790,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* fabs - floating point absolute value
*

* double fabs (dblParam)
*     double dblParam;

*/

_fabs: 
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fabsd   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5798,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* log - floating point natural logarithm 
*

* double log (dblParam)
*     double dblParam;

*/
_log:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	flognd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5794,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* log10 - floating point logarithm base 10 
*

* double log10 (dblParam)
*     double dblParam;

*/
_log10:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	flog10d a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5795,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* log2 - floating point logarithm base 2 
*

* double log2 (dblParam)
*     double dblParam;

*/
_log2:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	flog2d  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5796,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* sin - floating point sine
*

* double sin (dblParam)
*     double dblParam;

*/
_sin:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fsind   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x578e,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* sinh - floating point hyperbolic sine
*

* double sinh (dblParam)
*     double dblParam;

*/
_sinh:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fsinhd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5782,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* sqrt - floating point square root
*

* double sqrt (dblParam)
*     double dblParam;

*/

_sqrt:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fsqrtd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5784,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* tan - floating point tangent
*

* double tan (dblParam)
*     double dblParam;

*/

_tan:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	ftand   a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x578f,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/*******************************************************************************
*
* tanh - floating point hyperbolic tangent
*

* double tanh (dblParam)
*     double dblParam;

*/

_tanh:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	ftanhd  a6@(ARG1),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5789,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/* XXX THE REMAINING ROUTINES HAVE NOT BEEN CHECKED FOR ACCURACY/CORRECTNESS */

/*******************************************************************************
*
* sincos - simultaneous floating point sine and cosine
*

* double sincos (dblParam, sinResult, cosResult)
*     double dblParam;
*     double *sinResult;
*     double *cosResult;

*/

_sincos:
	link    a6,#0

#ifdef	MATH_ASM
	fmovemx  f6/f7,sp@-
	ftanhd  a6@(ARG1),f7
	fsincosd  a6@(ARG1),f7:f6
	movel   a6@(ARG3),a0
	fmoved  f6,a0@
	movel   a6@(ARG4),a0
	fmoved  f7,a0@
	fmovemx sp@+,f6/f7
#endif	MATH_ASM
	.word	0xf227,0xe003
	.word	0xf22e,0x5737,0x0008
	.word	0x206e,0x0010
	.word	0xf210,0x7700
	.word	0x206e,0x0014
	.word	0xf210,0x7780
	.word	0xf21f,0xd003

	unlk    a6
	rts

/*******************************************************************************
*
* rmod - floating point modulo remainder
*

* double rmod (dblParam, divisor)
*     double dblParam;
*     double divisor;

*/

_rmod:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fmoved  a6@(ARG1),f7
	fmodd   a6@(ARG2),f7
	fmoved  f7,a6@(ARG1)
	movel   a6@(ARG1),d0
	movel   a6@(ARG2),d1
	fmovex  sp@+,f7
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5780,0x0008
	.word	0xf22e,0x57a1,0x000c
	.word	0xf22e,0x7780,0x0008
	.word	0x202e,0x0008
	.word	0x222e,0x000c
	.word	0xf21f,0x4b80

	unlk    a6
	rts

/* ROUNDING MODES */

#define	tonearest	0x0
#define	tozero		0x10
#define	minusinf	0x20
#define	plusinf		0x30

/*******************************************************************************
*
* floor - floating point floor
*

* double floor (dblParam)
*     double dblParam;

*/

_floor:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fmovel  fpcr,d0		/* set FPCR for round-to-minus-infinity */
        movel   d0,d1
        movb    #minusinf,d1
        fmovel  d1,fpcr
        fintd   a6@(ARG1),f7
        fmoved  f7,a6@(ARG1)
        fmovex  sp@+,f7
        fmovel  d0,fpcr
        movel   a6@(ARG1),d0
        movel   a6@(ARG2),d1
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf200,0xb000
	.word	0x2200
	.word	0x123c,0x0020
	.word	0xf201,0x9000
	.word	0xf22e,0x5781,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0xf21f,0x4b80
	.word	0xf200,0x9000
	.word	0x202e,0x0008
	.word	0x222e,0x000c

	unlk    a6
	rts

/*******************************************************************************
*
* ceil - floating point ceiling
*

* double ceil (dblParam)
*     double dblParam;

*/

_ceil:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fmovel  fpcr,d0		/* set FPCR for round-to-plus-infinity */
        movel   d0,d1
        movb    #plusinf,d1
        fmovel  d1,fpcr
        fintd   a6@(ARG1),f7
        fmoved  f7,a6@(ARG1)
        fmovex  sp@+,f7
        fmovel  d0,fpcr
        movel   a6@(ARG1),d0
        movel   a6@(ARG2),d1
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf200,0xb000
	.word	0x2200
	.word	0x123c,0x0030
	.word	0xf201,0x9000
	.word	0xf22e,0x5781,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0xf21f,0x4b80
	.word	0xf200,0x9000
	.word	0x202e,0x0008
	.word	0x222e,0x000c

	unlk    a6
	rts

/*******************************************************************************
*
* trunc - floating point truncation
*

* double trunc (dblParam)
*     double dblParam;

*/

_trunc:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fintrzd a6@(ARG1),f7
        fmoved  f7,a6@(ARG1)
        fmovex  sp@+,f7
        movel   a6@(ARG1),d0
        movel   a6@(ARG2),d1
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf22e,0x5783,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0xf21f,0x4b80
	.word	0x202e,0x0008
	.word	0x222e,0x000c

	unlk    a6
	rts
/*******************************************************************************
*
* round - floating point rounding
*

* double round (dblParam)
*     double dblParam;

*/

_round:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fmovel  fpcr,d0		/* set FPCR for round-to-nearest */
        movel   d0,d1
        movb    #tonearest,d1
        fmovel  d1,fpcr
        fintd   a6@(ARG1),f7
        fmoved  f7,a6@(ARG1)
        fmovex  sp@+,f7
        fmovel  d0,fpcr
        movel   a6@(ARG1),d0
        movel   a6@(ARG2),d1
#endif	MATH_ASM

	.word	0xf227,0x6b80
	.word	0xf200,0xb000
	.word	0x2200
	.word	0x123c,0x0000
	.word	0xf201,0x9000
	.word	0xf22e,0x5781,0x0008
	.word	0xf22e,0x7780,0x0008
	.word	0xf21f,0x4b80
	.word	0xf200,0x9000
	.word	0x202e,0x0008
	.word	0x222e,0x000c

	unlk    a6
	rts

/*******************************************************************************
*
* entier - floating point
*

* double entier (dblParam)
*     double dblParam;

*/

_entier:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fmovel  fpcr,d0		/* set FPCR for round-to-minus-infinity */
        movel   d0,d1
        movb    #minusinf,d0
        fmovel  d0,fpcr
/*      fintd   a6@(ARG1),f7	XXX ?  */
        fmoved  a6@(ARG1),f7
        fmovel  f7,d0
        fmovex  sp@+,f7
        fmovel  d1,fpcr
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf200,0xb000
	.word	0x2200
	.word	0x103c,0x0020
	.word	0xf200,0x9000
	.word	0xf22e,0x5780,0x0008
/*	.word	0xf22e,0x7780,0x0008    XXX ? */
	.word	0xf200,0x6380
	.word	0xf21f,0x4b80
	.word	0xf201,0x9000

	unlk    a6
	rts

/*******************************************************************************
*
* iround - INTEGER floating point rounding
*

* int iround (dblParam)
*     double dblParam;

*/

_iround:
	link    a6,#0

#ifdef	MATH_ASM
	fmovex  f7,sp@-
	fmovel  fpcr,d0		/* set FPCR for round-to-nearest */
        movel   d0,d1
        movb    #tonearest,d0
        fmovel  d0,fpcr
        fmoved  a6@(ARG1),f7
        fmovel  f7,d0
        fmovex  sp@+,f7
        fmovel  d1,fpcr
#endif	MATH_ASM
	.word	0xf227,0x6b80
	.word	0xf200,0xb000
	.word	0x2200
	.word	0x103c,0x0000
	.word	0xf200,0x9000
	.word	0xf22e,0x5780,0x0008
	.word	0xf200,0x6380
	.word	0xf21f,0x4b80
	.word	0xf201,0x9000

	unlk    a6
	rts

/********************************************************************************
* irint - convert double to integer
*
 
* int irint (dblParam)
*     double dblParam;
 
*/
 
_irint:
        link    a6,#0
 
#ifdef  MATH_ASM
	fmovex  f7,sp@-
        fmoved  a6@(ARG1),f7
        fmovel  f7,a6@(ARG1)
        movel   a6@(ARG1),d0
        fmovex  sp@+,f7
#endif  MATH_ASM
	.word	0xf227,0x6b80
        .word   0xf22e,0x5780,0x0008
        .word   0xf22e,0x6380,0x0008
        .word   0x202e,0x0008
	.word	0xf201,0x9000
 
        addqw   #8,sp
        unlk    a6
        rts

