/* intALib.s - interrupt library assembly language routines */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
	.data
	.globl	_copyright_wind_river
	.long	_copyright_wind_river

/*
modification history
--------------------
04f,19aug88,gae  documentation.
04e,30may88,dnw  changed to v4 names.
04d,28may88,jcf  fixed over optimized v4c which didn't work.
04c,28apr88,jcf  optimized intSetLevel().
		  removed unused external _intCnt.
04b,22apr88,gae  documentation of intSetVBR().
04a,25jan88,jcf  remove intEnt and intExit, as they are kernel dependent.
03r,13feb88,dnw  added .data before .asciz above, for Intermetrics assembler.
03q,16nov87,ecs  documentation.
03p,24oct87,dnw  removed unnecessary declaration of sysVwTrap.
03o,18sep87,dnw  removed intDrop() (obsolete).
		 changed to call sysKernelTrap() and sysVwTrap()
		   instead of doing traps directly.
03n,24mar87,jlf  documentation
03m,20dec86,dnw  fixed to be compatible with motorola assembler.
03l,04dec86,dnw  changed to code for vector base register to be compatible
		   with all assemblers.
03k,29nov86,dnw  removed conditional assembly for 68020/68000.
03j,20nov86,dnw  Changed "mov[bwl]" to "move[bwl]" for compatiblity w/Sun as.
03i,28oct86,llk  conditionally compile out intSetVBR for non 68020 systems.
03h,27oct86,llk  added intSetVBR.  Used for setting the vector base register.
03g,04sep86,jlf  minor documentation.
03f,01jul86,jlf  documentation.
03e,18jan86,dnw  removed intEnd; code now directly built by intConnect.
03d,18jul85,jlf  added some stuff for mangen.
03c,19jun85,rdc  changed .globls for 4.2 as.
03b,12jun85,rdc  added C style comments.
03a,22may85,jlf+ translated from asm to as.  Removed intContext (now in C).
                 added intEnt and intExit.  Fixed intSet to do almost
                 everything at trap level, since move sr is priveleged on
                 68010.
02a,05apr85,rdc  installed modifications for vrtx version 3.
01c,06sep84,jlf  added copyright, some comments
01b,04sep84,dnw  added intContext.
01a,03aug84,jlf  written, by modifying gathering routines from hither
		   and yon.
*/

/*
DESCRIPTION
These routines are used to support various functions associated with
interrupts from C.  The routine intLevelSet (2) changes the current
interrupt level of the processor.

SEE ALSO
intLib (1)

INTERNAL
Some routines in this module "link" and "unlk" the "c" frame pointer
(a6) although they don't use it in any way!  This is only for the benefit of
the stacktrace facility to allow it to properly trace tasks executing within
these routines.
*/

#define ASMLANGUAGE
#include "asm.h"

	.text
	.even

	.globl	_intLevelSet
	.globl	_intVBRSet


/*******************************************************************************
*
* intLevelSet - set interrupt level
*
* This routine changes the interrupt mask in the status register to take
* on the value specified by level.  It is strongly advised that the level
* be in the range 0 - 7.
*
* Setting interrupts involves privileged instructions, so user level tasks
* must trap to supervisor level before executing this routine.
* This routine should only be called in supervisor mode.
*
* RETURNS: previous interrupt level, 0 - 7
*
* SEE ALSO: sysVwTrap (2)

* int intLevelSet (level)
*     int level;	/* new interrupt level mask, 0 - 7 *

*/

_intLevelSet:
	link	a6,#0
	movew	sr,d0		/* get old sr into d0 */
	andw	#0xf8ff,d0	/* clear interrupt mask in saved sr */
	movel	a6@(ARG1),d1	/* get new level into d1 */
	andl	#0x7,d1		/* clear all but interrupt mask */
	lslw	#8,d1		/* get level into high order byte */
	orw	d0,d1		/* combine with saved status reg contents */
	movew	sr,d0		/* remember status register */
	movew	d1,sr		/* set status register */

	lsrw	#8,d0		/* shift interrupt level to low bits */
	andl	#0x7,d0		/* clear all but interrupt mask */
	unlk	a6
	rts

/*******************************************************************************
*
* intVBRSet - set the vector base register
*
* This routine should only be called in supervisor mode.
* It is not used on the M68000.
*
* NOMANUAL

* VOID intVBRSet (baseAddr)
*      FUNCPTR *baseAddr;	/* vector base address *

*/

_intVBRSet:

	link	a6,#0
	movel	a6@(ARG1),d0	/* put base address in d0 */

	/* Since the assemblers differ on the syntax for setting the
	 * vector base register (if they even have it), its done with 
	 * two .word's.  Yucko. */

	.word	0x4e7b,0x0801	/* movec d0,vbr */

	unlk	a6
	rts
