/* bLib.c - buffer manipulation subroutine library */

/* Copyright 1984,1985,1986,1987,1988,1989 Wind River Systems, Inc. */
extern char copyright_wind_river[]; static char *copyright=copyright_wind_river;

/*
modification history
--------------------
01r,30aug88,gae  more documentation tweaks.
01q,20aug88,gae  documentation.
01p,05jun88,dnw  changed from bufLib to bLib.
01o,30may88,dnw  changed to v4 names.
01n,19mar87,gae  oops in 01m!
01m,19mar87,gae  fixed swab to work right when from/to are the same.
		 made swab type VOID.
01l,16feb87,llk  added swab().
01k,21dec86,dnw  changed to not get include files from default directories.
01j,01jul86,jlf  minor documentation cleanup.
01i,06aug85,jlf  removed cpybuf,movbuf, and filbuf, which are now in
		 asm language.  Made the remaining routines accept ints instead
		 of shorts, and removed the screwy loop constructs.
01h,06sep84,jlf  Added copyright notice.
01g,29jun84,ecs  changed cmpbuf to return -1, 0, 1.
01f,18jun84,dnw  Added LINTLIBRARY for lint.
01e,17nov83,jlf  Added movbuf
01d,09jun83,ecs  added some commentary
01c,07may83,dnw  enabled filbuf to fill more than 64K bytes
01b,04apr83,dnw  added invbuf.
01a,15mar83,dnw  created from old utillb.c
*/

/*
DESCRIPTION
This library contains routines to manipulate buffers, which are just
variable length byte arrays.  The routines in this library supplement
the highly optimized buffer copying routines found in bALib (1).
These routines do not check for null termination as the routines found
in strLib (1) do.

SEE ALSO: bALib (1), strLib (1)
*/

/* LINTLIBRARY */

#include "vxWorks.h"


/*******************************************************************************
*
* bcmp - compare one buffer to another
*
* This routine compares the first nbytes characters of `buf1' to `buf2'.
*
* RETURNS
*   0 if first nbytes of `buf1' and `buf2' are identical
*  -1 if buf1 < buf2
*   1 if buf1 > buf2
*/

int bcmp (buf1, buf2, nbytes)
    FAST char *buf1;		/* pointer to first buffer    */
    FAST char *buf2;		/* pointer to second buffer   */
    FAST int nbytes;		/* number of bytes to compare */

    {
    while (--nbytes >= 0)
	{
	if (*buf1 < *buf2)
	    return (-1);
	if (*buf1++ > *buf2++)
	    return (1);
	}

    return (0);				/* equality */
    }
/*******************************************************************************
*
* binvert - invert the order of bytes in a buffer
*
* This routine inverts an entire buffer, byte by byte.  For example,
* the buffer {1, 2, 3, 4, 5} would become, after inversion, {5, 4, 3, 2, 1}.
*/

VOID binvert (buf, nbytes)
    FAST char *buf;		/* pointer to buffer to invert	*/
    int nbytes;			/* number of bytes in buffer	*/

    {
    FAST char *buf_end = buf + nbytes - 1;
    FAST char temp;

    while (buf < buf_end)
	{
	temp       = *buf;
	*buf       = *buf_end;
	*buf_end   = temp;

	buf_end--;
	buf++;
	}
    }
/*******************************************************************************
*
* bswap - swap buffers
*
* This routine exchanges the first `nbytes' of the two specified buffers.
*/

VOID bswap (buf1, buf2, nbytes)
    FAST char *buf1;		/* pointer to first buffer  */
    FAST char *buf2;		/* pointer to second buffer */
    FAST int nbytes;		/* number of bytes to swap  */

    {
    FAST char temp;

    while (--nbytes >= 0)
	{
	temp = *buf1;
	*buf1++ = *buf2;
	*buf2++ = temp;
	}
    }
/*******************************************************************************
*
* swab - swap bytes
*
* This routine swaps `nbytes' pointed to by `source' to the position
* pointed to by `destination', exchanging adjacent even and odd bytes.
* If `source' and `destination' are the same then the bytes
* are simply interchanged.
* If `source' and `destination' buffers overlap and are not
* identical this routine is unsuitable.
* It is an error for `nbytes' to be odd.
*/

VOID swab (source, destination, nbytes)
    char *source;		/* pointer to source buffer      */
    char *destination;		/* pointer to destination buffer */
    int nbytes;			/* number of bytes to exchange   */

    {
    FAST short *src = (short *) source;
    FAST short *dst = (short *) destination;
    FAST short *dst_end = dst + (nbytes / 2);

    for (; dst < dst_end; dst++, src++)
	{
	*dst = ((*src & 0x00ff) << 8) | ((*src & 0xff00) >> 8);
	}
    }
/*******************************************************************************
*
* bzero - zero out a buffer
*
* This routine fills the first `nbytes' characters of the
* specified buffer with 0.
*/

VOID bzero (buffer, nbytes)
    char *buffer;		/* buffer to be zeroed       */
    int nbytes;			/* number of bytes in buffer */

    {
    bfill (buffer, nbytes, 0);
    }
